var winobj = getNeProperty(self);
var nmUser = winobj["nmUser"];
var neID = winobj.neid;
var btnRightArr = new Object();
var deleteRight = false;
var queryRight = false;
var modifyRight = false;
var createRight = false;
var oprSucc = 0;
var oprFail = 2;

var TIMEOUT = 131080;

var QUERYSFID = TECMDCODE_GET_ETHERROUTE_FROMNE;//    id
var DELETESFID = TECMDCODE_DEL_ETHERROUTE;//         id
var qpath = "../../../../../";
var hpath = "../../../../../";

var st = null;

var isManage = true;

var INVALID_SUBSOLTID = "255";
var ROUT_INEXIST = "42222";
var PARTSUCC = 1;
var FAIL = 2;
var MlpppPort = 0x1000;
var SerialPort = 0x1800;
var VIRTUAL_PORT = 0x2800;
var VIRTUAL_PORT_END = 0x2FFF;
var VIRTUAL_PORT_2 = 0x3800;
var VIRTUAL_PORT_EXCURSION = 2048;
/**
 *      
 */
window.onload = function()
{
    initpage();
    initBfd();
};
/*
 *       
 */
function initpage()
{
    st = new SortTable();
    st.head.setAttribute("id", "htmlTable_STHead_routeprotocol");
    st.body.setAttribute("id", "htmlTable_STBody_routeprotocol");
    st.setOnRowSelectHandler(rowSelected);
    st.setImage(qpath + "images/");
    createTableHead(st, window.tableconf[0]);
    st.setBodyHeight("450px");
    window.onresize = function()
    {
        bfdst.setBodyHeight(getComponetHeight($("tablecomponent_bfd"), 60) + "px");
    }
    $("tablecomponent").appendChild(st.getTable());
    $("totalrow").innerText = RESOURCE["total"];
    $("selrow").innerText = RESOURCE["selected"];
    $("totalrownumSta").innerText = "0";
    $("selrownumSta").innerText = "0";
    
    initButton();
    
    if (btnRightArr.querybtn.right) 
    {
        doQuery();
    }
}

/*
 *      
 */
function initButton()
{
    $("querybtn").value = RESOURCE["querybtn"];
    $("createbtn").value = RESOURCE["createbtn"];
    $("deletebtn").value = RESOURCE["deletebtn"];
    
    btnRightArr.querybtn = new BtnRightObj("querybtn", TECMDCODE_GET_ETHERROUTE_FROMNE);
    btnRightArr.createbtn = new BtnRightObj("createbtn", TECMDCODE_DEL_ETHERROUTE);
    btnRightArr.deletebtn = new BtnRightObj("deletebtn", TECMDCODE_DEL_ETHERROUTE);
    
    getRightInfo(winobj, btnRightArr);
    initrightbtn(btnRightArr);
    
    deleteRight = btnRightArr.deletebtn.right;
    queryRight = btnRightArr.querybtn.right;
    createRight = btnRightArr.createbtn.right;
}


/**
 * query static route
 */
function doQuery()
{
    $("querybtn").disabled = true;
    $("createbtn").disabled = true;
    $("deletebtn").disabled = true;
	$("queryBfdBtn").disabled = true;
    $("addBfdBtn").disabled = true;
    $("deleteBfdBtn").disabled = true;
		
    var xml = createQueryRequest();
    var URL = hpath + "neExlorerServlet?sfid=" + QUERYSFID + "&flag=1&nmUser=" + nmUser;
    loadXMLdoc(URL, "POST", false, processQueryResponse, null, "inputdata=" + xml);
}

/**
 * create query XML request
 */
function createQueryRequest()
{
    var root = new inputxml("datainterface");
    var business = new tagElement("bussiness-params");
    var row = new tagElement("row-params");
    
    var param = new tagElement("param");
    param.setAttribute("name", "neid");
    param.setAttribute("value", neID);
    row.appendChild(param);
    
    var param = new tagElement("param");
    param.setAttribute("name", "routeid");
    param.setAttribute("value", "0");
    row.appendChild(param);
    
    business.appendChild(row);
    
    root.getRoot().appendChild(business);
    return root.toString();
}

/**
 * callback function
 */
function processQueryResponse(doc)
{
    var dinterface = EncapsulateData(doc);
    
    var errArr = [];
    errArr[0] = "operObject";
    var size = dinterface.getBErrLength();
    for (var i = 0; i < size; i++) 
    {
        var tempObj = dinterface.getError().rowErrors[i].errorObj;
        tempObj["operObject"] = RESOURCE["operObject"];
    }
    if (oprSucc != dinterface.getError().getGlobleECode()) 
    {
        var flag = true;
        var len = dinterface.errObj.rowErrors.length
        for (var i = 0; i < len; i++) 
        {
            if ("38662" != dinterface.errObj.rowErrors[i].error.code) 
            {
                flag = false;
                break;
            }
        }
        if (flag && TIMEOUT != dinterface.errObj.s_error.code) 
        {
            dinterface.errObj.s_error.code = oprSucc;
        }
    }
    openErrPage(qpath + "page/", dinterface.getError(), errArr);
    
    if (oprFail == dinterface.getError().getGlobleECode() ||
    TIMEOUT == dinterface.getError().getGlobleECode()) 
    {
        $("querybtn").disabled = !btnRightArr.querybtn.right;
        $("createbtn").disabled = !btnRightArr.createbtn.right;
        
        return;
    }
    
    for (var i = 0; i < dinterface.getDataRowLength(); i++) 
    {
        var row = dinterface.rows[i];
        
        if (MlpppPort <= row["port"].value && SerialPort > row["port"].value) 
        {
            row["slotid"].value = "";
            row["boardname"].value = "";
            var portid = row["port"].value - MlpppPort;
            if (row["portname"].value == "") 
            {
            	 row["portname"].value = portid + "(MP-" + portid + ")";
            }           
        }
        
        else if (SerialPort <= row["port"].value && VIRTUAL_PORT > row["port"].value) 
        {
        	 if (row["portname"].value == "") 
            {
            	row["portname"].value = (row["port"].value - SerialPort) + "(Serial-" +(row["port"].value - SerialPort) +")";
            }            
        }
        
        else if (VIRTUAL_PORT <= row["port"].value && VIRTUAL_PORT_END >= row["port"].value) 
        {
            row["slotid"].value = "";
            row["boardname"].value = "";
            var portid = (row["port"].value - VIRTUAL_PORT);
            if (row["portname"].value == "") 
            {
                row["portname"].value = portid + "(VEther-" + portid + ")";
            }            
        }
        
        else if (VIRTUAL_PORT_2 <= row["port"].value) 
        {
            row["slotid"].value = "";
            row["boardname"].value = "";
            var portid = (row["port"].value - VIRTUAL_PORT_2 + VIRTUAL_PORT_EXCURSION);
            if (row["portname"].value == "") 
            {
                row["portname"].value = portid + "(VEther-" + portid + ")";
            }           
        }
        
        if (INVALID_SUBSOLTID == row["subslotid"].value) 
        {
            row["subslotid"].value = "";
        }
        row["nextip"].value = convertNumToIpaddr(row["nextip"].value);
        row["dip"].value = convertNumToIpaddr(row["dip"].value);
        row["dmass"].value = convertNumToIpaddr(row["dmass"].value);
        
    }
    
    clearTable();
    createTableBody(st, window.tableconf[0], dinterface, RESOURCE);
    
    if (!st.element.colsArray.selectedId) 
    {
        st.element.colsArray.selectedId = "routeid";
        st.element.colsArray.imgflag = 1;
    }
    
    var td = st.element.headRow.element.cols[st.element.colsArray.selectedId].element;
    st.sortRows(td, st.element.colsArray.imgflag);
    
    $("querybtn").disabled = !btnRightArr.querybtn.right;
    $("createbtn").disabled = !btnRightArr.createbtn.right;
    
	$("queryBfdBtn").disabled = true;
    $("addBfdBtn").disabled = true;
	
    bfdst.clearTableData();
    
    stChanged();
}

/**
 * remove all the table rows
 */
function clearTable()
{
    for (var i = 0; i < st.getDataRowLength(); ++i) 
    {
        st.deleteRow(i);
    }
    st.adjustDataRows();
    
}

/**
 * delete static route
 */
function doDelete()
{
    if (st.getSelectedRowCount() <= 0) 
    {
        alert(RESOURCE["noselect"]);
        return;
    }
    if (!confirm(RESOURCE["Delete_Hint"])) 
    {
        return;
    }
    
    $("querybtn").disabled = true;
    $("createbtn").disabled = true;
    $("deletebtn").disabled = true;
    
    var xml = createDeleteRequest();
    
    var URL = hpath + "neExlorerServlet?sfid=" + DELETESFID + "&flag=1&nmUser=" + nmUser;
    loadXMLdoc(URL, "POST", true, processDeleteResponse, null, "inputdata=" + xml);
}

/**
 * create delete XML request
 */
function createDeleteRequest()
{
    var ddtID = [];
    
    var selRows = st.getSelectedRows();
    for (var i = 0; i < selRows.length; ++i) 
    {
        ddtID[ddtID.length] = st.getCellStoreValue(selRows[i], "routeid", "routeid");
    }
    
    var root = new inputxml("datainterface");
    var business = new tagElement("bussiness-params");
    for (var i = 0; i < selRows.length; ++i) 
    {
        var row = new tagElement("row-params");
        
        var param = new tagElement("param");
        param.setAttribute("name", "neid");
        param.setAttribute("value", neID);
        row.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "routeid");
        param.setAttribute("value", ddtID[i]);
        row.appendChild(param);
        
        business.appendChild(row);
    }
    root.getRoot().appendChild(business);
    return root.toString();
}

/**
 * callback function
 */
function processDeleteResponse(doc)
{
    var dinterface = EncapsulateData(doc);
    
    var errCode = dinterface.getSErrorCode();
    if (0 != errCode) 
    {
        var len = dinterface.getBErrLength();
        for (var i = len - 1; i >= 0; i--) 
        {
            if (ROUT_INEXIST == dinterface.errObj.rowErrors[i].error.code) 
            {
                dinterface.errObj.rowErrors.removeAt(i);
                len--;
            }
        }
        if (0 == len && (PARTSUCC == errCode || FAIL == errCode)) 
        {
            dinterface.errObj.s_error.code = 0;
        }
        else 
        {
            var errArr = [];
            errArr[0] = "nename";
            openErrPage(qpath + "page/", dinterface.getError(), errArr);
        }
    }
    
    doQuery();
}

/**
 * table selection change
 */
function rowSelected(rows)
{
    var isSelected = (0 < rows.length);
    $("deletebtn").disabled = !deleteRight || !isSelected;
    if (isSelected) 
    {
        if (btnRightArr.querybtn.right) 
        {
            queryTracingBfd();
        }
    }
    else 
    {
        $("queryBfdBtn").disabled = true;
        $("addBfdBtn").disabled = true;
        $("deletebtn").disabled = true;
        bfdst.clearTableData();
    }
    
    stChanged();
}

function stChanged()
{
    $("totalrownumSta").innerText = "" + st.getDataRowLength();
    $("selrownumSta").innerText = "" + st.getSelectedRows().length;
}

/**
 * return currently select static route item.
 */
function getSelectedItemID()
{
    var rows = st.getSelectedRows();
    var routeItemID = -1;
    if (rows.length > 0) 
    {
        routeItemID = st.getCellStoreValue(rows[0], "routeid", "routeid");
    }
    return routeItemID;
}
