
/**
 *      
 */
var btnRightArr = new Object();
var obj,neid;

/**
 *         
 */
var POLICY_NAME_MAXLENGTH = 64;


/**
 * auto id flag
 */
var POLICY_AUTO_ID = 1;
var POLICY_MANUL_ID = 0;

var SWITCH_ON = 1;
var SWITCH_OFF = 0;

var logString = "";
/**
 * record wheter click apply button or ok button; 
 */
var bIsApply = false;
/**
 * save original query data.for comparing with settting data.
 */
var saveRuleTypes = [];

var DEFAULT_MATRIC_TYPE= 1;

/**
 * Save current rule items.
 */
var curRuleItems = null;
var cellonblurevt = cellonblur;

var windowParent = window.parent;
 if(!isIE)
 {
 	  if (parentWin.frames.length > 2)
 	  {
 	      windowParent = parentWin.frames[2];
 	  }
    else
    {
        windowParent = parentWin.frames[0];
    }
 }


function initRuleItemUI() {
	st = new SortTable();
    st.head.setAttribute("id", "htmlTable_STHead_RoutePolicy");
    st.body.setAttribute("id", "htmlTable_STBody_RoutePolicy");
    st.setImage("../../../../../images/");
    createTableHead(st, window.tableconf[0]);
	st.setBodyHeight("170px");
    st.setOnCellEditHandler(cellEditHandler);	
	st.setOnRowSelectHandler(rowSelectHandler);
    $("ruletable").appendChild(st.getTable());
    $("ruletable").oncontextmenu = tableContextHandler;   
	initRuleItemButtonInfo();
}

/**
 *              
 * @param {Object} param
 */
function cellEditHandler(param)	
{
	$("applyRbtn").disabled = !btnRightArr.applyRbtn.right;
}

function setTabsHeight(tab, tabodyheight)
{
    for(var key in tab.tabNodes)
    {
        tab.tabNodes[key].body.style.height = tabodyheight;
    }
}

/**
 * init button status
 */
function initRuleItemButtonInfo(){
	$("createbtn").value = RESOURCE["addbtn"];
	if($("applyRbtn") != null) {
		$("applyRbtn").value = RESOURCE["applybtn"];
		btnRightArr.applyRbtn = new BtnRightObj("applyRbtn", TECMDCODE_PTN_CONTROLPLAN_ROUTEPOLICY_APPLY);
	}
    $("deletebtn").value = RESOURCE["deletebtn"];
    btnRightArr.createbtn = new BtnRightObj("createbtn", TECMDCODE_PTN_CONTROLPLAN_ROUTEPOLICY_APPLY);
    btnRightArr.deletebtn = new BtnRightObj("deletebtn", TECMDCODE_PTN_CONTROLPLAN_ROUTEPOLICY_APPLY);	
    
	
    getRightInfo(winobj, btnRightArr);
    initrightbtn(btnRightArr);
	if ($("applyRbtn") != null) {
		$("applyRbtn").disabled = true;
	}	
	$("deletebtn").disabled = true;
}


/**
 * new policy rule
 */
function newrule(){	
    var dinterface = new DataInterface();
	var ruleName = getNextRuleName();
	if(ruleName == null)
	{
		return;
	}
	var ruleAction = getNextRuleAction(ruleName);
	ruleName = getNextRuleName(ruleAction);
  constructData(dinterface, ruleAction, ruleName, "");
  createTableBody(st, window.tableconf[0], dinterface, RESOURCE);
	var currentIndex = st.getDataRowLength() - 1;
	setDefaultScopeValue(ruleName, currentIndex);
	if(ruleName == FILTER_SUBNET)
	{
		st.getCellElement(currentIndex, "ruleArea").ondblclick = openEditIPDalog;
	}
	else if(ruleName == FILTER_ACTION_MATRIC)
	{
		st.getCellElement(currentIndex, "ruleArea").ondblclick = openEditMatricDialog;
	}
	
	ruleName = getNextRuleName();	
	if(ruleName == null) 
	{
		$("createbtn").disabled = true;
	}
	$("applyRbtn").disabled = !btnRightArr.applyRbtn.right;
	addCellEvent();
	
	
}

/**
 *    ISIS       ISIS   
 */
function addDefaultISISItem(){
    var dinterface = new DataInterface();
	var ruleName = rulenamesIDS[FILTER_ACTION_ROUTETYPE];	
	var ruleAction = ROUTE_ACTION_ACTION;
    constructData(dinterface, ruleAction, ruleName, "");
    createTableBody(st, window.tableconf[0], dinterface, RESOURCE);
	var currentIndex = st.getDataRowLength() - 1;
	var cell = st.getCell(currentIndex, "ruleArea");
	st.setAtomValue(st.getCellShow(currentIndex, "ruleArea"), RESOURCE[ROUTE_TYPE[RT_ISISL1EXT]]);
    st.setCellValue(cell, "ruleArea", RT_ISISL1EXT);		
    
    var nameCell = st.getCell(currentIndex, "ruleName");
    var actionCell = st.getCell(currentIndex, "action");  
    st.setCellIsEdit(nameCell, false);
    st.setCellIsEdit(actionCell, false);
    
	ruleName = getNextRuleName();		
	if(ruleName == null) 
	{
		$("createbtn").disabled = true;
	}
	$("applyRbtn").disabled = !btnRightArr.applyRbtn.right;
	addCellEvent();
}

/**
 * change dblclick on action scope
 * 
 */
function ruleNameChange() {
	var currentIndex = st.getSelectedRows()[0];
	var ruleNameValue = st.getCellStoreValue(currentIndex, "ruleName", "ruleName");
	var cell = st.getCell(currentIndex, "ruleArea").element;
	switch(ruleNameValue) {
		case FILTER_SUBNET:{
			cell.ondblclick = openEditIPDalog;			
			break;
		}		
		case FILTER_ACTION_MATRIC: 
		{
			cell.ondblclick = openEditMatricDialog;
			break;
		}
		default:
		{			
			cell.ondblclick = cellondbclick;
		}
	}
	
	setDefaultScopeValue(ruleNameValue, currentIndex);
	
}

function ruleNameOnChange()
{
	var currentIndex = st.getSelectedRows()[0];
	var ruleNameValue = this.options[this.selectedIndex].value;
	var cell = st.getCell(currentIndex, "ruleArea").element;
	switch(ruleNameValue) {
		case FILTER_SUBNET:{
			cell.ondblclick = openEditIPDalog;			
			break;
		}		
		case FILTER_ACTION_MATRIC: 
		{
			cell.ondblclick = openEditMatricDialog;
			break;
		}
		default:
		{			
			cell.ondblclick = cellondbclick;
		}
	}
	setDefaultScopeValue(ruleNameValue, currentIndex);
}

/**
 * set default scope value
 */
function setDefaultScopeValue(ruleNameValue, currentIndex) 
{
	var cell = st.getCell(currentIndex, "ruleArea");
	switch(ruleNameValue) {
		case FILTER_SUBNET:{
			st.setAtomValue(st.getCellShow(currentIndex, "ruleArea"), "0.0.0.0/0");
        	st.setCellValue(cell, "ip", "0.0.0.0");		
			st.setCellValue(cell, "masklength", "0");	
			st.setCellValue(cell, "ruleArea", "0.0.0.0/0");	
			break;
		}		
		case FILTER_ROUTETYPE: 
		{
			st.setAtomValue(st.getCellShow(currentIndex, "ruleArea"), "");
        	st.setCellValue(cell, "ruleArea", "");		
			break;
		}
		case FILTER_ACTION_ROUTETYPE: 
		{
			st.setAtomValue(st.getCellShow(currentIndex, "ruleArea"), "");
        	st.setCellValue(cell, "ruleArea", "");		
			break;
		}
		case FILTER_OSPF: 
		case FILTER_TAG:
		case FILTER_ACTION_OSPFTAG:
		{
			st.setAtomValue(st.getCellShow(currentIndex, "ruleArea"), "");
        	st.setCellValue(cell, "ruleArea", "");		
			break;
		}
		case FILTER_ACTION_MATRIC: 
		{
			st.setAtomValue(st.getCellShow(currentIndex, "ruleArea"), "");
			st.setCellValue(cell, "fact", "1");	
			break;
		}
	}
}

function updateRuleName(){
    var currentIndex = st.getSelectedRows()[0];
    var actionEditElement = st.getCellEdit(0, "action").element;
    var ruleActionValue = actionEditElement.options[actionEditElement.selectedIndex].value;
    var ruleNameShowElem = st.getCellShow(currentIndex, "ruleName");
    
    var ruleName = getNextRuleName(ruleActionValue);
    if (ruleName != null)
    {
    	st.setAtomValue(st.getCellShow(currentIndex, "ruleName"), RESOURCE[RULENAMES[ruleName]]);
      st.setCellValue(st.getCell(currentIndex, "ruleName"), "ruleName", ruleName);
    }
    else
    {
    	st.setAtomValue(st.getCellShow(currentIndex, "ruleName"), "");
      st.setCellValue(st.getCell(currentIndex, "ruleName"), "ruleName", "");
    }
    st.setAtomValue(st.getCellShow(currentIndex, "ruleArea"), "");
    st.setCellValue(st.getCell(currentIndex, "ruleArea"), "ruleArea", "");
	
	  ruleNameChange();
}


function openEditIPDalog() {
	var URL= "editIPDialog.html?neid=" + neid;
	var objx = getNeProperty(self);
	if(typeof(objx.token) != "undefined" && objx.token)
	{
		 URL += "&token=" + objx.token;
	}
	xshowModalDialog(URL, RESOURCE["title_subnet_filter"], 400, 180, "../../../../../images/");
}


function openEditMatricDialog() {
	var convertType = this.storeValue["convertType"];
	var fact = this.storeValue["fact"];
	var dstRouteType = windowParent.getDstType();
	var URL= "editmatrixdialg.html?neid=" + neid + "&convertType=" + convertType + "&fact=" + fact + "&dstRouteType=" + dstRouteType;
	var objx = getNeProperty(self);
	if(typeof(objx.token) != "undefined" && objx.token)
	{
		URL += "&token=" + objx.token;
	}		
	xshowModalDialog(URL, RESOURCE["title_matric"], 720, 180, "../../../../../images/");
}


/**
 * remove rule
 */
function deleterule(){	
    var selectedRows = st.getSelectedRows();
    for (var index = selectedRows.length - 1; index >= 0; index--) 
    {
    	if(getRuleNameISIS(selectedRows[index]))
    	{
    		continue;
    	}
        st.deleteRow(selectedRows[index]);
    }
    st.adjustDataRows();
	
	if(st.getDataRowLength() > 0)
	{
		st.setRowSelect(st.getDataRowLength() - 1);
		rowSelectHandler();
	}
	else
	{
		$("deletebtn").disabled = true;
	}

	$("createbtn").disabled = !btnRightArr.createbtn.right;
	$("applyRbtn").disabled = !btnRightArr.applyRbtn.right;
}

/**
 * finish modify subnet ip address
 */
function updateSubnetScope(ip, masklength){
    var currentIndex = st.getSelectedRows()[0];
    st.setAtomValue(st.getCellShow(currentIndex, "ruleArea"), ip + "/" + masklength);
	var cell = st.getCell(currentIndex, "ruleArea");
    st.setCellValue(cell, "ip", ip);
    st.setCellValue(cell, "masklength", masklength);
    st.setCellValue(cell, "ruleArea", ip);
	
    cell.element.modify = true;
    cell.element.parentNode.modify = true;
    cell.element.style.backgroundColor = "#d0f946";
	$("applyRbtn").disabled = !btnRightArr.applyRbtn.right;
}

/**
 * update matric
 */
function updateMatric(routeType, fact){
    var currentIndex = st.getSelectedRows()[0];
    var matricString = RESOURCE[matric[routeType]] + "." + "(" + RESOURCE["text_fact"] + ":"+ fact + ")";
    st.setAtomValue(st.getCellShow(currentIndex, "ruleArea"), matricString);
	var cell = st.getCell(currentIndex, "ruleArea");
    st.setCellValue(cell, "convertType", routeType);
    st.setCellValue(cell, "fact", fact);
	st.setCellValue(cell, "ruleArea", fact);
	
    cell.element.modify = true;
    cell.element.parentNode.modify = true;
    cell.element.style.backgroundColor = "#d0f946";
	$("applyRbtn").disabled = !btnRightArr.applyRbtn.right;
	
}

/**
 * modify rule item
 */
function modifyPolicy() {
	
}

/**
 *  update route policy
 * @param {Object} policyID
 */
function updateRoutePolicy(policyID, singlePolicyRow){
	st.clearTableData();	
	curRuleItems = singlePolicyRow;
	saveRuleType();
    var dinterface = new DataInterface();
    if (singlePolicyRow.subnetswitch.value == SWITCH_ON) {
        var scopeShowString = convertNumToIpaddr(singlePolicyRow.subnetip.value) + "/" + singlePolicyRow.masklength.value;
        constructData(dinterface, ROUTE_ACTION_MATCH, FILTER_SUBNET, scopeShowString);
    }    
    if (singlePolicyRow.routetypeswitch.value == SWITCH_ON) {
        constructData(dinterface, ROUTE_ACTION_MATCH, FILTER_ROUTETYPE, RESOURCE[ROUTE_TYPE[singlePolicyRow.routetype.value]]);
    }
	if(singlePolicyRow.ospfswitch.value == SWITCH_ON) 
	{
		constructData(dinterface, ROUTE_ACTION_MATCH, FILTER_OSPF, singlePolicyRow.ospfvalue.value);
	}	
	if(singlePolicyRow.ospftagswitch.value == SWITCH_ON) 
	{
		constructData(dinterface, ROUTE_ACTION_MATCH, FILTER_TAG, singlePolicyRow.ospftag.value);
	}
	if(singlePolicyRow.actiontagSwtich.value == SWITCH_ON) 
	{
		constructData(dinterface, ROUTE_ACTION_ACTION, FILTER_ACTION_OSPFTAG, singlePolicyRow.actionatag.value);
	}	
	if(singlePolicyRow.actionRouteTypeSwitch.value == SWITCH_ON) 
	{
		constructData(dinterface, ROUTE_ACTION_ACTION, FILTER_ACTION_ROUTETYPE, RESOURCE[ROUTE_TYPE[singlePolicyRow.actionRouteType.value]]);		
	}
	if(singlePolicyRow.matricConvert.value != DEFAULT_ACT_MATRIC_CONV)
	{
		var matricString = RESOURCE[matric[singlePolicyRow.matricConvert.value]] + "." + "(" + RESOURCE["text_fact"] + ":"+ singlePolicyRow.matricFact.value + ")"; 
		constructData(dinterface, ROUTE_ACTION_ACTION, FILTER_ACTION_MATRIC, matricString);
	}
    createTableBody(st, window.tableconf[0], dinterface, RESOURCE);
	var ruleName;
	for(var ri = 0, size = st.getDataRowLength(); ri < size; ri++) {
		ruleName = st.getCellStoreValue(ri, "ruleName", "ruleName");
		var cell = st.getCell(ri, "ruleArea");
		if(ruleName == FILTER_SUBNET) {
			var cell = st.getCell(ri, "ruleArea");
			st.setCellValue(cell, "ip", convertNumToIpaddr(singlePolicyRow.subnetip.value));
			st.setCellValue(cell, "masklength", singlePolicyRow.masklength.value);
			st.getCellElement(ri, "ruleArea").ondblclick = openEditIPDalog;
		}
		else if(ruleName == FILTER_ROUTETYPE)
		{
			st.setCellValue(cell, "ruleArea", singlePolicyRow.routetype.value);
		}
		else if(ruleName == FILTER_ACTION_ROUTETYPE)
		{
			st.setCellValue(cell, "ruleArea", singlePolicyRow.actionRouteType.value);
		}
		else if(ruleName == FILTER_ACTION_MATRIC)
		{
			st.setCellValue(cell, "convertType", singlePolicyRow.matricConvert.value);
			st.setCellValue(cell, "fact", singlePolicyRow.matricFact.value);
			st.getCellElement(ri, "ruleArea").ondblclick = openEditMatricDialog;
		}
	}	
	$("deletebtn").disabled = true;
	$("applyRbtn").disabled = true;
	var isDefault = false;
	var currentIndexs = parentWin.st.getSelectedRows();
	if(parentWin.isDefaultPolicy(parentWin.st.getCellStoreValue(currentIndexs[0], "policyID","policyID")))
    {
		isDefault = true;
    }
	$("createbtn").disabled = (getNextRuleName() == null) || isDefault ? true : !btnRightArr.createbtn.right; 
	
	addCellEvent();
	if(windowParent.getDstType() == PUBLICSRC_ISIS)
	{
		for(var ri = 0, size = st.getDataRowLength(); ri < size; ri++) 
		{
			if( st.getCellStoreValue(ri, "ruleName", "ruleName") == FILTER_ACTION_ROUTETYPE)
			{
			    var nameCell = st.getCell(ri, "ruleName");
			    var actionCell = st.getCell(ri, "action");  
			    st.setCellIsEdit(nameCell, false);
			    st.setCellIsEdit(actionCell, false);			 
			    break;   
			}			
		}
	}
}

/**
 * modify rule item xml,only called in main page
 */
function createModifyXML()
{
	logString = "";
	var subnetswitch;
	var subnetip = getOldRuleItemValue("subnetip");;
	var masklength = getOldRuleItemValue("masklength");;
	var routetypeswitch;
	var routetype = getOldRuleItemValue("routetype");		
	var ospfswitch;
	var ospfvalue = getOldRuleItemValue("ospfvalue");
	var ospftagswitch;
	var ospftag = getOldRuleItemValue("ospftag");
	var actiontagSwtich;
	var actionatag = getOldRuleItemValue("actionatag");
	var actionRouteTypeSwitch;
	var actionRouteType = getOldRuleItemValue("actionRouteType");
	var actionMatric;
	var matricConvert = getOldRuleItemValue("matricConvert");
	var matricFact = getOldRuleItemValue("matricFact");
	
    var ruleNameValue;	
	var bRuleEnable;
	var enableFlag  = false;
	var rowIndex;
	var ruleAreaValue;
    for (var ruleNamev = 0, rsize = rulenamesIDS.length; ruleNamev < rsize; ruleNamev++) {
        for (var index = 0, size = st.getDataRowLength(); index < size; index++) {
            ruleNameValue = st.getCellStoreValue(index, "ruleName", "ruleName");
			if(ruleNameValue == rulenamesIDS[ruleNamev]) {				
				bRuleEnable = true;
				rowIndex = index;
				break;
			}
        }
		enableFlag = bRuleEnable ? SWITCH_ON : SWITCH_OFF;
		if (bRuleEnable) {
			ruleAreaValue = st.getCellStoreValue(rowIndex , "ruleArea", "ruleArea");
		}
		switch(rulenamesIDS[ruleNamev]) {
			case FILTER_SUBNET: {
				subnetswitch = enableFlag;
				if(bRuleEnable) {					
					subnetip = hexToTen(convertIpaddrToHexcode(st.getCellStoreValue(rowIndex , "ruleArea", "ip")));
					masklength = st.getCellStoreValue(rowIndex , "ruleArea", "masklength");
				}
				break;
			}
			case FILTER_ROUTETYPE : {
				routetypeswitch = enableFlag;	
				if (bRuleEnable) {
					routetype = ruleAreaValue;
				}	
				break;
			}
			case FILTER_OSPF : {
				ospfswitch = enableFlag;	
				if (bRuleEnable) {
					ospfvalue = ruleAreaValue;
				}
				break;	
			}
			case FILTER_TAG : {
				ospftagswitch = enableFlag;		
				if (bRuleEnable) {
					ospftag = ruleAreaValue;
				}
				break;
			}
			case FILTER_ACTION_OSPFTAG : {
				actiontagSwtich = enableFlag;	
				if (bRuleEnable) {
					actionatag = ruleAreaValue;
				}	
				break;
			}
			case FILTER_ACTION_ROUTETYPE : {
				actionRouteTypeSwitch = enableFlag;		
				if (bRuleEnable) {
					actionRouteType = ruleAreaValue;
				}
				break;
			}
			case FILTER_ACTION_MATRIC : {
				actionMatric = enableFlag;		
				if (bRuleEnable) {
					matricConvert = st.getCellStoreValue(rowIndex , "ruleArea", "convertType");
					matricFact = st.getCellStoreValue(rowIndex , "ruleArea", "fact");
				}
				break;
			}
		}
		bRuleEnable = false;
    }
	
	
	var root = new inputxml("datainterface");
    var business = new tagElement("bussiness-params");
    var row;
	
    row = new tagElement("row-params");
	    
    var param = new tagElement("param");
    param.setAttribute("name", "neid");
    param.setAttribute("value", windowParent.neid);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "isauto");
    param.setAttribute("value", 0);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "policyID");
    param.setAttribute("value", windowParent.getSelectedPolicyID());
    row.appendChild(param);
	stuffLog(RESOURCE["text_policyID"], windowParent.getSelectedPolicyID());
	if(saveRuleTypes.contains(FILTER_SUBNET) || subnetswitch)
	{
		param = new tagElement("param");
    	param.setAttribute("name", "subnetswitch");
    	param.setAttribute("value", subnetswitch);
    	row.appendChild(param);		
		param = new tagElement("param");
    	param.setAttribute("name", "subnetip");
    	param.setAttribute("value", subnetip);
	    row.appendChild(param);	
		param = new tagElement("param");
	    param.setAttribute("name", "masklength");
	    param.setAttribute("value", masklength);
	    row.appendChild(param);	
	   	if(subnetswitch == SWITCH_ON)
		{
			stuffLog(RESOURCE["FILTER_SUBNET"], convertNumToIpaddr(subnetip));
			stuffLog(RESOURCE["text_mask"], masklength);
		}
		else 
		{
			stuffLog(RESOURCE["delItem"], RESOURCE["FILTER_ROUTETYPE"]);
		}
	}
	
	if(saveRuleTypes.contains(FILTER_ROUTETYPE) || routetypeswitch)
	{
		param = new tagElement("param");
	    param.setAttribute("name", "routetypeswitch");
	    param.setAttribute("value", routetypeswitch);
	    row.appendChild(param);	
	
		param = new tagElement("param");
	    param.setAttribute("name", "routetype");
	    param.setAttribute("value", routetype);
	    row.appendChild(param);	
		if(routetypeswitch == SWITCH_ON)
		{
			stuffLog(RESOURCE["FILTER_ROUTETYPE"], RESOURCE[RULENAMES[routetype]]);
		}
		else 
		{
			stuffLog(RESOURCE["delItem"], RESOURCE["FILTER_ROUTETYPE"]);
		}
	}
	
	if(saveRuleTypes.contains(FILTER_OSPF) || ospfswitch)
	{
		param = new tagElement("param");
	    param.setAttribute("name", "ospfswitch");
	    param.setAttribute("value", ospfswitch);
	    row.appendChild(param);	
		param = new tagElement("param");
	    param.setAttribute("name", "ospfvalue");
	    param.setAttribute("value", ospfvalue);
	    row.appendChild(param);	
		if(ospfswitch == SWITCH_ON)
		{
			stuffLog(RESOURCE["FILTER_OSPF"], ospfvalue);
		}
		else 
		{
			stuffLog(RESOURCE["delItem"], RESOURCE["FILTER_OSPF"]);
		}
	}
	
	if(saveRuleTypes.contains(FILTER_TAG) || ospftagswitch)
	{
		param = new tagElement("param");
	    param.setAttribute("name", "ospftagswitch");
	    param.setAttribute("value", ospftagswitch);
	    row.appendChild(param);	
		param = new tagElement("param");
	    param.setAttribute("name", "ospftag");
	    param.setAttribute("value", ospftag);
	    row.appendChild(param);	
		if(ospftagswitch == SWITCH_ON)
		{
			stuffLog(RESOURCE["FILTER_TAG"], ospfvalue);
		}
		else 
		{
			stuffLog(RESOURCE["delItem"], RESOURCE["FILTER_TAG"]);
		}
	}
	
	if(saveRuleTypes.contains(FILTER_ACTION_OSPFTAG) || actiontagSwtich)
	{
		param = new tagElement("param");
	    param.setAttribute("name", "actiontagSwtich");
	    param.setAttribute("value", actiontagSwtich);
	    row.appendChild(param);	
		param = new tagElement("param");
	    param.setAttribute("name", "actionatag");
	    param.setAttribute("value", actionatag);
	    row.appendChild(param);	
		if(actiontagSwtich == SWITCH_ON)
		{
			stuffLog(RESOURCE["FILTER_ACTION_OSPFTAG"], actionatag);
		}
		else 
		{
			stuffLog(RESOURCE["delItem"], RESOURCE["FILTER_ACTION_OSPFTAG"]);
		}
	}
	
	
	if(saveRuleTypes.contains(FILTER_ACTION_ROUTETYPE) || actionRouteTypeSwitch)
	{
		param = new tagElement("param");
	    param.setAttribute("name", "actionRouteTypeSwitch");
	    param.setAttribute("value", actionRouteTypeSwitch);
	    row.appendChild(param);	
		param = new tagElement("param");
	    param.setAttribute("name", "actionRouteType");
	    param.setAttribute("value", actionRouteType);
	    row.appendChild(param);	
		if(actionRouteTypeSwitch == SWITCH_ON)
		{
			stuffLog(RESOURCE["FILTER_ACTION_ROUTETYPE"], RESOURCE[ROUTE_TYPE[actionRouteType]]);
		}
		else 
		{
			stuffLog(RESOURCE["delItem"], RESOURCE["FILTER_ACTION_ROUTETYPE"]);
		}
	}	
	if(saveRuleTypes.contains(FILTER_ACTION_MATRIC) && !actionMatric)
	{
		matricConvert = DEFAULT_ACT_MATRIC_CONV;
		matricFact    = DEFAULT_ACT_MATRIC_FACT;
	}
	if(saveRuleTypes.contains(FILTER_ACTION_MATRIC) || actionMatric)
	{
		param = new tagElement("param");
	    param.setAttribute("name", "matricConvert");
	    param.setAttribute("value", matricConvert);
	    row.appendChild(param);	
		param = new tagElement("param");
	    param.setAttribute("name", "matricFact");
	    param.setAttribute("value", matricFact);
	    row.appendChild(param);	
	    
	    if (actionMatric == SWITCH_ON) {
	        stuffLog(RESOURCE["FILTER_ACTION_MATRIC"], RESOURCE[matric[matricConvert]] + "/" + RESOURCE["text_matrixconvType"] + ":" + matricFact);
	    }
	    else {
	        stuffLog(RESOURCE["delItem"], RESOURCE["FILTER_ACTION_MATRIC"]);
	    }
	}
	
    var param = new tagElement("param");
    param.setAttribute("name", "opDesc");
    param.setAttribute("value", logString);
    row.appendChild(param);
	
	
	business.appendChild(row);
	
    root.getRoot().appendChild(business);
    return root.toString();
}


/**
 * Call modify 
 * @param {Object} isApply true:click 'Apply', false: click 'OK'
 */
function modifyRuleItems(){
	if(!checkRuleValid())
	{
		return;
	}
	setRuleItemsStatus(false);
    var xml = createModifyXML();
    var URL = "../../../../../neExlorerServlet?sfid=" + TECMDCODE_PTN_CONTROLPLAN_ROUTEPOLICY_RULEITEM_APPLY + "&nmUser=" + windowParent.rootobj["nmUser"];
    loadXMLdoc(URL, "POST", false, doModifyBack, null, "inputdata=" + xml);
}

/**
 *  modify call back
 */
function doModifyBack(doc){		
    var data = EncapsulateData(doc);
	var retCode = data.getSErrorCode();
	if(retCode != OPERATION_SUCCESS)	
	{
		$("applyRbtn").disabled=!btnRightArr.applyRbtn.right;
		var isDefault = false;
		var currentIndexs = parentWin.st.getSelectedRows();
	  if(parentWin.isDefaultPolicy(parentWin.st.getCellStoreValue(currentIndexs[0], "policyID","policyID")))
    {
		    isDefault = true;
    }
		$("createbtn").disabled = (getNextRuleName() == null) || isDefault ? true : !btnRightArr.createbtn.right; 
		$("deletebtn").disabled = !btnRightArr.deletebtn.right;
		
	    if(data.getError().rowErrors[0])
	    {	
			var size = data.getBErrLength();
	        for(var i = 0;i < size;i++)
	        {
		        var tempObj = data.getError().rowErrors[i].errorObj;
  	        	tempObj["operateObj"] = RESOURCE["modifyItems"] + "," + RESOURCE["text_policyID"] + ":" + windowParent.getSelectedPolicyID();
		    }
	    }	
	    var errArr = [];
        errArr[0] = "operateObj";
        openErrPage("../../../../../page/", data.getError(), errArr);
	}
	
	if (OPERATION_SUCCESS == retCode || 
		OPERATION_PART_SUCCESS == retCode) 
	{
		var selectedRow = windowParent.getSelectedfirstRow();
		windowParent.queryPolicy(selectedRow);
    }
}

function getNextRuleAction(ruleName) 
{
	if(ruleName <= FILTER_TAG) 
	{
		return ROUTE_ACTION_MATCH;
	}
	return ROUTE_ACTION_ACTION;
}

/**
 * Get next rule name for adding new rule.
 */
function getNextRuleName(action)
{
	var srcType;
	var dstType;
	if(isCreateDial)
	{
		srcType = getSrcType();
		dstType = getDstType();
	}
	else
	{
		srcType = windowParent.getSrcType();
		dstType = windowParent.getDstType();
	}
	
	var selectedRuleNames = new Array();
	for(var index = 0, size = st.getDataRowLength(); index < size; index++) 
	{
		selectedRuleNames.append(st.getCellStoreValue(index, "ruleName", "ruleName"));		
	}
	/**
	 * if src or dst is not ospf,no show ospf relate ruleitems
	 */
	if(srcType != PUBLICSRC_OSPF)
	{
		selectedRuleNames.append(FILTER_OSPF);
		selectedRuleNames.append(FILTER_TAG);
	}
	if(srcType == PUBLICSRC_OTHER || 
	   srcType == PUBLICSRC_STATIC ||
	   srcType == PUBLICSRC_RIP ||
	   srcType == PUBLICSRC_BGP)
	{
		selectedRuleNames.append(FILTER_ROUTETYPE);
	}
	if(dstType != PUBLICSRC_OSPF)
	{
		selectedRuleNames.append(FILTER_ACTION_OSPFTAG);
	}
    if(dstType == PUBLICSRC_OTHER || 
       dstType == PUBLICSRC_STATIC||
       dstType == PUBLICSRC_RIP   ||
       dstType == PUBLICSRC_BGP)
	{
		selectedRuleNames.append(FILTER_ACTION_ROUTETYPE);
	}
	
	/**
	 *    action      rulename          
	 *                         
	 */
	if(action != null)
	{
		if (action == ROUTE_ACTION_MATCH) {
				selectedRuleNames.append(FILTER_ACTION_OSPFTAG);
				selectedRuleNames.append(FILTER_ACTION_ROUTETYPE);
				selectedRuleNames.append(FILTER_ACTION_MATRIC);
	  } 
	  else 
	  {
	  		selectedRuleNames.append(FILTER_SUBNET);
				selectedRuleNames.append(FILTER_ROUTETYPE);
				selectedRuleNames.append(FILTER_OSPF);
				selectedRuleNames.append(FILTER_TAG);
	  }
	}
	
 
	for(var nameIndex = 0, size = rulenamesIDS.length; nameIndex < size ; nameIndex ++) {
		if(!selectedRuleNames.contains(rulenamesIDS[nameIndex])) 
		{
			return rulenamesIDS[nameIndex];
		}
	}
	return null;
}

/**
 * check rule value
 */
function checkRuleValid()
{
	var selectedRuleNames = new Array();
	var ruleid ;
	for(var index = 0, size = st.getDataRowLength(); index < size; index++) 
	{
		ruleid = st.getCellStoreValue(index, "ruleName", "ruleName");
		if(selectedRuleNames.contains(ruleid)) 
		{
			alert(RESOURCE["promptDuplicateRule"] + RESOURCE[RULENAMES[ruleid]]);
			return false;
		}
		selectedRuleNames.append(ruleid);		
	}	
	
	var areaValue;
	for(var index = 0,size = st.getDataRowLength(); index < size; index++) 
	{
		areaValue = st.getCellStoreValue(index, "ruleArea", "ruleArea");
		var ruleNameValue = st.getCellStoreValue(index, "ruleName", "ruleName");
		if(ruleNameValue == FILTER_ACTION_MATRIC)
		{
			areaValue = st.getCellStoreValue(index, "ruleArea", "convertType");
		}
		
		if(areaValue == null || areaValue == "") 
		{
			alert(RESOURCE["prompArea"].replace("rulename", RESOURCE[RULENAMES[ruleNameValue]]));
			return false;
		}
		
		if(ruleNameValue == FILTER_SUBNET)
		{
			if(areaValue == "0.0.0.0" || areaValue == "0.0.0.0/0")
			{
				alert(RESOURCE["prompArea"].replace("rulename", RESOURCE[RULENAMES[ruleNameValue]]));
				return false;
			}
		}
	}
	return true;
}

function stuffLog(key, value)
{
	if(logString != "")	 
	{
		logString += "," ;
	}
	logString += key + ":" + value;
}

/**
 * Disabled right click handler for multi rows
 * @param {Object} event
 */
function tableContextHandler(event){
	var rows = st.getSelectedRows();
  if(rows.length > 1)
	{
		return ;
	}
	var colid = getSelectedColid(event);
	var curentValue = st.getCellStoreValue(rows[0], colid, colid);
	if (colid == "ruleName") {
  	  addEditOptions4RuleNameCol(rows[0]);
  }
	else if(colid == "ruleArea")
	{
			addEditOptions4RuleArea(rows[0],colid,curentValue);
			var ruleNameValue = st.getCellStoreValue(rows[0], "ruleName", "ruleName");
			var cell = st.getCell(rows[0], "ruleArea").element;
			switch(ruleNameValue) 
			{
				case FILTER_SUBNET:
				{
					openEditIPDalog.apply(cell);
					return;
				}		
				case FILTER_ACTION_MATRIC: 
				{
					openEditMatricDialog.apply(cell);
					return;
				}
			}
	}
  popupMenuHandler(event);
}

/**
 *         
 */
function setRuleItemsStatus(isEnable)
{
	$("createbtn").disabled = !isEnable;
    $("deletebtn").disabled = !isEnable;
	if($("applyRbtn") != null)
	{
		$("applyRbtn").disabled = !isEnable;
	}
}

function getSelectedColid(event)
{
	if (!event) {
        event = window.event;
    }
    var elem = (event.target) ? event.target : event.srcElement;
    while (elem != null) {
        if (elem.tagName == 'TD') {
            break;
        }
        else {
            elem = elem.parentNode;
        }
    }
	if(elem != null)
	{
		return elem.colid;
	}
	return null;
}

/**
 * dbclick handler
 */
var mozillaComboboxDiv;
function cellondbclick(){
    mozillaComboboxDiv = 0;
    this.style.backgroundColor = "#d0f946";
    if (isIE) {
        this.onselectstart = null;
    }
    else {
        this.style.MozUserSelect = "text";
    }
    this.modify = true; 
    this.parentNode.modify = true; 
	this.showElement.element.style.display = "none"; 
    var colid = this.colid;
    handleCellEdit(this, TABLE_CONSTANT.BEFOREEDIT);
	var rowIndex = st.getSelectedRows()[0];
	var action = st.getCellStoreValue(rowIndex, "action", "action");
	var ruleName = st.getCellStoreValue(rowIndex, "ruleName", "ruleName");
	var curentValue = st.getCellStoreValue(rowIndex, colid, colid);
	var isSelectEdit = false;
	
  if(colid == "action")
	{
		isSelectEdit = true;
	}
  else if (colid == "ruleName") {
  	  addEditOptions4RuleNameCol(rowIndex);
  	  isSelectEdit = true;
  }
	else if(colid == "ruleArea")
	{
			isSelectEdit = addEditOptions4RuleArea(rowIndex, colid, curentValue);
	}
	
	var editdom = this.parent.editdom[colid];	
  if(isSelectEdit)
	{
      for (i = 0; i < editdom.element.options.length; i++) {
          if (editdom.element.options[i].value == curentValue) {
              editdom.element.options[i].selected = true;
          }
      }
	}
	if (this.offsetWidth) {
       editdom.element.style.width = (this.offsetWidth - 1) + "px";
    }
    this.appendChild(editdom.element);
    editdom.element.focus();
}

/**
 *  rule name      options
 */
function addEditOptions4RuleNameCol(selectedIndex)
{
		var action = st.getCellStoreValue(selectedIndex, "action", "action");
    var editdom = st.getCellEdit(0, "ruleName");
    var src;
    var dest;
  	if(isCreateDial)
		{
			src = getSrcType();
			dest = getDstType();
		}
		else
		{
			src = windowParent.getSrcType();
			dest = windowParent.getDstType();
		}
    
    editdom.clearOptions();
    /**
     *   Qx     
     */
    if (action == ROUTE_ACTION_MATCH) {
        editdom.addOption(RESOURCE["FILTER_SUBNET"], FILTER_SUBNET);
        if(src == PUBLICSRC_ISIS || src == PUBLICSRC_OSPF)
        {
        	editdom.addOption(RESOURCE["FILTER_ROUTETYPE"], FILTER_ROUTETYPE);
        }
        
        if(src == PUBLICSRC_OSPF)
        {
        	editdom.addOption(RESOURCE["FILTER_OSPF"], FILTER_OSPF);
        	editdom.addOption(RESOURCE["FILTER_TAG"], FILTER_TAG);
        }
    }
    else {
    	if(dest == PUBLICSRC_OSPF)
    	{
    		editdom.addOption(RESOURCE["FILTER_ACTION_OSPFTAG"], FILTER_ACTION_OSPFTAG);
    	}  
    	if(dest == PUBLICSRC_ISIS || dest == PUBLICSRC_OSPF)
        {
        	editdom.addOption(RESOURCE["FILTER_ACTION_ROUTETYPE"], FILTER_ACTION_ROUTETYPE);
        }      	
        editdom.addOption(RESOURCE["FILTER_ACTION_MATRIC"], FILTER_ACTION_MATRIC);
    }
    editdom.element.onchange = ruleNameOnChange;
    editdom.element.onblur = rulenamecellonblur;
}

/**
 *   rulearea options
 */
function addEditOptions4RuleArea(selectedIndex, colid,curentValue)
{
		var ruleName = st.getCellStoreValue(selectedIndex, "ruleName", "ruleName");
		var ruleAreaCell = st.getCell(selectedIndex, "ruleArea").element;
		var isSelectDefault = false;
		switch (ruleName) {
			case FILTER_ROUTETYPE:
			case FILTER_ACTION_ROUTETYPE:
			{
				var publicSrc;
        var publicDest;
      	if(isCreateDial)
				{
					publicSrc = getSrcType();
					publicDest = getDstType();
				}
				else
				{
					publicSrc = windowParent.getSrcType();
					publicDest = windowParent.getDstType();
				}			
        var editdom = st.createAtom("select");
        editdom.element.onblur = cellonblur;
        editdom.element.onclick = stopEventPropagation;
        editdom.element.onmousedown = atomOnMouseDownHandle;
        editdom.element.ondblclick = stopEventPropagation;
				ruleAreaCell.parent.editdom[colid] = editdom;
				ruleAreaCell.editElement = editdom;
				var rtOptions ;
				if(ruleName == FILTER_ROUTETYPE)
				{
					rtOptions = getRTOptions(ruleName, publicSrc);
				}
				else if(ruleName == FILTER_ACTION_ROUTETYPE)
				{
					rtOptions = getRTOptions(ruleName, publicDest);
				}
				
				for(var i=0; i<rtOptions.length; i++)
				{
					editdom.addOptionObj(rtOptions[i]);
				}
                
				isSelectDefault = true;
        break;
			}			
			case FILTER_OSPF:
			case FILTER_TAG:
			case FILTER_ACTION_OSPFTAG:
			{
			    var editdom = st.createAtom("text");
					editdom.element.onblur = cellonblur;
			    editdom.element.onclick = stopEventPropagation;
			    editdom.element.onmousedown = atomOnMouseDownHandle;
			    editdom.element.ondblclick = stopEventPropagation;
			    if(curentValue == null)
			    {
			    	curentValue = "";
			    }
			    editdom.setValue(curentValue);
					ruleAreaCell.parent.editdom[colid] = editdom;
					ruleAreaCell.editElement = editdom;
					textCheck(editdom.element, 0, OSPFVALUE);
					break;
			}
		}
		
		return isSelectDefault;
}

/**
 *         
 */
function addCellEvent(){
    st.editdom["action"].element.onchange = updateRuleName;
}

function rowSelectHandler(event){
	var isSelectISISItem = false;
    var currentIndexs = st.getSelectedRows();
    for(var index = 0, size = currentIndexs.length; index < size; index++)
    {
    	if(getRuleNameISIS(currentIndexs[index]) )
    	{
    		isSelectISISItem = true;
    		break;
    	}
    }
    
    $("deletebtn").disabled= ((currentIndexs.length==0)  || isSelectISISItem )? true : !btnRightArr.deletebtn.right;
        
	var len = st.getDataRowLength();
	for (var i=0; i<len; i++)
	{
			setCellColor(st, i, "action");
			setCellColor(st, i, "ruleName");
			setCellColor(st, i, "ruleArea");
	}
		
}

/**
 *            
 */
function saveRuleType()
{
	saveRuleTypes = [];
	if (curRuleItems.subnetswitch.value == SWITCH_ON) {
		saveRuleTypes.push(FILTER_SUBNET);
    }    
    if (curRuleItems.routetypeswitch.value == SWITCH_ON) {
    	saveRuleTypes.push(FILTER_ROUTETYPE);
    }
	if(curRuleItems.ospfswitch.value == SWITCH_ON) 
	{
		saveRuleTypes.push(FILTER_OSPF);
	}	
	if(curRuleItems.ospftagswitch.value == SWITCH_ON) 
	{
		saveRuleTypes.push(FILTER_TAG);
	}
	if(curRuleItems.actiontagSwtich.value == SWITCH_ON) 
	{
		saveRuleTypes.push(FILTER_ACTION_OSPFTAG);
	}	
	if(curRuleItems.actionRouteTypeSwitch.value == SWITCH_ON) 
	{
		saveRuleTypes.push(FILTER_ACTION_ROUTETYPE);
	}
	if(curRuleItems.matricConvert.value != DEFAULT_MATRIC_TYPE)
	{
		saveRuleTypes.push(FILTER_ACTION_MATRIC);
	}
}

/**
 *              
 */
function getOldRuleItemValue(key)
{
	if(!curRuleItems[key])
	{
		return null;
	}
	return curRuleItems[key].value;
}

function setCellColor(st, row, colid)
{
		var cell = st.getCellElement(row, colid);
		var color = color_desel;
		
		if (st.getRowSelFlag(row))
		{
				color = color_select;
		}
		else if (cell.isEdit == 0)
		{
				color = color_nonedit;
		}
		else if (cell.modify)
		{
				color = color_edited;
		}
		
		cell.style.backgroundColor = color;
}

function rulenamecellonblur()
{	
	cellonblurevt.apply(this);
	ruleNameChange();
}

/**
 * 
 * according source route or sink route type to make route types needed to show.
 * 
 */
function getRTOptions(ruleName, routeType)
{
	var options = [];
	if(ruleName == FILTER_ROUTETYPE)
    {
    	switch(routeType)
    	{
        	case PUBLICSRC_STATIC:
        	{
        		options.push(new Option(RESOURCE[ROUTE_TYPE[RT_STATIC]], RT_STATIC));
        		break;
        	}
        	case PUBLICSRC_RIP:
        	{
        		options.push(new Option(RESOURCE[ROUTE_TYPE[RT_RIP]], RT_RIP));
        		break;
        	}
        	case PUBLICSRC_OSPF:
        	{
        		options.push(new Option(RESOURCE[ROUTE_TYPE[RT_OSPFINTRA]], RT_OSPFINTRA));
        		options.push(new Option(RESOURCE[ROUTE_TYPE[RT_OSPFINTER]], RT_OSPFINTER));
        		options.push(new Option(RESOURCE[ROUTE_TYPE[RT_OSPFTYPE1]], RT_OSPFTYPE1));
        		options.push(new Option(RESOURCE[ROUTE_TYPE[RT_OSPFTYPE2]], RT_OSPFTYPE2));
        		break;
        	}
        	case PUBLICSRC_ISIS:
        	{
        		options.push(new Option(RESOURCE[ROUTE_TYPE[RT_ISISL1INT]], RT_ISISL1INT));
        		options.push(new Option(RESOURCE[ROUTE_TYPE[RT_ISISL2INT]], RT_ISISL2INT));
        		options.push(new Option(RESOURCE[ROUTE_TYPE[RT_ISISL1EXT]], RT_ISISL1EXT));
        		options.push(new Option(RESOURCE[ROUTE_TYPE[RT_ISISL2EXT]], RT_ISISL2EXT));
        		break;
        	}
            case PUBLICSRC_BGP:
        	{
        		options.push(new Option(RESOURCE[ROUTE_TYPE[RT_BGPINT]], RT_BGPINT));
        		options.push(new Option(RESOURCE[ROUTE_TYPE[RT_BGPEXT]], RT_BGPEXT));
        		options.push(new Option(RESOURCE[ROUTE_TYPE[RT_BGPVPN]], RT_BGPVPN));
        		break;
        	}
    	}
    }
    
    if(ruleName == FILTER_ACTION_ROUTETYPE)
    {
    	switch(routeType)
    	{
        	case PUBLICSRC_RIP:
        	{
        		options.push(new Option(RESOURCE[ROUTE_TYPE[RT_RIP]], RT_RIP));
        		break;
        	}
        	case PUBLICSRC_OSPF:
        	{
        		options.push(new Option(RESOURCE[ROUTE_TYPE[RT_OSPFTYPE1]], RT_OSPFTYPE1));
        		options.push(new Option(RESOURCE[ROUTE_TYPE[RT_OSPFTYPE2]], RT_OSPFTYPE2));
        		break;
        	}
        	case PUBLICSRC_ISIS:
        	{
        		options.push(new Option(RESOURCE[ROUTE_TYPE[RT_ISISL1INT]], RT_ISISL1INT));
        		options.push(new Option(RESOURCE[ROUTE_TYPE[RT_ISISL2INT]], RT_ISISL2INT));
        		options.push(new Option(RESOURCE[ROUTE_TYPE[RT_ISISL1EXT]], RT_ISISL1EXT));
        		options.push(new Option(RESOURCE[ROUTE_TYPE[RT_ISISL2EXT]], RT_ISISL2EXT));
        		break;
        	}
            case PUBLICSRC_BGP:
        	{
        		options.push(new Option(RESOURCE[ROUTE_TYPE[RT_BGPINT]], RT_BGPINT));
        		options.push(new Option(RESOURCE[ROUTE_TYPE[RT_BGPEXT]], RT_BGPEXT));
        		options.push(new Option(RESOURCE[ROUTE_TYPE[RT_BGPVPN]], RT_BGPVPN));
        		break;
        	}
        	default:{
        		break;
        	}
    	}
    }
    
    return options;
}

/**
 *	       ISIS
 */
function getRuleNameISIS(index)
{
	var ruleNameValue = st.getCellStoreValue(index, "ruleName", "ruleName");
	if(ruleNameValue == FILTER_ACTION_ROUTETYPE && windowParent.getDstType() == PUBLICSRC_ISIS)
	{
		return true;
	}
	return false;	
}
