
/**
 *      
 */
var btnRightArr = new Object();

var rootobj,neid;

/**
 *  Query ALL 
 */
var Q_ALL_ROUTE_POLICY = 0;

/**
 * all policy data store in here.
 */
var policydata = null;

var logString = "";

var isE2E = false;
var e2ePolicyID;
var lastSelectedPolicyID ;

var DEFAULT_POLICY_RIP = 2147483644;
var DEFAULT_POLICY_OSPF = 2147483645;
var DEFAULT_POLICY_BGP = 2147483646;
var POLICY_NAME_MAXLENGTH = 64;

/**
 *       
 */
window.onload = function(){
	rootobj = getNeProperty(self);
	if(rootobj.policyID)
	{		
		isE2E = true;
		e2ePolicyID = rootobj.policyID;
	}
	neid = rootobj["neid"];
    initUI();
    window.onresize();
}


window.onresize = function(){
    var bodyClientHeight = document.getElementsByTagName("body")[0].clientHeight;
    var subButtonsHeight = bodyClientHeight - 170;// 140          resize     
    st.setBodyHeight(subButtonsHeight * 0.65); //               
}


function initUI() {
	initButtonInfo();	
	st = new SortTable();
    st.head.setAttribute("id", "htmlTable_STHead_RoutePolicy");
    st.body.setAttribute("id", "htmlTable_STBody_RoutePolicy");
    st.setImage("../../../../../images/");
    createTableHead(st, window.tableconf[0]);
    st.setOnCellEditHandler(cellEditHandler);
	st.setOnRowSelectHandler(rowSelectHandler);
    $("maintable").appendChild(st.getTable());
    $("maintable").oncontextmenu = popupMenuHandler;
	$("totalrow").innerText = RESOURCE["total"] +":";
    $("selrow").innerText = RESOURCE["selected"] +":";
    
    var objx = getNeProperty(self);
    var tokenURL = "";
    if(typeof(objx.token) != "undefined" && objx.token)
    {
    	tokenURL = "?token=" + objx.token;    	
    }
	
	
    tab = new Tabs();
    tab.setClass("tabs_head", "tabs_body", "tabs_ul", "tabs_li", "tabs_frame", "tabs_li_select");
    tab.addTab(TAB_ID_RULEITEM, RESOURCE["TAB_ID_RULEITEM"], "ruleitem.html"+tokenURL);
    tab.addTab(TAB_ID_APPLYOBJECT, RESOURCE["TAB_ID_APPLYOBJECT"], "applyobjects.html"+tokenURL);
    setTabsHeight(tab, "270px");
    $("policytab").appendChild(tab.getTabs());
    tab.selectTab(TAB_ID_RULEITEM);
}

/**
 * init button status
 */
function initButtonInfo(){
	if(isE2E)
	{
		$("querybtn").style.display = "none";
		$("createbtn").style.display = "none";
		$("deletebtn").style.display = "none";
	}
	$("querybtn").value = RESOURCE["querybtn"];
    $("createbtn").value = RESOURCE["createbtn"];
    $("deletebtn").value = RESOURCE["deletebtn"];
    $("applybtn").value = RESOURCE["applybtn"];
    
    btnRightArr.querybtn = new BtnRightObj("querybtn", TECMDCODE_PTN_CONTROLPLAN_ROUTEPOLICY_QUERY);
    btnRightArr.createbtn = new BtnRightObj("createbtn", TECMDCODE_PTN_CONTROLPLAN_ROUTEPOLICY_DEL);
    btnRightArr.deletebtn = new BtnRightObj("deletebtn", TECMDCODE_PTN_CONTROLPLAN_ROUTEPOLICY_NEW);
    btnRightArr.applybtn = new BtnRightObj("applybtn", TECMDCODE_PTN_CONTROLPLAN_ROUTEPOLICY_APPLY);
    
    getRightInfo(rootobj, btnRightArr);
    initrightbtn(btnRightArr);
    
    $("applybtn").disabled = true;
}

/**
 *              
 * @param {Object} param
 */
function cellEditHandler(param)
{
	$("applybtn").disabled = !btnRightArr.applybtn.right;
}

function rowSelectHandler(){
	var currentIndexs = st.getSelectedRows();
	var isDefault = false;
    if(currentIndexs.length > 0 && isDefaultPolicy(st.getCellStoreValue(currentIndexs[0], "policyID","policyID")))
    {
		isDefault = true;
    }
    $("deletebtn").disabled = ((currentIndexs.length == 0) || isDefault )? true : !btnRightArr.deletebtn.right;
    tab.getTabWindow(tab.getSelectedTabID()).tabSelectHandler();
	updateStatics();
}

function setTabsHeight(tab, tabodyheight)
{
    for(var key in tab.tabNodes)
    {
        tab.tabNodes[key].body.style.height = tabodyheight;
    }
}
/**
 * New policy dialog
 */
function createPolicy(){
    xshowModalDialog("newroutepolicy.html?neid=" + neid, RESOURCE["newpolicy"], 680, 550, "../../../../../images/");
}


function genQueryXML()
{
	var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var row = new tagElement("row-params");
    
    var param = new tagElement("param");    
    param.setAttribute("name","neid");
    param.setAttribute("value",neid);
    row.appendChild(param);
    
    param = new tagElement("param"); 
    param.setAttribute("name","policyID");
	if(e2ePolicyID)
	{
		param.setAttribute("value",e2ePolicyID);
	}
	else
	{
		param.setAttribute("value",Q_ALL_ROUTE_POLICY);
	}
    row.appendChild(param);
    
    bussiness.appendChild(row);
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

/**
 * modify policy
 */
function genModifyPolicyXML(){
	
	var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
	for (var i = 0, len = st.getDataRowLength(); i < len; i++) {	
        logString = "";
		if (st.getModify(i)) 		
		{
            var row = new tagElement("row-params");
            var param = new tagElement("param");
            param.setAttribute("name", "neid");
            param.setAttribute("value", neid);
            row.appendChild(param);
            
			param = new tagElement("param");
            param.setAttribute("name", "isauto");
            param.setAttribute("value", 0);
            row.appendChild(param);
            
            param = new tagElement("param");
            param.setAttribute("name", "policyID");
            param.setAttribute("value", st.getCellStoreValue(i, "policyID", "policyID"));
            row.appendChild(param);
            stuffLog(RESOURCE["text_policyID"], st.getCellStoreValue(i, "policyID", "policyID"));
            if(st.getCellModify(i,"name")) 
			{
				param = new tagElement("param"); 
    			param.setAttribute("name","name");
    			param.setAttribute("value",st.getCellStoreValue(i, "name", "name"));
			    row.appendChild(param);
				stuffLog(RESOURCE["text_policyName"], st.getCellStoreValue(i, "name", "name"));
			}
			if(st.getCellModify(i,"matchMode")) 
			{
				param = new tagElement("param"); 
    			param.setAttribute("name","matchMode");
    			param.setAttribute("value",st.getCellStoreValue(i, "matchMode", "matchMode"));
			    row.appendChild(param);
				stuffLog(RESOURCE["text_matchMode"], RESOURCE[matchMode[st.getCellStoreValue(i, "matchMode", "matchMode")]]);
			}
            
            if (st.getCellModify(i, "priority")) {
                param = new tagElement("param");
                param.setAttribute("name", "priority");
                param.setAttribute("value", st.getCellStoreValue(i, "priority", "priority"));
                row.appendChild(param);
                stuffLog(RESOURCE["text_priority"], st.getCellStoreValue(i, "priority", "priority"));
            }
			
            var param = new tagElement("param");
            param.setAttribute("name", "opDesc");
            param.setAttribute("value", logString);
            row.appendChild(param);
			
			bussiness.appendChild(row);
		}
	}
    
	di.getRoot().appendChild(bussiness);
    return di.toString();
}


/**
 * query policy
 */
function queryPolicy(policyID) {
	if(policyID)
	{
		lastSelectedPolicyID = policyID;
	}
	$("querybtn").disabled = true;
    $("createbtn").disabled = true;
	$("deletebtn").disabled = true;
	$("applybtn").disabled = true;
    var xml = genQueryXML();
    var URL = "../../../../../neExlorerServlet?sfid=" + TECMDCODE_PTN_CONTROLPLAN_ROUTEPOLICY_QUERY + "&nmUser=" + rootobj["nmUser"];
    loadXMLdoc(URL, "POST", false, doQueryBack, null, "inputdata=" + xml);
	lastSelectedPolicyID = null;
}

function doQueryBack(doc){
    $("querybtn").disabled = !btnRightArr.querybtn.right;
    $("createbtn").disabled = !btnRightArr.createbtn.right;
    policydata = EncapsulateData(doc);
    
    if (OPERATION_SUCCESS == policydata.getError().getGlobleECode() || OPERATION_PART_SUCCESS == policydata.getError().getGlobleECode()) {
    
        st.clearTableData();
        createTableBody(st, window.tableconf[0], policydata, RESOURCE);
        
		mozillaSort(st, "policyID");

    }
	addCellEvent();
	
	if(lastSelectedPolicyID)
	{
		selectLastPolicyRow(lastSelectedPolicyID);
	}
	else if(st.getDataRowLength() > 0)
	{
		st.setRowSelect(0);
	}
	
    if (policydata.getError().rowErrors[0]) {
        var size = policydata.getBErrLength();
        for (var i = 0; i < size; i++) {
            var tempObj = policydata.getError().rowErrors[i].errorObj;
            tempObj["operateObj"] = RESOURCE["querypolicy"];
        }
    }
    var errArr = [];
    errArr[0] = "operateObj";
    openErrPage("../../../../../page/", policydata.getError(), errArr);
    
    rowSelectHandler();
}

/**
 * query policy
 */
function modifyPolicy() {
	$("querybtn").disabled = true;
    $("createbtn").disabled = true;
	$("deletebtn").disabled = true;
	$("applybtn").disabled = true;
    var xml = genModifyPolicyXML();
    var URL = "../../../../../neExlorerServlet?sfid=" + TECMDCODE_PTN_CONTROLPLAN_ROUTEPOLICY_APPLY + "&nmUser=" + rootobj["nmUser"];	
    loadXMLdoc(URL, "POST", false, modifyPolicyCallback, null, "inputdata=" + xml);
}

/**
 * modify policy call back
 */
function modifyPolicyCallback(doc) 
{
	$("querybtn").disabled = !btnRightArr.querybtn.right;
    $("createbtn").disabled = !btnRightArr.createbtn.right;
	$("deletebtn").disabled = !btnRightArr.deletebtn.right;

	var data = EncapsulateData(doc);
	var retCode = data.getError().getGlobleECode()
	if (OPERATION_SUCCESS == retCode || OPERATION_PART_SUCCESS == retCode) {
	    refreshTableState(st, window.tableconf[0], data);
		if(OPERATION_SUCCESS == retCode)
		{
			$("applybtn").disabled = true;
			return;
		}
    } 
	
    if (data.getError().rowErrors[0]) {
        var size = data.getBErrLength();
        for (var i = 0; i < size; i++) {
            var tempObj = data.getError().rowErrors[i].errorObj;
            tempObj["operateObj"] = RESOURCE["text_policyID"] + ":" + tempObj["policyID"];
        }
    }
    var errArr = [];
    errArr[0] = "operateObj";
    openErrPage("../../../../../page/", data.getError(), errArr);
}

function genDeleteXML()
{
	var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    
    var selectedRows = st.getSelectedRows();
    for (var index = 0, size = selectedRows.length; index < size; index++) 
	{
		logString = "";
		var row = new tagElement("row-params");
		
        var policyID = st.getCellStoreValue(selectedRows[index], "policyID", "policyID");
        var param = new tagElement("param");
        param.setAttribute("name", "neid");
        param.setAttribute("value", neid);
        row.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "policyID");
        param.setAttribute("value", policyID);
        row.appendChild(param);
        stuffLog(RESOURCE["text_policyID"], policyID);
        
        var param = new tagElement("param");
        param.setAttribute("name", "opDesc");
        param.setAttribute("value", logString);
        row.appendChild(param);
	
		bussiness.appendChild(row);
    }
    
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

/**
 * delete policy
 */
function deletePolicy() {
	enableButtons(false);
	tab.getTabWindow(TAB_ID_RULEITEM).setRuleItemsStatus(false);
	
    var xml = genDeleteXML();
    var URL = "../../../../../neExlorerServlet?sfid=" + TECMDCODE_PTN_CONTROLPLAN_ROUTEPOLICY_DEL + "&nmUser=" + rootobj["nmUser"];
    loadXMLdoc(URL, "POST", false, callbackDelete, null, "inputdata=" + xml);
}

function callbackDelete(doc){
    var data = EncapsulateData(doc);
    var globalErr = data.getSErrorCode();
    if (globalErr == OPERATION_SUCCESS || globalErr == OPERATION_PART_SUCCESS) 
	{		 
		 var errorObjcets = new Array();
		 for(var ei = 0,esize = data.errObj.rowErrors.length; ei < esize; ei++)
		 {
		 	 errorObjcets.push(data.errObj.rowErrors[ei].errorObj["policyID"]);
		 }
		 var selectedRows = st.getSelectedRows();
		 for (var i = selectedRows.length - 1; i >=0; i--) 
         {         	
         	if(!errorObjcets.contains(st.getCellStoreValue(selectedRows[i], "policyID", "policyID")))
         	{
         		st.deleteRow(selectedRows[i]);         		
         	}	        
    	 }         
    	 st.adjustDataRows();
    }
	
    if (data.getError().rowErrors[0]) {
        var size = data.getBErrLength();
        for (var i = 0; i < size; i++) {
            var tempObj = data.getError().rowErrors[i].errorObj;
            tempObj["operateObj"] = RESOURCE["text_policyID"] + ":" + tempObj["policyID"];
        }
		$("deletebtn").disabled = !btnRightArr.deletebtn.right;
    }
    var errArr = [];
    errArr[0] = "operateObj";
    openErrPage("../../../../../page/", data.getError(), errArr);
    
    if(globalErr == OPERATION_SUCCESS || globalErr == OPERATION_PART_SUCCESS)
    {
    	if(st.getDataRowLength() > 0)
    	{
    		st.setRowSelect(0);
    	}    	
    	rowSelectHandler();
    }	
			
    $("querybtn").disabled = !btnRightArr.querybtn.right;
    $("createbtn").disabled = !btnRightArr.createbtn.right;
}

/**
 * get selected policy id
 */
function getSelectedPolicyID() 
{
	var selectedRows = st.getSelectedRows();
	if(selectedRows.length > 0) 
	{
		return st.getCellStoreValue(selectedRows[0], "policyID",  "policyID");
	}
	
	return null;
}

/**
 * get selected policy id
 */
function getSrcType() 
{
	var selectedRows = st.getSelectedRows();
	if(selectedRows.length > 0) 
	{
		return st.getCellStoreValue(selectedRows[0], "publicsrc",  "publicsrc");
	}
	
	return null;
}

/**
 * get selected policy id
 */
function getDstType() 
{
	var selectedRows = st.getSelectedRows();
	if(selectedRows.length > 0) 
	{
		return st.getCellStoreValue(selectedRows[0], "injectDest",  "injectDest");
	}
	
	return null;
}

function enableButtons(isEnabled) {
    if (!isEnabled) {
        $("querybtn").disabled = true;
        $("createbtn").disabled = true;
        $("deletebtn").disabled = true;
		$("applybtn").disabled = true;
    }
	else
	{
		$("querybtn").disabled = btnRightArr.querybtn.right;
        $("createbtn").disabled = btnRightArr.createbtn.right;
        $("deletebtn").disabled = btnRightArr.deletebtn.right;
		$("applybtn").disabled = btnRightArr.applybtn.right;
	}
}


function showErrorDialog(di){
    var operObj;    
    var errArr = [];
    var errorObj = null;
    for (var i = 0, len = di.getBErrLength(); i < len; i++) {
        errorObj = di.getError().rowErrors[i].errorObj;
        errorObj["operationObj"] = operObj;
    }
    errArr[0] = "operationObj";
    openErrPage("../../../../../page/", di.getError(), errArr);
}

function stuffLog(key, value)
{
	if(logString != "")	 
	{
		logString += "," ;
	}
	logString += key + ":" + value;
}

/**
 *     
 */
function updateStatics()
{
	var total = st.getDataRowLength();
	var selected1 = st.getSelectedRowCount();
	$("totalrownum").innerText = ""+total;
	$("selrownum").innerText = ""+selected1;
}

/**
 * add table cell event
 */
function addCellEvent(){
    var cell = null;
    var cellname = null;
    for (var i = 0, len = st.getDataRowLength(); i < len; i++) {
        cell = st.getCell(i, "priority");
        cellname = st.getCell(i, "name");
        if (null != cell) {
            textCheck(cell.element.editElement.element, MIN_PRIORITY, MAX_PRIORITY);
            checkInputData(cellname.element.editElement.element, POLICY_NAME_MAXLENGTH);
        }
        if(isDefaultPolicy(st.getCellStoreValue(i, "policyID","policyID")))
        {
        	st.setCellIsEdit(st.getCell(i, "matchMode"), false);
        	st.setCellIsEdit(st.getCell(i, "priority"), false);
        	st.setCellIsEdit(st.getCell(i, "name"), false);
        }        
    }
}

/**
 * select specified policy
 * @param {Object} policyID
 */
function selectLastPolicyRow(){
	var entryPolicyID;
	for(var index = 0, size = st.getDataRowLength(); index < size; index++)
	{
		entryPolicyID = st.getCellStoreValue(index, "policyID", "policyID");
		if((lastSelectedPolicyID != null) && (lastSelectedPolicyID == entryPolicyID))
		{
			st.setRowSelect(index);
			rowSelectHandler();
			break;
		}
	}
}

function getSelectedfirstRow()
{
	var rows = st.getSelectedRows();
	if(rows.length > 0)
	{
		return st.getCellStoreValue(rows[0], "policyID", "policyID");
	}
	return null;
}

/**
 *           
 */
function isDefaultPolicy(policyID) 
{
	if(policyID == DEFAULT_POLICY_RIP || 
	   policyID == DEFAULT_POLICY_OSPF || 
	   policyID == DEFAULT_POLICY_BGP )
	{
		return true;
	}
	return false;
}
