var winurlobj = getParentWindow();

var obj,neid;

/**
 * Max mask length
 */
var SUBNET_MIN = 0;
var SUBNET_MAX = 32;

window.onload = function(){
	obj = getNeProperty(self);
	neid = obj["neid"];
    initUI();
}

function initUI() {
    initCTable();
    initButtonInfo();	
}

/**
 * init button status
 */
function initButtonInfo(){	
    $("okbtn").value = RESOURCE["okbtn"];
    $("cancelbtn").value = RESOURCE["cancelbtn"];
}

/**
 * init baseinfo
 */
function initCTable(){

 if(!isIE)
 {
 	  if (winurlobj.frames.length > 3)
 	  {
 	      winurlobj = winurlobj.frames[winurlobj.frames.length - 2];
 	  }
    else
    {
        winurlobj = winurlobj.frames[0];
    }
 }
 
	var currentIndex = winurlobj.st.getSelectedRows()[0];
	var preIP = winurlobj.st.getCellStoreValue(currentIndex, "ruleArea", "ip");	
	var maskLength = winurlobj.st.getCellStoreValue(currentIndex, "ruleArea", "masklength");
	
    var atom;	
    ct = new CTable();
    ct.addHead(RESOURCE["PROPERTY"], RESOURCE["VALUE"]);
    atom = new Atom("text");
    atom.element.setAttribute("id", "subnetIp");
    validateIp(atom.element);
	ct.addAttrRow("subnetIp", RESOURCE["text_subnetIp"], atom);
    ct.getAtom("subnetIp").element.style.width = "100%";

    atom = new Atom("text");
    atom.element.setAttribute("id", "mask");
	validateNum(atom.element, SUBNET_MIN, SUBNET_MAX, 2, 0);
    ct.addAttrRow("mask", RESOURCE["text_mask"], atom);
	ct.getAtom("mask").element.style.width = "100%";
    $("subnet_ctable").appendChild(ct.getTable());
    
    if (preIP != null && preIP != "") {
        ct.setAttrValue("subnetIp", preIP);
        ct.setAttrValue("mask", maskLength);
    }
}

function okAction() {
	var ip = ct.getAttrValue("subnetIp");
	var maskLength = ct.getAttrValue("mask");
	winurlobj.updateSubnetScope(ip, maskLength);
	xcloseDialog();
}
