var parentWin = getParentWindow();
var interfaceTable;
var boardList = new Array();
var portList = new Array();
var winurlobj = parentWin.winurlobj;
var OPRSUCC = 0;
var usableBoardArr = new Array(); 
var INVALID_SUBSLOTID = "255";
var INVALID_VALUE = "65535";

function initpage()
{
    document.title = RESOURCE["selectinterface"];
    initBtn();
    getPorts();
}

function initBtn()
{
    $("confirmbtn").value = RESOURCE["confirmbtn"];
    $("cancelbtn").value = RESOURCE["cancelbtn"];
}

function getPorts()
{
    var xmlstr = createGetPortsXML();
    
    var urlreq = "../../../../../neExlorerServlet?sfid=" + TE_QUERY_AVAILABLE_PORT_RESOURCE + "" + "&nmUser=" + winurlobj["nmUser"];
    loadXMLdoc(urlreq, "POST", false, handleBackgetPorts, null, "inputdata=" + xmlstr);
}

function createGetPortsXML()
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var row = new tagElement("row-params");
    
    var param = new tagElement("param");
    param.setAttribute("name", "neid");
    param.setAttribute("value", winurlobj["neid"]);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "funid");
    param.setAttribute("value", "FUN_STATIC_ROUTE");
    row.appendChild(param);
    
    bussiness.appendChild(row);
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

function handleBackgetPorts(doc)
{
    var data = EncapsulateData(doc);
    var errArr = [];
    errArr[0] = "errObj";
    openErrPage("../../../../../page/", data.getError(), errArr);
    
    if (OPRSUCC == data.getError().getGlobleECode()) 
    {
        handleInit(data);
    }
}

function handleInit(data)
{
    for (var i = 0, len = data.getDataRowLength(); i < len; i++) 
    {
        var usableBd = new TEUsableBoard();
        usableBd.slotid = data.getDataRowParam(i, "slotid");
        usableBd.boardType = data.getDataRowParam(i, "boardType");
        usableBd.boardName = data.getDataRowParam(i, "boardName");
        usableBd.subslotid = data.getDataRowParam(i, "subslotid");
        usableBd.subBoardName = data.getDataRowParam(i, "subBoardName");
        usableBd.portid = data.getDataRowParam(i, "portid");
        usableBd.portidArr = data.getDataRowOptions(i, "portid");
        usableBd.portName = data.getDataRowParam(i, "portName");
        usableBd.portNameArr = data.getDataRowOptions(i, "portName");
        usableBoardArr.push(usableBd);
    }
    
    initTable();
}

function TEUsableBoard()
{
    this.slotid = null;
    this.boardType = null;
    this.boardName = null;
    this.subslotid = null;
    this.subBoardName = null;
    this.portid = null;
    this.portidArr = null
    this.portName = null;
    this.portNameArr = null;
}


function initTable()
{
    ct = new CTable();
    ct.addHead(RESOURCE["attributeName"], RESOURCE["attributeValue"]);
    
    var atom = new Atom("select");
    atom.element.setAttribute("id", "htmlSelect_boardCreatestaroute");
    atom.addOption("/", INVALID_VALUE);
    for (var i = 0, len = usableBoardArr.length; i < len; i++) 
    {
        var board = "";
        var slotid = usableBoardArr[i].slotid;
        if (null == usableBoardArr[i].portNameArr ||
        usableBoardArr[i].portNameArr.length == 0) 
        {
            continue
        }
        if (INVALID_VALUE == slotid) 
        {
            board = usableBoardArr[i].boardName;
        }
        else 
        {
            board = usableBoardArr[i].slotid + "-" + usableBoardArr[i].boardName;
        }
        
        if ("0" != usableBoardArr[i].subslotid && INVALID_SUBSLOTID != usableBoardArr[i].subslotid) 
        {
            board += "-" + usableBoardArr[i].subslotid + "-" +
            usableBoardArr[i].subBoardName;
        }
        atom.addOption(board, i + 1);
    }
    atom.element["onchange"] = function()
    {
        boardChanged(this);
    }
    ct.addAttrRow("board", RESOURCE["board"], atom);
    
    var atom = new Atom("select");
    atom.element.setAttribute("id", "htmlSelect_portCreatestaroute");
    atom.addOption("/", 0);
    ct.addAttrRow("port", RESOURCE["port"], atom);
    
    document.body.insertBefore(ct.getTable(), document.body.firstChild);
}

function boardChanged(selectCombox)
{
    if (null == usableBoardArr || 0 == usableBoardArr.length) 
    {
        return;
    }
    
    var atom = ct.getAtom("port");
    atom.clearOptions();
    var key = selectCombox.value;
    if (INVALID_VALUE == key) 
    {
        atom.addOption("/", INVALID_VALUE);
        return;
    }
    var board = usableBoardArr[key - 1];

    if (null != board.portNameArr) 
    {
        for (var i = 0, len = board.portNameArr.length; i < len; i++) 
        {
            atom.addOption(board.portNameArr[i], board.portidArr[i]);
        }
    }
}

function confirm()
{
    var parentst = parentWin.st;
    var cell = parentst.getCell(0, "outinterface");

    var boardElement = ct.getAtom("board").element;
    var portElement = ct.getAtom("port").element;
    var sendValue = "";    
    var sendStoreValue = "";
    var key = ct.getAttrValue("board");
    
    if (INVALID_VALUE == key) 
    {
        sendValue = "/";
        sendStoreValue = INVALID_VALUE + "-" + INVALID_SUBSLOTID + "-" + INVALID_VALUE;
    }
    else
    {
        var board = usableBoardArr[key - 1];
        sendValue = boardElement.options[boardElement.selectedIndex].text + "-" + portElement.options[portElement.selectedIndex].text;
        sendStoreValue = board.slotid + "-" + board.subslotid + "-" + ct.getAttrValue("port");        
    }
    
    cell.element.style.backgroundColor = "#d0f946";
    parentst.setCellValue(cell, "outinterface", sendStoreValue);
    parentst.setAtomValue(cell.element.showElement, sendValue);
    
    xcloseDialog();
}
