var winurlobj = getNeProperty(self);
var btnRightArr = new Object();
var st, st1, st2;
var OPRSUCC = 0;
var OPRPART = 1;

var DEFAULT_DESTIP = "0.0.0.0";
var DEFAULT_ICMPREQNUM = "5";
var DEFAULT_TTL = "255";
var DEFAULT_INTERVAL = "100";
var DEFAULT_MSGLENGTH = "64";
var DEFAULT_TIMEOUT = "3000";
var DEFAULT_FISRT_TTL = "1";
var DEFAULT_MAX_TTL = "255";
var DEFAULT_RSPTIMEOUT = "3000";
var DEFAULT_INTERFACE = "/";
var DEFAULT_TOS = "0";

var START_PING = "1";
var STOP_PING = "2";
var REFRESH_PING = "3";

var START_TRACEROUTE = "4";
var STOP_TRACEROUTE = "5";
var REFRESH_TRACEROUTE = "6";

var ping_intervalID = null;
var trace_intervalID = null;

var working_ping = null;
var working_traceroute = null;

var ALREADY_START_PING = "43766";
var ALREADY_START_TRACEROUTE = "43768";

var INVALID_VALUE = "65535";
var INVALID_SUBSLOTID = "255";

function initpage()
{
    initPingTable();
    initTraceRouteTable();
    addCellEvent();
    getRightInfo(winurlobj, btnRightArr);
    initrightbtn(btnRightArr);
    $("stopPingBtn").disabled = true;
    $("stopTraceRouteBtn").disabled = true;
}


function initPingTable()
{
    $("pingtblname").innerText = RESOURCE["pingtblname"];
    st1 = new SortTable();
    st1.head.setAttribute("id", "htmlTablePingTHead");
    st1.body.setAttribute("id", "htmlTablePingTBody");
    st1.setImage("../../../../../images/");
    midtc = window.tableconf[0]
    createTableHead(st1, midtc);
    st1.setBodyHeight("40px");
    $("pingtbldiv").oncontextmenu = popupMenuHandler;
    $("pingtbldiv").appendChild(st1.getTable());
    st1.setBodyWidth(getTableHeight($("pingtbldiv"), st1) + "px");
    
    
    $("startPingBtn").value = RESOURCE["startPingBtn"];
    $("stopPingBtn").value = RESOURCE["stopPingBtn"];
    
    btnRightArr.startPingBtn = new BtnRightObj("startPingBtn", PTN_CMD_START_PING);
    btnRightArr.stopPingBtn = new BtnRightObj("stopPingBtn", PTN_CMD_STOP_PING);
    
    var defaultVal = new Array(DEFAULT_DESTIP, DEFAULT_DESTIP, DEFAULT_ICMPREQNUM, DEFAULT_TTL, DEFAULT_INTERVAL, DEFAULT_MSGLENGTH, DEFAULT_TIMEOUT, DEFAULT_INTERFACE, DEFAULT_TOS);
    createTableRow(st1, window.tableconf[0], defaultVal, RESOURCE);
}

function initTraceRouteTable()
{
    $("traceroutetblname").innerText = RESOURCE["traceroutetblname"];
    st2 = new SortTable();
    st2.head.setAttribute("id", "htmlTableTraceRouteTHead");
    st2.body.setAttribute("id", "htmlTableTraceRouteTBody");
    st2.setImage("../../../../../images/");
    lowtc = window.tableconf[1];
    createTableHead(st2, lowtc);
    st2.setBodyHeight("40px");
    $("traceroutedbldiv").appendChild(st2.getTable());
    st2.setBodyWidth(getTableHeight($("traceroutedbldiv"), st1) + "px");
    
    $("startTraceRouteBtn").value = RESOURCE["startTraceRouteBtn"];
    $("stopTraceRouteBtn").value = RESOURCE["stopTraceRouteBtn"];
    
    btnRightArr.startTraceRouteBtn = new BtnRightObj("startTraceRouteBtn", PTN_CMD_START_TRACEROUTE);
    btnRightArr.stopTraceRouteBtn = new BtnRightObj("stopTraceRouteBtn", PTN_CMD_STOP_TRACEROUTE);
    
    var defaultVal = new Array(DEFAULT_DESTIP, DEFAULT_DESTIP, DEFAULT_FISRT_TTL, DEFAULT_MAX_TTL, DEFAULT_RSPTIMEOUT, DEFAULT_INTERFACE);
    createTableRow(st2, window.tableconf[1], defaultVal, RESOURCE);
    
}

function addCellEvent()
{
    var cell = null;
    var ping_ipadd = st1.getCellEdit(i, "destipaddress").element;
    ping_ipadd.isSupportPaste = true;
    validateIp(ping_ipadd, true);
    ping_ipadd.onblur = onipcellonblur;
    
    cell = st1.getCell(0, "icmprequestnum");
    if (cell != null) 
    {
        textCheck(cell.element.editElement.element, 1, 4294967295);
    }
    
    cell = st1.getCell(0, "ttl");
    if (cell != null) 
    {
        textCheck(cell.element.editElement.element, 1, 255);
    }
    
    cell = st1.getCell(0, "interval");
    if (cell != null) 
    {
        textCheck(cell.element.editElement.element, 10, 1000);
    }
    
    cell = st1.getCell(0, "msglength");
    if (cell != null) 
    {
        textCheck(cell.element.editElement.element, 64, 1400);
    }
    
    cell = st1.getCell(0, "timeout");
    if (cell != null) 
    {
        textCheck(cell.element.editElement.element, 0, 65535);
    }
    
    var ping_ipadd_source = st1.getCellEdit(0, "sourceipaddress").element;
    ping_ipadd_source.isSupportPaste = true;
    validateIp(ping_ipadd_source, true);
    ping_ipadd_source.onblur = onipcellonblur;
    
    var outInterface = st1.getCellElement(0, "outinterface");
    outInterface.ondblclick = dblclick_outinterface_ping;
    
    cell = st1.getCell(0, "tos");
    if (cell != null) 
    {
        textCheck(cell.element.editElement.element, 0, 255);
    }
    
    var trace_ipadd = st2.getCellEdit(0, "destipaddress").element;
    trace_ipadd.isSupportPaste = true;
    validateIp(trace_ipadd, true);
    trace_ipadd.onblur = onipcellonblur;
    
    cell = st2.getCell(0, "fistttl");
    if (cell != null) 
    {
        textCheck(cell.element.editElement.element, 1, 255);
    }
    cell = st2.getCell(0, "maxttl");
    if (cell != null) 
    {
        textCheck(cell.element.editElement.element, 1, 255);
    }
    
    cell = st2.getCell(0, "rsptimout");
    if (cell != null) 
    {
        textCheck(cell.element.editElement.element, 0, 65535);
    }
    
    var trace_ipadd_source = st2.getCellEdit(0, "sourceipaddress").element;
    trace_ipadd_source.isSupportPaste = true;
    validateIp(trace_ipadd_source, true);
    trace_ipadd_source.onblur = onipcellonblur;
    
    var outInterface = st2.getCellElement(0, "outinterface");
    outInterface.ondblclick = dblclick_outinterface_trace;
}

/**
 * ip       
 */
function onipcellonblur()
{
    var event = EventUtil.getEvent();
    var objIp = event.srcElement;
    var tidIpArr = objIp.value.split(splitchar);
    if (objIp.value == "" || tidIpArr.length > 4) 
    {
        objIp.value = "0.0.0.0";
        cellonblur(objIp);
        alert(RESOURCE["format"]);
        return;
    }
    for (var i = 0; i < tidIpArr.length; i++) 
    {
        if (tidIpArr[i] != "" && !/^\d+$/.test(tidIpArr[i])) 
        {
            objIp.value = "0.0.0.0";
            cellonblur(objIp);
            alert(RESOURCE["format"]);
            return;
        }
    }
    
    objIp.value = formFullAddr(objIp.value);
    var errFlg = false;
    var i = 0;
    for (i = 0; i < tidIpArr.length; ++i) 
    {
        if (tidIpArr[i] > maxvalue) 
        {
            tidIpArr[i] = maxvalue
            errFlg = true;
        }
    }
    if (errFlg) 
    {
        objIp.value = tidIpArr[0];
        for (i = 1; i < tidIpArr.length; ++i) 
        {
            objIp.value += (splitchar + aryIp[i]);
        }
    }
    
    cellonblur(objIp);
}

function startping()
{
    $('pingResult').innerHTML = "";
    $("startPingBtn").disabled = true;
    var xmlstr = createStartPingXML();
    urlreq = "../../../../../neExlorerServlet?sfid=" + PTN_CMD_START_PING + "" + "&nmUser=" + winurlobj["nmUser"];
    loadXMLdoc(urlreq, "POST", false, handleBackStartPing, null, "inputdata=" + xmlstr);
}

function createStartPingXML()
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var row = new tagElement("row-params");
    
    var param = new tagElement("param");
    param.setAttribute("name", "neid");
    param.setAttribute("value", winurlobj["neid"]);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "configKey");
    param.setAttribute("value", START_PING);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "serviecindex");
    param.setAttribute("value", 0xFFFFFFFF);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "destipaddress");
    param.setAttribute("value", convertIpaddrToHexcode(st1.getCellStoreValue(0, "destipaddress", "destipaddress")));
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "destip_bak");
    param.setAttribute("value", st1.getCellStoreValue(0, "destipaddress", "destipaddress"));
    row.appendChild(param);
    param = new tagElement("param");
    param.setAttribute("name", "icmprequestnum");
    param.setAttribute("value", st1.getCellStoreValue(0, "icmprequestnum", "icmprequestnum"));
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "ttl");
    param.setAttribute("value", st1.getCellStoreValue(0, "ttl", "ttl"));
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "interval");
    param.setAttribute("value", st1.getCellStoreValue(0, "interval", "interval"));
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "msglength");
    param.setAttribute("value", st1.getCellStoreValue(0, "msglength", "msglength"));
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "timeout");
    param.setAttribute("value", st1.getCellStoreValue(0, "timeout", "timeout"));
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "sourceipaddress");
    param.setAttribute("value", convertIpaddrToHexcode(st1.getCellStoreValue(0, "sourceipaddress", "sourceipaddress")));
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "tunnelindex");
    param.setAttribute("value", 0xFFFFFFFF);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "tos");
    param.setAttribute("value", st1.getCellStoreValue(0, "tos", "tos"));
    row.appendChild(param);

    var boardPort = st1.getCellStoreValue(0, "outinterface", "outinterface").split("-");
    var slotid = boardPort[0];
    var subslotid = boardPort[1];
    var port = boardPort[2];
    var outinterfacetype = 1;
    if ("/" == slotid)
    {
        slotid = INVALID_VALUE;
        subslotid = INVALID_SUBSLOTID;
        port = INVALID_VALUE;
    }
    
    if (INVALID_VALUE ==  slotid && INVALID_VALUE == port)
    {
        outinterfacetype = 0;
    }
    
    param = new tagElement("param");
    param.setAttribute("name", "outinterfacetype");
    param.setAttribute("value", outinterfacetype);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "slotid");
    param.setAttribute("value", slotid);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "subslotid");
    param.setAttribute("value", subslotid);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "port");
    param.setAttribute("value", port);
    row.appendChild(param);
    
    bussiness.appendChild(row);
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

function handleBackStartPing(doc)
{
    var data = EncapsulateData(doc);
    showErrorDialog(data);
    if (0 == data.getSErrorCode()) 
    {
        $("stopPingBtn").disabled = !btnRightArr.stopPingBtn.right;
        working_ping = st1.getCellStoreValue(0, "destipaddress", "destipaddress");
        ping_intervalID = setInterval(refreshPingResult, 3000);
    }
    else 
    {
        if (data.getBErrorCode(0) == ALREADY_START_PING) 
        {
            working_ping = st1.getCellStoreValue(0, "destipaddress", "destipaddress");
            $("startPingBtn").disabled = true
            $("stopPingBtn").disabled = !btnRightArr.stopPingBtn.right;
        }
        else 
        {
            $("startPingBtn").disabled = !btnRightArr.startPingBtn.right;
            $("stopPingBtn").disabled = true;
        }
    }
}

function refreshPingResult()
{
    var xml = createRereshPingXML();
    var url = "../../../../../neExlorerServlet?sfid=" + PTN_CMD_PING_NOTIFY + "&nmUser=" + winurlobj["nmUser"];
    loadXMLdoc(url, "POST", true, refreshPingBackHandler, null, "inputdata=" + xml);
}


function createRereshPingXML()
{

    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var row = new tagElement("row-params");
    
    var param = new tagElement("param");
    param.setAttribute("name", "neid");
    param.setAttribute("value", winurlobj["neid"]);
    row.appendChild(param);
    param = new tagElement("param");
    param.setAttribute("name", "destip_bak");
    param.setAttribute("value", working_ping);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "configKey");
    param.setAttribute("value", REFRESH_PING);
    row.appendChild(param);
    
    bussiness.appendChild(row);
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

function refreshPingBackHandler(doc)
{
    var data = EncapsulateData(doc);
    
    if (0 == data.getSErrorCode()) 
    {
        if (data.getDataRowParam(0, 'endFlg') == '1') 
        {
            clearInterval(ping_intervalID);
            
            $("startPingBtn").disabled = !btnRightArr.startPingBtn.right;
            $("stopPingBtn").disabled = true;
        }
        var tempStr = data.getDataRowParam(0, 'content');
        if ("" != tempStr) 
        {
            $('pingResult').value = tempStr;
            document.getElementById('pingResult').scrollTop = document.getElementById('pingResult').scrollHeight;
        }
    }
}

function startTraceRoute()
{
    $('traceRouteResult').innerHTML = "";
    $("startTraceRouteBtn").disabled = true;
    
    var xmlstr = createStartTraceRouteXML();
    urlreq = "../../../../../neExlorerServlet?sfid=" + PTN_CMD_START_TRACEROUTE + "" + "&nmUser=" + winurlobj["nmUser"];
    loadXMLdoc(urlreq, "POST", false, handleBackStartTraceRoute, null, "inputdata=" + xmlstr);
}

function createStartTraceRouteXML()
{

    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var row = new tagElement("row-params");
    
    var param = new tagElement("param");
    param.setAttribute("name", "neid");
    param.setAttribute("value", winurlobj["neid"]);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "configKey");
    param.setAttribute("value", START_TRACEROUTE);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "serviecindex");
    param.setAttribute("value", 0xFFFFFFFF);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "destipaddress");
    param.setAttribute("value", convertIpaddrToHexcode(st2.getCellStoreValue(0, "destipaddress", "destipaddress")));
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "destip_bak");
    param.setAttribute("value", st2.getCellStoreValue(0, "destipaddress", "destipaddress"));
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "fistttl");
    param.setAttribute("value", st2.getCellStoreValue(0, "fistttl", "fistttl"));
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "maxttl");
    param.setAttribute("value", st2.getCellStoreValue(0, "maxttl", "maxttl"));
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "rsptimout");
    param.setAttribute("value", st2.getCellStoreValue(0, "rsptimout", "rsptimout"));
    row.appendChild(param);
        
    param = new tagElement("param");
    param.setAttribute("name", "sourceipaddress");
    param.setAttribute("value", convertIpaddrToHexcode(st2.getCellStoreValue(0, "sourceipaddress", "sourceipaddress")));
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "tunnelindex");
    param.setAttribute("value", 0xFFFFFFFF);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "tos");
    param.setAttribute("value", 0);
    row.appendChild(param);
    
    var boardPort = st2.getCellStoreValue(0, "outinterface", "outinterface").split("-");
    var slotid = boardPort[0];
    var subslotid = boardPort[1];
    var port = boardPort[2];
    var outinterfacetype = 1;
    if ("/" == slotid)
    {
        slotid = INVALID_VALUE;
        subslotid = INVALID_SUBSLOTID;
        port = INVALID_VALUE;
    }
    
    if (INVALID_VALUE ==  slotid && INVALID_VALUE == port)
    {
        outinterfacetype = 0;
    }
    
    param = new tagElement("param");
    param.setAttribute("name", "outinterfacetype");
    param.setAttribute("value", outinterfacetype);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "slotid");
    param.setAttribute("value", slotid);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "subslotid");
    param.setAttribute("value", subslotid);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "port");
    param.setAttribute("value", port);
    row.appendChild(param);

    
    bussiness.appendChild(row);
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

function handleBackStartTraceRoute(doc)
{
    var data = EncapsulateData(doc);
    showErrorDialog(data);
    if (0 == data.getSErrorCode()) 
    {
        $("stopTraceRouteBtn").disabled = !btnRightArr.stopTraceRouteBtn.right;
        working_traceroute = st2.getCellStoreValue(0, "destipaddress", "destipaddress");
        trace_intervalID = setInterval(refreshTraceRouteResult, 3000);
    }
    else 
    {
        if (data.getBErrorCode(0) == ALREADY_START_TRACEROUTE) 
        {
            working_traceroute = st2.getCellStoreValue(0, "destipaddress", "destipaddress");
            $("startTraceRouteBtn").disabled = true;
            $("stopTraceRouteBtn").disabled = !btnRightArr.stopTraceRouteBtn.right;
        }
        else 
        {
            $("startTraceRouteBtn").disabled = !btnRightArr.stopTraceRouteBtn.right;
            $("stopTraceRouteBtn").disabled = true;
        }
    }
}

function refreshTraceRouteResult()
{
    var xml = createRereshTraceRouteXML();
    var url = "../../../../../neExlorerServlet?sfid=" + PTN_CMD_TRACEROUTE_NOTIFY + "&nmUser=" + winurlobj["nmUser"];
    loadXMLdoc(url, "POST", true, refreshTraceRouteBackHandler, null, "inputdata=" + xml);
}


function createRereshTraceRouteXML()
{

    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var row = new tagElement("row-params");
    
    var param = new tagElement("param");
    param.setAttribute("name", "neid");
    param.setAttribute("value", winurlobj["neid"]);
    row.appendChild(param);
    param = new tagElement("param");
    param.setAttribute("name", "destip_bak");
    param.setAttribute("value", working_traceroute);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "configKey");
    param.setAttribute("value", REFRESH_TRACEROUTE);
    row.appendChild(param);
    
    bussiness.appendChild(row);
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

function refreshTraceRouteBackHandler(doc)
{
    var data = EncapsulateData(doc);
    
    if (0 == data.getSErrorCode()) 
    {
        if (data.getDataRowParam(0, 'endFlg') == '1') 
        {
            clearInterval(trace_intervalID);
            
            $("startTraceRouteBtn").disabled = !btnRightArr.startTraceRouteBtn.right;
            $("stopTraceRouteBtn").disabled = true;
        }
        var tempStr = data.getDataRowParam(0, 'content');
        if ("" != tempStr) 
        {
            $('traceRouteResult').value = tempStr;
            document.getElementById('traceRouteResult').scrollTop = document.getElementById('traceRouteResult').scrollHeight;
        }
    }
}

function stopping()
{
    var xml = createStopPingXML();
    var url = "../../../../../neExlorerServlet?sfid=" + PTN_CMD_STOP_PING + "&nmUser=" + winurlobj["nmUser"];
    loadXMLdoc(url, "POST", true, callStopPingHandler, null, "inputdata=" + xml);
}

function createStopPingXML()
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var row = new tagElement("row-params");
    
    var param = new tagElement("param");
    param.setAttribute("name", "neid");
    param.setAttribute("value", winurlobj["neid"]);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "configKey");
    param.setAttribute("value", STOP_PING);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "serviecindex");
    param.setAttribute("value", 0xFFFFFFFF);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "destipaddress");
    param.setAttribute("value", convertIpaddrToHexcode(working_ping));
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "destip_bak");
    param.setAttribute("value", working_ping);
    row.appendChild(param);
    
    bussiness.appendChild(row);
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

function callStopPingHandler(doc)
{
    var data = EncapsulateData(doc);
    if (0 == data.getSErrorCode()) 
    {
        if (ping_intervalID) 
        {
            refreshPingResult();
        }
    }
    $("startPingBtn").disabled = !btnRightArr.startPingBtn.right;
    $("stopPingBtn").disabled = true;
    var errArr = [];
    errArr[0] = "nename";
    openErrPage("../../../../../page/", data.getError(), errArr);
}


function stopTraceRoute()
{
    var xml = createStopTraceRouteXML();
    var url = "../../../../../neExlorerServlet?sfid=" + PTN_CMD_STOP_TRACEROUTE + "&nmUser=" + winurlobj["nmUser"];
    loadXMLdoc(url, "POST", true, callStopTraceRouteHandler, null, "inputdata=" + xml);
}

function createStopTraceRouteXML()
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var row = new tagElement("row-params");
    
    var param = new tagElement("param");
    param.setAttribute("name", "neid");
    param.setAttribute("value", winurlobj["neid"]);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "configKey");
    param.setAttribute("value", STOP_TRACEROUTE);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "serviecindex");
    param.setAttribute("value", 0xFFFFFFFF);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "destipaddress");
    param.setAttribute("value", convertIpaddrToHexcode(working_traceroute));
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "destip_bak");
    param.setAttribute("value", working_traceroute);
    row.appendChild(param);
    
    bussiness.appendChild(row);
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

function callStopTraceRouteHandler(doc)
{
    var data = EncapsulateData(doc);
    if (0 == data.getSErrorCode()) 
    {
    
        if (trace_intervalID) 
        {
            refreshTraceRouteResult();
        }
    }
    $("startTraceRouteBtn").disabled = !btnRightArr.startTraceRouteBtn.right;
    $("stopTraceRouteBtn").disabled = true;
    var errArr = [];
    errArr[0] = "nename";
    openErrPage("../../../../../page/", data.getError(), errArr);
}

function showErrorDialog(data)
{
    var errArr = [];
    errArr[0] = "nename";
    openErrPage("../../../../../page/", data.getError(), errArr);
}

function dblclick_outinterface_ping()
{
    st = st1;
    dblclick_outinterface();
}

function dblclick_outinterface_trace()
{
    st = st2;
    dblclick_outinterface();
}

function dblclick_outinterface()
{
    if (!btnRightArr.startPingBtn.right) 
    {
        return;
    }
    st.element.datarows[0].element.modify = true;
    this.modify = true;
    xshowModalDialog("selectinterface.html?", RESOURCE["selectinterface"], 420, 120, "../../../../../images/");
}


