var winurlobj = getParentWindow();
var neid = winurlobj.winurlobj["neid"];
var OPRSUCC = 0;
var OPRPART = 1;
var MIN_OSPFID = "1";
var MAX_OSPFID = "65535";
var MIN_OVERHEAD = "1";
var MAX_OVERHEAD = "255";
var ct;
var submitFlag = false;
var OSPF = "1";
var usableOspfArr = new Array();

function TEUsableOspf()
{
	   this.ospfID = null;
	   this.areaidArr = null;
}


function initpage()
{
	  $("submitBtn").value=RESOURCE["okbutton"];
	  $("cancelBtn").value=RESOURCE["cancelbutton"];
	  $("applyBtn").value=RESOURCE["applybutton"];
	  
	  createTable();
	
	  getOspfIDs();
	  
	  if (usableOspfArr.length == 0)
    {
      	  alert(RESOURCE["noProtocolorArea"]);
      	  xcloseDialog();
	        return;
    }
	 
}

function getOspfIDs()
{
    var xmlstr = createGetOspfIDsXML();
    var urlreq ="../../../../../neExlorerServlet?sfid="+TE_QUERY_AVAILABLE_OSPF_RESOURCE+""+"&nmUser="+winurlobj["nmUser"];
    loadXMLdoc(urlreq, "POST",false,handleBackgetOspfIDs,null,"inputdata="+xmlstr);
}

function createGetOspfIDsXML()
{
	  var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var row = new tagElement("row-params");
    
    var param = new tagElement("param");    
    param.setAttribute("name","neid");
    param.setAttribute("value",neid);
    row.appendChild(param);
    
    bussiness.appendChild(row);
    di.getRoot().appendChild(bussiness);
    return di.toString();
	
}

function handleBackgetOspfIDs(doc)
{
	  var data = EncapsulateData(doc);
    var errArr = [];
    errArr[0] = "errObj";
    openErrPage("../../../../../page/", data.getError(), errArr);
    
    if (OPRSUCC == data.getError().getGlobleECode()) 
    {
        ConverttoDataStru(data);
        initOspfIDSelectBox();
    }
}


function ConverttoDataStru(data)
{
	
		for(var i = 0, len = data.getDataRowLength(); i < len; i ++)
		{
	    var usableOspf = new TEUsableOspf();
	    usableOspf.ospfID = data.getDataRowParam(i ,"ospfID");
      usableOspf.areaidArr = data.getDataRowOptions(i , "areaid");
	    usableOspfArr.push(usableOspf);
	  }
	
}

function initOspfIDSelectBox()
{
    var ospfIDAtom = ct.getAtom("ospfID");
    
	  for (var i = 0, len = usableOspfArr.length; i < len; i++)
	  {
         var ospfID = usableOspfArr[i].ospfID;
         ospfIDAtom.addOption(ospfID, i);  
	  }
	  
     if (ospfIDAtom.element.length == 0)
     {
      	  alert(RESOURCE["noProtocolorArea"]);
      	  xcloseDialog();
	        return;
    }
  
	  if(ospfIDAtom.element.length > 0)
		{
			 ospfIDChanged(ospfIDAtom.element);
		}
}

function ospfIDChanged(selectCombox)
{   
	  var key = selectCombox.value;
	  var usableOspf = usableOspfArr[key];
	 
    var areaIDAtom = ct.getAtom("areaid");
    areaIDAtom.element.length = 0;
     
		for (var i = 0, len = usableOspf.areaidArr.length; i < len; i++)
		{
		    var temString = usableOspf.areaidArr[i];
		    temString= convertHexIpAddrtoTen(temString);
        areaIDAtom.addOption(temString, usableOspf.areaidArr[i]);      	                 
		}
}



function createTable()
{
	  ct = new CTable();		
	  ct.addHead(RESOURCE["attributeName"], RESOURCE["attributeValue"]);
    
    var atom = new Atom("select");
    atom.element.setAttribute("id", "htmlTableSelectOSPFID");
    ct.addAttrRow("ospfID", RESOURCE["OSPFID"], atom);
    atom.element["onchange"] = function()
    {
      ospfIDChanged(this);	
    }
    
    atom = new Atom("select");
    atom.element.setAttribute("id", "htmlTableTextAreaID");
    atom.element.style.imeMode = "disabled";
    ct.addAttrRow("areaid",RESOURCE["areaid"],atom);
    
    atom = new Atom("select");
    atom.element.setAttribute("id", "htmlTableSelectLsaType");
    atom.addOption(RESOURCE["t3lsa"],3);
    atom.element["onchange"] = function()
    {
	      changeVale(this);
    }
    ct.addAttrRow("lsatype",RESOURCE["lsatype"],atom);
    
    
    atom = new Atom("text");
    atom.element.setAttribute("id", "htmlTableTextSubnetIpaddr");
    atom.element.style.imeMode = "disabled";
    atom.element.value="0.0.0.0";
    validateIp(atom.element);
    atom.element["onchange"] = function()
    {
	      changeVale(this);
    }
    ct.addAttrRow("subnetipaddr",RESOURCE["subnetipaddr"],atom);
    
    atom = new Atom("text");
    atom.element.setAttribute("id", "htmlTableTextSubnetMask");
    atom.element.style.imeMode = "disabled";
    atom.element.value="255.255.255.255";
    validateIp(atom.element);
    atom.element["onchange"] = function()
    {
	      changeVale(this);
    }
    ct.addAttrRow("subnetmask",RESOURCE["subnetmask"],atom);


    atom = new Atom("select");
    atom.element.setAttribute("id", "htmlTableSelectAdvertiseFlag");
    atom.addOption(RESOURCE["advertise"],1);
    atom.addOption(RESOURCE["noadvertise"],0);
    atom.element["onchange"] = function()
    {
	      changeVale(this);
    }
    ct.addAttrRow("advertiseflag",RESOURCE["advertiseflag"],atom);
    $("tablecomponent").appendChild(ct.getTable());
}


function changeVale(atom)
{
 	  $("applyBtn").disabled=false;
}

function sendCreateInfo(buttonFlag)
{
	  submitFlag = buttonFlag;

	  if ($("applyBtn").disabled && submitFlag)
	  {
		    xcloseDialog();
		    return;
	  }
	  
	  $("submitBtn").disabled=true;
	  $("applyBtn").disabled=true;

		var xml = createNewXML();
		
		var url = "../../../../../neExlorerServlet?sfid="+TE_SET_OSPF_AGGREGATE+"&nmUser=" + winurlobj.winurlobj["nmUser"]; 
		loadXMLdoc(url, "POST", true, handlBackCreate, null, "inputdata=" + xml);
}

function createNewXML()
{
	  var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var row = new tagElement("row-params");
    
    var param = new tagElement("param");    
    param.setAttribute("name","neid");
    param.setAttribute("value",neid);
    row.appendChild(param);
    
    param = new tagElement("param"); 
    param.setAttribute("name","flag");
    param.setAttribute("value","0");
    row.appendChild(param);
    
    var key = ct.getAttrValue("ospfID");
    var ospfID = usableOspfArr[key].ospfID;
    
    param = new tagElement("param"); 
    param.setAttribute("name","ospfID");
    param.setAttribute("value",ospfID);
    row.appendChild(param);
    
    param = new tagElement("param"); 
    param.setAttribute("name","areaid");
    param.setAttribute("value",ct.getAttrValue("areaid"));
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name","lsatype");
    param.setAttribute("value",ct.getAttrValue("lsatype"));
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name","subnetipaddr");
    param.setAttribute("value",convertIpaddrToHexcode(ct.getAttrValue("subnetipaddr")));
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name","subnetmask");
    param.setAttribute("value",convertIpaddrToHexcode(ct.getAttrValue("subnetmask")));
    row.appendChild(param);

    
    param = new tagElement("param");
    param.setAttribute("name","advertiseflag");
    param.setAttribute("value",ct.getAttrValue("advertiseflag"));
    row.appendChild(param);
   
    bussiness.appendChild(row);
    di.getRoot().appendChild(bussiness);
    
    
    return di.toString();
}

function handlBackCreate(doc)
{ 	  
	  $("submitBtn").disabled=false;
	  $("applyBtn").disabled=false;
	  
	  var data = EncapsulateData(doc);    
	  
    if(OPRSUCC == data.getSErrorCode()) 
    {	      
    	
    	  winurlobj.sendQueryInfo();
	      
	      if (submitFlag)
	      {
	      	  xcloseDialog();
	      }
    } 
    else
    {   
        if(data.getError().rowErrors[0])
	      {		
	        	var size = data.getBErrLength();
	        	for(var i = 0;i < size;i++)
	        	{
		        	  var tempObj = data.getError().rowErrors[i].errorObj;
  	        		tempObj["operateObj"] = RESOURCE["createRouteAggr"];
		        }
	      }		
	      var errArr = [];
        errArr[0] = "operateObj";
        openErrPage("../../../../../page/", data.getError(), errArr);
    }	  
}


function constructData(ospfID)
{
	  dinterface = new DataInterface(); 
	  var obj = new Object();
    dinterface.rows[dinterface.rows.length] = obj;
    
    var ptag = new ParamTag();
    ptag.value = ospfID; 
    obj["ospfID"] = ptag;
    
    ptag = new ParamTag();
    ptag.value = ct.getAttrValue("areaid"); 
    obj["areaid"] = ptag;
    
    ptag = new ParamTag();
    ptag.value = ct.getAttrValue("lsatype"); 
    obj["lsatype"] = ptag;
    
    ptag = new ParamTag();
    ptag.value = ct.getAttrValue("subnetipaddr") 
    obj["subnetipaddr"] = ptag;

    ptag = new ParamTag();
    ptag.value = ct.getAttrValue("subnetmask") 
    obj["subnetmask"] = ptag;
    
    ptag = new ParamTag();
    ptag.value = ct.getAttrValue("advertiseflag"); 
    obj["advertiseflag"] = ptag;
}
     
