
var winurlobj = getParentWindow();
var neid = winurlobj.winurlobj["neid"];
var OPRSUCC = 0;
var okFlag = false;
var ct;
var MIN_PRI = "0";
var MAX_PRI = "255";
var DEF_PRI = "1";
var usableOspfArr = new Array();

function initpage()
{
    initButtonText();
    ct = new CTable();
    ct.addHead(RESOURCE["attributeName"], RESOURCE["attributeValue"]);
    
    var atom = new Atom("select");
    atom.element.setAttribute("id", "htmlTableSelectOspfIDTBody");
    atom.element["onchange"] = function()
    {
        $("applybtn").disabled = false;
    }
    ct.addAttrRow("ospfID", RESOURCE["OSPFID"], atom);
    
    atom = new Atom("text");
    atom.element.setAttribute("id", "htmlTableTextOspfPeerIPTBody");
    atom.element.style.imeMode = "disabled";
    atom.element["onkeypress"] = function()
    {
        if (!restrict(this, event, "0123456789.")) 
        {
            return false;
        }
        return true;
    }
    
    atom = new Atom("text");
    atom.element.setAttribute("id", "htmlTableTextOspfPeerRemoteIPTBody");
    validateIp(atom.element);
    atom.element.style.imeMode = "disabled";
    atom.element["onfocus"] = function()
    {
        $("applybtn").disabled = false;
    }
    atom.setValue("0.0.0.0");
    ct.addAttrRow("peerip", RESOURCE["peerip"], atom);
    
    atom = new Atom("text");
    atom.element.setAttribute("id", "htmlTableTextOspfPeerPriTBody");
    checkText(atom.element,MIN_PRI,MAX_PRI);    
    atom.setValue(DEF_PRI); 
    ct.addAttrRow("peerpri", RESOURCE["peerpri"], atom);
    atom.element["onfocus"] = function()
    {
        $("applybtn").disabled = false;
    }
    
    document.body.insertBefore(ct.getTable(), document.body.firstChild);
    
    getOspfIDs();
}



function getOspfIDs()
{
    var xmlstr = createGetOspfIDsXML();
    var urlreq ="../../../../../neExlorerServlet?sfid="+TE_QUERY_NODE_CONFIG_OSPF+""+"&nmUser="+winurlobj["nmUser"];
    loadXMLdoc(urlreq, "POST",false,handleBackgetOspfIDs,null,"inputdata="+xmlstr);
}

function createGetOspfIDsXML()
{
	  var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var row = new tagElement("row-params");
    
    var param = new tagElement("param");    
    param.setAttribute("name","neid");
    param.setAttribute("value",neid);
    row.appendChild(param);
    
    param = new tagElement("param");    
    param.setAttribute("name","ospfID");
    param.setAttribute("value","0");
    row.appendChild(param);
    
    bussiness.appendChild(row);
    di.getRoot().appendChild(bussiness);
    return di.toString();
	
}

function handleBackgetOspfIDs(doc)
{
	  var data = EncapsulateData(doc);
    for(var i=data.getDataRowLength() -1; i>=0; i--)
    {
        if(data.getDataRowParam(i,"vpnID") != "4294967295")
        {
            data.rows.removeAt(i);
        }    	  	  
    }
    var errArr = [];
    errArr[0] = "errObj";
    openErrPage("../../../../../page/", data.getError(), errArr);
    
    if (OPRSUCC == data.getError().getGlobleECode()) 
    {
        ConverttoDataStru(data);
        initOspfIDSelectBox();
    }
}


function ConverttoDataStru(data)
{
	
		for(var i = 0, len = data.getDataRowLength(); i < len; i ++)
		{
	    usableOspfArr.push(data.getDataRowParam(i ,"protocolID"));
	  }
	
}

function initOspfIDSelectBox()
{
    var ospfIDAtom = ct.getAtom("ospfID");
    
	  for (var i = 0, len = usableOspfArr.length; i < len; i++)
	  {
         ospfIDAtom.addOption(usableOspfArr[i], usableOspfArr[i]);  
	  }
	  
     if (ospfIDAtom.element.length == 0)
     {
      	  alert(RESOURCE["noProtocol"]);
      	  xcloseDialog();
	        return;
    }
}


function initButtonText()
{
    $("okbtn").value = RESOURCE["okbutton"];
    $("cancelbtn").value = RESOURCE["cancelbutton"];
    $("applybtn").value = RESOURCE["applybutton"];
    $("applybtn").disabled = true;
}

function sendCreateInfo(buttonFlag)
{
    okFlag = buttonFlag;
		if(ct.getAttrValue("peerip") == "0.0.0.0")
		{
			alert(RESOURCE["wrongIPaddr"]);
			return;
		}
    
    if (!check_IPaddr(ct.getAttrValue("peerip"))) 
    {
        return;
    }
    
    $("okbtn").disabled = true;
    $("applybtn").disabled = true;
    
    var xmlstr = createXML();
    urlreq = "../../../../../neExlorerServlet?sfid=" + PTN_CMD_OSPF_ADD_PEER + "" + "&nmUser=" + winurlobj.winurlobj["nmUser"];
    loadXMLdoc(urlreq, "POST", true, handleBackCreate, null, "inputdata=" + xmlstr);
}

function createXML()
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var row = new tagElement("row-params");
    
    var param = new tagElement("param");
    param.setAttribute("name", "neid");
    param.setAttribute("value", neid);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "flag");
    param.setAttribute("value", "0");
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "ospfID");
    param.setAttribute("value", ct.getAttrValue("ospfID"));
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "peerip");
    param.setAttribute("value", convertIpaddrToHexcode(ct.getAttrValue("peerip")));
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "peerpri");
    param.setAttribute("value", ct.getAttrValue("peerpri"));
    row.appendChild(param);
    
    bussiness.appendChild(row);
    
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

function handleBackCreate(doc)
{
    $("okbtn").disabled = false;
    
    var data = EncapsulateData(doc);
    if (OPRSUCC == data.getSErrorCode()) 
    {
        winurlobj.sendQueryInfo();
        
        if (okFlag) 
        {
            xcloseDialog();
        }
    }
    else 
    {
        $("applybtn").disabled = false;
        if (data.getError().rowErrors[0]) 
        {
            var size = data.getBErrLength();
            for (var i = 0; i < size; i++) 
            {
                var tempObj = data.getError().rowErrors[i].errorObj;
                tempObj["createPeer"] = RESOURCE["createpeer"];
            }
        }
        var errArr = [];
        errArr[0] = "createPeer";
        openErrPage("../../../../../page/", data.getError(), errArr);
    }
}
