var winurlobj = getParentWindow();
var OPRSUCC = 0;
var OPRPART = 1;
var ct;
var submitFlag = false;
var DEFAILT_VPNID = "4294967295";
var AUTH_NONE = "0";
var AUTH_PSWD = "1";
var AUTH_MD5 = "2";
var AUTH_PSWD_LEN = 8;
var AUTH_MD5_LEN = 24;

var dinterface;

function initpage()
{
    var script = document.createElement("script");
    script.src = "../../../../../script/encrypt.js";
    document.body.appendChild(script);

	  createTable();
	
	  $("submitBtn").value=RESOURCE["okbutton"];
	  $("cancelBtn").value=RESOURCE["cancelbutton"];
	  $("applyBtn").value=RESOURCE["applybutton"];
}

function createTable()
{
	
	  var ospfid =winurlobj.getSelectedOspfID();
	
	  ct = new CTable();	
	  ct.addHead(RESOURCE["attributeName"], RESOURCE["attributeValue"]);
    
    var atom = new Atom("text");
    atom.element.disabled = true;
    ct.addAttrRow("ospfID", RESOURCE["OSPFID"], atom);
    ct.setAttrValue("ospfID", ospfid);  
    
    atom = new Atom("text");
    atom.element.setAttribute("id", "htmlTableTextAreaID");
    atom.element.style.imeMode = "disabled";
    atom.element.value="0.0.0.0";
    validateIp(atom.element);
    ct.addAttrRow("areaid",RESOURCE["areaid"],atom);
    atom.element["onkeydown"] = function()
    {
	      changeVale(this);
    }
    
    atom = new Atom("select");
    atom.element.setAttribute("id", "htmlTableSelectAreaType");
    atom.addOption(RESOURCE["standard"],1);
    atom.addOption(RESOURCE["stub"],2);
    atom.addOption(RESOURCE["nssa"],3);    
    atom.element["onchange"] = function()
    {
	      changeVale(this);
	      
    }
    ct.addAttrRow("areatype",RESOURCE["areatype"],atom);

    atom = new Atom("select");
    atom.element.setAttribute("id", "htmlTableSelectAuthType");
    atom.addOption(RESOURCE["authnone"],AUTH_NONE);
    atom.addOption(RESOURCE["authpswd"],AUTH_PSWD);
    atom.addOption(RESOURCE["authmd5"],AUTH_MD5);    
    atom.element["onchange"] = function()
    {
	      changeVale(this);
	      if(this.value== AUTH_NONE)
	      {
	      	ct.setAttrValue("authcode", "/"); 	
	      	ct.getAtom("authcode").element.disabled = true;
	      }else
	      {
	        ct.setAttrValue("authcode", ""); 	
	        ct.getAtom("authcode").element.disabled = false;
	      }
	      if(this.value == AUTH_PSWD)
	      {
	      	  ct.getAtom("authcode").element.maxLength = AUTH_PSWD_LEN;
	      	  
	      }else if(this.value == AUTH_MD5)
	      {
	      		 ct.getAtom("authcode").element.maxLength = AUTH_MD5_LEN;
	      }
    }
    ct.addAttrRow("authtype",RESOURCE["authtype"],atom);

    atom = new Atom("password");
    atom.element.setAttribute("id", "htmlTableTextAuthCode");
    atom.element.maxLength = AUTH_MD5_LEN;
    ct.addAttrRow("authcode", RESOURCE["authcode"], atom);
    ct.setAttrValue("authcode", "/"); 
    atom.element.disabled = true;
    atom.element.readOnly = true;
    atom.element["onfocus"] = function()
    {
	    if (!atom.element.disabled)
        {
            setPassword();
        }
        return false;
    }

    
    $("tablecomponent").appendChild(ct.getTable());
}

function setPassword()
{
	var PASSWORD_LEN = AUTH_MD5_LEN;
	if(ct.getAttrValue("authtype") == AUTH_PSWD)
    {
        PASSWORD_LEN = AUTH_PSWD_LEN;
    }
	showSetPwdPage(RESOURCE["setpwd"],"../../../../../",false,PASSWORD_LEN,null,false,false,0);
}

function setpwdpageHandler(value)
{
	ct.setAttrValue("authcode", EncryptUtils.encrypt(value));
}

function changeVale(atom)
{
	  $("applyBtn").disabled=false;
}

function sendCreateInfo(buttonFlag)
{
	  submitFlag = buttonFlag;

	  if ($("applyBtn").disabled)
	  {
		    xcloseDialog();
		    return;
	  }
    
    var areaid = ct.getAttrValue("areaid")
    if ("255.255.255.255" == areaid)
    {
        alert(RESOURCE["areatyperange"]);
        return;
    }
    
		var xml = createNewXML();
		if (null == xml)
		{
		    return;
		}
	  
	  $("submitBtn").disabled=true;
	  $("applyBtn").disabled=true;
	  
		var url = "../../../../../neExlorerServlet?sfid="+TECMD_OSPF_ADD_AREA+"&nmUser=" + winurlobj.winurlobj["nmUser"]; 
		loadXMLdoc(url, "POST", true, handlBackCreate, null, "inputdata=" + xml);
}

function createNewXML()
{
	var authcode = "";
	  var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var row = new tagElement("row-params");
    
    var param = new tagElement("param");    
    param.setAttribute("name","neid");
    param.setAttribute("value",winurlobj.winurlobj["neid"]);
    row.appendChild(param);
    
    param = new tagElement("param"); 
    param.setAttribute("name","flag");
    param.setAttribute("value","0");
    row.appendChild(param);
     
    param = new tagElement("param"); 
    param.setAttribute("name","ospfID");
    param.setAttribute("value",ct.getAttrValue("ospfID"));
    row.appendChild(param);
    
    param = new tagElement("param"); 
    param.setAttribute("name","areaid");
    param.setAttribute("value",convertIpaddrToHexcode(ct.getAttrValue("areaid")));
    row.appendChild(param);
    
    param = new tagElement("param"); 
    param.setAttribute("name","areaidstr");
    param.setAttribute("value",ct.getAttrValue("areaid"));
    row.appendChild(param);
    
    
    param = new tagElement("param"); 
    param.setAttribute("name","areatype");
    param.setAttribute("value",ct.getAttrValue("areatype"));
    row.appendChild(param);
 
    var authtype = ct.getAttrValue("authtype");  
    param = new tagElement("param"); 
    param.setAttribute("name","authtype");
    param.setAttribute("value",authtype);
    row.appendChild(param);
 
    if(authtype ==0)
    {
    	authcode ="";
    }
    else
    {
      authcode= ct.getAttrValue("authcode"); 
      if(authcode =="" || !authcode)
      {
          alert(RESOURCE["putAuthenticationKey"]);
          return null;
      } 		
    }
    param = new tagElement("param"); 
    param.setAttribute("name","authcode");
    param.setAttribute("isPassword",true);
    param.setAttribute("value",authcode);
    row.appendChild(param);

    constructData();
	         
    bussiness.appendChild(row);
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

function handlBackCreate(doc)
{ 	  
	  $("submitBtn").disabled=false;
	  
	  var data = EncapsulateData(doc);    
    if(OPRSUCC == data.getSErrorCode()) 
    {	      
      
	      winurlobj.appendrowtotable(dinterface);
	      
	      if (submitFlag)
	      {
	      	  xcloseDialog();
	      }
    } 
    else
    {   
    	  $("applyBtn").disabled=false;
	      if(data.getError().rowErrors[0])
	      {		
	        	var size = data.getBErrLength();
	        	for(var i = 0;i < size;i++)
	        	{
		        	  var tempObj = data.getError().rowErrors[i].errorObj;
  	        		tempObj["operateObj"] = RESOURCE["createarea"];
		        }
	      }		
	      var errArr = [];
        errArr[0] = "operateObj";
        openErrPage("../../../../../page/", data.getError(), errArr);
    }	  
}


function constructData()
{
	  dinterface = new DataInterface(); 
	  
	  var obj = new Object();
    dinterface.rows[dinterface.rows.length] = obj;
    
    var ptag = new ParamTag();
    ptag.value = ct.getAttrValue("ospfID"); 
    obj["ospfID"] = ptag;
    
    ptag = new ParamTag();
    ptag.value = ct.getAttrValue("areaid"); 
    obj["areaid"] = ptag;
    
    ptag = new ParamTag();
    ptag.value =  ct.getAttrValue("areatype"); 
    obj["areatype"] = ptag;
    
    ptag = new ParamTag();
    ptag.value = ct.getAttrValue("authtype") 
    obj["authtype"] = ptag;
    
    ptag = new ParamTag();
    ptag.value = "*"; 
    obj["authcode"] = ptag;
}
