/*
 * Title:        iManager U2000 V1R2<br>
 * Description:  MPLS-LDP       JS<br>
 * Copyright:    Copyright (c) 2000-2009<br>
 * Company:      Huawei Tech. Co., Ltd<br>
 * @author       zhaoliang 69741
 * @version      1.0  Jun 10, 2009
 */

var st = new SortTable();
st.head.setAttribute("id", "htmlTable_STHead_ldpprotocol");
st.body.setAttribute("id", "htmlTable_STBody_ldpprotocol");

var winobj = getNeProperty(self);

var nmUser = winobj["nmUser"];

var neID = winobj.neid;

var btnRightArr = new Object();

var deleteRight = false;
var queryRight = false;
var modifyRight = false;
var createRight = false;

var oprSucc = 0;
var oprFail = 2;

var TIMEOUT = 131080;

var QUERYSFID = TECMDCODE_GET_LDP_CONF;
var DELETESFID = TECMDCODE_DEL_LDP_CONF;
var SENDSFID = TECMDCODE_MODIFY_LDP_CONF;

var servInfoArray = null;

var modifyInfoArray = [];
var NEIDBASE = 65536;
var LDP_INEXIST = "42140";
var PARTSUCC = 1;
var FAIL = 2;

var qpath = "../../../../../";
var hpath = "../../../../../";

var rowSelectedRow;
var passwordColid;

/*
 *     
 */
function ServiceInfo()
{
    this.data = new Array();
    this.colid = new Array();
    
    this.torowparamXML = function()
    {
        var row = new tagElement("row-params");
        
        for (var i = 0; i < this.colid.length; i++) 
        {
            colid = this.colid[i];
            var val = this.data[colid];
            if (colid == "ddtID") 
            {
                val = hexToTen(this.data[colid]);
            }
            this.addParam(row, colid, val);
        }
        return row;
    }
    
    this.addParam = function(row, name, value)
    {
        var param = new tagElement("param");
        param.setAttribute("name", name);
        if ("md5pwd" == name)
        {            
            param.setAttribute("isPassword",true);
            param.setAttribute("value",value);
        }
        else
        {
            param.setAttribute("value", value);
        }
        
        row.appendChild(param);
    }
}

/*
 *      
 */
function initpage()
{ 
    var script = document.createElement("script");
    script.src = "../../../../../script/encrypt.js";
    document.body.appendChild(script);
    
    st.setOnRowSelectHandler(rowSelected);
    st.setOnCellEditHandler(cellEditHandler);
    st.setImage(qpath + "images/");
    
    createTableHead(st, window.tableconf[0]);
    
    $("tablecomponent").appendChild(st.getTable());
    st.setBodyWidth(window.tableconf[0].width,window.tableconf[0].percent,0);
    st.setBodyHeight(getComponetHeight($("tablecomponent"), 70) + "px");
    
    initButton();
    
    if (btnRightArr.querybtn.right) 
    {
        doQuery();
    }
    
    $("tablecomponent").oncontextmenu = popupMenuHandler;
}

/*
 *      
 */
function initButton()
{
    document.getElementById("applybtn").value = RESOURCE["applybtn"];
    document.getElementById("querybtn").value = RESOURCE["querybtn"];
    document.getElementById("createbtn").value = RESOURCE["createbtn"];
    document.getElementById("deletebtn").value = RESOURCE["deletebtn"];
    
    btnRightArr.applybtn = new BtnRightObj("applybtn", TECMDCODE_MODIFY_LDP_CONF);
    btnRightArr.querybtn = new BtnRightObj("querybtn", TECMDCODE_GET_LDP_CONF);
    btnRightArr.createbtn = new BtnRightObj("createbtn", TECMDCODE_ADD_LDP_CONF);
    btnRightArr.deletebtn = new BtnRightObj("deletebtn", TECMDCODE_DEL_LDP_CONF);
    
    sendRightInfo(btnRightArr);
    
    $("querybtn").disabled = !btnRightArr.querybtn.right;
    $("createbtn").disabled = !btnRightArr.createbtn.right;
    $("deletebtn").disabled = !btnRightArr.deletebtn.right;
    $("applybtn").disabled = !btnRightArr.applybtn.right;
    deleteRight = btnRightArr.deletebtn.right;
    queryRight = btnRightArr.querybtn.right;
    createRight = btnRightArr.createbtn.right;
    modifyRight = btnRightArr.applybtn.right;
}

/*
 *     
 */
function doQuery()
{
    document.getElementById("querybtn").disabled = true;
    document.getElementById("createbtn").disabled = true;
    document.getElementById("deletebtn").disabled = true;
    document.getElementById("applybtn").disabled = true;
    
    var xml = createQueryRequest();
    var URL = hpath + "neExlorerServlet?sfid=" + QUERYSFID + "&flag=1&nmUser=" + nmUser;
    loadXMLdoc(URL, "POST", false, processQueryResponse, null, "inputdata=" + xml);
}

/*
 *     XML
 */
function createQueryRequest()
{
    var root = new inputxml("datainterface");
    var business = new tagElement("bussiness-params");
    var row = new tagElement("row-params");
    
    var param = new tagElement("param");
    param.setAttribute("name", "neid");
    param.setAttribute("value", neID);
    row.appendChild(param);
    
    var param = new tagElement("param");
    param.setAttribute("name", "ddtID");
    param.setAttribute("value", "0");
    row.appendChild(param);
    
    business.appendChild(row);
    
    root.getRoot().appendChild(business);
    return root.toString();
}

/*
 *         
 */
function processQueryResponse(doc)
{
    var dinterface = EncapsulateData(doc);
    var errArr = [];
    errArr[0] = "nename";
    var size = dinterface.getBErrLength();
  
    openErrPage(qpath + "page/", dinterface.getError(), errArr);
    
    if (oprFail == dinterface.getError().getGlobleECode() ||
    TIMEOUT == dinterface.getError().getGlobleECode()) 
    {
        $("querybtn").disabled = !btnRightArr.querybtn.right;
        $("createbtn").disabled = !btnRightArr.createbtn.right;
        document.getElementById("deletebtn").disabled = true;
        document.getElementById("applybtn").disabled = true;
        
        return;
    }
    
    for (var i = 0; i < dinterface.getDataRowLength(); i++) 
    {
        var row = dinterface.rows[i];
        
        var tempStr = dinterface.rows[0]["nodeID"].value;
        tempStr = convertNumToIpaddr(tempStr);
        row["localID"].value = tempStr;
        
        tempStr = row["ddtID"].value;
        tempStr = parseInt("0x" + tempStr.substring(0, 2)) + "." +
        parseInt("0x" + tempStr.substring(2, 4)) + "." +
        parseInt("0x" + tempStr.substring(4, 6)) +"." +
        parseInt("0x" + tempStr.substring(6, 8));
        row["remoteID"].value = tempStr;
        
        if (row["locallablespace"].value == "-1" || row["locallablespace"].value == "") 
        {
            row["locallablespace"].value = "/";
        }
        if (row["remotelablespace"].value == "-1" || row["remotelablespace"].value == "") 
        {
            row["remotelablespace"].value = "/";
        }
        if (row["sessiontype"].value == "-1" || row["sessiontype"].value == "") 
        {
            row["sessiontype"].value = "/";
        }
        if (row["status"].value == "-1" || row["status"].value == "") 
        {
            row["status"].value = "/";
        }
        if (row["role"].value == "-1" || row["role"].value == "") 
        {
            row["role"].value = "/";
        }
        if (row["grcap"].value == "-1" || row["grcap"].value == "") 
        {
            row["grcap"].value = "/";
        }
        if (row["grinntertime"].value == "-1" || row["grinntertime"].value == "") 
        {
            row["grinntertime"].value = "/";
        }
        if (row["grreturntime"].value == "-1" || row["grreturntime"].value == "") 
        {
            row["grreturntime"].value = "/";
        }
        if (row["ckasendtime"].value == "-1" || row["ckasendtime"].value == "") 
        {
            row["ckasendtime"].value = "/";
        }
        if (row["localkeeptime"].value == "-1" || row["localkeeptime"].value == "") 
        {
            row["localkeeptime"].value = "/";
        }
        if (row["remotekeeptime"].value == "-1" || row["remotekeeptime"].value == "") 
        {
            row["remotekeeptime"].value = "/";
        }
        row["md5pwd"].value = "*";
    }
    
    clearTable();
    createTableBody(st, window.tableconf[0], dinterface, RESOURCE);
    
    addCellEvent();
    
    if (!st.element.colsArray.selectedId) 
    {
        st.element.colsArray.selectedId = "remoteID";
        st.element.colsArray.imgflag = 1;
    }
    
    var td = st.element.headRow.element.cols[st.element.colsArray.selectedId].element;
    
    document.getElementById("querybtn").disabled = !btnRightArr.querybtn.right;
    document.getElementById("createbtn").disabled = !btnRightArr.createbtn.right;
    document.getElementById("deletebtn").disabled = true;
    document.getElementById("applybtn").disabled = true;
}

/*
 *       
 */
function clearTable()
{
    for (var i = 0; i < st.getDataRowLength(); ++i) 
    {
        st.deleteRow(i);
    }
    st.adjustDataRows();
}

/*
 *     
 */
function doDelete()
{
    if (st.getSelectedRowCount() <= 0) 
    {
        alert(RESOURCE["noselect"]);
        return;
    }
    if (!confirm(RESOURCE["Delete_Hint"])) 
    {
        return;
    }
    
    document.getElementById("querybtn").disabled = true;
    document.getElementById("createbtn").disabled = true;
    document.getElementById("deletebtn").disabled = true;
    document.getElementById("applybtn").disabled = true;
    
    var xml = createDeleteRequest();
    var URL = hpath + "neExlorerServlet?sfid=" + DELETESFID + "&flag=1&nmUser=" + nmUser;
    loadXMLdoc(URL, "POST", true, processDeleteResponse, null, "inputdata=" + xml);
}

/*
 *     XML
 */
function createDeleteRequest()
{
    var ddtID = [];
    
    var selRows = st.getSelectedRows();
    for (var i = 0; i < selRows.length; ++i) 
    {
        ddtID[ddtID.length] = st.getCellStoreValue(selRows[i], "ddtID", "ddtID");
    }
    
    var root = new inputxml("datainterface");
    var business = new tagElement("bussiness-params");
    for (var i = 0; i < selRows.length; ++i) 
    {
        var row = new tagElement("row-params");
        
        var param = new tagElement("param");
        param.setAttribute("name", "neid");
        param.setAttribute("value", neID);
        row.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "ddtID");
        param.setAttribute("value", hexToTen(ddtID[i]));
        row.appendChild(param);
        
        business.appendChild(row);
    }
    root.getRoot().appendChild(business);
    return root.toString();
}

/*
 *         
 */
function processDeleteResponse(doc)
{
    var dinterface = EncapsulateData(doc);
    
    var errCode = dinterface.getSErrorCode();
    if (0 != errCode) 
    {
        var len = dinterface.getBErrLength();
        for (var i = len - 1; i >= 0; i--) 
        {
            if (LDP_INEXIST == dinterface.errObj.rowErrors[i].error.code) 
            {
                dinterface.errObj.rowErrors.removeAt(i);
                len--;
            }
        }
        if (0 == len && (PARTSUCC == errCode || FAIL == errCode)) 
        {
            dinterface.errObj.s_error.code = 0;
        } 
        else 
        {
            for (var i = 0; i < len; i++) 
            {
                var tempObj = dinterface.getError().rowErrors[i].errorObj;
                tempObj["operateObj"] = RESOURCE["deletebtn"] + RESOURCE["ldppeer"];
            }
            
            var errArr = [];
            errArr[0] = "nename";
            errArr[1] = "operateObj";
            openErrPage(qpath + "page/", dinterface.getError(), errArr);
        }
    }
    
    doQuery();
}

/*
 *     
 */
function doApply()
{
    document.getElementById("querybtn").disabled = true;
    document.getElementById("createbtn").disabled = true;
    document.getElementById("deletebtn").disabled = true;
    document.getElementById("applybtn").disabled = true;
    
    sreahModify();
    
    var xml = createSendXml();
    
    if (null == xml) 
    {
        return;
    }
    
    sendXmlData(xml);
}

/*
 *     XML
 */
function createSendXml()
{

    var root = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    
    for (var i = 0; i < modifyInfoArray.length; i++) 
    {
        var servInfo = modifyInfoArray[i];
        
        servInfo.colid[servInfo.colid.length] = "neid";
        servInfo.data["neid"] = neID;
        
        var row = servInfo.torowparamXML();
        bussiness.appendChild(row);
    }
    
    root.getRoot().appendChild(bussiness);
    return root.toString();
}

/*
 *   XML  
 */
function sendXmlData(xml)
{
    var url = hpath + "neExlorerServlet?sfid=" + SENDSFID + "&flag=1&nmUser=" + nmUser;
    loadXMLdoc(url, "POST", true, PostCallBackHandler, null, "inputdata=" + xml);
}

/*
 *         
 */
function PostCallBackHandler(doc)
{
    var dinterface = EncapsulateData(doc);
    
    var errArr = [];
    errArr[0] = "nename";
    
    openErrPage(qpath + "page/", dinterface.getError(), errArr);
    
    refreshTableState(st, window.tableconf[0], dinterface);
        
    if (dinterface.getSErrorCode() != 0) 
    {
        $("applybtn").disabled = !btnRightArr.applybtn.right;
    }
    $("querybtn").disabled = !btnRightArr.querybtn.right;
    $("createbtn").disabled = !btnRightArr.createbtn.right;
    $("deletebtn").disabled = !btnRightArr.deletebtn.right;
}

/*
 *        
 */
function cellEditHandler()
{
    if (btnRightArr.applybtn.right) 
    {
        $("applybtn").disabled = false;
    }
}

/*
 *       
 */
function showShareChanged()
{
    sharedFlag = false;
    doQuery();
}

/*
 *     
 */
function create()
{
    xshowModalDialog("createldp.html", RESOURCE["servCrea"], 450, 160, qpath + "images/")
}

/*
 *     
 */
function queryLink()
{
    doQuery();
}

/*
 *     
 */
function delLink()
{
    doDelete();
}

/*
 *     
 */
function applyLink()
{
    doApply();
}

/*
 *     
 */
function BtnRightObj(btnId, sfid)
{
    if (null != btnId) 
    {
        this.btnId = btnId;
    } 
    else 
    {
        this.btnId = "";
    }
    
    if (isNaN(parseInt(sfid))) 
    {
        this.sfid = -1;
    } 
    else 
    {
        this.sfid = sfid;
    }
    
    this.right = true;
}

/*
 *       
 */
function sendRightInfo()
{
    var url = hpath + "securityServlet?neID=" + winobj["neid"] + "&nmUser=" + winobj["nmUser"];
    loadXMLdoc(url, "POST", false, rightHandleBack, null, "inputdata=" + createRightXML());
}

/*
 *     XML
 */
function createRightXML()
{
    var root = new inputxml("datainterface");//Create the root of a xml file
    var firstlevel = new tagElement("bussiness-params");
    
    var secondlevel = null;
    var thirdlevel = null;
    
    for (var btnrightobj in btnRightArr)
    {
        secondlevel = new tagElement("row-params");
        
        thirdlevel = new tagElement("param");
        thirdlevel.setAttribute("name", "btnID");
        thirdlevel.setAttribute("value", btnRightArr[btnrightobj].btnId);
        secondlevel.appendChild(thirdlevel);
        
        thirdlevel = new tagElement("param");
        thirdlevel.setAttribute("name", "sfid");
        thirdlevel.setAttribute("value", btnRightArr[btnrightobj].sfid);
        secondlevel.appendChild(thirdlevel);
        
        firstlevel.appendChild(secondlevel);
    }
    root.getRoot().appendChild(firstlevel);
    return root.toString();
}

/*
 *         
 */
function rightHandleBack(doc)
{
    var data = EncapsulateData(doc);
    
    for (var i = 0; i < data.getDataRowLength(); i++) 
    {
        var right = data.getDataRowParam(i, "right");
        
        if (0 == right) 
        {
            btnRightArr[data.getDataRowParam(i, "btnID")].right = false;
        } 
        else 
        {
            btnRightArr[data.getDataRowParam(i, "btnID")].right = true;
        }
    }
}

/*
 * Tab     
 */
function tabSelectHandler()
{
    if (btnRightArr.querybtn.right) 
    {
        doQuery();
    }
}

/*
 *     
 */
window.onresize = function()
{
    st.setBodyHeight(getComponetHeight($("tablecomponent"), 70) + "px");
}

/*
 *     
 */
window.onload = function()
{
    initpage();
}

/*
 *      
 */
function rowSelected(rows)
{
    if (deleteRight) 
    {
        document.getElementById("deletebtn").disabled = false;
    }
    
    if (null == rows || 0 >= rows.length) 
    {
        document.getElementById("deletebtn").disabled = true;
        document.getElementById("applybtn").disabled = true;
        return;
    }
    
    if (1 < rows.length) 
    {
        document.getElementById("applybtn").disabled = true;
    }
    
    servInfoArray = [];
    for (var i = 0; i < rows.length; i++) 
    {
        var servInfo = new ServiceInfo();
        colsArr = st.getTable().colsArray
        
        for (var j = 0; j < colsArr.length; j++) 
        {
            colid = window.tableconf[0].getColId(j);
            servInfo.data[colid] = st.getCellStoreValue(rows[i], colid, colid);
        }
        servInfoArray[servInfoArray.length] = servInfo;
    }
}

/*
 *       
 */
function rightClickEvent()
{
    rightClickHandler();
}

/*
 *           
 */
function addCellEvent()
{
    var cell = null;
    
    for (var i = 0, len = st.getDataRowLength(); i < len; i++) 
    {
        cell = st.getCell(i, "grinntertime");
        if (null != cell) 
        {   
            textCheck(cell.element.editElement.element, "90", "86400");
        }
    
        cell = st.getCell(i, "grreturntime");
        if (null != cell) 
        {   
            textCheck(cell.element.editElement.element, "60", "86400");
        }
    
        cell = st.getCell(i, "hellotime");
        if (null != cell) 
        {   
            textCheck(cell.element.editElement.element, "3", "65535");
        }
        
        cell = st.getCell(i, "kasendtime");
        if (null != cell) 
        {   
            textCheck(cell.element.editElement.element, "3", "65535");
        }
    
        cell = st.getCellElement(i,"md5pwd");
        if (cell.isEdit == 1)
        {
            cell.ondblclick = setPassword;
        }

        cell.editElement.element.maxLength = 24;
        checkInputData(cell.editElement.element, 24);
        /*
        cell.editElement.element["onkeypress"] = function()
        {
            if(!restrict(this, event, "0123456789abcdefABCDEF"))
            {
                return false;
            }
            return true;
        }
        */
    }
}

function setPassword()
{
	rowSelectedRow = this.parentNode.rowIndex;
	passwordColid = this.colid;
	showSetPwdPage(RESOURCE["setpwd"],"../../../../../",false,24);
}

function setpwdpageHandler(value)
{
	var cpcell = st.getCellElement(rowSelectedRow, passwordColid);
	cpcell.showElement.setValue("*");
	cpcell.storeValue[passwordColid] = EncryptUtils.encrypt(value);
	cpcell.modify = true;
	cpcell.parentNode.modify = true;
	cpcell.style.backgroundColor = "#d0f946";
	
	if(btnRightArr.applybtn.right)
    {
        $("applybtn").disabled = false; 
    }
}

function checkInputData(obj, maxlen)
{
    obj.onkeyup = function()
    {
        return calStrSinoLen(this, maxlen);
    }
}

/*
 *        
 */
function tagCellEvent(cell)
{
    var atom = cell.element.editElement;
    atom.element["onchange"] = function()
    {
        tabCellEditHandler(this);
    }
    atom.element["onkeydown"] = function(){}
}

/*
 *          
 */
function tabCellEditHandler(atom)
{
    if (modifyRight) 
    {
        document.getElementById("applybtn").disabled = false;
    }
    var rowindex = atom.parentNode.parentNode.rowIndex;
    var colid = atom.parentNode.colid;
    var value = atom.value;
    
    st.setCellIsEdit(st.getCell(rowindex, colid),1);
    modifyInfoArray.length = 0;
    for (var i = 0, len = st.getDataRowLength(); i < len; i++) 
    {
        if (st.getRow(i).element.modify) 
        {
            var servInfo = new ServiceInfo();
            colsArr = st.getTable().colsArray
            
            for (var j = 0; j < colsArr.length; j++) 
            {
                colid = window.tableconf[0].getColId(j);
                servInfo.data[colid] = st.getCellStoreValue(st.getRow(i), colid, colid);
            }
            modifyInfoArray[modifyInfoArray.length] = servInfo;
        }
    }
}

/*
 *       
 */
function sreahModify()
{
    modifyInfoArray.length = 0;
    
    for (var i = 0, len = st.getDataRowLength(); i < len; i++) 
    {
        if (st.getRow(i).element.modify) 
        {
            var servInfo = new ServiceInfo();
            colsArr = st.getTable().colsArray;
            var index = 0;
            for (var j = 0; j < colsArr.length; j++) 
            {
                colid = window.tableconf[0].getColId(j);
                if (st.getCellModify(i, colid) || colid == "ddtID") 
                {
                    servInfo.colid[index++] = colid;
                    servInfo.data[colid] = st.getCellStoreValue(i, colid, colid);
                }
            }
            modifyInfoArray[modifyInfoArray.length] = servInfo;
        }
    }
}
