/*
 * Title:        iManager U2000 V1R2<br>
 * Description:  MPLS-LDP       JS<br>
 * Copyright:    Copyright (c) 2000-2009<br>
 * Company:      Huawei Tech. Co., Ltd<br>
 * @author       zhaoliang 69741
 * @version      1.0  Jun 10, 2009
 */

var winurlobj = getNeProperty(self);

var btnRightArr = new Object();

var OPRSUCC = 0;
var PARTSUCC = 1;
var RESULT_NULL = "38662";
var TIMEOUT = 131080;
var SERIALPORT_MIN = 6144;
var SERIALPORT_MAX = 8191;

var st;

var MIN_SECOND = "3";
var MAX_SECOND = "65535";

var portenable = new Object();
portenable[0] = "Disabled";
portenable[1] = "Enabled";

/*
 *     
 */
window.onresize=function()
{
    st.setBodyHeight(getComponetHeight($("tablecomponent"),70)+"px");
}

/*
 *      
 */
function initpage()
{
    document.body.oncontextmenu = returnFalse;
    st = new SortTable();
    st.head.setAttribute("id", "htmlTable_SortTableHead_ldpport");
    st.body.setAttribute("id", "htmlTable_SortTableBody_ldpport");
    st.setImage("../../../../../images/");    
    tc = window.tableconf[0];    
    st.setOnCellEditHandler(cellEditHandler);
    createTableHead(st, tc);    
    st.setBodyHeight(getComponetHeight($("tablecomponent"),70)+"px");    
    $("tablecomponent").oncontextmenu = popupMenuHandler;
    $("tablecomponent").appendChild(st.getTable());
    
    $("queryBtn").value=RESOURCE["querybutton"];
    $("applyBtn").value=RESOURCE["applybutton"];
    
    btnRightArr.queryBtn = new BtnRightObj("queryBtn",TECMDCODE_QUERY_LDP_PORT);    
    btnRightArr.applyBtn = new BtnRightObj("applyBtn",TECMDCODE_MODIFY_LDP_PORT);
    
    getRightInfo(winurlobj,btnRightArr);
    $("queryBtn").disabled = true;
    $("applyBtn").disabled = true;
    if(btnRightArr.queryBtn.right)
    {
        query();
    }   
}

/*
 *        
 */
function cellEditHandler()
{
    $("applyBtn").disabled = !btnRightArr.applyBtn.right; 
}

/*
 *     
 */
function query()
{
    $("queryBtn").disabled = true;
    $("applyBtn").disabled = true;
  
    var xmlstr = createQueryXML();
    
    var urlreq ="../../../../../neExlorerServlet?sfid="+TECMDCODE_QUERY_LDP_PORT+""+"&nmUser="+winurlobj["nmUser"];        
    loadXMLdoc(urlreq, "POST",true,handleBackQuery,null,"inputdata="+xmlstr);   
}

/*
 *     XML
 */
function createQueryXML()
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var row = new tagElement("row-params");
    
    var param = new tagElement("param");    
    param.setAttribute("name","neid");
    param.setAttribute("value",winurlobj["neid"]);
    row.appendChild(param);
    
    var param = new tagElement("param");    
    param.setAttribute("name","slotid");
    param.setAttribute("value","0");
    row.appendChild(param);
    
    var param = new tagElement("param");    
    param.setAttribute("name","subslotid");
    param.setAttribute("value","0");
    row.appendChild(param);
    
    var param = new tagElement("param");    
    param.setAttribute("name","port");
    param.setAttribute("value","0");
    row.appendChild(param);
    
    bussiness.appendChild(row);
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

/*
 *         
 */
function handleBackQuery(doc)
{
    st.clearTableData();
    
    $("queryBtn").disabled = !btnRightArr.queryBtn.right;
    
    data = EncapsulateData(doc); 
    if(data.getError().rowErrors[0])
    {   
        var size = data.getBErrLength();
        for(var i = 0;i < size;i++)
        {
            var tempObj = data.getError().rowErrors[i].errorObj;
            tempObj["operateObj"] = RESOURCE["queryLDPPort"];
        }
    }   
    var errArr = [];
    errArr[0] = "operateObj";
    
    if (OPRSUCC != data.getError().getGlobleECode()) 
    { 
        var flag = true;
        var len = data.errObj.rowErrors.length
        for (var i = 0; i < len; i++)
        {
            if (RESULT_NULL != data.errObj.rowErrors[i].error.code)
            {
                flag = false;
                break;
            }
        }
        if (flag && TIMEOUT != data.errObj.s_error.code)
        {
            data.errObj.s_error.code = OPRSUCC;
        }
    }
    
    openErrPage("../../../../../page/", data.getError(), errArr);
    
    
    if (OPRSUCC == data.getError().getGlobleECode() || PARTSUCC == data.getError().getGlobleECode()) 
    {
        for(var i=0;i<data.getDataRowLength();i++)
        {
          
            var row = data.rows[i];
          
            getPortName(row["port"].value, row);
        }
        
        st.clearTableData();
        createTableBody(st, window.tableconf[0], data, RESOURCE);
        
        addCellEvent();
    } 
}

/*
 *          
 */
function addCellEvent()
{
    var cell = null;
    for(var i = 0,len = st.getDataRowLength();i<len;i++)
    {            
        cell = st.getCellElement(i,"hellopara");
        textCheck(cell.editElement.element,MIN_SECOND,MAX_SECOND);
        
        cell = st.getCellElement(i,"keepalive");
        textCheck(cell.editElement.element,MIN_SECOND,MAX_SECOND);
    }
}

/*
 *     
 */
function apply()
{
    var xml = createApplyXML();
    if (null == xml)
    {
        return;
    }
    
    $("queryBtn").disabled = true;
    $("applyBtn").disabled = true;
    
    var urlreq ="../../../../../neExlorerServlet?sfid="+TECMDCODE_MODIFY_LDP_PORT+""+"&nmUser="+winurlobj["nmUser"];
    loadXMLdoc(urlreq, "POST",true,handleBackApply,null,"inputdata="+xml);
}

/*
 *     XML
 */
function createApplyXML()
{
    di = new inputxml("datainterface");
    bussiness = new tagElement("bussiness-params");
    var row;
    var param;
    
    for(var i=0,length = st.getDataRowLength();i<length;i++)
    {
        if(!st.getModify(i))
        {
          continue;
        }
        row = new tagElement("row-params");   
            
        param = new tagElement("param");
        param.setAttribute("name","neid");
        param.setAttribute("value",winurlobj["neid"]);
        row.appendChild(param); 
        
        param = new tagElement("param");    
        param.setAttribute("name","slotid");
        var slotid = st.getCellStoreValue(i,"port","slotid");
        if (undefined == slotid)
        {
            slotid = INVALID_SOLTID;
        }
        param.setAttribute("value",slotid);
        row.appendChild(param);
        
        param = new tagElement("param");    
        param.setAttribute("name","subslotid");
        var subslotid = st.getCellStoreValue(i,"port","subslotid");
        if (undefined == subslotid)
        {
            subslotid = INVALID_SUBSOLTID;
        }
        param.setAttribute("value",subslotid);
        row.appendChild(param);
        
        param = new tagElement("param");    
        param.setAttribute("name","port");
        param.setAttribute("value",st.getCellStoreValue(i,"portid","port"));
        row.appendChild(param);
        
        if (st.getCellModify(i, "portenable"))
        {
            param = new tagElement("param");
            param.setAttribute("name","portenable");
            param.setAttribute("value",st.getCellStoreValue(i,"portenable","portenable"));
            row.appendChild(param);
        }
        
        if (st.getCellModify(i, "hellopara"))
        {
            param = new tagElement("param");
            param.setAttribute("name","hellopara");
            param.setAttribute("value",st.getCellStoreValue(i,"hellopara","hellopara"));
            row.appendChild(param);
        }
        
        if (st.getCellModify(i, "keepalive"))
        {    
            param = new tagElement("param");
            param.setAttribute("name","keepalive");
            param.setAttribute("value",st.getCellStoreValue(i,"keepalive","keepalive"));
            row.appendChild(param);
        }
        
        bussiness.appendChild(row);
    }
    di.getRoot().appendChild(bussiness);
    
    return di.toString(); 
}

/*
 *         
 */
function handleBackApply(doc)
{
    $("queryBtn").disabled = !btnRightArr.queryBtn.right;

    var data = EncapsulateData(doc);
    
    if (OPRSUCC != data.getError().getGlobleECode())
    {
        if(data.getError().rowErrors[0])
        {   
            var size = data.getBErrLength();
            for(var i = 0;i < size;i++)
            {
                var tempObj = data.getError().rowErrors[i].errorObj;
                var portid = parseInt(tempObj["port"], 10);
                getPortNameForError(portid, tempObj);                    
            }
        }   
        var errArr = [];
        errArr[0] = "slotid";
        errArr[1] = "boardname"; 
        errArr[2] = "portname"; 
        openErrPage("../../../../../page/", data.getError(), errArr);
        
        $("applyBtn").disabled = !btnRightArr.applyBtn.right;
    }

    if (OPRSUCC == data.getError().getGlobleECode() || PARTSUCC == data.getError().getGlobleECode())
    {
        refreshTableState(st,tc,data);
    }
       
}
