/*
 * Title:        iManager U2000 V1R2<br>
 * Description:  MPLS-LDP       JS<br>
 * Copyright:    Copyright (c) 2000-2009<br>
 * Company:      Huawei Tech. Co., Ltd<br>
 * @author       zhaoliang 69741
 * @version      1.0  Jun 10, 2009
 */

var winurlobj = getNeProperty(self);

var neID = winurlobj.neid;

var btnRightArr = new Object();

var OPRSUCC = 0;
var PARTSUCC = 1;

var st;

var policymode = new Object();
policymode[1] = "Deny";
policymode[2] = "Permit";

var policydirection = new Object();
policydirection[1] = "Import";
policydirection[2] = "Export";

/*
 *     
 */
window.onresize=function()
{
    st.setBodyHeight(getComponetHeight($("tablecomponent"),70)+"px");
}

/*
 *      
 */
function initpage()
{
    document.body.oncontextmenu = returnFalse;
    st = new SortTable();
    st.head.setAttribute("id", "htmlTable_SortTableHead_ldplabelpolicy");
    st.body.setAttribute("id", "htmlTable_SortTableBody_ldplabelpolicy");
    st.setImage("../../../../../images/");    
    tc = window.tableconf[0];    
    createTableHead(st, tc);    
    st.setOnRowSelectHandler(rowSelected); 
    st.setBodyHeight(getComponetHeight($("tablecomponent"),70)+"px");    
    $("tablecomponent").oncontextmenu = popupMenuHandler;
    $("tablecomponent").appendChild(st.getTable());
    
    $("queryBtn").value=RESOURCE["querybutton"];
    $("createBtn").value = RESOURCE["newbutton"];
    $("deleteBtn").value = RESOURCE["deletebutton"];
    
    btnRightArr.queryBtn = new BtnRightObj("queryBtn",TECMDCODE_QUERY_LDP_LABELPOLICY);    
    btnRightArr.createBtn = new BtnRightObj("createBtn",TECMDCODE_CREATE_LDP_LABELPOLICY);
    btnRightArr.deleteBtn = new BtnRightObj("deleteBtn",TECMDCODE_DELETE_LDP_LABELPOLICY);
    
    getRightInfo(winurlobj,btnRightArr);
    
    $("queryBtn").disabled = true;
    $("createBtn").disabled = true;
    $("deleteBtn").disabled = true;
  
    if(btnRightArr.queryBtn.right)
    {
        query();
    }   
}

function rowSelected()
{
	  if (0 < st.getSelectedRowCount())
	  {
        $("deleteBtn").disabled = !btnRightArr.deleteBtn.right;	  	
	  }
	  else
	  {
	  	  $("deleteBtn").disabled = true;
	  }
}

/*
 *     
 */
function query()
{
    $("queryBtn").disabled = true;
    $("createBtn").disabled = true;
    $("deleteBtn").disabled = true;
  
    var xmlstr = createQueryXML();
    
    var urlreq ="../../../../../neExlorerServlet?sfid="+TECMDCODE_QUERY_LDP_LABELPOLICY+""+"&nmUser="+winurlobj["nmUser"];        
    loadXMLdoc(urlreq, "POST",false,handleBackQuery,null,"inputdata="+xmlstr);   
}

/*
 *     XML
 */
function createQueryXML()
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var row = new tagElement("row-params");
    
    var param = new tagElement("param");    
    param.setAttribute("name","neid");
    param.setAttribute("value",winurlobj["neid"]);
    row.appendChild(param);
    
    param = new tagElement("param");    
    param.setAttribute("name","labelindex");
    param.setAttribute("value","0");
    row.appendChild(param);
    
    bussiness.appendChild(row);
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

/*
 *         
 */
function handleBackQuery(doc)
{
	  st.clearTableData();
	
    data = EncapsulateData(doc); 
    if(data.getError().rowErrors[0])
    {   
        var size = data.getBErrLength();
        for(var i = 0;i < size;i++)
        {
            var tempObj = data.getError().rowErrors[i].errorObj;
            tempObj["operateObj"] = RESOURCE["queryLDPLabelPolicy"];
        }
    }   
    var errArr = [];
    errArr[0] = "operateObj";
    openErrPage("../../../../../page/", data.getError(), errArr);
    
    if (OPRSUCC == data.getSErrorCode() || PARTSUCC == data.getSErrorCode()) 
    {
		    for (var i = 0; i < data.getDataRowLength(); i++) 
        {
			      var row = data.rows[i];
			      row["peerip"].value = convertNumToIpaddr(row["peerip"].value);
        }
        st.clearTableData();
        createTableBody(st, window.tableconf[0], data, RESOURCE);
    }

    $("queryBtn").disabled = !btnRightArr.queryBtn.right;   
    $("createBtn").disabled = !btnRightArr.createBtn.right;
}

/*
 *     
 */
function deletePolicy()
{
    if (st.getSelectedRowCount() <= 0) 
    {
        alert(RESOURCE["noselect"]);
        return;
    }
    if (!confirm(RESOURCE["Delete_Hint"])) 
    {
        return;
    }
    
    var xml = createDeleteXML();
    if (null == xml)
    {
        return;
    }
    
    $("queryBtn").disabled = true;
    $("createBtn").disabled = true;
    $("deleteBtn").disabled = true;
    
    var urlreq ="../../../../../neExlorerServlet?sfid="+TECMDCODE_DELETE_LDP_LABELPOLICY+""+"&nmUser="+winurlobj["nmUser"];
    loadXMLdoc(urlreq, "POST",true,handleBackDelete,null,"inputdata="+xml);
}

/*
 *     XML
 */
function createDeleteXML()
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    
    for (var i = 0, len = st.getDataRowLength(); i < len; i++) 
    {
        if (!(st.getRowSelFlag(i))) 
        {
            continue;
        }
        
        var row = new tagElement("row-params");
        
        var param = new tagElement("param");
        param.setAttribute("name", "neid");
        param.setAttribute("value", winurlobj["neid"]);
        row.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "labelindex");
        param.setAttribute("value", st.getCellStoreValue(i, "labelindex", "labelindex"));
        row.appendChild(param);
        
        bussiness.appendChild(row);
    }
    
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

/*
 *         
 */
function handleBackDelete(doc)
{     
    $("queryBtn").disabled = !btnRightArr.queryBtn.right;
    $("createBtn").disabled = !btnRightArr.createBtn.right;
    
    var data = EncapsulateData(doc);
    if (data.getError().rowErrors[0]) 
    {
        var size = data.getBErrLength();
        for (var i = 0; i < size; i++) 
        {
            var tempObj = data.getError().rowErrors[i].errorObj;
            tempObj["operateObj"] = RESOURCE["deleteLDPLabelPolicy"];
        }
    }
    var errArr = [];
    errArr[0] = "operateObj";
    openErrPage("../../../../../page/", data.getError(), errArr);
    
    if (OPRSUCC == data.getError().getGlobleECode() || PARTSUCC == data.getError().getGlobleECode()) 
    {
        query();
    }
    else 
    {
        $("deleteBtn").disabled = !btnRightArr.deleteBtn.right;
    }
}

/*
 *     
 */
function create()
{
    xshowModalDialog("createlabelpolicy.html", RESOURCE["createLabelPolicy"], 530, 252, "../../../../../images/");
}

/*
 *     IP
 */
/*
function convertNumToIpaddr(num)
{
	var tempStr = parseInt("0x" + num.substring(0, 2)) + "." +
    parseInt("0x" + num.substring(2, 4)) + "." +
    parseInt("0x" + num.substring(4, 6)) + "." +
    parseInt("0x" + num.substring(6, 8));
	return tempStr;
}
*/

/*
 * IP    
 */
/*
function convertIpaddrToNum(ip)
{
	var str;
	var temp = ip.split(".");
	
	for (var i = 0, len = temp.length; i < len; i++)
    {
        str += tenToHex(temp[i]);
    }
	
	return str;
}
*/
