/*
 * Title:        iManager U2000 V1R2<br>
 * Description:  MPLS-LDP IP filtrate table JS<br>
 * Copyright:    Copyright (c) 2000-2009<br>
 * Company:      Huawei Tech. Co., Ltd<br>
 * @author       zhaoliang 69741
 * @version      1.0  Jun 10, 2009
 */

var winurlobj = getNeProperty(self);

var neID = winurlobj.neid;

var btnRightArr = new Object();

var OPRSUCC = 0;
var PARTSUCC = 1;

var st0;

var st1;

var iscreate = true;

var modifyID = 0;

var queryID = 0;

var selectedRows;

var isSendCommand = true;

/*
 * resize page
 */
window.onresize=function()
{
    st0.setBodyHeight(getComponetHeight($("tablecomponent"),170)+"px");
    st1.setBodyHeight(getComponetHeight($("iptable"),170)+"px");
}

/*
 * init page
 */
function initpage()
{
    document.body.oncontextmenu = returnFalse;
    st0 = new SortTable();
    st0.head.setAttribute("id", "htmlTable_SortTableHead_ldpipflt");
    st0.body.setAttribute("id", "htmlTable_SortTableBody_ldpipflt");
    st0.setImage("../../../../../images/");    
    createTableHead(st0, window.tableconf[0]);
    st0.setOnRowSelectHandler(rowSelectHandler); 
    st0.setBodyHeight(getComponetHeight($("tablecomponent"),170)+"px");    
    $("tablecomponent").oncontextmenu = popupMenuHandler;
    $("tablecomponent").appendChild(st0.getTable());
    
    st1 = new SortTable();
    st1.head.setAttribute("id", "htmlTable_SortTableHead_ldproutepolicy");
    st1.body.setAttribute("id", "htmlTable_SortTableBody_ldproutepolicy");
    st1.setImage("../../../../../images/");
    st1.isUsedForSelectList = true;
    createTableHead(st1, window.tableconf[1]);
    st1.setOnRowSelectHandler(iptableRowSelectHandler); 
    st1.setBodyHeight("200px");    
    $("iptable").oncontextmenu = popupMenuHandler;
    $("iptable").appendChild(st1.getTable());
    
    
    $("queryBtn").value=RESOURCE["querybutton"];
    $("createBtn").value = RESOURCE["newbutton"];
    $("deleteIDBtn").value = RESOURCE["deletebutton"];
    
    $("addIPBtn").value=RESOURCE["addIPBtn"];
    $("deleteIPBtn").value = RESOURCE["deletebutton"];
    
    btnRightArr.queryBtn = new BtnRightObj("queryBtn",TECMDCODE_QUERY_LDP_IPFLTLST);    
    btnRightArr.createBtn = new BtnRightObj("createBtn",TECMDCODE_CREATE_LDP_IPFLTLST);
    btnRightArr.deleteIDBtn = new BtnRightObj("deleteIDBtn",TECMDCODE_DELETE_LDP_IPFLTLST);
    
    btnRightArr.addIPBtn = new BtnRightObj("addIPBtn",TECMDCODE_ADD_LDP_IPFLTLSTMBR);
    btnRightArr.deleteIPBtn = new BtnRightObj("deleteIPBtn",TECMDCODE_DELETE_LDP_IPFLTLST);
    
    getRightInfo(winurlobj,btnRightArr);
    
    $("queryBtn").disabled = true;
    $("createBtn").disabled = true;
    $("deleteIDBtn").disabled = true;
    
    $("addIPBtn").disabled = true;
    $("deleteIPBtn").disabled = true;
    
    if(btnRightArr.queryBtn.right)
    {
        query();
    }   
}

function rowSelectHandler()
{
    selectedRows = st0.getSelectedRows();
    if (selectedRows.length <= 0)
    {
    	  $("addIPBtn").disabled = true;		
        $("deleteIDBtn").disabled = true;		
        st1.clearTableData();
        return;
    }

    $("deleteIDBtn").disabled = !btnRightArr.deleteIDBtn.right;

    queryID = st0.getCellStoreValue(selectedRows[0], "ipindexid", "ipindexid");
		
    queryIPFltMbr(queryID);
}

function iptableRowSelectHandler()
{
    if (st1.getSelectedRows().length <= 0)
    {
        $("deleteIPBtn").disabled = true;			
        return;
    }

    $("deleteIPBtn").disabled = !btnRightArr.deleteIPBtn.right;
}

/*
 *     
 */
function queryIPFltMbr(ipindexid)
{
	  $("addIPBtn").disabled = true;
	  $("deleteIPBtn").disabled = true;
	  
    var xmlstr = createQueryIPFltMbrXML(ipindexid);
    
    var urlreq ="../../../../../neExlorerServlet?sfid="+TECMDCODE_QUERY_LDP_IPFLTLST+""+"&nmUser="+winurlobj["nmUser"];        
    loadXMLdoc(urlreq, "POST",false,handleBackQueryIPFltMbr,null,"inputdata="+xmlstr);   
}

/*
 *     XML
 */
function createQueryIPFltMbrXML(ipindexid)
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var row = new tagElement("row-params");
    
    var param = new tagElement("param");    
    param.setAttribute("name","neid");
    param.setAttribute("value",winurlobj["neid"]);
    row.appendChild(param);
    
    param = new tagElement("param");    
    param.setAttribute("name","ipindexid");
    param.setAttribute("value",ipindexid);
    row.appendChild(param);
    
    bussiness.appendChild(row);
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

/*
 *         
 */
function handleBackQueryIPFltMbr(doc)
{
    st1.clearTableData();
    data = EncapsulateData(doc); 
    if(data.getError().rowErrors[0])
    {   
        var size = data.getBErrLength();
        for(var i = 0;i < size;i++)
        {
            var tempObj = data.getError().rowErrors[i].errorObj;
            tempObj["operateObj"] = RESOURCE["queryLDPIPfltMbr"];
        }
    }   
    var errArr = [];
    errArr[0] = "operateObj";
    
    if (OPRSUCC == data.getSErrorCode()) 
    {
    	  var ipnum = 0;
    	  if (data.getDataRowLength() > 0)
    	  {
    	      var row = data.rows[0];
    	      ipnum = row["ipnum"].value;
    	  }
    	  
        for (var i = 0; i < ipnum; i++) 
        {
            var row = data.rows[i];
            row["ipaddr"].value = convertNumToIpaddr(row["ipaddr"].value);
            row["netmask"].value = convertNumToIpaddr(row["netmask"].value);
        }
        st1.clearTableData();
        
        if (ipnum > 0)
        {
            createTableBody(st1, window.tableconf[1], data, RESOURCE);
        }  
    }
    
    $("addIPBtn").disabled = !btnRightArr.addIPBtn.right; 
}

/*
 *     
 */
function query()
{
    $("queryBtn").disabled = true;
    $("createBtn").disabled = true;
    $("deleteIDBtn").disabled = true;
    
    $("addIPBtn").disabled = true;
    $("deleteIPBtn").disabled = true;
  
    var xmlstr = createQueryXML(); 
    
    var urlreq ="../../../../../neExlorerServlet?sfid="+TECMDCODE_QUERY_LDP_IPFLTLST+""+"&nmUser="+winurlobj["nmUser"];        
    loadXMLdoc(urlreq, "POST",false,handleBackQuery,null,"inputdata="+xmlstr);   
}

/*
 *     XML
 */
function createQueryXML()
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var row = new tagElement("row-params");
    
    var param = new tagElement("param");    
    param.setAttribute("name","neid");
    param.setAttribute("value",winurlobj["neid"]);
    row.appendChild(param);
    
    param = new tagElement("param");    
    param.setAttribute("name","ipindexid");
    param.setAttribute("value",0);
    row.appendChild(param);
    
    bussiness.appendChild(row);
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

/*
 *         
 */
function handleBackQuery(doc)
{
    st0.clearTableData();
    data = EncapsulateData(doc); 
    if(data.getError().rowErrors[0])
    {   
        var size = data.getBErrLength();
        for(var i = 0;i < size;i++)
        {
            var tempObj = data.getError().rowErrors[i].errorObj;
            tempObj["operateObj"] = RESOURCE["queryLDPIPflt"];
        }
    }   
    var errArr = [];
    errArr[0] = "operateObj";
    openErrPage("../../../../../page/", data.getError(), errArr);
    
    if (OPRSUCC == data.getSErrorCode() || PARTSUCC == data.getSErrorCode()) 
    {
        st0.clearTableData();
        createTableBody(st0, window.tableconf[0], data, RESOURCE);
		
        if (st0.getDataRowLength() > 0)
        {
            st0.setRowSelect(0);
            selectedRows = st0.getSelectedRows();
            queryID = st0.getCellStoreValue(0,"ipindexid","ipindexid");
			
            queryIPFltMbr(queryID);
            
            $("deleteIDBtn").disabled = !btnRightArr.deleteIDBtn.right;
        }
        else
        {
            rowSelectHandler();
        }
    }

    $("queryBtn").disabled = !btnRightArr.queryBtn.right;   
    $("createBtn").disabled = !btnRightArr.createBtn.right; 
    
    $("addIPBtn").disabled = !btnRightArr.addIPBtn.right; 
}

/*
 *   ID  
 */
function deleteID()
{
    if (st0.getSelectedRowCount() <= 0) 
    {
        alert(RESOURCE["noselect"]);
        return;
    }
    if (!confirm(RESOURCE["Delete_Hint"])) 
    {
        return;
    }
    
    var xml = createDeleteXML();
    if (null == xml)
    {
        return;
    }
    
    $("queryBtn").disabled = true;
    $("createBtn").disabled = true;
    $("deleteIDBtn").disabled = true;
    
    $("addIPBtn").disabled = true;
    $("deleteIPBtn").disabled = true;
    
    var urlreq ="../../../../../neExlorerServlet?sfid="+TECMDCODE_DELETE_LDP_IPFLTLST+""+"&nmUser="+winurlobj["nmUser"];
    loadXMLdoc(urlreq, "POST",true,handleBackDelete,null,"inputdata="+xml);
}

/*
 *     XML
 */
function createDeleteXML()
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    
    for (var i = 0, len = st0.getDataRowLength(); i < len; i++) 
    {
        if (!(st0.getRowSelFlag(i))) 
        {
            continue;
        }
        
        var row = new tagElement("row-params");
        
        var param = new tagElement("param");
        param.setAttribute("name", "neid");
        param.setAttribute("value", winurlobj["neid"]);
        row.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "ipindexid");
        param.setAttribute("value", st0.getCellStoreValue(i,"ipindexid","ipindexid"));
        row.appendChild(param);
        
        bussiness.appendChild(row);
    }
    
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

/*
 *         
 */
function handleBackDelete(doc)
{
    $("queryBtn").disabled = !btnRightArr.queryBtn.right;
    $("createBtn").disabled = !btnRightArr.createBtn.right;
    
    $("addIPBtn").disabled = !btnRightArr.addIPBtn.right; 
    
    var data = EncapsulateData(doc);
    if (data.getError().rowErrors[0]) 
    {
        var size = data.getBErrLength();
        for (var i = 0; i < size; i++) 
        {
            var tempObj = data.getError().rowErrors[i].errorObj;
            tempObj["operateObj"] = RESOURCE["deleteLDPIPflt"] + "," +RESOURCE["ipindexid"] + ":" + tempObj["ipindexid"];
        }
    }
    var errArr = [];
    errArr[0] = "operateObj";
    openErrPage("../../../../../page/", data.getError(), errArr);
    
    if (OPRSUCC == data.getError().getGlobleECode() || PARTSUCC == data.getError().getGlobleECode()) 
    {
        query();
    }
    else 
    {
        $("deleteIDBtn").disabled = !btnRightArr.deleteIDBtn.right;
    }
}

/*
 *     
 */
function create()
{
    iscreate = true;
    xshowModalDialog("createipfltlst.html", RESOURCE["createipfltlst"], 600, 470, "../../../../../images/");
}

/*
 *     
 */
function addIP()
{
    iscreate = true;
    xshowModalDialog("addipaddr.html", RESOURCE["addIPAddr"], 450, 160, "../../../../../images/");
}

/*
 *   ID  
 */
function deleteIP()
{
    if (st1.getSelectedRowCount() <= 0) 
    {
        alert(RESOURCE["noselect"]);
        return;
    }
    if (!confirm(RESOURCE["Delete_Hint"])) 
    {
        return;
    }
    
    var xml = createDeleteIPXML();
    if (null == xml)
    {
        return;
    }
    
    $("queryBtn").disabled = true;
    $("createBtn").disabled = true;
    $("deleteIDBtn").disabled = true;
    
    $("addIPBtn").disabled = true;
    $("deleteIPBtn").disabled = true;
    
    var urlreq ="../../../../../neExlorerServlet?sfid="+TECMDCODE_DELETE_LDP_IPFLTLSTMBR+""+"&nmUser="+winurlobj["nmUser"];
    loadXMLdoc(urlreq, "POST",true,handleBackDeleteIP,null,"inputdata="+xml);
}

/*
 *     XML
 */
function createDeleteIPXML()
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    
    for (var i = 0, len = st1.getDataRowLength(); i < len; i++) 
    {
        if (!(st1.getRowSelFlag(i))) 
        {
            continue;
        }
        
        var row = new tagElement("row-params");
        
        var param = new tagElement("param");
        param.setAttribute("name", "neid");
        param.setAttribute("value", winurlobj["neid"]);
        row.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "ipindexid");
        param.setAttribute("value", queryID);
        row.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "ipaddr");
        param.setAttribute("value", hexToTen(convertIpaddrToHexcode(st1.getCellStoreValue(i,"ipaddr","ipaddr"))));
        row.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "netmask");
        param.setAttribute("value", hexToTen(convertIpaddrToHexcode(st1.getCellStoreValue(i,"netmask","netmask"))));
        row.appendChild(param);
        
        bussiness.appendChild(row);
    }
    
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

/*
 *         
 */
function handleBackDeleteIP(doc)
{
    $("queryBtn").disabled = !btnRightArr.queryBtn.right;
    $("createBtn").disabled = !btnRightArr.createBtn.right;
    $("deleteIDBtn").disabled = !btnRightArr.deleteIDBtn.right;
    
    $("addIPBtn").disabled = !btnRightArr.addIPBtn.right; 
    
    var data = EncapsulateData(doc);
    if (data.getError().rowErrors[0]) 
    {
        var size = data.getBErrLength();
        for (var i = 0; i < size; i++) 
        {
            var tempObj = data.getError().rowErrors[i].errorObj;
            tempObj["operateObj"] = RESOURCE["deleteLDPIPfltlstMbr"] + "," + RESOURCE["ipindexid"] + ":" + tempObj["ipindexid"] + "," 
                                  + RESOURCE["ipaddr"] + ":" + convertNumToIpaddr(tempObj["ipaddr"]);
        }
    }
    var errArr = [];
    errArr[0] = "operateObj";
    openErrPage("../../../../../page/", data.getError(), errArr);
    
    if (OPRSUCC == data.getError().getGlobleECode() || PARTSUCC == data.getError().getGlobleECode()) 
    {
        queryIPFltMbr(queryID);
    }
    else 
    {
        $("deleteIPBtn").disabled = !btnRightArr.deleteIPBtn.right;
    }
}

/*
 *     
 */
 /*
function modify()
{
    iscreate = false;
    
    for (var i = 0, len = st0.getDataRowLength(); i < len; i++) 
    {
        if (!(st0.getRowSelFlag(i))) 
        {
            continue;
        }
        
        modifyID = convertIpaddrToHexcode(st0.getCellStoreValue(i,"ipindexid","ipindexid"));
        break;
    }
    
    xshowModalDialog("createipfltlst.html", RESOURCE["createipflt"], 450, 160, "../../../../../images/");
}
*/

/*
 *     IP
 */
/*
function convertNumToIpaddr(num)
{
    var tempstr = parseInt("0x" + num.substring(0, 2)) + "." +
    parseInt("0x" + num.substring(2, 4)) + "." +
    parseInt("0x" + num.substring(4, 6)) + "." +
    parseInt("0x" + num.substring(6, 8));
    return tempstr;
}
*/

/*
 * IP    
 */
/*
function convertIpaddrToNum(ip)
{
    var str;
    var temp = ip.split(".");
	
    for (var i = 0, len = temp.length; i < len; i++)
    {
    	  if (0 == i)
    	  {
    	      str = tenToHex(temp[i]);
    	  }
    	  else
    	  {
    	      str += tenToHex(temp[i]);
    	  }
    }
	
    return str;
}
*/
