/*
 * Title:        iManager U2000 V1R2<br>
 * Description:  MPLS-LDP         JS<br>
 * Copyright:    Copyright (c) 2000-2009<br>
 * Company:      Huawei Tech. Co., Ltd<br>
 * @author       zhaoliang 69741
 * @version      1.0  Jun 9, 2009
 */

document.title = RESOURCE["createRoutePolicy"];
var winurlobj = getParentWindow();
var neid = winurlobj.neID;

var OPRSUCC = 0;

var okFlag = false;

var ct;

var policymode = new Array();
policymode["1"] = "Deny";
policymode["2"] = "Permit";

var MIN_ID = "1";
var MAX_ID = "4294967295";

var ipFilterList = new Array();//IP      

/*
 * window onload handler
 */
function initpage()
{
    initTable();

    initButtonText();
}

/*
 *      
 */
function initTable()
{
    ct = new CTable();
    ct.addHead(RESOURCE["attribute"], RESOURCE["value"]);
    queryFilterListID();
    var atom = new Atom("select");
    atom.element.setAttribute("id", "htmlText_routeIPFltID");
    
    if(ipFilterList[0])
    {
	   atom.setValue(ipFilterList[0]);
    }
    
    for(var i=0;i<ipFilterList.length;i++)
    {
	atom.element.options.add(new Option(ipFilterList[i], ipFilterList[i]));
    }
    
    atom.element["onchange"] = function()
    {
        changeVale(this);
    }
    
    ct.addAttrRow("ipindex", RESOURCE["ipindex"], atom);
    
    var atom = new Atom("select");
    atom.element.setAttribute("id", "htmlSelect_routePolicyMode");
    atom.addOption(RESOURCE["policymode_1"], 1);
    atom.addOption(RESOURCE["policymode_2"], 2);
    atom.element["onchange"] = function()
    {
        changeVale(this);
    }
    ct.addAttrRow("policymode", RESOURCE["policymode"], atom);

    $("tablecomponent").appendChild(ct.getTable());
}

/*
 *   
 */
function changeVale(atom)
{
    if ($("applybtn").disabled)
    {
        $("applybtn").disabled = false;
    }
}

/*
 *      
 */
function initButtonText()
{
    $("okbtn").value = RESOURCE["okbtn"];
    $("cancelbtn").value = RESOURCE["cancelbtn"];
    $("applybtn").value = RESOURCE["applybtn"];
    $("applybtn").disabled = false;
}

/*
 *     
 */
function doCreate(buttonFlag)
{
    okFlag = buttonFlag;
    if ($("applybtn").disabled && okFlag)
    {
        xcloseDialog();
        return;
    }
    
    if (!checkDataValid())
    {
        return;
    }

    $("okbtn").disabled = true;
    $("applybtn").disabled = true;
    $("cancelbtn").disabled = true;

    var xmlstr = createXML();
    
    urlreq ="../../../../../neExlorerServlet?sfid="+TECMDCODE_CREATE_LDP_ROUTEPOLICY+""+"&nmUser="+winurlobj.winurlobj["nmUser"];
    loadXMLdoc(urlreq, "POST",true,handleBackCreate,null,"inputdata="+xmlstr);
}

function checkDataValid()
{
    var fecip = ct.getAttrValue("ipindex");
    if(!fecip)
    {
    	alert(RESOURCE["checkipindexname"]);
    	return false;
    }
    
    
    return true;
}

/*
 *     XML
 */
function createXML()
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var row = new tagElement("row-params");

    var param = new tagElement("param");
    param.setAttribute("name", "neid");
    param.setAttribute("value", neid);
    row.appendChild(param);

    param = new tagElement("param");
    param.setAttribute("name", "ipindex");
    param.setAttribute("value", ct.getAttrValue("ipindex"));
    row.appendChild(param);

    param = new tagElement("param");
    param.setAttribute("name", "policymode");
    var atom = ct.getAtom("policymode");
    param.setAttribute("value", atom.getValue());
    row.appendChild(param);

    bussiness.appendChild(row);

    di.getRoot().appendChild(bussiness);
    return di.toString();
}

/*
 *         
 */
function handleBackCreate(doc)
{
    $("okbtn").disabled = false;
    $("cancelbtn").disabled = false;

    var data = EncapsulateData(doc);
    if (OPRSUCC == data.getSErrorCode())
    {
        winurlobj.query();

        if (okFlag)
        {
            xcloseDialog();
        }
    }
    else
    {
        $("applybtn").disabled = false;
        if (data.getError().rowErrors[0])
        {
            var size = data.getBErrLength();
            for ( var i = 0; i < size; i++)
            {
                var tempObj = data.getError().rowErrors[i].errorObj;
                tempObj["operateObj"] = RESOURCE["addLDPRoutePolicy"];
            }
        }
        var errArr = [];
        errArr[0] = "operateObj";
        openErrPage("../../../../../page/", data.getError(), errArr);
    }
}

/**
 *  IP      ID
*/
function queryFilterListID()
{
	var xmlstr = createQueryFilterListIDXml();
        var urlreq ="../../../../../neExlorerServlet?sfid="+TECMDCODE_QUERY_LDP_IPFLTLST+""+"&nmUser="+winurlobj.winurlobj["nmUser"];        
        loadXMLdoc(urlreq, "POST",false,handleBackQuery,null,"inputdata="+xmlstr); 
}

function createQueryFilterListIDXml()
{
     var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var row = new tagElement("row-params");
    
    var param = new tagElement("param");    
    param.setAttribute("name","neid");
    param.setAttribute("value",neid);
    row.appendChild(param);
    
    param = new tagElement("param");    
    param.setAttribute("name","ipindexid");
    param.setAttribute("value",0);
    row.appendChild(param);
    
    bussiness.appendChild(row);
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

function handleBackQuery(doc)
{
    data = EncapsulateData(doc); 
    
    if (data.getSErrorCode() == 0)
    {
		for(var i=0;i<data.getDataRowLength();i++)
		{
		      var queryID =  data.rows[i].ipindexid.value;
		      ipFilterList.push(queryID);
		}
    }
}
