/*
 * Title:        iManager U2000 V1R2<br>
 * Description:  MPLS-LDP         JS<br>
 * Copyright:    Copyright (c) 2000-2009<br>
 * Company:      Huawei Tech. Co., Ltd<br>
 * @author       zhaoliang 69741
 * @version      1.0  Jun 9, 2009
 */

document.title = RESOURCE["createLabelPolicy"];

var winurlobj = getParentWindow();
var parentObject = winurlobj.winurlobj;
var neid = winurlobj.neID;

var OPRSUCC = 0;

var okFlag = false;

var ct;

var MIN_ID = "1";
var MAX_ID = "4294967295";

var policydirection = new Array();
policydirection["1"] = "Import";
policydirection["2"] = "Export";

var policymode = new Array();
policymode["1"] = "Deny";
policymode["2"] = "Permit";

var policy_name_max_len = 64;

var ipFilterList = new Array();//IP      

/*
 * window onload handler
 */
function initpage()
{   
    initTable();   
    	
    initButtonText();
}


function initTable()
{
    var atom;
    ct = new CTable();
    queryFilterListID();
    ct.addHead(RESOURCE["attribute"], RESOURCE["value"]);
    
    atom = new Atom("text");
    atom.element.setAttribute("id", "htmlText_labelPolicyId");
    ct.addAttrRow("policyId", RESOURCE["policyId"], atom);
    checkText(ct.getAtom("policyId").element, MIN_ID, MAX_ID);     
    ct.setAttrValue("policyId", "1");   
    atom.element["onkeydown"] = function()
    {
	      changeVale(this);
    }
    
    checkboxElem = document.createElement("input");
    checkboxElem.setAttribute("type",	"checkbox");
    checkboxElem.className = "checkboxInput";
    checkboxElem.onclick = handleCheckbox;
    ct.getAtom("policyId").element.style.width = "32%";
    ct.getAtom("policyId").element.parentNode.appendChild(checkboxElem);
	        	
    var span = document.createElement("span");
    span.innerText=RESOURCE["auto"];
    ct.getAtom("policyId").element.parentNode.appendChild(span);
		    	        	
    atom = new Atom("text");
    atom.element.setAttribute("id", "htmlText_labelPolicyName");
    atom.element.maxLength = policy_name_max_len;
    checkInputData(atom.element, policy_name_max_len);
    ct.addAttrRow("policyName", RESOURCE["policyName"], atom);  
    atom.element["onkeypress"] = function()
    {	     
        changeVale(this);
    }	
	    	        	
    var atom = new Atom("select");
    atom.element.setAttribute("id", "htmlSelect_labelPolicyDirection");
    atom.addOption(RESOURCE["policydirection_1"],1);
    atom.addOption(RESOURCE["policydirection_2"],2);
    atom.element["onchange"] = function()
    {
        changeVale(this);
    }
    ct.addAttrRow("policydirection",RESOURCE["policydirection"],atom); 

    var atom = new Atom("text");   
    atom.element.setAttribute("id", "htmlText_labelPeerIP"); 
    atom.element["onfocus"] = function()
    {
	     changeVale(this);
    }
    atom.setValue("0.0.0.0");
    validateIp(atom.element);
    ct.addAttrRow("peerip", RESOURCE["peerip"], atom);
    
    var atom = new Atom("select");
    atom.element.setAttribute("id", "htmlSelect_routePolicyMode");
    atom.addOption(RESOURCE["policymode_1"], 1);
    atom.addOption(RESOURCE["policymode_2"], 2);
    atom.element["onchange"] = function()
    {
        changeVale(this);
    }
    ct.addAttrRow("policymode", RESOURCE["policymode"], atom);
    
    var atom = new Atom("select");   
    atom.element.setAttribute("id", "htmlText_labelFECIP");
    if(ipFilterList[0])
    {
	   atom.setValue(ipFilterList[0]);
    }
    
    for(var i=0;i<ipFilterList.length;i++)
    {
	      atom.element.options.add(new Option(ipFilterList[i], ipFilterList[i]));
    }
    atom.element["onchange"] = function()
    {
        changeVale(this);
    }
    
    ct.addAttrRow("fecip", RESOURCE["fecip"], atom);
  
    $("tablecomponent").appendChild(ct.getTable());
}

/*
 *   
 */
function changeVale(atom)
{
    if ($("applybtn").disabled)
    {
        $("applybtn").disabled=false;
    }
}

/*
 * Checkbox  
 */
function handleCheckbox()
{
    var atomPolicyId  = ct.getAtom("policyId").element;
    if (checkboxElem.checked)
    {       
  	    atomPolicyId.disabled = true;
        atomPolicyId.value = "";
    }
    else
    {
        atomPolicyId.disabled = false;
        atomPolicyId.value = "1";
    }
    $("applybtn").disabled = false;
    flag = false;
}

function initButtonText()
{     
    $("okbtn").value = RESOURCE["okbtn"];
    $("cancelbtn").value = RESOURCE["cancelbtn"]; 
    $("applybtn").value = RESOURCE["applybtn"]; 
    $("applybtn").disabled = true;
}

function doCreate(buttonFlag)
{
    okFlag = buttonFlag;
    if ($("applybtn").disabled && okFlag)
    {
        xcloseDialog();
        return;
    }
    
    if (!checkDataValid())
    {
        return;
    }
    
    $("okbtn").disabled = true;
    $("applybtn").disabled = true;
    $("cancelbtn").disabled = true;
  
    var xmlstr = createXML();
    
    var urlreq ="../../../../../neExlorerServlet?sfid="+TECMDCODE_CREATE_LDP_LABELPOLICY+""+"&nmUser="+parentObject["nmUser"];
    loadXMLdoc(urlreq, "POST",true,handleBackCreate,null,"inputdata="+xmlstr);
}

function checkDataValid()
{
		var policyName = ct.getAttrValue("policyName");
		if (policyName == null || policyName == "")
		{
				alert(RESOURCE["checkname"]);
				return false;
		}
		
    if (!check_IPaddr(ct.getAttrValue("peerip")))
    {
        return false;
    }
    
    var fecip = ct.getAttrValue("fecip");
    if(!fecip)
    {
    	alert(RESOURCE["checkipindexname"]);
    	return false;
    }
    
    
    return true;
}

function createXML()
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var row = new tagElement("row-params");
    
    var param = new tagElement("param");    
    param.setAttribute("name","neid");
    param.setAttribute("value",neid);
    row.appendChild(param);

    var policyId = ct.getAttrValue("policyId");
    if (checkboxElem.checked)
    {
        policyId = "0";
    }
    param = new tagElement("param");    
    param.setAttribute("name","autoCreate");
    param.setAttribute("value",policyId == 0 ? 1 : 0);
    row.appendChild(param);
    
    param = new tagElement("param");    
    param.setAttribute("name","labelindex");
    param.setAttribute("value",policyId);
    row.appendChild(param);
    
    param = new tagElement("param");    
    param.setAttribute("name","labelname");
    param.setAttribute("value",ct.getAttrValue("policyName"));
    row.appendChild(param);
    
    param = new tagElement("param");    
    param.setAttribute("name","policydirection");
    param.setAttribute("value",ct.getAttrValue("policydirection"));
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "policymode");
    var atom = ct.getAtom("policymode");
    param.setAttribute("value", atom.getValue());
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "peerip");
    param.setAttribute("value", hexToTen(convertIpaddrToHexcode(ct.getAttrValue("peerip"))));
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "policymode");
    var atom = ct.getAtom("policymode");
    param.setAttribute("value", atom.getValue());
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "fecip");
    param.setAttribute("value", ct.getAttrValue("fecip"));
    row.appendChild(param);                                         
    bussiness.appendChild(row);
    
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

function handleBackCreate(doc)
{
    $("okbtn").disabled=false;
    $("cancelbtn").disabled=false;
    
    var data = EncapsulateData(doc);    
    if(OPRSUCC == data.getSErrorCode()) 
    {       
        winurlobj.query();
        
        if (okFlag)
        {
            xcloseDialog();
        }
    } 
    else
    {   
        $("applybtn").disabled=false;
        if(data.getError().rowErrors[0])
        {   
            var size = data.getBErrLength();
            for(var i = 0;i < size;i++)
            {
                var tempObj = data.getError().rowErrors[i].errorObj;
                tempObj["operateObj"] = RESOURCE["addLDPLabelPolicy"];
            }
        }   
        var errArr = [];
        errArr[0] = "operateObj";
        openErrPage("../../../../../page/", data.getError(), errArr);
    }   
}


/**
 *  IP      ID
*/
function queryFilterListID()
{
	var xmlstr = createQueryFilterListIDXml();
        var urlreq ="../../../../../neExlorerServlet?sfid="+TECMDCODE_QUERY_LDP_IPFLTLST+""+"&nmUser="+parentObject["nmUser"];        
        loadXMLdoc(urlreq, "POST",false,handleBackQuery,null,"inputdata="+xmlstr); 
}

function createQueryFilterListIDXml()
{
     var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var row = new tagElement("row-params");
    
    var param = new tagElement("param");    
    param.setAttribute("name","neid");
    param.setAttribute("value",neid);
    row.appendChild(param);
    
    param = new tagElement("param");    
    param.setAttribute("name","ipindexid");
    param.setAttribute("value",0);
    row.appendChild(param);
    
    bussiness.appendChild(row);
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

function handleBackQuery(doc)
{
    data = EncapsulateData(doc); 
    
    if (data.getSErrorCode() == 0)
    {
		for(var i=0;i<data.getDataRowLength();i++)
		{
		      var queryID =  data.rows[i].ipindexid.value;
		      ipFilterList.push(queryID);
		}
    }
}

function checkInputData(obj, maxlen)
{
    obj.onkeyup = function()
    {
        return calStrSinoLen(this, maxlen);
    }
}
