/*
 * Title:        iManager U2000 V1R2<br>
 * Description:  MPLS-LDP     IP      JS<br>
 * Copyright:    Copyright (c) 2000-2009<br>
 * Company:      Huawei Tech. Co., Ltd<br>
 * @author       zhaoliang 69741
 * @version      1.0  Jun 20, 2009
 */

document.title = RESOURCE["createipfltlst"];
var winurlobj = getParentWindow();

var neid = winurlobj.neID;

var OPRSUCC = 0;
var OPR_PART_SUCC = 1;
var OPR_FAILED = 2;
var okFlag = false;

var ct;

var st;

var tc;

var policy_name_max_len = 64;

var isSendCommand = false;

var MIN_ID = "1";
var MAX_ID = "4294967295";

/**
 * sort table's row color
 */
var color_select = "#6f99a5";  //dark green
var color_desel = "#ffffff";   //white
var color_nonedit = "#E8E8E8"; //grey
var color_edited = "#d0f946";  //green

/*
 * window onload handler
 */
function initpage()
{       
    initTable();
    
    initButtonText();
}


function initTable()
{
    var atom;
    ct = new CTable();
    ct.addHead(RESOURCE["attribute"], RESOURCE["value"]);
    
    var atom = new Atom("text");
    atom.element.setAttribute("id", "htmlText_IPFltID");
    atom.element["onkeydown"] = function()
    {	     
        changeVale(this);
    }
    atom.setValue("1");
    checkText(atom.element, MIN_ID, MAX_ID);     
    ct.addAttrRow("ipindexid", RESOURCE["ipindexid"], atom);    
    
    checkboxElem = document.createElement("input");
    checkboxElem.setAttribute("type",	"checkbox");
    checkboxElem.className = "checkboxInput";
    checkboxElem.onclick = handleCheckbox;
    ct.getAtom("ipindexid").element.style.width = "32%";
    ct.getAtom("ipindexid").element.parentNode.appendChild(checkboxElem);
	
    var span = document.createElement("span");
    span.innerText=RESOURCE["auto"];
    ct.getAtom("ipindexid").element.parentNode.appendChild(span);
	
    atom = new Atom("text");
    atom.element.setAttribute("id", "htmlText_IPFltName");
    atom.element.maxLength = policy_name_max_len;
    checkInputData(atom.element, policy_name_max_len);
    ct.addAttrRow("ipindexname", RESOURCE["ipindexname"], atom);  
    atom.element["onkeypress"] = function()
    {
        changeVale(this);
    }	

    st = new SortTable();
    st.head.setAttribute("id", "htmlTable_SortTableHead_ldpiptable");
    st.body.setAttribute("id", "htmlTable_SortTableBody_ldpiptable");
    st.setImage("../../../../../images/");    
    tc = window.tableconf[0];
    createTableHead(st, tc);
    st.setOnRowSelectHandler(rowSelected); 
    st.setBodyHeight("200px");
    $("iptable").appendChild(st.getTable());
    
  
    $("tablecomponent").appendChild(ct.getTable());
}

function rowSelected()
{
	  if (0 < st.getSelectedRowCount())
	  {
        $("deletebtn").disabled = false;	  	
	  }
	  else
	  {
	  	  $("deletebtn").disabled = true;
	  }
	  
		var len = st.getDataRowLength();
		for (var i=0; i<len; i++)
		{
				setCellColor(st, i, "ipaddr");
				setCellColor(st, i, "netmask");
		}
}

/*
 *   
 */
function changeVale(atom)
{
    if ($("applybtn").disabled)
    {
        $("applybtn").disabled=false;
    }
}

/*
 * Checkbox  
 */
function handleCheckbox()
{
    var atomPolicyId  = ct.getAtom("ipindexid").element;
    if (checkboxElem.checked)
    {       
  	    atomPolicyId.disabled = true;
        atomPolicyId.value = "";
    }
    else
    {
        atomPolicyId.disabled = false;
        atomPolicyId.value = "1";
    }
    $("applybtn").disabled = false;
    flag = false;
}

function initButtonText()
{     
    $("okbtn").value = RESOURCE["okbtn"];
    $("cancelbtn").value = RESOURCE["cancelbtn"]; 
    $("applybtn").value = RESOURCE["applybtn"]; 
    $("applybtn").disabled = false;
    
    $("addbtn").value = RESOURCE["addIPBtn"];
    $("deletebtn").value = RESOURCE["deletebutton"]; 
    $("deletebtn").disabled = true;
}

function doCreate(buttonFlag)
{
    okFlag = buttonFlag;
    if ($("applybtn").disabled && okFlag)
    {
        xcloseDialog();
        return;
    }
    
    $("addbtn").disabled = true;
    $("deletebtn").disabled = true;
    
    $("okbtn").disabled = true;
    $("applybtn").disabled = true;
    $("cancelbtn").disabled = true;
  
    var xmlstr = createXML();
    
    var urlreq ="../../../../../neExlorerServlet?sfid="+TECMDCODE_CREATE_LDP_IPFLTLST+""+"&nmUser="+winurlobj.winurlobj["nmUser"];
    loadXMLdoc(urlreq, "POST",true,handleBackCreate,null,"inputdata="+xmlstr);
}

function checkDataValid()
{
    var policyName = ct.getAttrValue("ipindexname");
		if (policyName == null || policyName == "")
		{
				alert(RESOURCE["checkipindexname"]);
				return;
		}

    return true;
}

function createXML()
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var row = new tagElement("row-params");
    
    var param = new tagElement("param");    
    param.setAttribute("name","neid");
    param.setAttribute("value",neid);
    row.appendChild(param);

    var ipindexid = ct.getAttrValue("ipindexid");
    if (checkboxElem.checked)
    {
        ipindexid = "0";
    }
    param = new tagElement("param");    
    param.setAttribute("name","autoCreate");
    param.setAttribute("value",ipindexid == 0 ? 1 : 0);
    row.appendChild(param);
    
    param = new tagElement("param");    
    param.setAttribute("name","ipindexid");
    param.setAttribute("value",ipindexid);
    row.appendChild(param);
    
    param = new tagElement("param");    
    param.setAttribute("name","ipindexname");
    param.setAttribute("value",ct.getAttrValue("ipindexname"));
    row.appendChild(param);
    
    param = new tagElement("param");    
    param.setAttribute("name","ipnum");
    param.setAttribute("value",st.getDataRowLength());
    row.appendChild(param);
    
    bussiness.appendChild(row);
    
    for (var i = 0, len = st.getDataRowLength(); i < len; i++) 
    {
        var row = new tagElement("row-params");
        
        var param = new tagElement("param");
        param.setAttribute("name", "ipaddr");
        param.setAttribute("value", hexToTen(convertIpaddrToHexcode(st.getCellStoreValue(i,"ipaddr","ipaddr"))));
        row.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "netmask");
        param.setAttribute("value", hexToTen(convertIpaddrToHexcode(st.getCellStoreValue(i,"netmask","netmask"))));
        row.appendChild(param);
        
        param = new tagElement("param");    
	    param.setAttribute("name","isNoLog");
	    param.setAttribute("value","1");
	    row.appendChild(param);
	    
        bussiness.appendChild(row);
    }
    
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

function handleBackCreate(doc)
{
    $("okbtn").disabled=false;
    $("cancelbtn").disabled=false;
    $("applybtn").disabled=false;
    
    $("addbtn").disabled = false;
   
    var data = EncapsulateData(doc);    
    if(data.getSErrorCode() > OPRSUCC)
    {   
        $("applybtn").disabled=false;
        if(data.getError().rowErrors[0])
        {   
            var size = data.getBErrLength();
            for(var i = 0;i < size;i++)
            {
                var tempObj = data.getError().rowErrors[i].errorObj;
                tempObj["operateObj"] = RESOURCE["addLDPIPFltlst"];
            }
        }   
        var errArr = [];
        errArr[0] = "operateObj";
        openErrPage("../../../../../page/", data.getError(), errArr);
    } 
    
    if(OPRSUCC == data.getSErrorCode() || OPR_PART_SUCC == data.getSErrorCode()) 
    {       
        winurlobj.query();
        
        if (okFlag && OPRSUCC == data.getSErrorCode() )
        {
            xcloseDialog();
        }
        
        $("applybtn").disabled=true;
    } 
}

/*
 *     
 */
function addIP()
{
    $("addbtn").disabled = true;
    $("applybtn").disabled = false;
    
    var dinterface = new DataInterface();
    var ptag, obj;
	
		obj = new Object();
    ptag = new ParamTag();
    ptag.value = "0.0.0.0";
    obj["ipaddr"] = ptag;
            
    ptag = new ParamTag();
    ptag.value = "255.255.255.255";
    obj["netmask"] = ptag;
          
    dinterface.rows.append(obj);  

    createTableBody(st, tc, dinterface, RESOURCE);
    st.adjustDataRows();
    
    addCellEvent();
    $("addbtn").disabled = false;
}

/*
 *          
 */
function addCellEvent()
{
    var cell = null;
    for(var i = 0,len = st.getDataRowLength();i<len;i++)
    {            
        cell = st.getCellElement(i,"ipaddr");
        validateIp(cell.editElement.element, true);
        
        cell = st.getCellElement(i,"netmask");
        validateIp(cell.editElement.element, true);
    }
}

/*
 *   ID  
 */
function delIP()
{
    if (st.getSelectedRowCount() <= 0) 
    {
        alert(RESOURCE["noselect"]);
        return;
    }
    
    for (var i = st.getDataRowLength() - 1 ; i >= 0; i--) 
    {
        if (!(st.getRowSelFlag(i))) 
        {
            continue;
        }
        st.deleteRow(i);
    }
    
    st.adjustDataRows();
    
    $("deletebtn").disabled = true;
}

function checkInputData(obj, maxlen)
{
    obj.onkeyup = function()
    {
        return calStrSinoLen(this, maxlen);
    }
}

function setCellColor(st, row, colid)
{
		var cell = st.getCellElement(row, colid);
		var color = color_desel;
		
		if (st.getRowSelFlag(row))
		{
				color = color_select;
		}
		else if (cell.isEdit == 0)
		{
				color = color_nonedit;
		}
		else if (cell.modify)
		{
				color = color_edited;
		}
		
		cell.style.backgroundColor = color;
}
