/*
 * Title:        iManager U2000 V1R2<br>
 * Description:  MPLS-LDP         JS<br>
 * Copyright:    Copyright (c) 2000-2009<br>
 * Company:      Huawei Tech. Co., Ltd<br>
 * @author       zhaoliang 69741
 * @version      1.0  Jun 9, 2009
 */

document.title = RESOURCE["addIPAddr"];

var winurlobj = getParentWindow();
var parentObject = getParentWindow().winurlobj;
var neid = winurlobj.neID;

var OPRSUCC = 0;

var okFlag = false;

var ct;

var isSendCommand = winurlobj.isSendCommand;

/*
 * window onload handler
 */
function initpage()
{       
    initTable();
    
    initButtonText();
}


function initTable()
{
    var atom;
    ct = new CTable();
    ct.addHead(RESOURCE["attribute"], RESOURCE["value"]);
    
    var atom = new Atom("text");   
    atom.element.setAttribute("id", "htmlText_ipaddr"); 
    atom.element["onfocus"] = function()
    {
	     changeVale(this);
    }
    atom.setValue("0.0.0.0");
    validateIp(atom.element);
    ct.addAttrRow("ipaddr", RESOURCE["ipaddr"], atom);
    
    var atom = new Atom("text");   
    atom.element.setAttribute("id", "htmlText_netmask"); 
    atom.element["onfocus"] = function()
    {
	     changeVale(this);
    }
    atom.setValue("255.255.255.255");
    validateIp(atom.element);
    ct.addAttrRow("netmask", RESOURCE["netmask"], atom);
  
    $("tablecomponent").appendChild(ct.getTable());
}

/*
 *   
 */
function changeVale(atom)
{
    if ($("applybtn").disabled)
    {
        $("applybtn").disabled = false;
    }
}

function initButtonText()
{     
    $("okbtn").value = RESOURCE["okbtn"];
    $("cancelbtn").value = RESOURCE["cancelbtn"]; 
    $("applybtn").value = RESOURCE["applybtn"];
    $("applybtn").disabled = true;
}

function doCreate(buttonFlag)
{
    okFlag = buttonFlag;
    if ($("applybtn").disabled && okFlag)
    {
        xcloseDialog();
        return;
    }
    
    if (!checkDataValid())
    {
        return;
    }
    
    $("okbtn").disabled = true;
    $("cancelbtn").disabled = true;
    $("applybtn").disabled = true;
    
    if (isSendCommand)
    {
        var xmlstr = createXML();
    
        var urlreq ="../../../../../neExlorerServlet?sfid="+TECMDCODE_ADD_LDP_IPFLTLSTMBR+""+"&nmUser="+parentObject["nmUser"];
        loadXMLdoc(urlreq, "POST",true,handleBackCreate,null,"inputdata="+xmlstr);
    }
    else
    {
        addRowData();
    }
}

function addRowData()
{
    var dinterface = new DataInterface();
    var ptag, obj;
	
		obj = new Object();
    ptag = new ParamTag();
    ptag.value = ct.getAttrValue("ipaddr");
    obj["ipaddr"] = ptag;
            
    ptag = new ParamTag();
    ptag.value = ct.getAttrValue("netmask");
    obj["netmask"] = ptag;
          
    dinterface.rows.append(obj);  

    createTableBody(winurlobj.st, winurlobj.tc, dinterface, RESOURCE);
    winurlobj.st.adjustDataRows();
	
	
    xcloseDialog();
}

function checkDataValid()
{
    if (!check_IPaddr(ct.getAttrValue("ipaddr")))
    {
        return false;
    }
	
    if (!check_IPaddr(ct.getAttrValue("netmask")))
    {
        return false;
    }
    return true;
}

function createXML()
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var row = new tagElement("row-params");
    
    var param = new tagElement("param");    
    param.setAttribute("name","neid");
    param.setAttribute("value",neid);
    row.appendChild(param);

    var ipindexid = winurlobj.queryID;
    param = new tagElement("param");    
    param.setAttribute("name","autoCreate");
    param.setAttribute("value","0");
    row.appendChild(param);
    
    param = new tagElement("param");    
    param.setAttribute("name","ipindexid");
    param.setAttribute("value",ipindexid);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "ipaddr");
    param.setAttribute("value", hexToTen(convertIpaddrToHexcode(ct.getAttrValue("ipaddr"))));
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "netmask");
    param.setAttribute("value", hexToTen(convertIpaddrToHexcode(ct.getAttrValue("netmask"))));
    row.appendChild(param);                                         
    bussiness.appendChild(row);
    
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

function handleBackCreate(doc)
{
    $("okbtn").disabled=false;
    $("cancelbtn").disabled=false;
    $("applybtn").disabled=false;
    
    var data = EncapsulateData(doc);    
    if(OPRSUCC == data.getSErrorCode()) 
    {       
        winurlobj.queryIPFltMbr(winurlobj.queryID);
        
        if (okFlag)
        {
            xcloseDialog();
        }
        
        $("applybtn").disabled=true;
    } 
    else
    {   
        $("applybtn").disabled=false;
        if(data.getError().rowErrors[0])
        {   
            var size = data.getBErrLength();
            for(var i = 0;i < size;i++)
            {
                var tempObj = data.getError().rowErrors[i].errorObj;
                tempObj["operateObj"] = RESOURCE["addLDPIPFltlstMbr"];
            }
        }   
        var errArr = [];
        errArr[0] = "operateObj";
        openErrPage("../../../../../page/", data.getError(), errArr);
    }   
}
