/*
 * Title:        iManager U2000 V1R2<br>
 * Description:  MPLS-LDP       JS<br>
 * Copyright:    Copyright (c) 2000-2009<br>
 * Company:      Huawei Tech. Co., Ltd<br>
 * @author       zhaoliang 69741
 * @version      1.0  Jun 9, 2009
 */

var winurlobj = getNeProperty(self);

var btnRightArr = new Object();

var OPRSUCC = 0;
var PARTSUCC = 1;

var st;

var grenable = new Object();
grenable[0] = "disabled";
grenable[1] = "enabled";

var helperenable = new Object();
helperenable[0] = "disabled";
helperenable[1] = "enabled";

var MIN_INTERRUPTTIME = "1";
var MAX_INTERRUPTTIME = "3600";

var MIN_WAITLSDBTIME = "1";
var MAX_WAITLSDBTIME = "3600";

var MIN_RESUMETIME = "1";
var MAX_RESUMETIME = "65535";

var level = null ;
var LEVEL_1_2 = "0";
var LEVEL_1= "1";
var LEVEL_2 = "2";

/*
 *     
 */
window.onresize=function()
{
    st.setBodyHeight(getComponetHeight($("tablecomponent"),70)+"px");
}

/*
 *      
 */
function initpage()
{
    document.body.oncontextmenu = returnFalse;
    st = new SortTable();
    st.head.setAttribute("id", "htmlTable_SortTableHead_isisgrsession");
    st.body.setAttribute("id", "htmlTable_SortTableBody_isisgrsession");
    st.setImage("../../../../../images/");    
    tc = window.tableconf[0];    
    st.setOnCellEditHandler(cellEditHandler);
    createTableHead(st, tc);    
    st.setBodyHeight(getComponetHeight($("tablecomponent"),70)+"px");    
    $("tablecomponent").oncontextmenu = popupMenuHandler;
    $("tablecomponent").appendChild(st.getTable());
    
    $("queryBtn").value=RESOURCE["querybutton"];
    $("applyBtn").value=RESOURCE["applybutton"];
    
    btnRightArr.queryBtn = new BtnRightObj("queryBtn",TE_QUERY_ISIS_GRSESSION);    
    btnRightArr.applyBtn = new BtnRightObj("applyBtn",TE_MODIFY_ISIS_GRSESSION);
    
    getRightInfo(winurlobj,btnRightArr);
    initrightbtn(btnRightArr);
    
    if(btnRightArr.queryBtn.right)
    {
        query();
    }   
}

/*
 *        
 */
function cellEditHandler()
{
    $("applyBtn").disabled = !btnRightArr.applyBtn.right; 
}

/*
 *     
 */
function query()
{
    $("queryBtn").disabled = true;
    $("applyBtn").disabled = true;
  
    var xmlstr = createQueryXML();
    
    var urlreq ="../../../../../neExlorerServlet?sfid="+TE_QUERY_ISIS_GRSESSION+"&nmUser="+winurlobj["nmUser"];        
    loadXMLdoc(urlreq, "POST",true,handleBackQuery,null,"inputdata="+xmlstr);   
}

/*
 *     XML
 */
function createQueryXML()
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var row = new tagElement("row-params");
    
    var param = new tagElement("param");    
    param.setAttribute("name","neid");
    param.setAttribute("value",winurlobj["neid"]);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name","isisID");
    param.setAttribute("value",0);
    row.appendChild(param);
    
    bussiness.appendChild(row);
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

/*
 *         
 */
function handleBackQuery(doc)
{
    $("queryBtn").disabled = !btnRightArr.queryBtn.right;
    
    data = EncapsulateData(doc); 
    
    if(data.getError().rowErrors[0])
    {   
        var size = data.getBErrLength();
        for(var i = 0;i < size;i++)
        {
            var tempObj = data.getError().rowErrors[i].errorObj;
            tempObj["operateObj"] = RESOURCE["queryISISGRSession"];
        }
    }   
    var errArr = [];
    errArr[0] = "operateObj";
    openErrPage("../../../../../page/", data.getError(), errArr);
    
    if (OPRSUCC == data.getSErrorCode() || PARTSUCC == data.getSErrorCode()) 
    {
    	level = data.rows[0].nodeLevel.value;
        st.clearTableData();
        createTableBody(st, window.tableconf[0], data, RESOURCE);
    
        addCellEvent();
    }
}

/*
 *          
 */
function addCellEvent()
{
    var cell = null;    
    for(var i = 0,len = st.getDataRowLength();i<len;i++)
    {            
        cell = st.getCellElement(i,"interrupttime");
        textCheck(cell.editElement.element,MIN_INTERRUPTTIME,MAX_INTERRUPTTIME);
       
        var l1_cell = st.getCellElement(i,"l1waitlsdbtime");
        textCheck(l1_cell.editElement.element,MIN_WAITLSDBTIME,MAX_WAITLSDBTIME);
        
        var l2_cell = st.getCellElement(i,"l2waitlsdbtime");
        textCheck(l2_cell.editElement.element,MIN_WAITLSDBTIME,MAX_WAITLSDBTIME);
       
       	if(level && (level == LEVEL_1)) 
       	{
       		st.setCellIsEdit(l2_cell, false);
       	}       	
       if(level && (level == LEVEL_2))
       {
       		st.setCellIsEdit(l1_cell, false);
       }
       	
        cell = st.getCellElement(i,"resumetime");
        textCheck(cell.editElement.element,MIN_RESUMETIME,MAX_RESUMETIME);
    }
}

/*
 *     
 */
function apply()
{
    var xml = createApplyXML();
    if (null == xml)
    {
        return;
    }
    
    $("queryBtn").disabled = true;
    $("applyBtn").disabled = true;
    
    var urlreq ="../../../../../neExlorerServlet?sfid="+TE_MODIFY_ISIS_GRSESSION+""+"&nmUser="+winurlobj["nmUser"];
    loadXMLdoc(urlreq, "POST",true,handleBackApply,null,"inputdata="+xml);
}

/*
 *     XML
 */
function createApplyXML()
{
    di = new inputxml("datainterface");
    bussiness = new tagElement("bussiness-params");
    var row;
    var param;
    
    for(var i=0,length = st.getDataRowLength();i<length;i++)
    {
        if(!st.getModify(i))
        {
          continue;
        }
        row = new tagElement("row-params");   
            
        param = new tagElement("param");
        param.setAttribute("name","neid");
        param.setAttribute("value",winurlobj["neid"]);
        row.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name","isisID");
        param.setAttribute("value",st.getCellStoreValue(i,"isisID","isisID"));
        row.appendChild(param);
        
        if (st.getCellModify(i, "grenable"))
        {
            param = new tagElement("param");
            param.setAttribute("name","grenable");
            param.setAttribute("value",st.getCellStoreValue(i,"grenable","grenable"));
            row.appendChild(param);
        }
        
        if (st.getCellModify(i, "helperenable"))
        {
            param = new tagElement("param");
            param.setAttribute("name","helperenable");
            param.setAttribute("value",st.getCellStoreValue(i,"helperenable","helperenable"));
            row.appendChild(param);
        }
        
        if (st.getCellModify(i, "interrupttime")
         || st.getCellModify(i, "l1waitlsdbtime")
         || st.getCellModify(i, "l2waitlsdbtime")
         || st.getCellModify(i, "resumetime"))
        {    
        	var interrupttime = st.getCellStoreValue(i,"interrupttime","interrupttime");
        	
            param = new tagElement("param");
            param.setAttribute("name","interrupttime");
            param.setAttribute("value",interrupttime);
            row.appendChild(param);       

            var l1time = st.getCellStoreValue(i,"l1waitlsdbtime","l1waitlsdbtime");
            var l2time = st.getCellStoreValue(i,"l2waitlsdbtime","l2waitlsdbtime");
            var resumetime = st.getCellStoreValue(i,"resumetime","resumetime");
            if(level == LEVEL_2)
            {
            	l1time = l2time;
            }
            else if(level == LEVEL_1)
            {
            	l2time = l1time;
            }
            if(parseInt(resumetime) < parseInt(l2time) || 
                parseInt(resumetime) < parseInt(l1time) || 
                parseInt(resumetime) < parseInt(interrupttime) || 
                parseInt(l2time) < parseInt(interrupttime) || 
                parseInt(l1time) < parseInt(interrupttime))
            {            	
            	alert(RESOURCE["out_of_range"]);
            	return null;
            }
            
            if(level == LEVEL_2)
            {
            	l1time = "65535";
            }
            else if(level == LEVEL_1)
            {
            	l2time = "65535";
            }
            param = new tagElement("param");
            param.setAttribute("name","l1waitlsdbtime");
            param.setAttribute("value",l1time);
            row.appendChild(param);
            
            param = new tagElement("param");
            param.setAttribute("name","l2waitlsdbtime");
            param.setAttribute("value",l2time);
            row.appendChild(param);
            
            param = new tagElement("param");
            param.setAttribute("name","resumetime");
            param.setAttribute("value",resumetime);
            row.appendChild(param);            
        }
        
        bussiness.appendChild(row);
    }
    di.getRoot().appendChild(bussiness);
    
    return di.toString(); 
}

/*
 *         
 */
function handleBackApply(doc)
{    
    $("queryBtn").disabled = !btnRightArr.queryBtn.right;

    var data = EncapsulateData(doc);
    
    if (OPRSUCC != data.getError().getGlobleECode())
    {
        if(data.getError().rowErrors[0])
        {   
            var size = data.getBErrLength();
            for(var i = 0;i < size;i++)
            {
                var tempObj = data.getError().rowErrors[i].errorObj;
                tempObj["operateObj"] = RESOURCE["modifyISISGRSession"] + "," + RESOURCE["isisID"] + ":" + tempObj["isisID"];
            }
        }   
        var errArr = [];
        errArr[0] = "operateObj";
        openErrPage("../../../../../page/", data.getError(), errArr);
        
        $("applyBtn").disabled = !btnRightArr.applyBtn.right;
    }

    if (OPRSUCC == data.getError().getGlobleECode()  || PARTSUCC == data.getError().getGlobleECode())
    {
        refreshTableState(st,tc,data);
    }   
}


