var winurlobj = window.parent;
var neid = winurlobj.winurlobj["neid"];
var nmUser = winurlobj.winurlobj["nmUser"];
var btnRightArr = new Object();
var OPRSUCC = 0;
var OPRPART = 1;
var FAIL = 2;
var st;
var selectedRowID = 0;
var tc;
var RTType_AS = 2;
var RTType_IPV4 = 102;

function initPage()
{
    createTable();
    initButtonText();
}

function createTable()
{
    st = new SortTable();
    st.head.setAttribute("id", "htmlTableIBGPRTFilterPolicyTHead");
    st.body.setAttribute("id", "htmlTableIBGPRTFilterPolicyTBody");
    st.setImage("../../../../../images/");
    tc = window.tableconf[0];
	st.isUsedForSelectList = true;
    createTableHead(st, tc);
    st.setOnRowSelectHandler(rowSelectedHandler);
    st.setBodyHeight("80px");
    st.element.style.width = "100%";
    $("tablearea").appendChild(st.getTable());
    $("tablearea").oncontextmenu = popupMenuHandler;
}

function initButtonText()
{
    $("createBtn").value = RESOURCE["newbutton"];
    $("deleteBtn").value = RESOURCE["deletebutton"];
    
    $("createBtn").disabled = true;
    $("deleteBtn").disabled = true;
    
    btnRightArr.createBtn = new BtnRightObj("createBtn", TECMD_BGP_POLICY_ADD_RT);
    btnRightArr.deleteBtn = new BtnRightObj("deleteBtn", TECMD_BGP_POLICY_DEL_RT);
    
    getRightInfo(winurlobj.winurlobj, btnRightArr);
    initrightbtn(btnRightArr);
}

function rowSelectedHandler()
{
    if (st.getSelectedRowCount() > 0) 
    {
        $("deleteBtn").disabled = !btnRightArr.deleteBtn.right;
    }
    else 
    {
        $("deleteBtn").disabled = true;
    }
}

function tabSelectHandler()
{    
    sendQueryInfo();
}

function sendQueryInfo()
{
    var xmlstr = createQueryFilterPolicyXml();
    if (null == xmlstr)
    {
        return;
    }
    
    $("createBtn").disabled = false;
    $("deleteBtn").disabled = true;
    
    urlreq = "../../../../../neExlorerServlet?sfid=" + TECMD_BGP_POLICY_GET_RT + "&nmUser=" + nmUser;
    loadXMLdoc(urlreq, "POST", false, handleBackQueryFilterPolicy, null, "inputdata=" + xmlstr);   
}

function createQueryFilterPolicyXml()
{
    var selectedPolicyID = winurlobj.getSelectedPolicyID();
    var selectedPolicyItemID = winurlobj.getSelectedPolicyItemID();
    if (selectedPolicyID == -1 || selectedPolicyItemID == -1)
    {
        clearTableData();
        return null;
    }
    
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var row = new tagElement("row-params");
    
    var param = new tagElement("param");
    param.setAttribute("name", "neid");
    param.setAttribute("value", neid);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "policyID");
    param.setAttribute("value", selectedPolicyID);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "policyItemID");
    param.setAttribute("value", selectedPolicyItemID);
    row.appendChild(param);
    
    bussiness.appendChild(row);
    di.getRoot().appendChild(bussiness);
    return di.toString();
    
}

function handleBackQueryFilterPolicy(doc)
{
    $("createBtn").disabled = !btnRightArr.createBtn.right;
    data = EncapsulateData(doc);    
    
    var errArr = [];
    errArr[0] = "nename";
    openErrPage("../../../../../page/", data.getError(), errArr);
    
    if (OPRSUCC == data.getError().getGlobleECode() || OPRPART == data.getError().getGlobleECode()) 
    {
        processFilterPolicyData(data);
        st.clearTableData();
        createTableBody(st, tc, data, RESOURCE);        
    }    
}

function processFilterPolicyData(data)
{
    for (var i = 0, len = data.getDataRowLength(); i < len; i++) 
    {
        var ptag = new ParamTag();
        
        if (RTType_AS == data.getDataRowParam(i, "rtType"))
        {
            ptag.value =  data.getDataRowParam(i, "rtAdministrator") + ":" + data.getDataRowParam(i, "rtAssignedNumber");
        }
        else
        {
            var tempStr = data.getDataRowParam(i, "rtAdministrator");
            ptag.value = convertNumToIpaddr(tempStr) + ":" + data.getDataRowParam(i, "rtAssignedNumber");
        }
        data.rows[i]["rtfilterpolicy"] = ptag;        
    }
}

function sendCreateFilterPolicy()
{
    xshowModalDialog("creatertfilterpolicy.html", RESOURCE["createRTFilterPolicy"], 450, 160, "../../../../../images/");
}

function sendDeleteFilterPolicy()
{
    if (!confirm(RESOURCE["modifyHint"])) 
    {
        return;
    }
    
    $("createBtn").disabled = true;
    $("deleteBtn").disabled = true;
    
    var xmlstr = createDeleteFilterPolicyXML();
    
    urlreq = "../../../../../neExlorerServlet?sfid=" + TECMD_BGP_POLICY_DEL_RT  + "&nmUser=" + nmUser;
    loadXMLdoc(urlreq, "POST", true, handleBackDeleteFilterPolicy, null, "inputdata=" + xmlstr);
}


function createDeleteFilterPolicyXML()
{

    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    
    for (var i = 0, len = st.getDataRowLength(); i < len; i++) 
    {
        if (st.getRowSelFlag(i)) 
        {
            var row = new tagElement("row-params");
            
            var param = new tagElement("param");
            param.setAttribute("name", "neid");
            param.setAttribute("value", neid);
            row.appendChild(param);
            
            param = new tagElement("param");
            param.setAttribute("name", "policyID");
            param.setAttribute("value", st.getCellStoreValue(i, "policyID", "policyID"));
            row.appendChild(param);
            
            param = new tagElement("param");
            param.setAttribute("name", "policyItemID");
            param.setAttribute("value", st.getCellStoreValue(i, "policyItemID", "policyItemID"));
            row.appendChild(param);
            
            param = new tagElement("param");
            param.setAttribute("name", "rtType");
            param.setAttribute("value", st.getCellStoreValue(i, "rtType", "rtType"));
            row.appendChild(param);
            
            param = new tagElement("param");
            param.setAttribute("name", "rtAdministrator");
            param.setAttribute("value", st.getCellStoreValue(i, "rtAdministrator", "rtAdministrator"));
            row.appendChild(param);
            
            param = new tagElement("param");
            param.setAttribute("name", "rtAssignedNumber");
            param.setAttribute("value", st.getCellStoreValue(i, "rtAssignedNumber", "rtAssignedNumber"));
            row.appendChild(param);
    
            var opDesc = RESOURCE["policyID"] + ":" + st.getCellStoreValue(i, "policyID", "policyID") + " " + 
                         RESOURCE["policyItemID"] + ":" + st.getCellStoreValue(i, "policyItemID", "policyItemID") + " " + 
                         RESOURCE["rtFilterPolicy"] + ":" + st.getCellStoreValue(i, "rtfilterpolicy", "rtfilterpolicy");
                
            param = new tagElement("param");
            param.setAttribute("name","opDesc");
            param.setAttribute("value",opDesc);
            row.appendChild(param);; 
            
            bussiness.appendChild(row);
        }
    }
    
    di.getRoot().appendChild(bussiness);
    return di.toString();
}


function handleBackDeleteFilterPolicy(doc)
{
    $("createBtn").disabled = !btnRightArr.createBtn.right;
    
    var data = EncapsulateData(doc);
    var errArr = [];
    errArr[0] = "nename";
    openErrPage("../../../../../page/", data.getError(), errArr);
    
    if (OPRSUCC == data.getError().getGlobleECode()) 
    {
        for (var i = 0, len = st.getDataRowLength(); i < len; i++) 
        {
            if (st.getRowSelFlag(i)) 
            {
                st.deleteRow(i);
            }
        }
        st.adjustDataRows();
    }
    else 
    {
        $("deleteBtn").disabled = !btnRightArr.deleteBtn.right;
        
        sendQueryInfo();
    }
}

function clearTableData()
{
    st.clearTableData();
    
    $("createBtn").disabled = true;
    $("deleteBtn").disabled = true;
}

function addFilterPolicyRecord(dinterface)
{		      
     createTableBody(st, tc, dinterface, RESOURCE);
}

