var winurlobj = getNeProperty(self);
var btnRightArr = new Object();
var st,st1,st2;
var OPRSUCC = 0;
var OPRPART = 1;

var policyType = new Object();
policyType[1] = "PERMIT";
policyType[2] = "DENY";

var matchIpType = new Object();
matchIpType[1] = "NLRI";
matchIpType[2] = "SOURCE";
matchIpType[3] = "NEXTHOP";

var localprefpolicy = new Object();
localprefpolicy["0"] = "none";
localprefpolicy["1"] = "set-specific";

var MIN_VALUE = "1";
var MAX_VALUE = "65535";
var MIN_PREF ="0";
var MAX_PREF ="4294967295";
var DEFAULT_PREFPOLICY="0";
var DEFAULT_PREF = "100";
var DEFAULT_ATTENURESTRAIN = "125";
var DEFAULT_ATTENURESTORE = "50";
var DEFAULT_UPPERLIMIT = "900";
var DEFAULT_ROUTEHALFLIFE = "300";
var DEFAULT_NOROUTEHALFLIFE = "900";

var lastPolicyItemID = -1;
var NOSUPPORT_VALUE="-";
var INVALIDE_VALUE ="/";
var POLICY_NAME_MAXLENGTH = 64;
var logString = "";

var PLYTYPE_PERMIT=1;
var PLYTYPE_DENY=2;

var lastUpSelectedRowID = -1;
var lastMidSelectedRowID = -1;

function initpage()
{
	  initUpTable();
	  initMidTable();
	  initLowTable();
	
    $("createPolicyItemBtn").disabled = true;
    $("deletePolicyItemBtn").disabled = true;
    $("applyPolicyItemBtn").disabled = true;
    $("clearFlapBtn").disabled = true;
    
    $("createIpFilterPolicyBtn").disabled = true;
    $("deleteIpFilterPolicyBtn").disabled = true;
    
    getRightInfo(winurlobj,btnRightArr);
    $("querybtn").disabled = true;
    $("createbtn").disabled = true;
    $("deletebtn").disabled = true; 
    $("applybtn").disabled = true; 
    
    if(btnRightArr.querybtn.right)
	  {
		    sendQueryInfo();
	  } 

}

function initUpTable()
{
	  st = new SortTable();	
    st.head.setAttribute("id", "htmlTableIbgpPolicyTHead");
    st.body.setAttribute("id", "htmlTableIbgpPolicyTBody");
    st.setImage("../../../../../images/");    
    tc = window.tableconf[0];   
    createTableHead(st, tc); 
	st.setOnRowSelectHandler(rowSelected);   
	st.setBodyHeight("240px");
	window.onresize=function()
	{
	  st.setBodyHeight(getComponetHeight($("tablecomponent"),60)+"px");
	}	    
	 st.setOnCellEditHandler(cellEditHandler);
	 $("tablecomponent").oncontextmenu = popupMenuHandler;
    $("tablecomponent").appendChild(st.getTable());
    
    $("totalrow").innerText = RESOURCE["countrows"];
	  $("selrow").innerText = RESOURCE["seleterows"];
	  $("totalrownum").innerText = "0";
	  $("selrownum").innerText = "0";
    
    $("querybtn").value=RESOURCE["querybutton"];
    $("createbtn").value=RESOURCE["newbutton"];
    $("deletebtn").value=RESOURCE["deletebutton"];   	    
	$("applybtn").value=RESOURCE["applybutton"];   	    
    btnRightArr.querybtn = new BtnRightObj("querybtn",TECMD_BGP_GET_POLICY);
    btnRightArr.createbtn = new BtnRightObj("createbtn",TECMD_BGP_DEL_POLICY);   
    btnRightArr.deletebtn = new BtnRightObj("deletebtn",TECMD_BGP_DEL_POLICY); 
    btnRightArr.applybtn = new BtnRightObj("applybtn",TECMD_BGP_DEL_POLICY); 
}

function initMidTable()
{
    $("midtablename").innerText = RESOURCE["policyItemTableName"];
    st1 = new SortTable();
    st1.head.setAttribute("id", "htmlTableIBGPPolicyItemTHead");
    st1.body.setAttribute("id", "htmlTableIBGPPolicyItemTBody");
    st1.setImage("../../../../../images/");
    midtc = window.tableconf[1];
    st1.isUsedForSelectList = true;
    createTableHead(st1, midtc);
    st1.setOnRowSelectHandler(midTableRowSelectedHandler); 
    st1.setOnCellEditHandler(midTableCellEditHandler);
    st1.setBodyHeight("120px");
    $("midtablecomponent").oncontextmenu = popupMenuHandler;
    $("midtablecomponent").appendChild(st1.getTable());
    st1.setBodyWidth(midtc.width, tc.percent, 0);
    
    $("createPolicyItemBtn").value=RESOURCE["newbutton"];
    $("deletePolicyItemBtn").value=RESOURCE["deletebutton"];   
    $("applyPolicyItemBtn").value=RESOURCE["applybutton"];   
    $("clearFlapBtn").value=RESOURCE["clearFlapBtn"];   

    btnRightArr.createPolicyItemBtn = new BtnRightObj("createPolicyItemBtn",TECMD_BGP_ADD_POLICY_ITEM);
    btnRightArr.deletePolicyItemBtn = new BtnRightObj("deletePolicyItemBtn",TECMD_BGP_DEL_POLICY_ITEM); 
    btnRightArr.applyPolicyItemBtn  = new BtnRightObj("applyPolicyItemBtn",TECMD_BGP_DEL_POLICY_ITEM);
    btnRightArr.clearFlapBtn  = new BtnRightObj("clearFlapBtn",TECMD_BGP_DEL_POLICY_ITEM);
}

function initLowTable()
{
	  $("lowtablename").innerText = RESOURCE["ipFilterPolicyTable"];
	  st2 = new SortTable();
    st2.head.setAttribute("id", "htmlTableIBGPIpFilterPolicyTHead");
    st2.body.setAttribute("id", "htmlTableIBGPIpFilterPolicyTBody");
    st2.setImage("../../../../../images/");
    lowtc = window.tableconf[2];
    st2.isUsedForSelectList = true;
    createTableHead(st2, lowtc);
    st2.setOnRowSelectHandler(lowTableRowSelectedHandler); 
    st2.setBodyHeight("120px");
    $("lowtablecomponent").appendChild(st2.getTable());
    st2.setBodyWidth(lowtc.width, tc.percent, 0);

    $("createIpFilterPolicyBtn").value=RESOURCE["newbutton"];
    $("deleteIpFilterPolicyBtn").value=RESOURCE["deletebutton"];   	

    btnRightArr.createIpFilterPolicyBtn = new BtnRightObj("createIpFilterPolicyBtn",TECMD_BGP_DEL_POLICY_ITEM);     
    btnRightArr.deleteIpFilterPolicyBtn = new BtnRightObj("deleteIpFilterPolicyBtn",TECMD_BGP_DEL_POLICY_ITEM)
}


function midTableRowSelectedHandler()
{
	if (st1.getSelectedRowCount()>0)
	{
        $("deletePolicyItemBtn").disabled = !btnRightArr.deletePolicyItemBtn.right
        $("clearFlapBtn").disabled = !btnRightArr.clearFlapBtn.right
	    var selectedRowID = st1.getSelectedRows()[0];
	    if (selectedRowID != lastMidSelectedRowID) 
	    {
            lastMidSelectedRowID = selectedRowID;
            doQueryIPFilterPolicy();
	    }
  	}
  	else
  	{
 		   $("deletePolicyItemBtn").disabled =true;
 		   $("clearFlapBtn").disabled = true;
  		  
  		  st2.clearTableData();
  		  lastPolicyItemID = -1;
  		lastMidSelectedRowID = -1;
        $("createIpFilterPolicyBtn").disabled = true;
  		  $("deleteIpFilterPolicyBtn").disabled = true;
  	}


}

function lowTableRowSelectedHandler()
{
    if (st2.getSelectedRowCount()>0)
	  {
       $("deleteIpFilterPolicyBtn").disabled = !btnRightArr.deleteIpFilterPolicyBtn.right

  	}
  	else
  	{
 		   $("deleteIpFilterPolicyBtn").disabled =true;
  		  
  	}
}

function midTableCellEditHandler()
{
    $("applyPolicyItemBtn").disabled = !btnRightArr.applyPolicyItemBtn.right;
}


function sendQueryInfo()
{
	  $("querybtn").disabled = true;
    $("createbtn").disabled = true;
    $("deletebtn").disabled = true; 
    $("applybtn").disabled = true; 
    lastPolicyItemID = -1;    
	
    var xmlstr = createQueryXML();    
    
    urlreq ="../../../../../neExlorerServlet?sfid="+TECMD_BGP_GET_POLICY+""+"&nmUser="+winurlobj["nmUser"];        
    loadXMLdoc(urlreq, "POST",false,handleBackQuery,null,"inputdata="+xmlstr);
   
}

function createQueryXML()
{
	  var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var row = new tagElement("row-params");
    
    var param = new tagElement("param");    
    param.setAttribute("name","neid");
    param.setAttribute("value",winurlobj["neid"]);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name","policyID");
    param.setAttribute("value","0");
    row.appendChild(param);
    
    bussiness.appendChild(row);
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

function handleBackQuery(doc)
{
	  $("querybtn").disabled = !btnRightArr.querybtn.right;;
    $("createbtn").disabled = !btnRightArr.createbtn.right;
    
	  var data = EncapsulateData(doc); 
	  
    for(var i = 0, len = data.getBErrLength();i < len;i++)
	  {
	  	  var tempObj = data.getError().rowErrors[i].errorObj;
    		tempObj["operateObj"] = RESOURCE["queryPolicy"];
	  }	
	  
	  var errArr = [];
    errArr[0] = "operateObj";
    openErrPage("../../../../../page/", data.getError(), errArr);    
	    
    if (OPRSUCC == data.getSErrorCode()||OPRPART == data.getSErrorCode()) 
    {
	      st.clearTableData();
        createTableBody(st, window.tableconf[0], data, RESOURCE);
        addCellEvent();
        if( st.getDataRowLength()>0)
        {
            st.setRowSelect(0);
        }
        
         $("totalrownum").innerText = ""+data.getDataRowLength();
	       $("selrownum").innerText = ""+st.getSelectedRows().length;
    }
    
    rowSelected();
}

function rowSelected()
{
	  $("selrownum").innerText = ""+st.getSelectedRows().length;
	
	  if (st.getSelectedRowCount() > 0)
	  {
  	      $("deletebtn").disabled = !btnRightArr.deletebtn.right;
	      var selectedRowID = st.getSelectedRows()[0];
	      if (selectedRowID != lastUpSelectedRowID) 
	      {
              lastUpSelectedRowID = selectedRowID;
              lastMidSelectedRowID = -1;
	  	      doQueryPolicyItem(); 	  	
	      }
	  }
	  else
	  {
	      $("deletebtn").disabled = true;
	      
	      st1.clearTableData();
  		  $("createPolicyItemBtn").disabled = true;
        $("deletePolicyItemBtn").disabled = true;
  		  $("applyPolicyItemBtn").disabled = true;
        $("clearFlapBtn").disabled = true; 
        st2.clearTableData();
  		  lastPolicyItemID = -1;
          lastUpSelectedRowID = -1;
          lastMidSelectedRowID = -1;
        $("createIpFilterPolicyBtn").disabled = true;
  		  $("deleteIpFilterPolicyBtn").disabled = true;
       
	  }
}

function sendDeleteInfo()
{
	  if (!confirm(RESOURCE["Delete_Hint"]))
    {
        return;
    }
    
	  $("querybtn").disabled = true;
    $("createbtn").disabled = true;
    $("deletebtn").disabled = true;
	 $("applybtn").disabled = true;
    var xmlstr = createDeleteXML();   
    urlreq ="../../../../../neExlorerServlet?sfid="+TECMD_BGP_DEL_POLICY+""+"&nmUser="+winurlobj["nmUser"];        
    loadXMLdoc(urlreq, "POST",true,handleBackDelete,null,"inputdata="+xmlstr);
}

function createDeleteXML()
{
	  var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    
    for(var i=0, len = st.getDataRowLength(); i<len; i++)
	  {
	  	  if (st.getRowSelFlag(i))
	  	  {	  	  	
            var row = new tagElement("row-params");
            
            var param = new tagElement("param");        
            param.setAttribute("name","neid");
            param.setAttribute("value",winurlobj["neid"]);
            row.appendChild(param);
            
            param = new tagElement("param");
            param.setAttribute("name","policyID");
            param.setAttribute("value",st.getCellStoreValue(i,"policyID","policyID"));
            row.appendChild(param);

            bussiness.appendChild(row);
        }
    }
    
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

function handleBackDelete(doc)
{
	  $("querybtn").disabled = !btnRightArr.querybtn.right;
    $("createbtn").disabled = !btnRightArr.createbtn.right;
    
	  var data = EncapsulateData(doc);
    for(var i = 0, len = data.getBErrLength();i < len;i++)
	  {
	  	  var tempObj = data.getError().rowErrors[i].errorObj;
    		tempObj["operateObj"] = RESOURCE["deletePolicy"];
	  }	
	  
	  var errArr = [];
    errArr[0] = "operateObj";
    openErrPage("../../../../../page/", data.getError(), errArr);    	 
    
    if (OPRSUCC == data.getError().getGlobleECode() || OPRPART == data.getError().getGlobleECode()) 
    {
	      sendQueryInfo();
    }
    else
    {
    	  $("deletebtn").disabled = !btnRightArr.deletebtn.right;
    }
}

function sendCreateInfo()
{
    xshowModalDialog("createpolicy.html", RESOURCE["createPolicy"], 580, 180, "../../../../../images/");
}


function sendCreatePolicyItem()
{
    xshowModalDialog("createpolicyitem.html", RESOURCE["createPolicyItem"], 670, 220, "../../../../../images/");
}

function sendCreateIpFilterPolicy()
{
	xshowModalDialog("createipfilterpolicy.html", RESOURCE["createIPFilterPolicy"], 450, 300, "../../../../../images/");
}


function doQueryPolicyItem()
{
   	var xmlstr= createQueryPolicyItemXml();
   	
    $("createPolicyItemBtn").disabled = true;
    $("deletePolicyItemBtn").disabled = true;
    $("applyPolicyItemBtn").disabled = true;
   	
    urlreq ="../../../../../neExlorerServlet?sfid="+TECMD_BGP_GET_POLICY_ITEM+""+"&nmUser="+winurlobj["nmUser"];        
    loadXMLdoc(urlreq, "POST",false,handleBackQueryPolicyItem,null,"inputdata="+xmlstr);

}


function getSelectedPolicyID()
{
	  var rows = st.getSelectedRows();
	  var policyID = -1;
	  if(rows.length>0)
	  {
	    policyID= st.getCellStoreValue(rows[0],"policyID","policyID");
	    
	  }
	   return policyID;	
	  
}

function getSelectedPolicyItemID()
{
	  var rows = st1.getSelectedRows();
	  var policyItemID = -1;
	  if(rows.length>0)
	  {
	    policyItemID= st1.getCellStoreValue(rows[0],"policyItemID","policyItemID");
	    
	  }
	   return policyItemID;	
}



function createQueryPolicyItemXml()
{
	  
	  var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var row = new tagElement("row-params");
    
    var param = new tagElement("param");    
    param.setAttribute("name","neid");
    param.setAttribute("value",winurlobj["neid"]);
    row.appendChild(param);
    
    param = new tagElement("param");    
    param.setAttribute("name","policyID");
    param.setAttribute("value",getSelectedPolicyID());
    row.appendChild(param);
    
    param = new tagElement("param");    
    param.setAttribute("name","flagprefpolicy");
    param.setAttribute("value",DEFAULT_PREFPOLICY);
    row.appendChild(param);
    
    bussiness.appendChild(row);
    di.getRoot().appendChild(bussiness);
    return di.toString();


}


function handleBackQueryPolicyItem(doc)
{

    $("createPolicyItemBtn").disabled = !btnRightArr.createPolicyItemBtn.right;

	  data = EncapsulateData(doc); 
	  
	  if(data.getError().rowErrors[0])
	  {		
	    	var size = data.getBErrLength();
	    	for(var i = 0;i < size;i++)
	    	{
		    	  var tempObj = data.getError().rowErrors[i].errorObj;
  	    		tempObj["operateObj"] = RESOURCE["queryPolicyItem"];
		    }
	  }		
	  
	  var errArr = [];
    errArr[0] = "operateObj";
    openErrPage("../../../../../page/", data.getError(), errArr);
    
    if (OPRSUCC == data.getError().getGlobleECode() || OPRPART == data.getError().getGlobleECode()) 
    {
        preProcessData(data); 
       
	      st1.clearTableData();
	      
        createTableBody(st1, window.tableconf[1], data, RESOURCE);
        
        addMidTableCellEvent();
        
    }  
    
    midTableRowSelectedHandler();    
}

function preProcessData(data)
{
	      for(var i=0, len = data.getDataRowLength(); i<len; i++)
    	  {
    	  	  var ptag = new ParamTag();
    	  	  if("" ==data.getDataRowParam(i,"attenurestrain"))
    	  	  {
    	  	  	data.rows[i]["attenurestrain"].value ="/";
    	  	  }
    	  	  
    	      if("" ==data.getDataRowParam(i,"attenurestore"))
    	  	  {
    	  	  	data.rows[i]["attenurestore"].value ="/";
    	  	  }

    	      if("" ==data.getDataRowParam(i,"upperlimit"))
    	  	  {
    	  	  	data.rows[i]["upperlimit"].value ="/";
    	  	  }

    	      if("" ==data.getDataRowParam(i,"routehalflife"))
    	  	  {
    	  	  	data.rows[i]["routehalflife"].value ="/";
    	  	  }

    	      if("" ==data.getDataRowParam(i,"noroutehalflife"))
    	  	  {
    	  	  	data.rows[i]["noroutehalflife"].value ="/";
    	  	  }
    	  	  
    	  	  if("2"==data.getDataRowParam(i,"policyType"))
    	  	  {
    	  	  	    ptag = new ParamTag();
                  ptag.value = NOSUPPORT_VALUE; 
                  data.rows[i]["localprefpolicy"]=ptag;
               
                  ptag = new ParamTag();
                  ptag.value =NOSUPPORT_VALUE; 
                  data.rows[i]["localpref"]=ptag;
    	  	  }
    	  	  else
    	  	  {    	  	  
    	  	     if(null == data.getDataRowParam(i,"localprefpolicy"))
    	  	     {
                    ptag = new ParamTag();
                    ptag.value =DEFAULT_PREFPOLICY; 
                    data.rows[i]["localprefpolicy"]=ptag;
               }
    	  	  }
    	  	  
    	  	  if(null == data.getDataRowParam(i,"localpref"))
    	  	  {
                     ptag = new ParamTag();
                     ptag.value =NOSUPPORT_VALUE; 
                     data.rows[i]["localpref"]=ptag;
    	  	  }           
    	  }
}


function addMidTableCellEvent()
{
	
    var cell = null;
    var plyType = null;
	  for(var i = 0,len = st1.getDataRowLength();i<len;i++)
	  {	  	  	  		  	
	  	  plyType =  st1.getCellStoreValue(i,"policyType","policyType");	  	  	  	  
	  	  cell = st1.getCell(i,"attenurestrain");
		    textCheck(cell.element.editElement.element, MIN_VALUE, MAX_VALUE);
	  	  
	  	  cell = st1.getCell(i,"attenurestore");
 	     	textCheck(cell.element.editElement.element, MIN_VALUE, MAX_VALUE);
	  	  
        cell = st1.getCell(i,"upperlimit");
	     	textCheck(cell.element.editElement.element, MIN_VALUE, MAX_VALUE);
	  	  
        cell = st1.getCell(i,"routehalflife");
	     	textCheck(cell.element.editElement.element, MIN_VALUE, MAX_VALUE);

        cell = st1.getCell(i,"noroutehalflife");
 	     	textCheck(cell.element.editElement.element, MIN_VALUE, MAX_VALUE);
 	     	
 	     	cell = st1.getCell(i,"localpref");
 	     	textCheck(cell.element.editElement.element, MIN_PREF,MAX_PREF); 	
 	     	
 	     	 var currCell = st1.getCell(i,"localprefpolicy");
	     	 if(PLYTYPE_DENY==plyType)
	     	 {
	     	 	   st1.setCellIsEdit(currCell,0); 
	    	       currCell.modify = false;
	    	       st1.setAtomValue(currCell.element.showElement,NOSUPPORT_VALUE);
	    	       currCell.element.children[0].style.color = "#000000"; 
	    	       
	    	       st1.setCellIsEdit(cell,0); 
	    	       cell.modify = false;
	    	       st1.setAtomValue(cell.element.showElement,NOSUPPORT_VALUE);
	    	       cell.element.children[0].style.color = "#000000"; 
	     	 }
 	     	     	
 	     	var atom = st1.getCell(i,"localprefpolicy").element.editElement; 	     	
	     	
 	     	atom.element["onchange"] = function()
	      {
	     	    var v = this.value;
	     	    var rowindex = this.parentNode.parentNode.rowIndex;	     	    	     	    
	     	    cell = st1.getCell(rowindex,"localpref");	     	    
	     	    if ( 0 == v)
	     	    {	     	    	  	     	    	  
	    		      st1.setCellIsEdit(cell,0); 
	    		      cell.modify = false;
	    		      st1.setAtomValue(cell.element.showElement,NOSUPPORT_VALUE);
	    		      cell.element.children[0].style.color = "#000000";
	     	    }
	     	    else
	     	    {		
                st1.setCellIsEdit(cell,1);                 
                cell.element.modify=true;
            	  cell.modify=true;            	
            	  cell.element.style.backgroundColor= "#d0f946";
	     	    	  st1.setAtomValue(cell.element.showElement,DEFAULT_PREF);
	     	        st1.setCellValue(cell,"localpref",DEFAULT_PREF);	     	      
	     	    }
	     	}
	     	var localprefValue =st1.getCellStoreValue(i,"localpref","localpref");
	     	var localPrefPly = st1.getCellStoreValue(i,"localprefpolicy","localprefpolicy");
	     	if ((DEFAULT_PREFPOLICY==localPrefPly)||NOSUPPORT_VALUE==localprefValue)
	       {
	                st1.setCellIsEdit(cell,0);
	                st1.setAtomValue(cell.element.showElement,NOSUPPORT_VALUE);	            
	     	}
	  }	
}


function sendDeletePolicyItem()
{
	  if (!confirm(RESOURCE["Delete_Hint"]))
    {
        return;
    }
    
    $("createPolicyItemBtn").disabled = true;
    $("deletePolicyItemBtn").disabled = true;
    $("applyPolicyItemBtn").disabled = true;
    $("clearFlapBtn").disabled = true;
	
    var xmlstr = createDeletePolicyItemXML();   
   
    urlreq ="../../../../../neExlorerServlet?sfid="+TECMD_BGP_DEL_POLICY_ITEM+""+"&nmUser="+winurlobj["nmUser"];        
    loadXMLdoc(urlreq, "POST",true,handleBackDeletePolicyItem,null,"inputdata="+xmlstr);
}

function createDeletePolicyItemXML()
{
	  var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    
   
    for(var i=0, len = st1.getDataRowLength(); i<len; i++)
	  {
	  	  if (st1.getRowSelFlag(i))
	  	  {	  	  	
            var row = new tagElement("row-params");
            
            var param = new tagElement("param");        
            param.setAttribute("name","neid");
            param.setAttribute("value",winurlobj["neid"]);
            row.appendChild(param);
            
            param = new tagElement("param");
            param.setAttribute("name","policyID");
            param.setAttribute("value",getSelectedPolicyID());
            row.appendChild(param);
            
            param = new tagElement("param");
            param.setAttribute("name","policyItemID");
            param.setAttribute("value",st1.getCellStoreValue(i,"policyItemID","policyItemID"));
            row.appendChild(param);
            
            bussiness.appendChild(row);
        }
    }
    
    di.getRoot().appendChild(bussiness);
    return di.toString();
}


function handleBackDeletePolicyItem(doc)
{
	   $("createPolicyItemBtn").disabled = !btnRightArr.createPolicyItemBtn.right;
    
	  var data = EncapsulateData(doc);
    for(var i = 0, len = data.getBErrLength();i < len;i++)
	  {
	  	  var tempObj = data.getError().rowErrors[i].errorObj;
    		tempObj["operateObj"] = RESOURCE["deletePolicyItem"];
	  }	
	  
	  var errArr = [];
    errArr[0] = "operateObj";
    openErrPage("../../../../../page/", data.getError(), errArr);    	 
    
    if (OPRSUCC == data.getError().getGlobleECode()|| OPRPART == data.getError().getGlobleECode()) 
    {
	       doQueryPolicyItem();
    }
    else
    {
    	  $("deletePolicyItemBtn").disabled = !btnRightArr.deletePolicyItemBtn.right;
    }
	
}


function sendDeleteIpFilterPolicy()
{
		if (!confirm(RESOURCE["Delete_Hint"]))
    {
        return;
    }
    
    $("createIpFilterPolicyBtn").disabled = true;
    $("deleteIpFilterPolicyBtn").disabled = true;
	
    var xmlstr = createDeleteIpFilterPolicyXML();   
    
    urlreq ="../../../../../neExlorerServlet?sfid="+TECMD_BGP_POLICY_DEL_IP_PRE+""+"&nmUser="+winurlobj["nmUser"];        
    loadXMLdoc(urlreq, "POST",true,handleBackDeleteIpFilterPolicy,null,"inputdata="+xmlstr);

	
	
}


function createDeleteIpFilterPolicyXML()
{
	
	 var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    
   
    for(var i=0, len = st2.getDataRowLength(); i<len; i++)
	  {
	  	  if (st2.getRowSelFlag(i))
	  	  {	  	  	
            var row = new tagElement("row-params");
            
            var param = new tagElement("param");        
            param.setAttribute("name","neid");
            param.setAttribute("value",winurlobj["neid"]);
            row.appendChild(param);
            
            param = new tagElement("param");
            param.setAttribute("name","policyID");
            param.setAttribute("value",getSelectedPolicyID());
            row.appendChild(param);
            
            param = new tagElement("param");
            param.setAttribute("name","policyItemID");
            param.setAttribute("value",getSelectedPolicyItemID());
            row.appendChild(param);
            
            param = new tagElement("param");
            param.setAttribute("name","matchIpType");
            param.setAttribute("value",st2.getCellStoreValue(i,"matchIpType","matchIpType"));
            row.appendChild(param);            
            
            param = new tagElement("param");
            param.setAttribute("name","ipFilterPolicyID");
            param.setAttribute("value",st2.getCellStoreValue(i,"ipFilterPolicyID","ipFilterPolicyID"));
            row.appendChild(param);
            
            bussiness.appendChild(row);
        }
    }
    
    di.getRoot().appendChild(bussiness);
    return di.toString();
}


function handleBackDeleteIpFilterPolicy(doc)
{
	
	  $("createIpFilterPolicyBtn").disabled = !btnRightArr.createIpFilterPolicyBtn.right;
    
	  var data = EncapsulateData(doc);
    for(var i = 0, len = data.getBErrLength();i < len;i++)
	  {
	  	  var tempObj = data.getError().rowErrors[i].errorObj;
    		tempObj["operateObj"] = RESOURCE["deleteIPFilterPolicy"];
	  }	
	  
	  var errArr = [];
    errArr[0] = "operateObj";
    openErrPage("../../../../../page/", data.getError(), errArr);    	 
    
    if (OPRSUCC == data.getError().getGlobleECode()) 
    {
	      for(var i=0, len = st2.getDataRowLength(); i<len; i++)
	      {
	          if (st2.getRowSelFlag(i))
	          {
	              st2.deleteRow(i);
	          }	          
	      }
	      st2.adjustDataRows();
    }
    else
    {
    	  $("deleteIpFilterPolicyBtn").disabled = !btnRightArr.deleteIpFilterPolicyBtn.right;
    	  
    	  doQueryIPFilterPolicy();
    }
}



function doQueryIPFilterPolicy()
{
	  var selectedPolicyItemID = getSelectedPolicyItemID();
	  if( lastPolicyItemID == selectedPolicyItemID)
	  {
	     return; 	
	  }else
	  {
       lastPolicyItemID = selectedPolicyItemID;	  	
	  }
	  
	  var xmlstr= createQueryIPFilterPolicyXml();
   	
    $("createIpFilterPolicyBtn").disabled = true;
    $("deleteIpFilterPolicyBtn").disabled = true;
   	
	  urlreq ="../../../../../neExlorerServlet?sfid="+TECMD_BGP_POLICY_GET_IP_PRE+""+"&nmUser="+winurlobj["nmUser"];        
    loadXMLdoc(urlreq, "POST",false,handleBackQueryIPFilterPolicy,null,"inputdata="+xmlstr);
	
}


function createQueryIPFilterPolicyXml()
{
	 var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var row = new tagElement("row-params");
    
    var param = new tagElement("param");    
    param.setAttribute("name","neid");
    param.setAttribute("value",winurlobj["neid"]);
    row.appendChild(param);
    
    param = new tagElement("param");    
    param.setAttribute("name","policyID");
    param.setAttribute("value",getSelectedPolicyID());
    row.appendChild(param);
    
    param = new tagElement("param");    
    param.setAttribute("name","policyItemID");
    param.setAttribute("value",getSelectedPolicyItemID());
    row.appendChild(param);
    
    param = new tagElement("param");    
    param.setAttribute("name","matchIpType");
    param.setAttribute("value","0");
    row.appendChild(param);

    param = new tagElement("param");    
    param.setAttribute("name","ipFilterPolicyID");
    param.setAttribute("value","0");
    row.appendChild(param);        
   
    bussiness.appendChild(row);
    di.getRoot().appendChild(bussiness);
    return di.toString();
	
}

function handleBackQueryIPFilterPolicy(doc)
{
	 
  	 $("createIpFilterPolicyBtn").disabled = !btnRightArr.createIpFilterPolicyBtn.right;

	  data = EncapsulateData(doc); 
	  
	  if(data.getError().rowErrors[0])
	  {		
	    	var size = data.getBErrLength();
	    	for(var i = 0;i < size;i++)
	    	{
		    	  var tempObj = data.getError().rowErrors[i].errorObj;
  	    		tempObj["operateObj"] = RESOURCE["queryIPFilterPolicy"];
		    }
	  }		
	  
	  var errArr = [];
    errArr[0] = "operateObj";
    openErrPage("../../../../../page/", data.getError(), errArr);
    
    if (OPRSUCC == data.getError().getGlobleECode() || OPRPART == data.getError().getGlobleECode()) 
    {
    	 
        processIpFilterPolicyData(data);
       
	      st2.clearTableData();
	      
        createTableBody(st2, window.tableconf[2], data, RESOURCE);
        
    }  
	
}

function processIpFilterPolicyData(data)
{
	 for(var i=0, len = data.getDataRowLength(); i<len; i++)
    	  {
    	  	  var ptag = new ParamTag();
    	      var tempStr = data.getDataRowParam(i,"filteredIpAddr");
    	      ptag.value = parseInt("0x" + tempStr.substring(0,2)) + "."
    	                 + parseInt("0x" + tempStr.substring(2,4)) + "."
    	                 + parseInt("0x" + tempStr.substring(4,6)) + "."
    	                 + parseInt("0x" + tempStr.substring(6,8));
    	      data.rows[i]["filteredIpAddr"]=ptag;
    	  	  
    	  }
}


function sendClearFlap()
{
	  if (!confirm(RESOURCE["ClearFlap_Hint"]))
    {
        return;
    }
   
    
    $("createPolicyItemBtn").disabled = true;
    $("deletePolicyItemBtn").disabled = true;
    $("applyPolicyItemBtn").disabled = true;
    $("clearFlapBtn").disabled = true;
	
    var xmlstr = createDeletePolicyItemXML();   
    
    urlreq ="../../../../../neExlorerServlet?sfid="+TECMD_BGP_POLICY_CLEAR_FLAP+""+"&nmUser="+winurlobj["nmUser"];        
    loadXMLdoc(urlreq, "POST",true,handleBackClearFlap,null,"inputdata="+xmlstr);

}


function handleBackClearFlap(doc)
{
	  $("createPolicyItemBtn").disabled = !btnRightArr.createPolicyItemBtn.right;
    
	  var data = EncapsulateData(doc);
    for(var i = 0, len = data.getBErrLength();i < len;i++)
	  {
	  	  var tempObj = data.getError().rowErrors[i].errorObj;
    		tempObj["operateObj"] = RESOURCE["clearFlapBtn"];
	  }	
	  
	  var errArr = [];
    errArr[0] = "operateObj";
    openErrPage("../../../../../page/", data.getError(), errArr);    	 
    
    if (OPRSUCC == data.getError().getGlobleECode()|| OPRPART == data.getError().getGlobleECode()) 
    {
	       doQueryPolicyItem();
    }
    else
    {
    	  $("deletePolicyItemBtn").disabled = !btnRightArr.deletePolicyItemBtn.right;
    	  $("clearFlapBtn").disabled = !btnRightArr.clearFlapBtn.right;
    }	
	
}


/** 
* Set policy item flap
*/
function sendApplyPolicyItem()
{
	
    var xmlstr = createApplyPolicyItemXml();
    if(xmlstr == null)
    {
    	return;
    }
	  
	  $("createPolicyItemBtn").disabled = true;
	  $("deletePolicyItemBtn").disabled = true;
	  $("applyPolicyItemBtn").disabled = true;
	  $("clearFlapBtn").disabled = true;
	  
    urlreq ="../../../../../neExlorerServlet?sfid="+TECMD_BGP_POLICY_SET_FLAP+""+"&nmUser="+winurlobj["nmUser"];
    loadXMLdoc(urlreq, "POST",true,handleBackAApplyPolicyItem,null,"inputdata="+xmlstr);  	
  	
  	
}


function handleBackAApplyPolicyItem(doc)
{
	 $("createPolicyItemBtn").disabled = !btnRightArr.createPolicyItemBtn.right;
	 $("clearFlapBtn").disabled = !btnRightArr.clearFlapBtn.right;
	 $("deletePolicyItemBtn").disabled = !btnRightArr.deletePolicyItemBtn.right;
    
	  var data = EncapsulateData(doc);
    for(var i = 0, len = data.getBErrLength();i < len;i++)
	  {
	  	  var tempObj = data.getError().rowErrors[i].errorObj;
    		tempObj["operateObj"] = RESOURCE["applyPolicyItem"] + "," + RESOURCE["policyItemID"] + ":" + tempObj["policyItemID"];
	  }	
	  
	  var errArr = [];
    errArr[0] = "operateObj";
    openErrPage("../../../../../page/", data.getError(), errArr);    	 
    
    if (OPRSUCC == data.getError().getGlobleECode()) 
    {
	       refreshTableState(st1,window.tableconf[1],data);
    }
    else
    {
        $("applyPolicyItemBtn").disabled = !btnRightArr.applyPolicyItemBtn.right;    	 
    }	
	
}

function createApplyPolicyItemXml()
{
	  di = new inputxml("datainterface");
    bussiness = new tagElement("bussiness-params");
    var row;
    var param;
    var prefPlyMode;
    var prefPlyValue;
    var flag = false;
    
    for(var i=0,length = st1.getDataRowLength();i<length;i++)
    {
        if(!st1.getModify(i))
        {
        	continue;
        }
	      row = new tagElement("row-params"); 	
	   		    
	      param = new tagElement("param");
	      param.setAttribute("name","neid");
	      param.setAttribute("value",winurlobj["neid"]);
	      row.appendChild(param);	
	      
	      param = new tagElement("param"); 
    		param.setAttribute("name","policyID");
    		param.setAttribute("value",getSelectedPolicyID());
    		row.appendChild(param);
     
	      param = new tagElement("param");
	      param.setAttribute("name","policyItemID");
	      param.setAttribute("value",st1.getCellStoreValue(i,"policyItemID","policyItemID"));
	      row.appendChild(param);

        if (st1.getCellModify(i, "attenurestrain")||st1.getCellModify(i, "attenurestore")||st1.getCellModify(i, "upperlimit")
            ||st1.getCellModify(i, "routehalflife")||st1.getCellModify(i, "noroutehalflife"))
         {
               var attenurestrain = st1.getCellStoreValue(i,"attenurestrain","attenurestrain");
              if(attenurestrain == INVALIDE_VALUE)
              {
              	 alert(RESOURCE["attenurestrain"]+RESOURCE["invalidvalue"]);
                 return null;	
              }
              param = new tagElement("param");
              param.setAttribute("name","attenurestrain");
              param.setAttribute("value",attenurestrain);
              row.appendChild(param);        
              
              var attenurestore =st1.getCellStoreValue(i,"attenurestore","attenurestore");
              if(attenurestore == INVALIDE_VALUE)
              {
              	 alert(RESOURCE["attenurestore"]+RESOURCE["invalidvalue"]);
                 return null;	
              }        
              param = new tagElement("param");
              param.setAttribute("name","attenurestore");
              param.setAttribute("value",attenurestore);
              row.appendChild(param);    	      
      
              var upperlimit =st1.getCellStoreValue(i,"upperlimit","upperlimit");
              if(upperlimit == INVALIDE_VALUE)
              {
              	 alert(RESOURCE["upperlimit"]+RESOURCE["invalidvalue"]);
                 return null;	
              }   
              param = new tagElement("param");
              param.setAttribute("name","upperlimit");
              param.setAttribute("value",upperlimit);
              row.appendChild(param);    
      
              var routehalflife =st1.getCellStoreValue(i,"routehalflife","routehalflife");
              if(routehalflife == INVALIDE_VALUE)
              {
              	 alert(RESOURCE["routehalflife"]+RESOURCE["invalidvalue"]);
                 return null;	
              }   
              param = new tagElement("param");
              param.setAttribute("name","routehalflife");
              param.setAttribute("value",routehalflife);
              row.appendChild(param);    
      
              var noroutehalflife =st1.getCellStoreValue(i,"noroutehalflife","noroutehalflife");
              if(noroutehalflife == INVALIDE_VALUE)
              {
              	 alert(RESOURCE["noroutehalflife"]+RESOURCE["invalidvalue"]);
                 return null;	
              }           
              param = new tagElement("param");
              param.setAttribute("name","noroutehalflife");
              param.setAttribute("value",noroutehalflife);
              row.appendChild(param);                    	     
              
              attenurestore = parseInt(attenurestore);
              attenurestrain = parseInt(attenurestrain);
              upperlimit =parseInt(upperlimit);
      
         		  if(!((attenurestore < attenurestrain) && (attenurestrain < upperlimit)))
      		    {
      			   	alert(RESOURCE["flaplimit"]);
      				 	return;
      				}            
         }						
	  	   if (st1.getCellModify(i, "localprefpolicy")||st1.getCellModify(i, "localpref"))
	       {
  	 	      	prefPlyMode = st1.getCellStoreValue(i,"localprefpolicy","localprefpolicy");
              param = new tagElement("param");
              param.setAttribute("name", "localprefpolicy");
              param.setAttribute("value", prefPlyMode);
              row.appendChild(param); 
              
     		      prefPlyValue =  st1.getCellStoreValue(i,"localpref","localpref");
              param = new tagElement("param");
              param.setAttribute("name", "localpref");
              param.setAttribute("value", (NOSUPPORT_VALUE==prefPlyValue||DEFAULT_PREFPOLICY==prefPlyMode)?DEFAULT_PREF:prefPlyValue);
              row.appendChild(param);   					  					
     		}    	      	      
     		
        param = new tagElement("param");
        param.setAttribute("name", "flagprefpolicy");
        param.setAttribute("value", "0");
        row.appendChild(param);   					  					
     		
   	    bussiness.appendChild(row);
    }
    di.getRoot().appendChild(bussiness);      
    return di.toString();		
}


function addIPFilterPolicyRecord(dinterface)
{
	
     processIpFilterPolicyData(dinterface);
	      
     createTableBody(st2, window.tableconf[2], dinterface, RESOURCE);
}


function addPolicyItemRecord(dinterface)
{
     preProcessData(dinterface); 
	   
     createTableBody(st1, window.tableconf[1], dinterface, RESOURCE);
     
     addMidTableCellEvent();	
}

/**
 *          
 */
function sendApplyInfo()
{
	 var xmlstr = createApplyPolicyXml();
    if(xmlstr == null)
    {
    	return;
    }	  
	  $("querybtn").disabled = true;
	  $("createbtn").disabled = true;
	  $("applybtn").disabled = true;
	  $("deletebtn").disabled = true;
	  
    urlreq ="../../../../../neExlorerServlet?sfid="+TECMD_BGP_MODI_POLICY+""+"&nmUser="+winurlobj["nmUser"];
    loadXMLdoc(urlreq, "POST",true,handleBackAApplyPolicy,null,"inputdata="+xmlstr);  	
  	
}

function createApplyPolicyXml()
{
	di = new inputxml("datainterface");
    bussiness = new tagElement("bussiness-params");
    var row;
    var param;
    logString = "";
    for(var i=0,length = st.getDataRowLength();i<length;i++)
    {
        if(!st.getModify(i))
        {
        	continue;
        }
	    row = new tagElement("row-params"); 	
	   		    
	    param = new tagElement("param");
	    param.setAttribute("name","neid");
	    param.setAttribute("value",winurlobj["neid"]);
	    row.appendChild(param);	
	      
	    param = new tagElement("param"); 
  		param.setAttribute("name","policyID");
  		param.setAttribute("value",st.getCellStoreValue(i,"policyID","policyID"));
  		row.appendChild(param);     
        stuffLog(RESOURCE["policyID"], st.getCellStoreValue(i, "policyID", "policyID"));
	    param = new tagElement("param"); 
    	param.setAttribute("name","policyName");
    	param.setAttribute("value",st.getCellStoreValue(i,"policyName","policyName"));
    	row.appendChild(param);     	      	      
    	
    	stuffLog(RESOURCE["policyName"], st.getCellStoreValue(i, "policyName", "policyName"));
    	
        var param = new tagElement("param");
        param.setAttribute("name", "opDesc");
        param.setAttribute("value", logString);
        row.appendChild(param);
	    bussiness.appendChild(row);
    }
    
    di.getRoot().appendChild(bussiness);    
    
    return di.toString();		
}

function handleBackAApplyPolicy(doc)
{   
	  var data = EncapsulateData(doc);
    for(var i = 0, len = data.getBErrLength();i < len;i++)
	  {
	  	  var tempObj = data.getError().rowErrors[i].errorObj;
    		tempObj["operateObj"] = RESOURCE["policyID"] + ":" + tempObj["policyID"];
	  }	
	  
	  var errArr = [];
    errArr[0] = "operateObj";
    openErrPage("../../../../../page/", data.getError(), errArr);    	 
    
    if (OPRSUCC == data.getError().getGlobleECode()) 
    {
	       refreshTableState(st,window.tableconf[0],data);
    }
    else
    {
        $("applybtn").disabled = !btnRightArr.applybtn.right;    	 
    }	
	
	$("querybtn").disabled = !btnRightArr.querybtn.right;
	$("createbtn").disabled = !btnRightArr.createbtn.right;
	if (st.getSelectedRowCount() > 0)
	{
	  	$("deletebtn").disabled = !btnRightArr.deletebtn.right;
	}
}

function checkInputData(obj, maxlen){
    obj.onkeyup = function(){
        return calStrSinoLen(this, maxlen);
    }
}
/**
 * add table cell event
 */
function addCellEvent(){
    for (var i = 0, len = st.getDataRowLength(); i < len; i++) {
        checkInputData( st.getCell(i, "policyName").element.editElement.element,POLICY_NAME_MAXLENGTH);
    }
}

function stuffLog(key, value)
{
	if(logString != "")	 
	{
		logString += "," ;
	}
	logString += key + ":" + value;
}

function cellEditHandler(param)
{
	$("applybtn").disabled = !btnRightArr.applybtn.right;
}
