var winurlobj = window.parent;
var neid = winurlobj.winurlobj["neid"];
var nmUser = winurlobj.winurlobj["nmUser"];
var btnRightArr = new Object();
var OPRSUCC = 0;
var OPRPART = 1;
var FAIL = 2;
var st;
var selectedRowID = 0;
var tc;

function initPage()
{
    createTable();
    initButtonText();
    
    if (winurlobj.btnRightArr.querybtn.right) 
    {
        winurlobj.sendQueryInfo();
    } 
}

function createTable()
{
    st = new SortTable();
    st.head.setAttribute("id", "htmlTableIBGPRemoteAddrTHead");
    st.body.setAttribute("id", "htmlTableIBGPRemoteAddrTBody");
    st.setImage("../../../../../images/");
    tc = window.tableconf[0];
	st.isUsedForSelectList = true;
    createTableHead(st, tc);
    st.setOnRowSelectHandler(rowSelectedHandler);
    st.setBodyHeight("180px");
    st.element.style.width = "100%";
    $("tablearea").appendChild(st.getTable());
    $("tablearea").oncontextmenu = popupMenuHandler;
}

function initButtonText()
{
    $("createAddrBtn").value = RESOURCE["newbutton"];
    $("deleteAddrBtn").value = RESOURCE["deletebutton"];
    
    btnRightArr.createAddrBtn = new BtnRightObj("createAddrBtn", TECMD_BGP_ADD_PEERGR_MEMBER);
    btnRightArr.deleteAddrBtn = new BtnRightObj("deleteAddrBtn", TECMD_BGP_DEL_PEERGR_MEMBER);
    
    getRightInfo(winurlobj.winurlobj, btnRightArr);
}

function rowSelectedHandler()
{
    if (st.getSelectedRowCount() > 0) 
    {
        $("deleteAddrBtn").disabled = !btnRightArr.deleteAddrBtn.right;
    }
    else 
    {
        $("deleteAddrBtn").disabled = true;
    }
}

function tabSelectHandler()
{    
    sendQueryInfo();
}

function sendQueryInfo()
{
    var xmlstr = createQueryXml();
    if (null == xmlstr)
    {
        return;
    }
    
    $("createAddrBtn").disabled = true;
    $("deleteAddrBtn").disabled = true;
    
    urlreq = "../../../../../neExlorerServlet?sfid=" + TECMD_BGP_GET_PEERGR_MEMBER + "&nmUser=" + nmUser;
    loadXMLdoc(urlreq, "POST", false, handleBackQuery, null, "inputdata=" + xmlstr);
}

function createQueryXml()
{
    var peergroup = winurlobj.getSelectedPeerGroup();
        
    if (peergroup.length == 0) 
    {
        return null;
    }
    
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var row = new tagElement("row-params");
    
    var param = new tagElement("param");
    param.setAttribute("name", "neid");
    param.setAttribute("value", neid);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "ibgpID");
    param.setAttribute("value", peergroup[0]);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "peerGroupID");
    param.setAttribute("value", peergroup[1]);
    row.appendChild(param);
    
    
    bussiness.appendChild(row);
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

function handleBackQuery(doc)
{
    $("createAddrBtn").disabled = !btnRightArr.createAddrBtn.right;
    
    data = EncapsulateData(doc);
    
    if (data.getError().rowErrors[0]) 
    {
        var size = data.getBErrLength();
        for (var i = 0; i < size; i++) 
        {
            var tempObj = data.getError().rowErrors[i].errorObj;
            tempObj["operateObj"] = RESOURCE["queryRemoteAddr"];
        }
    }
    
    var errArr = [];
    errArr[0] = "operateObj";
    openErrPage("../../../../../page/", data.getError(), errArr);
    
    if (OPRSUCC == data.getError().getGlobleECode() || OPRPART == data.getError().getGlobleECode()) 
    {
        for (var i = 0, len = data.getDataRowLength(); i < len; i++) 
        {
            var ptag = new ParamTag();
            var tempStr = data.getDataRowParam(i, "remotePeerAddr");
            ptag.value = convertHexIpAddrtoTen(tempStr);
            data.rows[i]["remotePeerAddr"] = ptag;
        }
        
        st.clearTableData();
        createTableBody(st, tc, data, RESOURCE);
    }
}


function sendDeleteAddrInfo()
{
    if (!confirm(RESOURCE["Delete_Hint"])) 
    {
        return;
    }
    
    $("createAddrBtn").disabled = true;
    $("deleteAddrBtn").disabled = true;
    
    var xmlstr = createDeleteAddrXML();
    if (xmlstr == null) 
    {
        return;
    }
    
    urlreq = "../../../../../neExlorerServlet?sfid=" + TECMD_BGP_DEL_PEERGR_MEMBER + "&nmUser=" + nmUser;
    loadXMLdoc(urlreq, "POST", true, handleBackDeleteAddr, null, "inputdata=" + xmlstr);
}

function createDeleteAddrXML()
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    
    var peergroup = winurlobj.getSelectedPeerGroup();
    if (peergroup.length == 0) 
    {
        return null;
    }
    
    for (var i = 0, len = st.getDataRowLength(); i < len; i++) 
    {
        if (st.getRowSelFlag(i)) 
        {
            var row = new tagElement("row-params");
            
            var param = new tagElement("param");
            param.setAttribute("name", "neid");
            param.setAttribute("value", neid);
            row.appendChild(param);
            
            param = new tagElement("param");
            param.setAttribute("name", "ibgpID");
            param.setAttribute("value", peergroup[0]);
            row.appendChild(param);
            
            param = new tagElement("param");
            param.setAttribute("name", "peerGroupID");
            param.setAttribute("value", peergroup[1]);
            row.appendChild(param);
            
            param = new tagElement("param");
            param.setAttribute("name", "remotePeerAddr");
            param.setAttribute("value", convertIpaddrToHexcode(st.getCellStoreValue(i, "remotePeerAddr", "remotePeerAddr")));
            row.appendChild(param);
            
            bussiness.appendChild(row);
        }
    }
    
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

function handleBackDeleteAddr(doc)
{
    $("createAddrBtn").disabled = !btnRightArr.createAddrBtn.right;
    
    var data = EncapsulateData(doc);
    for (var i = 0, len = data.getBErrLength(); i < len; i++) 
    {
        var tempObj = data.getError().rowErrors[i].errorObj;
        tempObj["operateObj"] = RESOURCE["deleteRemoteAddr"];
    }
    
    var errArr = [];
    errArr[0] = "operateObj";
    openErrPage("../../../../../page/", data.getError(), errArr);
    
    if (OPRSUCC == data.getError().getGlobleECode() || OPRPART == data.getError().getGlobleECode()) 
    {
        for (var i = 0, len = st.getDataRowLength(); i < len; i++) 
        {
            if (st.getRowSelFlag(i)) 
            {
                st.deleteRow(i);
            }
        }
        st.adjustDataRows();
    }
    else 
    {
        $("deleteAddrBtn").disabled = !btnRightArr.deleteAddrBtn.right;
    }
}

function sendCreateAddrInfo()
{
    xshowModalDialog("createremoteaddr.html", RESOURCE["createRemoteAddr"], 400, 200, "../../../../../images/");
}

function appendrowtotable(dinterface)
{
    createTableBody(st, tc, dinterface, RESOURCE);
}

function clearTableData()
{
    $("createAddrBtn").disabled = true;
    $("deleteAddrBtn").disabled = true;
    
    st.clearTableData();
}

function getSelectedPeerGroup()
{
    return winurlobj.getSelectedPeerGroup();
}
