var winurlobj = window.parent;
var neid = winurlobj.winurlobj["neid"];
var nmUser = winurlobj.winurlobj["nmUser"];
var btnRightArr = new Object();
var OPRSUCC = 0;
var OPRPART = 1;
var FAIL = 2;
var st;
var selectedRowID = 0;
var tc;
var RDType_AS = 0;
var RDType_IPV4 = 1;

function initPage()
{
    createTable();
    initButtonText();
}

function createTable()
{
    st = new SortTable();
    st.head.setAttribute("id", "htmlTableIBGPRDFilterPolicyTHead");
    st.body.setAttribute("id", "htmlTableIBGPRDFilterPolicyTBody");
    st.setImage("../../../../../images/");
    tc = window.tableconf[0];
	st.isUsedForSelectList = true;
    createTableHead(st, tc);
    st.setOnRowSelectHandler(rowSelectedHandler);
    st.setBodyHeight("80px");
    st.element.style.width = "100%";
    $("tablearea").appendChild(st.getTable());
    $("tablearea").oncontextmenu = popupMenuHandler;
}

function initButtonText()
{
    $("createBtn").value = RESOURCE["newbutton"];
    $("deleteBtn").value = RESOURCE["deletebutton"];
    
    $("createBtn").disabled = true;
    $("deleteBtn").disabled = true;
    
    btnRightArr.createBtn = new BtnRightObj("createBtn", TECMD_BGP_POLICY_ADD_RD);
    btnRightArr.deleteBtn = new BtnRightObj("deleteBtn", TECMD_BGP_POLICY_DEL_RD);
    
    getRightInfo(winurlobj.winurlobj, btnRightArr);
    initrightbtn(btnRightArr);
}

function rowSelectedHandler()
{
    if (st.getSelectedRowCount() > 0) 
    {
        $("deleteBtn").disabled = !btnRightArr.deleteBtn.right;
    }
    else 
    {
        $("deleteBtn").disabled = true;
    }
}

function tabSelectHandler()
{    
    sendQueryInfo();
}

function sendQueryInfo()
{
    var xmlstr = createQueryFilterPolicyXml();
    if (null == xmlstr)
    {
        return;
    }
    
    $("createBtn").disabled = true;
    $("deleteBtn").disabled = true;
    
    urlreq = "../../../../../neExlorerServlet?sfid=" + TECMD_BGP_POLICY_GET_RD + "&nmUser=" + nmUser;
    loadXMLdoc(urlreq, "POST", false, handleBackQueryFilterPolicy, null, "inputdata=" + xmlstr);   
}

function createQueryFilterPolicyXml()
{
    var selectedPolicyID = winurlobj.getSelectedPolicyID();
    var selectedPolicyItemID = winurlobj.getSelectedPolicyItemID();
    if (selectedPolicyID == -1 || selectedPolicyItemID == -1)
    {
        clearTableData();
        return null;
    }
    
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var row = new tagElement("row-params");
    
    var param = new tagElement("param");
    param.setAttribute("name", "neid");
    param.setAttribute("value", neid);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "policyID");
    param.setAttribute("value", selectedPolicyID);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "policyItemID");
    param.setAttribute("value", selectedPolicyItemID);
    row.appendChild(param);
    
    bussiness.appendChild(row);
    di.getRoot().appendChild(bussiness);
    return di.toString();
    
}

function handleBackQueryFilterPolicy(doc)
{
    $("createBtn").disabled = !btnRightArr.createBtn.right;
    data = EncapsulateData(doc);    
    
    var errArr = [];
    errArr[0] = "nename";
    openErrPage("../../../../../page/", data.getError(), errArr);
    
    if (OPRSUCC == data.getError().getGlobleECode() || OPRPART == data.getError().getGlobleECode()) 
    {
        processFilterPolicyData(data);
        st.clearTableData();
        createTableBody(st, tc, data, RESOURCE);        
    }    
}

function processFilterPolicyData(data)
{
    for (var i = 0, len = data.getDataRowLength(); i < len; i++) 
    {
        var ptag = new ParamTag();
        
        if (RDType_AS == data.getDataRowParam(i, "rdType"))
        {
            ptag.value =  data.getDataRowParam(i, "rdAdministrator") + ":" + data.getDataRowParam(i, "rdAssignedNumber");
        }
        else
        {
            var tempStr = data.getDataRowParam(i, "rdAdministrator");
            ptag.value = convertNumToIpaddr(tempStr) + ":" + data.getDataRowParam(i, "rdAssignedNumber");
        }
        data.rows[i]["rdfilterpolicy"] = ptag;        
    }
}

function sendCreateFilterPolicy()
{
    xshowModalDialog("createrdfilterpolicy.html", RESOURCE["createRDFilterPolicy"], 450, 160, "../../../../../images/");
}

function sendDeleteFilterPolicy()
{
    if (!confirm(RESOURCE["modifyHint"])) 
    {
        return;
    }
    
    $("createBtn").disabled = true;
    $("deleteBtn").disabled = true;
    
    var xmlstr = createDeleteFilterPolicyXML();
    
    urlreq = "../../../../../neExlorerServlet?sfid=" + TECMD_BGP_POLICY_DEL_RD  + "&nmUser=" + nmUser;
    loadXMLdoc(urlreq, "POST", true, handleBackDeleteFilterPolicy, null, "inputdata=" + xmlstr);
}


function createDeleteFilterPolicyXML()
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    
    for (var i = 0, len = st.getDataRowLength(); i < len; i++) 
    {
        if (st.getRowSelFlag(i)) 
        {
            var row = new tagElement("row-params");
            
            var param = new tagElement("param");
            param.setAttribute("name", "neid");
            param.setAttribute("value", neid);
            row.appendChild(param);
            
            param = new tagElement("param");
            param.setAttribute("name", "policyID");
            param.setAttribute("value", st.getCellStoreValue(i, "policyID", "policyID"));
            row.appendChild(param);
            
            param = new tagElement("param");
            param.setAttribute("name", "policyItemID");
            param.setAttribute("value", st.getCellStoreValue(i, "policyItemID", "policyItemID"));
            row.appendChild(param);
            
            param = new tagElement("param");
            param.setAttribute("name", "rdType");
            param.setAttribute("value", st.getCellStoreValue(i, "rdType", "rdType"));
            row.appendChild(param);
            
            param = new tagElement("param");
            param.setAttribute("name", "rdAdministrator");
            param.setAttribute("value", st.getCellStoreValue(i, "rdAdministrator", "rdAdministrator"));
            row.appendChild(param);
            
            param = new tagElement("param");
            param.setAttribute("name", "rdAssignedNumber");
            param.setAttribute("value", st.getCellStoreValue(i, "rdAssignedNumber", "rdAssignedNumber"));
            row.appendChild(param);
    
            var opDesc = RESOURCE["policyID"] + ":" + st.getCellStoreValue(i, "policyID", "policyID") + " " + 
                         RESOURCE["policyItemID"] + ":" + st.getCellStoreValue(i, "policyItemID", "policyItemID") + " " + 
                         RESOURCE["rdFilterPolicy"] + ":" + st.getCellStoreValue(i, "rdfilterpolicy", "rdfilterpolicy");
                
            param = new tagElement("param");
            param.setAttribute("name","opDesc");
            param.setAttribute("value",opDesc);
            row.appendChild(param);; 
            
            bussiness.appendChild(row);
        }
    }
    
    di.getRoot().appendChild(bussiness);
    return di.toString();
}


function handleBackDeleteFilterPolicy(doc)
{
    $("createBtn").disabled = !btnRightArr.createBtn.right;
    
    var data = EncapsulateData(doc);
    var errArr = [];
    errArr[0] = "nename";
    openErrPage("../../../../../page/", data.getError(), errArr);
    
    if (OPRSUCC == data.getError().getGlobleECode()) 
    {
        for (var i = 0, len = st.getDataRowLength(); i < len; i++) 
        {
            if (st.getRowSelFlag(i)) 
            {
                st.deleteRow(i);
            }
        }
        st.adjustDataRows();
    }
    else 
    {
        $("deleteBtn").disabled = !btnRightArr.deleteBtn.right;
        
        sendQueryInfo();
    }
}

function clearTableData()
{
    st.clearTableData();
    
    $("createBtn").disabled = true;
    $("deleteBtn").disabled = true;
}

function addFilterPolicyRecord(dinterface)
{
     createTableBody(st, tc, dinterface, RESOURCE);
}

