var winurlobj = window.parent;
var neid = winurlobj.winurlobj["neid"];
var nmUser = winurlobj.winurlobj["nmUser"];
var btnRightArr = new Object();
var OPRSUCC = 0;
var OPRPART = 1;
var FAIL = 2;
var st;
var selectedRowID = 0;
var tc;

var matchIpType = new Object();
matchIpType[1] = "NLRI";
matchIpType[2] = "SOURCE";
matchIpType[3] = "NEXTHOP";

function initPage()
{
    createTable();
    initButtonText();
}


function createTable()
{
    st = new SortTable();
    st.head.setAttribute("id", "htmlTableIBGPIpFilterPolicyTHead");
    st.body.setAttribute("id", "htmlTableIBGPIpFilterPolicyTBody");
    st.setImage("../../../../../images/");
    tc = window.tableconf[0];
	st.isUsedForSelectList = true;
    createTableHead(st, tc);
    st.setOnRowSelectHandler(lowTableRowSelectedHandler);
    st.setBodyHeight("80px");
    st.element.style.width = "100%";
    $("tablearea").appendChild(st.getTable());
    $("tablearea").oncontextmenu = popupMenuHandler;
}

function initButtonText()
{
    $("createBtn").value = RESOURCE["newbutton"];
    $("deleteBtn").value = RESOURCE["deletebutton"];
    
    $("createBtn").disabled = true;
    $("deleteBtn").disabled = true;
    
    btnRightArr.createBtn = new BtnRightObj("createBtn", TECMD_BGP_DEL_POLICY_ITEM);
    btnRightArr.deleteBtn = new BtnRightObj("deleteBtn", TECMD_BGP_DEL_POLICY_ITEM);
    
    getRightInfo(winurlobj.winurlobj, btnRightArr);
}

function lowTableRowSelectedHandler()
{
    if (st.getSelectedRowCount() > 0) 
    {
        $("deleteBtn").disabled = !btnRightArr.deleteBtn.right;
        
    }
    else 
    {
        $("deleteBtn").disabled = true;
    }
}

function tabSelectHandler()
{    
    sendQueryInfo();
}

function sendQueryInfo()
{
    var xmlstr = createQueryFilterPolicyXml();
    if (null == xmlstr)
    {
        return;
    }
    
    $("createBtn").disabled = true;
    $("deleteBtn").disabled = true;
    
    urlreq = "../../../../../neExlorerServlet?sfid=" + TECMD_BGP_POLICY_GET_IP_PRE + "" + "&nmUser=" + nmUser;
    loadXMLdoc(urlreq, "POST", false, handleBackQueryFilterPolicy, null, "inputdata=" + xmlstr);
    
}


function createQueryFilterPolicyXml()
{
    var selectedPolicyID = winurlobj.getSelectedPolicyID();
    var selectedPolicyItemID = winurlobj.getSelectedPolicyItemID();
    if (selectedPolicyID == -1 || selectedPolicyItemID == -1)
    {
        clearTableData();
        return null;
    }
    
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var row = new tagElement("row-params");
    
    var param = new tagElement("param");
    param.setAttribute("name", "neid");
    param.setAttribute("value", neid);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "policyID");
    param.setAttribute("value", selectedPolicyID);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "policyItemID");
    param.setAttribute("value", selectedPolicyItemID);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "matchIpType");
    param.setAttribute("value", "0");
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "ipFilterPolicyID");
    param.setAttribute("value", "0");
    row.appendChild(param);
    
    bussiness.appendChild(row);
    di.getRoot().appendChild(bussiness);
    return di.toString();
    
}

function handleBackQueryFilterPolicy(doc)
{

    $("createBtn").disabled = !btnRightArr.createBtn.right;
    
    data = EncapsulateData(doc);
    
    if (data.getError().rowErrors[0]) 
    {
        var size = data.getBErrLength();
        for (var i = 0; i < size; i++) 
        {
            var tempObj = data.getError().rowErrors[i].errorObj;
            tempObj["operateObj"] = RESOURCE["queryIPFilterPolicy"];
        }
    }
    
    var errArr = [];
    errArr[0] = "operateObj";
    openErrPage("../../../../../page/", data.getError(), errArr);
    
    if (OPRSUCC == data.getError().getGlobleECode() || OPRPART == data.getError().getGlobleECode()) 
    {
        processIpFilterPolicyData(data);
        
        st.clearTableData();
        
        createTableBody(st, tc, data, RESOURCE);        
    }    
}

function processIpFilterPolicyData(data)
{
    for (var i = 0, len = data.getDataRowLength(); i < len; i++) 
    {
        var ptag = new ParamTag();
        var tempStr = data.getDataRowParam(i, "filteredIpAddr");
        ptag.value = parseInt("0x" + tempStr.substring(0, 2)) + "." +
        parseInt("0x" + tempStr.substring(2, 4)) +
        "." +
        parseInt("0x" + tempStr.substring(4, 6)) +
        "." +
        parseInt("0x" + tempStr.substring(6, 8));
        data.rows[i]["filteredIpAddr"] = ptag;
        
    }
}

function sendCreateIpFilterPolicy()
{
    xshowModalDialog("createipfilterpolicy.html", RESOURCE["createIPFilterPolicy"], 450, 300, "../../../../../images/");
}

function sendDeleteIpFilterPolicy()
{
    if (!confirm(RESOURCE["Delete_Hint"])) 
    {
        return;
    }
    
    $("createBtn").disabled = true;
    $("deleteBtn").disabled = true;
    
    var xmlstr = createDeleteFilterPolicyXML();
    
    urlreq = "../../../../../neExlorerServlet?sfid=" + TECMD_BGP_POLICY_DEL_IP_PRE + "" + "&nmUser=" + nmUser;
    loadXMLdoc(urlreq, "POST", true, handleBackDeleteFilterPolicy, null, "inputdata=" + xmlstr);
}


function createDeleteFilterPolicyXML()
{

    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    
    
    for (var i = 0, len = st.getDataRowLength(); i < len; i++) 
    {
        if (st.getRowSelFlag(i)) 
        {
            var row = new tagElement("row-params");
            
            var param = new tagElement("param");
            param.setAttribute("name", "neid");
            param.setAttribute("value", neid);
            row.appendChild(param);
            
            param = new tagElement("param");
            param.setAttribute("name", "policyID");
            param.setAttribute("value", winurlobj.getSelectedPolicyID());
            row.appendChild(param);
            
            param = new tagElement("param");
            param.setAttribute("name", "policyItemID");
            param.setAttribute("value", winurlobj.getSelectedPolicyItemID());
            row.appendChild(param);
            
            param = new tagElement("param");
            param.setAttribute("name", "matchIpType");
            param.setAttribute("value", st.getCellStoreValue(i, "matchIpType", "matchIpType"));
            row.appendChild(param);
            
            param = new tagElement("param");
            param.setAttribute("name", "ipFilterPolicyID");
            param.setAttribute("value", st.getCellStoreValue(i, "ipFilterPolicyID", "ipFilterPolicyID"));
            row.appendChild(param);
            
            bussiness.appendChild(row);
        }
    }
    
    di.getRoot().appendChild(bussiness);
    return di.toString();
}


function handleBackDeleteFilterPolicy(doc)
{

    $("createBtn").disabled = !btnRightArr.createBtn.right;
    
    var data = EncapsulateData(doc);
    for (var i = 0, len = data.getBErrLength(); i < len; i++) 
    {
        var tempObj = data.getError().rowErrors[i].errorObj;
        tempObj["operateObj"] = RESOURCE["deleteIPFilterPolicy"];
    }
    
    var errArr = [];
    errArr[0] = "operateObj";
    openErrPage("../../../../../page/", data.getError(), errArr);
    
    if (OPRSUCC == data.getError().getGlobleECode()) 
    {
        for (var i = 0, len = st.getDataRowLength(); i < len; i++) 
        {
            if (st.getRowSelFlag(i)) 
            {
                st.deleteRow(i);
            }
        }
        st.adjustDataRows();
    }
    else 
    {
        $("deleteBtn").disabled = !btnRightArr.deleteBtn.right;
        
        sendQueryInfo();
    }
}

function clearTableData()
{
    st.clearTableData();
    
    $("createBtn").disabled = true;
    $("deleteBtn").disabled = true;
}

function addIPFilterPolicyRecord(dinterface)
{	
     processIpFilterPolicyData(dinterface);
	      
     createTableBody(st, tc, dinterface, RESOURCE);
}

function getSelectedPolicyID()
{
    return winurlobj.getSelectedPolicyID();
}

function getSelectedPolicyItemID()
{
    return winurlobj.getSelectedPolicyItemID();
}

