
var winurlobj = getParentWindow();
var neid = winurlobj.winurlobj["neid"];
var OPRSUCC = 0;
var okFlag = false;
var ct;
var MIN = "1";
var MAX = "65535";
var asNumberObj = new Object();
var PUBLIC_NET = "4294967295";

function initpage()
{
    initButtonText();
    ct = new CTable();
    ct.addHead(RESOURCE["attributeName"], RESOURCE["attributeValue"]);
    
    var atom = new Atom("select");
    atom.element.setAttribute("id", "htmlTableSelectIbgpPeerIbgpIDTBody");
    atom.element["onchange"] = function()
    {
        $("applybtn").disabled = false;
        ct.setAttrValue("remoteAS", asNumberObj[this.value]);
    }
    ct.addAttrRow("ibgpID", RESOURCE["ibgpID"], atom);
    
    atom = new Atom("text");
    atom.element.setAttribute("id", "htmlTableTextIbgpPeerRemoteIPTBody");
    validateIp(atom.element);
    atom.element.style.imeMode = "disabled";
    atom.element["onblur"] = function()
    {
        if (!check_IPaddr(this.value)) 
        {
            this.value = "0.0.0.0";
            $("applybtn").disabled = false;
        }
    }
    atom.setValue("0.0.0.0");
    ct.addAttrRow("remoteIP", RESOURCE["remoteIP"], atom);
    ct.attrArray["remoteIP"].element.onkeydown = setButtonStatus;
    
    atom = new Atom("text");
    atom.element.setAttribute("id", "htmlTableTextIbgpPeerRemoteASTBody");
    atom.element.disabled = true;
    ct.addAttrRow("remoteAS", RESOURCE["remoteAS"], atom);
    
    document.body.insertBefore(ct.getTable(), document.body.firstChild);
    
    getIBGPData();
}

function setButtonStatus()
{
		$("applybtn").disabled = false;
		
}

function getIBGPData()
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var row = new tagElement("row-params");
    
    var param = new tagElement("param");
    param.setAttribute("name", "neid");
    param.setAttribute("value", neid);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "ibgpID");
    param.setAttribute("value", "0");
    row.appendChild(param);
    
    bussiness.appendChild(row);
    di.getRoot().appendChild(bussiness);
    
    urlreq = "../../../../../neExlorerServlet?sfid=" + TE_QUERY_IBGP_PROTOCOL + "" + "&nmUser=" + winurlobj["nmUser"];
    loadXMLdoc(urlreq, "POST", false, handleBackQuery, null, "inputdata=" + di.toString());
}

function handleBackQuery(doc)
{
    var data = EncapsulateData(doc);
    
    for (var i = 0, len = data.getBErrLength(); i < len; i++) 
    {
        var tempObj = data.getError().rowErrors[i].errorObj;
        tempObj["operateObj"] = RESOURCE["queryArp"];
    }
    
    var errArr = [];
    errArr[0] = "operateObj";
    openErrPage("../../../../../page/", data.getError(), errArr);
    
    if (OPRSUCC == data.getSErrorCode()) 
    {
        var ibgpIDAtom = ct.getAtom("ibgpID");
        for (var i = 0, len = data.getDataRowLength(); i < len; i++) 
        {
            if (data.getDataRowParam(i, "serviceID") != PUBLIC_NET) 
            {
                continue;
            }
            var protocolID = data.getDataRowParam(i, "ibgpID");
            ibgpIDAtom.addOption(protocolID, protocolID);
            asNumberObj[protocolID] = data.getDataRowParam(i, "asNumber");
        }
        
        if (ibgpIDAtom.element.length == 0) 
        {
            alert(RESOURCE["noProtocol"]);
            xcloseDialog();
            return;
        }
        else 
        {
            ct.setAttrValue("remoteAS", asNumberObj[ct.getAttrValue("ibgpID")]);
        }
    }
}

function initButtonText()
{
    $("okbtn").value = RESOURCE["okbutton"];
    $("cancelbtn").value = RESOURCE["cancelbutton"];
    $("applybtn").value = RESOURCE["applybutton"];
    $("applybtn").disabled = false;
}

function sendCreateInfo(buttonFlag)
{
    okFlag = buttonFlag;
    if ($("applybtn").disabled && okFlag) 
    {
        xcloseDialog();
        return;
    }
    
    if (!check_IPaddr(ct.getAttrValue("remoteIP"))) 
    {
        return;
    }
    
    $("okbtn").disabled = true;
    $("applybtn").disabled = true;
    
    var xmlstr = createXML();
    
    urlreq = "../../../../../neExlorerServlet?sfid=" + TE_CREATE_IBGP_PROTOCOL_PEER + "" + "&nmUser=" + winurlobj.winurlobj["nmUser"];
    loadXMLdoc(urlreq, "POST", true, handleBackCreate, null, "inputdata=" + xmlstr);
}

function createXML()
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var row = new tagElement("row-params");
    
    var param = new tagElement("param");
    param.setAttribute("name", "neid");
    param.setAttribute("value", neid);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "flag");
    param.setAttribute("value", "0");
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "ibgpID");
    param.setAttribute("value", ct.getAttrValue("ibgpID"));
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "slotid");
    param.setAttribute("value", 0xFFFF);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "subslotid");
    param.setAttribute("value", 0xFF);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "port");
    param.setAttribute("value", 0xFFFF);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "remoteIP");
    param.setAttribute("value", convertIpaddrToHexcode(ct.getAttrValue("remoteIP")));
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "remoteAS");
    param.setAttribute("value", ct.getAttrValue("remoteAS"));
    row.appendChild(param);
    
    bussiness.appendChild(row);
    
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

function handleBackCreate(doc)
{
    $("okbtn").disabled = false;
    
    var data = EncapsulateData(doc);
    if (OPRSUCC == data.getSErrorCode()) 
    {
        winurlobj.sendQueryInfo();
        
        if (okFlag) 
        {
            xcloseDialog();
        }
    }
    else 
    {
        $("applybtn").disabled = false;
        if (data.getError().rowErrors[0]) 
        {
            var size = data.getBErrLength();
            for (var i = 0; i < size; i++) 
            {
                var tempObj = data.getError().rowErrors[i].errorObj;
                tempObj["createPeer"] = RESOURCE["createPeer"];
            }
        }
        var errArr = [];
        errArr[0] = "createPeer";
        openErrPage("../../../../../page/", data.getError(), errArr);
    }
}
