
var winurlobj = getParentWindow();
var neid = winurlobj.winurlobj["neid"];
var OPRSUCC = 0;
var okFlag = false;
var ct;
var MIN_ROUTEID = "1";
var MAX_ROUTEID = "65535";
var usableBoardArr = new Array();
var INVALID_SLOTID = INVALID_SLOT_PTN;
var MACARRAYLEN = 6;
var MACLEN = 2;

function initPage()
{
    initButtonText();
    ct = new CTable();
    ct.addHead(RESOURCE["attribute"], RESOURCE["value"]);
    
    var atom = new Atom("text");
    atom.element.setAttribute("id", "htmlText_arpipCreateearp");  
    atom.element.style.imeMode = "disabled";
    atom.element["onkeypress"] = function()
    {
        if (!restrict(this, event, "0123456789.")) 
        {
            return false;
        }
        return true;
    }
    atom.element["onchange"] = function()
    {
        $("applybtn").disabled = false;
    }
    atom.element["onblur"] = function()
    {
        if (!check_IPaddr(this.value)) 
        {
            this.value = "0.0.0.0";
        }
    }
	atom.setValue("0.0.0.0");
    ct.addAttrRow("arpip", RESOURCE["arpip"], atom);
    
    var atom = new Atom("text");
    atom.element.setAttribute("id", "htmlText_arpmacCreateearp");      
    atom.element.style.imeMode = "disabled";
    atom.element["onkeypress"] = function()
    {
        if (!restrict(this, event, "0123456789abcdefABCDEF-")) 
        {
            return false;
        }
        return true;
    }
    atom.element["onchange"] = function()
    {
        $("applybtn").disabled = false;
    }
    atom.element["onblur"] = function()
    {
        if (!checkMAC(this.value)) 
        {
            this.value = "00-00-00-00-00-00";
        }
    }
	atom.setValue("00-00-00-00-00-00");
    ct.addAttrRow("arpmac", RESOURCE["arpmac"], atom);
    
    document.body.insertBefore(ct.getTable(), document.body.firstChild);
}

function checkMAC(strparam)
{
    var ipAddressArray = strparam.split("-");
    
    if (MACARRAYLEN != ipAddressArray.length) 
    {
        alert(RESOURCE["wrongMAC"]);
        return false;
    }
    
    for (var i = 0, len = ipAddressArray.length; i < len; i++) 
    {
        if (MACLEN != ipAddressArray[i].length) 
        {
            alert(RESOURCE["wrongMAC"]);
            return false;
        }
    }
    
    return true;
}

function initButtonText()
{
    $("okbtn").value = RESOURCE["submitbtn"];
    $("cancelbtn").value = RESOURCE["cancelbtn"];
    $("applybtn").value = RESOURCE["applybtn"];
}

function doCreate(buttonFlag)
{
    okFlag = buttonFlag;
    if ($("applybtn").disabled && okFlag) 
    {
        xcloseDialog();
        return;
    }
    
    if (!checkDataValid()) 
    {
        return;
    }
    
    $("okbtn").disabled = true;
    $("applybtn").disabled = true;
    
    var xmlstr = createXML();
    
    urlreq = "../../../../../neExlorerServlet?sfid=" + TE_CREATE_ADDRESS_PARSE + "" + "&nmUser=" + winurlobj.winurlobj["nmUser"];
    loadXMLdoc(urlreq, "POST", true, handleBackCreate, null, "inputdata=" + xmlstr);
}

function checkDataValid()
{
    if (!check_IPaddr(ct.getAttrValue("arpip"))) 
    {
        return false;
    }
    if (!checkMAC(ct.getAttrValue("arpmac"))) 
    {
        return false;
    }
    return true;
}

function createXML()
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var row = new tagElement("row-params");
    
    var param = new tagElement("param");
    param.setAttribute("name", "neid");
    param.setAttribute("value", neid);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "arpip");
    param.setAttribute("value", convertIpaddrToHexcode(ct.getAttrValue("arpip")));
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "arpmac");
    param.setAttribute("value", convertMAC(ct.getAttrValue("arpmac")));
    row.appendChild(param);
    
    bussiness.appendChild(row);
    
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

function convertMAC(strparam)
{
    var ipAry = strparam.split("-");
    var rs = "";
    for (var i = 0; i < ipAry.length; i++) 
    {
        rs += ipAry[i];
    }
    return rs;
}

function handleBackCreate(doc)
{
    $("okbtn").disabled = false;
    
    var data = EncapsulateData(doc);
    if (OPRSUCC == data.getSErrorCode()) 
    {
        winurlobj.sendQueryInfo();
        
        if (okFlag) 
        {
            xcloseDialog();
        }
    }
    else 
    {
        $("applybtn").disabled = false;
        if (data.getError().rowErrors[0]) 
        {
            var size = data.getBErrLength();
            for (var i = 0; i < size; i++) 
            {
                var tempObj = data.getError().rowErrors[i].errorObj;
                tempObj["addArp"] = RESOURCE["addArp"];
            }
        }
        var errArr = [];
        errArr[0] = "addArp";
        openErrPage("../../../../../page/", data.getError(), errArr);
    }
}
