var winurlobj = getNeProperty(parent);
var btnRightArr = new Object();
var st;
var OPRSUCC = 0;
var PARTSUCC = 1;
var neid = winurlobj["neid"];
var DCLS = "1";
var PPS = "2";

var extinterfacemode = new Object();
extinterfacemode["1"] = "outerClock";
extinterfacemode["2"] = "outerTime";
extinterfacemode["3"] = "power";
extinterfacemode["4"] = "nullClock";

var interfacedirection = new Object();
interfacedirection["1"] = "ingress";
interfacedirection["2"] = "egress";

var protocoltype = new Object();
protocoltype["1"] = "DCLS";
protocoltype["2"] = "PPS";

var interfaceletricity = new Object();
interfaceletricity["1"] = "TTL";
interfaceletricity["2"] = "RS232";
interfaceletricity["3"] = "RS422";

var acPowerMonitorProtocolStatus = new Object();
acPowerMonitorProtocolStatus["0"] = "DOWN";
acPowerMonitorProtocolStatus["1"] = "UP";

var mode_clock = "1";
var mode_ptptime = "2";
var mode_powerinput = "3";
var mode_powernull = "4";
var non_editable = [mode_clock,mode_powerinput,mode_powernull]; 
var powerInputMode_PortList = [1,7,11,13,21,23,37];

var extinterfacemodeMap = new Object();

function tabSelectHandler()
{
    if (st == null)
    {
        init();
    }
    
    if(btnRightArr.querybtn.right)
    {
	    query();
	}   
}

window.onresize = function()
{
    st.setBodyHeight(getComponetHeight($("tablecomponent"), 70) + "px");
}

function init()
{
    st = new SortTable();
	  st.head.setAttribute("id", "htmlTable_SortTableHead_basicattri");
    st.body.setAttribute("id", "htmlTable_SortTableBody_basicattri");
    st.setImage("../../../../images/");
    tc = window.tableconf[0];
    createTableHead(st, tc);
    st.setOnCellEditHandler(cellEditHandler);
    st.setBodyHeight(getComponetHeight($("tablecomponent"), 70) + "px");
    $("tablecomponent").appendChild(st.getTable());
    
    $("querybtn").value = RESOURCE["querybutton"];
    $("applybtn").value = RESOURCE["applybutton"];
    $("querybtn").disabled = true;
    $("applybtn").disabled = true; 	
    btnRightArr.querybtn = new BtnRightObj("querybtn", TECMDCODE_QUERY_PTP_BASICATTRIBUTE);
    btnRightArr.applybtn = new BtnRightObj("applybtn", TECMDCODE_SET_PTP_BASICATTRIBUTE);
    
    getRightInfo(winurlobj, btnRightArr);
    
    if (btnRightArr.querybtn.right) 
    {
        query();
    }
}

function cellEditHandler(param)
{
    $("applybtn").disabled = !btnRightArr.applybtn.right;

    var rowindex = param.rowindex;
    if ((winurlobj.neversion.indexOf(".59.") >= 0 || SpecialAttrMgr.isNESupport(neid,"TE_FUNC_CFG_PTPCLOCK_EXTERN_TIME","TE_ATTR_PTN_OUTTIMEINF_INFELC"))
     && param.colid == "interfaceletricity") 
    {
        var cellEdit = st.getCellEdit(rowindex, "interfaceletricity");
        var portid = st.getCellStoreValue(rowindex, "portid", "port");
        cellEdit.clearOptions();
        if (portid == "1")
        {
            cellEdit.addOption("TTL", 1);
        
            if (st.getCellStoreValue(rowindex, "protocoltype", "protocoltype") == PPS)
            {
                cellEdit.addOption("RS232", 2);
            }
        }
        else
        {
        	  cellEdit.addOption("RS422", 3);
        }
    }
    
    if(ver.indexOf("5.94.") >= 0 && ver >= "5.94.03.40" || SpecialAttrMgr.isNESupport(neid,"TE_FUNC_CFG_PTPCLOCK_EXTERN_TIME","TE_ATTR_PTN_OUTTIMEINF_INFMODE1"))
    {
    	var cellEdit = st.getCellEdit(rowindex, "extinterfacemode");
        var portid = st.getCellStoreValue(rowindex, "portid", "port");
        cellEdit.clearOptions();
        
    	if(portid == "1")
    	{
    		cellEdit.addOption(RESOURCE["outerClock"] ,1);
    		cellEdit.addOption(RESOURCE["power"] ,3);
    	}
    	else if(portid == "2")
    	{
    		cellEdit.addOption(RESOURCE["outerTime"] ,2);
            cellEdit.addOption(RESOURCE["power"] ,3);
    		cellEdit.addOption(RESOURCE["nullClock"] ,4);
    	}
    }
    
    if(ver.indexOf("5.65.") >= 0 && ver >= "5.65.05.10" || SpecialAttrMgr.isNESupport(neid,"TE_FUNC_CFG_PTPCLOCK_EXTERN_TIME","TE_ATTR_PTN_OUTTIMEINF_INFMODE2"))
    {
    	var cellEdit = st.getCellEdit(rowindex, "extinterfacemode");
        var portid = st.getCellStoreValue(rowindex, "portid", "port");
        cellEdit.clearOptions();
        if(portid == "1")
    	{
    		cellEdit.addOption(RESOURCE["outerClock"] ,1);
    		cellEdit.addOption(RESOURCE["outerTime"] ,2);
            cellEdit.addOption(RESOURCE["power"] ,3);
    	}
        else if(portid == "2")
    	{
    		cellEdit.addOption(RESOURCE["outerClock"] ,1);
    		cellEdit.addOption(RESOURCE["outerTime"] ,2);
            cellEdit.addOption(RESOURCE["power"] ,3);
    		cellEdit.addOption(RESOURCE["nullClock"] ,4);
    	}
    }
}

function query()
{
    $("querybtn").disabled = true;
    $("applybtn").disabled = true;
    
    var xmlstr = createQueryXML();
    var urlreq = "../../../../neExlorerServlet?sfid=" + TECMDCODE_QUERY_PTP_BASICATTRIBUTE + "&nmUser=" + winurlobj["nmUser"];
    loadXMLdoc(urlreq, "POST", false, handleBackQuery, null, "inputdata=" + xmlstr);
}

function createQueryXML()
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var row = new tagElement("row-params");
    
    var param = new tagElement("param");
    param.setAttribute("name", "neid");
    param.setAttribute("value", winurlobj["neid"]);
    row.appendChild(param);
    bussiness.appendChild(row);
    
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

function handleBackQuery(doc)
{
    $("querybtn").disabled = false;
    
    var data = EncapsulateData(doc);
    
    for (var i = 0, len = data.getBErrLength(); i < len; i++) 
    {
        var tempObj = data.getError().rowErrors[i].errorObj;
        tempObj["operateObj"] = RESOURCE["queryBaseAttr"];
    }
    
    var errArr = [];
    errArr[0] = "operateObj";
    openErrPage("../../../../page/", data.getError(), errArr);
    
    if (OPRSUCC == data.getSErrorCode() || PARTSUCC == data.getSErrorCode()) 
    {
        for (var i = 0, len = data.getDataRowLength(); i < len; i++) 
        {
            var row = data.rows[i];
            row["portname"].value = RESOURCE["outerTime"] + row["port"].value;
        }
        
        st.clearTableData();
        createTableBody(st, window.tableconf[0], data, RESOURCE);
        
        for (var i = 0, len = st.getDataRowLength(); i < len; i++) 
        {
        	extinterfacemodeMap[st.getCellElement(i, "outerTime").innerText] = 
        		st.getCellStoreValue(i, "extinterfacemode", "extinterfacemode");
        	
            var value = st.getCellStoreValue(i, "portid", "port");
            
            var cpcell = st.getCellElement(i, "interfacedirection");
            if (non_editable.contains(st.getCellStoreValue(i, "extinterfacemode", "extinterfacemode"))) 
            {
                st.setCellIsEdit(cpcell,0); 
                cpcell.modify = false;
                st.setAtomValue(cpcell.showElement, "/");
            }
            
            var cpcel2 = st.getCellElement(i, "protocoltype");
            if (non_editable.contains(st.getCellStoreValue(i, "extinterfacemode", "extinterfacemode"))) 
            {
                st.setCellIsEdit(cpcel2,0); 
                cpcel2.modify = false;
                st.setAtomValue(cpcel2.showElement, "/");
            }
            
            var cpcel3 = st.getCellElement(i, "interfaceletricity");
            if (non_editable.contains(st.getCellStoreValue(i, "extinterfacemode", "extinterfacemode")))
            {
                st.setCellIsEdit(cpcel3,0); 
                cpcel3.modify = false;
                st.setAtomValue(cpcel3.showElement, "/");
            }
            
            var cpcel4 = st.getCellElement(i, "acPowerMonitorProtocolStatus");
            if ((cpcel4 != null) && (st.getCellStoreValue(i, "extinterfacemode", "extinterfacemode") != mode_powerinput))
            {
            	cpcel4.modify = false;
            	st.setAtomValue(cpcel4.showElement, "/");
            }            
        }
        
        addCellEvent();
    }
}


function addCellEvent()
{
    var cell = null;
    for (var i = 0, len = st.getDataRowLength(); i < len; i++) 
    {
    	if(winurlobj.neversion.indexOf(".86.") >= 0 || winurlobj.neversion.indexOf(".87.") >= 0)
    	{
    		var opts = st.getCellEdit(i, "interfaceletricity").element.options;
    		for(var ci = opts.length - 1; ci >=0; ci--)
    		{
    			if(opts.item(ci).innerText == "TTL" || opts.item(ci).innerText == "RS232")
    			{
    				opts.remove(ci);
    			}
    		}
    	}    	    	
    	
        cell = st.getCell(i, "extinterfacemode");        
        cell.element.editElement.element["onchange"] = function()
        {
            var rowindex = this.parentNode.parentNode.rowIndex;
            var cpcell = st.getCell(rowindex, "interfacedirection");
            if (this.value == "2") 
            {
                st.setCellIsEdit(cpcell,1); 
                cpcell.element.showElement.setValue(RESOURCE["egress"]);
                st.setCellValue(cpcell, "interfacedirection", "2");
            }
            else 
            {
                st.setCellIsEdit(cpcell,0); 
                cpcell.element.showElement.setValue("/");
            }
            
            var cpcel2 = st.getCell(rowindex, "protocoltype");
            if (this.value == "2") 
            {
                st.setCellIsEdit(cpcel2,1); 
                if ((winurlobj.neversion.indexOf(".58.") >= 0 && winurlobj.neversion >= "5.58.02.31") ||
                (winurlobj.neversion.indexOf(".59.") >= 0 && winurlobj.neversion >= "5.59.02.31") ||
                (winurlobj.neversion.indexOf(".78.") >= 0 && winurlobj.neversion >= "5.78.02.31") ||
                (winurlobj.neversion.indexOf(".64.") >= 0 && winurlobj.neversion >= "5.64.02.11") ||
                (winurlobj.neversion.indexOf(".65.") >= 0 && winurlobj.neversion >= "5.65.02.11") ||
                (winurlobj.neversion.indexOf(".91.") >= 0 && winurlobj.neversion >= "5.91.03.30") || 
                (winurlobj.neversion.indexOf(".94.") >= 0 && winurlobj.neversion >= "5.94.03.40") ||
                SpecialAttrMgr.isNESupport(neid,"TE_FUNC_CFG_PTPCLOCK_EXTERN_TIME","TE_ATTR_PTN_OUTTIMEINF_PROTOTYPE")) 
                {
                    cpcel2.element.showElement.setValue(RESOURCE["PPS"]);
                    st.setCellValue(cpcel2, "protocoltype", "2");
                }
                else 
                {
                    cpcel2.element.showElement.setValue(RESOURCE["DCLS"]);
                    st.setCellValue(cpcel2, "protocoltype", "1");
                }
            }
            else 
            {
                st.setCellIsEdit(cpcel2,0); 
                cpcel2.element.showElement.setValue("/");
            }
            
            portid = st.getCellStoreValue(rowindex, "portid", "port");
            var cpcel3 = st.getCell(rowindex, "interfaceletricity");
            if (this.value == "2") 
            {
                st.setCellIsEdit(cpcel3,1); 
                if ((winurlobj.neversion.indexOf(".59.") >= 0  
                || SpecialAttrMgr.isNESupport(neid,"TE_FUNC_CFG_PTPCLOCK_EXTERN_TIME","TE_ATTR_PTN_OUTTIMEINF_INFELC"))
                 && "1" == portid) 
                {
                    cpcel3.element.showElement.setValue(RESOURCE["TTL"]);
                    st.setCellValue(cpcel3, "interfaceletricity", "1");
                }
                else 
                {
                    cpcel3.element.showElement.setValue(RESOURCE["RS422"]);
                    st.setCellValue(cpcel3, "interfaceletricity", "3");
                }
            }
            else 
            {
                st.setCellIsEdit(cpcel3,0); 
                cpcel3.element.showElement.setValue("/");
            }
            if(this.value=="2")
            {
            	cpcell.element.modify=true;
            	cpcell.modify=true;            	
            	cpcell.element.style.backgroundColor= "#d0f946";
            	cpcel2.element.modify=true;
            	cpcel2.modify=true;            	
            	cpcel2.element.style.backgroundColor= "#d0f946";
            	cpcel3.element.modify=true;
            	cpcel3.modify=true;            	
            	cpcel3.element.style.backgroundColor= "#d0f946";
            }      
            
        }
        
        if (winurlobj.neversion.indexOf(".59.") >= 0 || SpecialAttrMgr.isNESupport(neid,"TE_FUNC_CFG_PTPCLOCK_EXTERN_TIME","TE_ATTR_PTN_OUTTIMEINF_INFELC"))
        {
        	  cell = st.getCell(i, "protocoltype");
            
            cell.element.editElement.element["onchange"] = function()
            {
                var rowindex = this.parentNode.parentNode.rowIndex;
                var portid = st.getCellStoreValue(rowindex, "portid", "port");
                var cpcell = st.getCell(rowindex, "interfaceletricity");
                if (portid == "1" && this.value == "1") 
                {
                    cpcell.element.showElement.setValue(RESOURCE["TTL"]);
                    st.setCellValue(cpcell, "interfaceletricity", "1");
                }
            }
        }        
    }
}

function apply()
{
    var xmlstr = createApplyXML();
    if (null == xmlstr) 
    {
        return;
    }
    
    $("querybtn").disabled = true;
    $("applybtn").disabled = true;
    
    var urlreq = "../../../../neExlorerServlet?sfid=" + TECMDCODE_SET_PTP_BASICATTRIBUTE + "&nmUser=" + winurlobj["nmUser"];
    loadXMLdoc(urlreq, "POST", true, handleBackApply, null, "inputdata=" + xmlstr);
}

function createApplyXML()
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    
    var isSetPowerInterface = false;	
    var port;
    var imode;
	var tempPort;
	var msg;
	
 	if ((ver.indexOf("5.64.") >= 0 && ver >= "5.64.05.10")
			|| (ver.indexOf("5.65.") >= 0 && ver >= "5.65.05.10")
			|| (ver.indexOf("5.94.") >= 0 && ver >= "5.94.03.40")
			|| SpecialAttrMgr.isNESupport(neid,"TE_FUNC_CFG_PTPCLOCK_EXTERN_TIME","TE_ATTR_PTN_OUTTIMEINF_ONEPOWER"))
	{
	    for (var rowindex = 0, length = st.getDataRowLength(); rowindex < length; rowindex++) 
	    {
	    	 imode = st.getCellStoreValue(rowindex, "extinterfacemode", "extinterfacemode");
	    	 if(imode == mode_powerinput)
		     {
		      	 if(isSetPowerInterface)
		      	 {
		      	     alert(RESOURCE["only_1_powerinput_can_select"].replace(1, ""));
		      	     return null;
		      	 }        
		      	 else
		      	 {
		      	     isSetPowerInterface = true;
		      	 } 	 
		     }
	    }
	}
	else
	{
	    for (var rowindex = 0, length = st.getDataRowLength(); rowindex < length; rowindex++) 
	    {
	    	 imode = st.getCellStoreValue(rowindex, "extinterfacemode", "extinterfacemode");
	    	 port = st.getCellStoreValue(rowindex, "portid", "port");
			 if(powerInputMode_PortList.contains(port))		 
			 {
			 	tempPort = port;
			 }
	    	 if(imode == mode_powerinput)
		     {
		      	 if(!powerInputMode_PortList.contains(port))
				 {
				     msg =RESOURCE["only_1_powerinput_can_select"].replace(1,tempPort)
		      	     alert(msg);
		      	     return null;
		      	 }
		      	 if(isSetPowerInterface)
		      	 {
		      	     alert(RESOURCE["only_1_powerinput_can_select"]);
		      	     return null;
		      	 }        
		      	 else
		      	 {
		      	     isSetPowerInterface = true;
		      	 } 	 
		     }
	    }
	}
 	
    var isNeedNotice = false;
    for (var rowindex = 0, length = st.getDataRowLength(); rowindex < length; rowindex++)
    {
        var outerTimeCellElement = st.getCellElement(rowindex, "outerTime");
        var eiModeCellElement = st.getCellElement(rowindex, "extinterfacemode");
        var eiMode = st.getCellStoreValue(rowindex, "extinterfacemode", "extinterfacemode");
        var srcEiMode = extinterfacemodeMap[outerTimeCellElement.innerText];
        	
        if (eiModeCellElement.modify && (srcEiMode == mode_powerinput) && (eiMode != mode_powerinput))
        {
        	isNeedNotice = true;
        	break;
        }
    }
    
    if (isNeedNotice)
    {
    	if (!confirm(RESOURCE["extinterfacemodeChangeNotice"]))
        {
            return null;
        }
    }
        
    var isInsertLast = false;
    var toBeenInserted = [];
    for (var rowindex = 0, length = st.getDataRowLength(); rowindex < length; rowindex++) 
    {
        if (!st.getModify(rowindex)) 
        {
            continue;
        }
        
        var row = new tagElement("row-params");
        
        var param = new tagElement("param");
        param.setAttribute("name", "neid");
        param.setAttribute("value", neid);
        row.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "slotid");
        param.setAttribute("value", st.getCellStoreValue(rowindex, "portid", "slotid"));
        row.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "subslotid");
        var subslotid = st.getCellStoreValue(rowindex, "portid", "subslotid");
        if (null == subslotid) 
        {
            subslotid = "255";
        }
        param.setAttribute("value", subslotid);
        row.appendChild(param);
        
        port = st.getCellStoreValue(rowindex, "portid", "port");
        param = new tagElement("param");
        param.setAttribute("name", "port");
        param.setAttribute("value", port);
        row.appendChild(param);
        
        if (st.getCellModify(rowindex, "extinterfacemode")) 
        {
        		imode = st.getCellStoreValue(rowindex, "extinterfacemode", "extinterfacemode");
            param = new tagElement("param");
            param.setAttribute("name", "extinterfacemode");
            param.setAttribute("value", imode);
            row.appendChild(param);
            if(imode == mode_powerinput)
	     			{
	     				isInsertLast = true;
	     			}
	     			else
	     			{
	     				isInsertLast = false;
	     			}
        }
        
        if ((st.getCellModify(rowindex, "interfacedirection") || st.getCellModify(rowindex, "protocoltype") ||
        st.getCellModify(rowindex, "interfaceletricity") )&&
        (2 == st.getCellStoreValue(rowindex, "extinterfacemode", "extinterfacemode"))) // add this condition for AU9D49663 
        {
            param = new tagElement("param");
            param.setAttribute("name", "interfacedirection");
            param.setAttribute("value", st.getCellStoreValue(rowindex, "interfacedirection", "interfacedirection"));
            row.appendChild(param);
            
            param = new tagElement("param");
            param.setAttribute("name", "protocoltype");
            param.setAttribute("value", st.getCellStoreValue(rowindex, "protocoltype", "protocoltype"));
            row.appendChild(param);
            
            param = new tagElement("param");
            param.setAttribute("name", "interfaceletricity");
            param.setAttribute("value", st.getCellStoreValue(rowindex, "interfaceletricity", "interfaceletricity"));
            row.appendChild(param);
        }
        
        if(isInsertLast)
        {
        	toBeenInserted.push(row);
        }
        else
        {
        	bussiness.appendChild(row);
        }
    }
    
    for(var index = 0,size = toBeenInserted.length; index < size; index++)
    {
    	bussiness.appendChild(toBeenInserted[index]);
    }
    
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

function handleBackApply(doc)
{
    $("querybtn").disabled = !btnRightArr.querybtn.right;
    
    var data = EncapsulateData(doc);
    
	$("applybtn").disabled = (OPRSUCC == data.getError().getGlobleECode());
    if (OPRSUCC != data.getError().getGlobleECode()) 
    {
        for (var i = 0, size = data.getBErrLength(); i < size; i++) 
        {
            var tempObj = data.getError().rowErrors[i].errorObj;
            tempObj["operateObj"] = RESOURCE["setBaseAttr"];
        }
        var errArr = [];
        errArr[0] = "operateObj";
        openErrPage("../../../../page/", data.getError(), errArr);
		return;
    }    
    refreshTableState(st, tc, data);
    for (var i = 0, length = st.getDataRowLength(); i < length; i++)
    {
    	var eiModeCellElement = st.getCellElement(i, "extinterfacemode");
    	if (!eiModeCellElement.modify)
    	{
    		var outerTimeElement = st.getCellElement(i, "outerTime");
    		extinterfacemodeMap[outerTimeElement.innerText] = st.getCellStoreValue(i, "extinterfacemode", "extinterfacemode");
    	}
    }
    
}
