var Months = new Array(" ", " ", " ", " ", " ", " ", " ", " ", " ", " ", "  ", "  ");
var DaysInMonth = new Array(31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31);
var Days = new Array(" ", " ", " ", " ", " ", " ", " ");

/*******************************************************
*      
*    year month         
*    divId        div   id
*    cssclassname           css class  
*******************************************************/
function showCalendar(year, month, divId, func)
{
    if(document.getElementById("caltable"))
    {
    	document.getElementById("caltable").parentNode.innerHTML = "";
    }
    if(month < 0 || month > 11)
    {
    	alert("       1-12  !");
    	return;
    }   
    var showCalDate = new Date(year, month, 1);
    var startDay = showCalDate.getDay();
    var showDaysInMonth = getDaysInMonth(showCalDate.getFullYear(), showCalDate.getMonth());
    var today = new Today();
    var daily = 0;
    var strCalTable = "<table border='0' cellpadding='0' cellspacing='1' class='Calendar' id='caltable'>" +
                      "<thead><tr align='center' valign='middle'><td colspan='7' class='Caltitle'>" + 
                      "<span onclick='frontMonth(\"" + divId + "\","+func+")' tiyle='   ' class='DayButton'>3</span>" + 
                      "<input id='year' name='year' type='text' size='4' maxlength='4' value='" + year + 
                      "' onkeydown='txtOnkeydn(\"" + divId +"\","+func+")' onkeyup='txtOnkeyup(this)' onpaste='txtOnkeyup(this)'> " + 
                      "<input id='month' name='month' type='text' size='1' maxlength='2' value='" + (month+1) + 
                      "' onkeydown='txtOnkeydn(\"" + divId +"\","+func+")' onkeyup='txtOnkeyup(this)' onpaste='txtOnkeyup(this)'> " +
                      "<span onclick='nextMonth(\"" + divId + "\","+func+")' title='   ' class='DayButton'>4</a></td></tr>";
    strCalTable += "<tr align='center' valign='middle'>";
    strCalTable += "<td class='DaySunTitle' id='diary'>" + Days[0] + "</td>"
    for(var weekloop = 1; weekloop < Days.length-1; weekloop++)
    {
        strCalTable += "<td class='DayTitle' id='diary'>" + Days[weekloop] + "</td>"
    }
    strCalTable += "<td class='DaySunTitle' id='diary'>" + Days[6] + "</td>"
    strCalTable += "</tr></thead><tbody border='1' cellspacing='0' cellpadding='0' id='calendar' align='center'>";
    for(var weeknum = 0; weeknum < 6; weeknum++)
    {
        strCalTable += "<tr style='cursor:hand'>";
        for(var intDays = 0; intDays < Days.length;intDays++)
        {
            if((intDays == startDay) && (0 == daily))
            { 
                daily = 1;
            }
            if((daily > 0) && (daily <= showDaysInMonth))
            {
                if(intDays == 0 || intDays ==6)
                {
                    strCalTable += "<td class='DaySun' onMouseover='mouseover()' onMouseOut='mouseout()' onclick='getDateAndTime(this,"+func+")'>" + daily + "</td>";
                }
                else
                {	
                    strCalTable += "<td class='Day' onMouseover='mouseover()' onMouseOut='mouseout()' onclick='getDateAndTime(this,"+func+")'>" + daily + "</td>";             
                }
                daily++;
            } 
            else
            {
                strCalTable += "<td class='CalendarTD' onMouseover='mouseover()' onMouseOut='mouseout()'></td>";             
            }
        }
        strCalTable += "</tr>";
    }
    strCalTable += "<tr><td colspan='7'><input type='text' id='time' style='width:100%' value='" + 
                   today.hour + ":" + today.minutes + ":" + today.second + 
                   "' /></td></tr></tbody></table>";
                     
    document.getElementById(divId).innerHTML = strCalTable;
}

/****************************
*      
*****************************/
function Today()
{
    this.now = new Date();
    this.year = this.now.getFullYear();
    this.month = this.now.getMonth();
    this.nowdate = this.now.getDate();
    this.day = this.now.getDay();
    
    this.hour = this.now.getHours();
    this.minutes = this.now.getMinutes();
    this.second = this.now.getSeconds();
}

/****************************************
*            
*    year month           
*****************************************/
function getDaysInMonth(year, month)
{
    if(1 == month)
    {
        return ((0 == year % 4) && (0 != (year % 100)) ||(0 == year % 400) ? 29 : 28);
    }
    else
    {
    	return DaysInMonth[month];
    }
}

/***************************************
*      
****************************************/
function frontMonth(divId, func)
{
    var year = document.getElementById("year").value;
    var month = document.getElementById("month").value;
    if((month - 1) < 1)
    {
        month = 11;
        year = year - 1;
    }    
    else
    {
        month = month - 2;
    }
    showCalendar(year, month, divId, func);
}

/***************************
*      
****************************/
function nextMonth(divId, func)
{
    var year = parseInt(document.getElementById("year").value);
    var month = parseInt(document.getElementById("month").value);
    if ((month + 1) > 12)
    {
        month = 0;
        year = year + 1;
    }
    showCalendar(year, month, divId, func);
}

/*************************************
*
***************************************/
function txtOnkeydn(divId, func)
{
    if(event.keyCode == 13)
    {
        var year = parseInt(document.getElementById("year").value);
        var month = parseInt(document.getElementById("month").value) - 1;
        showCalendar(year, month, divId, func);
    }
}

/***************************************
*****************************************/
function txtOnkeyup(divnode)
{
    divnode.value = divnode.value.replace(/[^0-9]/g,'');    
}

/********************************************
*********************************************/
function mouseover()
{
    var obj = window.event.srcElement;
    obj.runtimeStyle.cssText = "background-color:#FFFFFF";    
}

function mouseout()
{
    var obj = window.event.srcElement;
    window.setTimeout(function(){obj.runtimeStyle.cssText = "";},300); 
}

function getDateAndTime(divobj,func)
{
    var strTime = document.getElementById("year").value;
    if(document.getElementById("month").value < 10 && document.getElementById("month").value.length == 1)
    {
        strTime += "-" + "0" + document.getElementById("month").value;
    }
    else
    {
        strTime += "-" + document.getElementById("month").value;
    }
    if(divobj.innerHTML < 10)
    {
        strTime += "-" + "0" + divobj.innerHTML;
    }
    else
    {
        strTime += "-" + divobj.innerHTML;    
    }    
    var inputtime = document.getElementById("time").value;
    var pattern = /^\d{1,2}:\d{1,2}:\d{1,2}$/;
    if(pattern.test(inputtime))
    {
        var substrTime = inputtime.split(":");
        inputtime = "";
        flag = true;
        for(i = 0; i < substrTime.length; i++)
        {
            switch(i)
            {
                case 0: 
                {
                    if(substrTime[i] > 23)
                    {
                        flag = false    
                    }
                    break;                    
                }
                case 1:
                case 2:
                {
                    if(substrTime[i] > 59)
                    {
                        flag = false;
                    }
                    break;
                }  
            }
            if(flag == true)
            {
                if(substrTime[i] < 10 && substrTime[i].length == 1)
                {
                    substrTime[i] = "0" + substrTime[i];
                }
                if(i != 2)
                {
                    inputtime += substrTime[i] + ":";
                }
                else
                {
                    inputtime += substrTime[i];
                }
            }
            else
            {
                alert("       ");
                return;
            }        
        }
        strTime += " " + inputtime;
        func(strTime);    
    }
    else
    {
        alert("       ");
    }
}
