var st;
var rowIndex = null;
var vrfIndex, vrfId, vrfName, vrfRD;
var parobj = getParentWindow();
var neid = parobj.winurlobj.neid;

if(!isIE)
{
	if (parobj.frames.length > 3)
	{
		parobj = parobj.frames[parobj.frames.length - 2];
	}
    else
    {
    	parobj = parobj.frames[0];
    }
}

window.onload = function()
{
    initTable();
    initButtonInfo();
    queryVRFInfo();
}

/**
 *      
 */
function initTable()
{
    st = new SortTable();
    st.head.setAttribute("id", "htmlTableBfdVRFSelectTHead");
    st.body.setAttribute("id", "htmlTableBfdVRFSelectTBody");
    st.setImage("../../../../images/");
    createTableHead(st, window.tableconf[0]);
    st.setBodyHeight((getTableHeight($("vrfselecttable"), st) - 50) + "px");
    st.setOnRowSelectHandler(rowSelectHandler);
    st.setSingleChoiceFlg(true);
    $("vrfselecttable").appendChild(st.getTable());
}

/**
 *      
 */
function initButtonInfo()
{
    $("confirmbtn").value = RESOURCE["okbutton"];
    $("cancelbtn").value = RESOURCE["cancelbutton"];
}

function rowSelectHandler()
{
    var rows = st.getSelectedRows();
    if (rows.length <= 0) 
    {
        rowIndex = null;
        return;
    }
    rowIndex = rows[0];
    vrfIndex = st.getCellStoreValue(rowIndex, "vrfIndex", "vrfIndex");
    vrfId = st.getCellStoreValue(rowIndex, "vrfID", "vrfID");
    vrfName = st.getCellStoreValue(rowIndex, "name", "name");
    vrfRD = st.getCellStoreValue(rowIndex, "RDInfo", "RDInfo");
}

function queryVRFInfo()
{    
    var xmldata = createQueryXml();
    var urlstr = "../../../../neExlorerServlet?sfid=" + TECMDCODE_L3VPN_QUERY_VRF + "&flag=1&timestamp=" + new Date().getTime() + "&nmUser=" + parobj.winurlobj["nmUser"];
    loadXMLdoc(urlstr, "POST", false, callbackQuery, null, "inputdata=" + xmldata);
}

function createQueryXml()
{
    var root = new inputxml("datainterface");
    var business = new tagElement("bussiness-params");
    var row = new tagElement("row-params");
    
    var param = new tagElement("param");
    param.setAttribute("name", "neid");
    param.setAttribute("value", neid);
    row.appendChild(param);
    
    var param = new tagElement("param");
    param.setAttribute("name", "isLogFlag");
    param.setAttribute("value", "0");
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "vrfindex");
    param.setAttribute("value", 0);
    row.appendChild(param);
    
    business.appendChild(row);
    root.getRoot().appendChild(business);
    
    return root.toString();
}

function callbackQuery(doc)
{
    var data = EncapsulateData(doc);
    if (data.getSErrorCode() == 0 || data.getSErrorCode() == 1) 
    {
        st.clearTableData();
        createTableBody(st, window.tableconf[0], data, RESOURCE);
    }
}

function selectvrf(param)
{
    if (rowIndex == null) 
    {
        closeWindow(false);
        return;
    }
    else 
    {        
        var brdVRFValue;
        if (vrfIndex == "4294967295") 
        {
            brdVRFValue = vrfName;
            vrfId = "0";
        }
        else 
        {
            brdVRFValue = vrfId + "(" + vrfName + ")";
        }
        parobj.addbfdTable.setAttrValue("vrf", brdVRFValue);
        parobj.bfdvrfIndex = vrfIndex;
        parobj.bfdvrfId = vrfId;
        if (param) 
        {
            closeWindow();
        }
    }
}

function closeWindow()
{
    xcloseDialog();
}

window.onresize = function()
{
    if (document.body) 
    {
        st.setBodyHeight(getTableHeight($("tunnelselecttable"), st) + "px");
    }
}
