var parentWin = getParentWindow();
var bindPortTable;
var tunnelIndex = 0xffffffff;
var boardList = new Array(); //  BFD       
var portList = new Array(); //       
var winurlobj = parentWin.winurlobj;
if(parentWin.openBindType == "port")
{
    document.title = RESOURCE["bindport"];
}
else
{
    document.title = RESOURCE["bindtunnel"];
}
function init(){
    getEthBoard();
    initTable(); //     
    initBtn();
}

function getBoardList(){
    return boardList;
}

function getPortList(){
    return portList;
}


/**********************************
 *        
 ************************************/
function initTable(){
    bindPortTable = new CTable();//       
    bindPortTable.addHead(RESOURCE["property"], RESOURCE["value"]);
    var arrlen = null;
    
    atom = new Atom("select");
    atom.element.setAttribute("id", "htmlSelectBfdBindType");
    if(parentWin.openBindType == "port")
    {
    	atom.addOption(RESOURCE["port"], OBJTYPE_PORT);
    }
    else
    {
    	atom.addOption("GRE Tunnel", OBJTYPE_GRETUNNEL);
    	atom.addOption("IP Tunnel", OBJTYPE_IPTUNNEL);
    }
    bindPortTable.addAttrRow("bandtype", RESOURCE["bandtype"], atom);
    
    atom.element.onchange = actionTypeChange;
    
    var atom = new Atom("select");
    var tempList = getBoardList();
    atom.addOption("/", NOT_SUPPORT);
    for (var j = 0, len = tempList.length; j < len; j++) {
        atom.addOption(tempList[j], tempList[j]);
    }
    var urlAttr = this.location.search;
    var temp = urlAttr.split("-");
    if (urlAttr != "?/") {
        var boardAttr = temp[0].substring(1, temp[0].length);
        var board = boardAttr.split("-");
        for (var j = 0, len = tempList.length; j < len; j++) {
            var slot = tempList[j].split("-");
            if (slot[0] == board[0]) {
                atom.element.selectedIndex = j + 1;
            }
        }
    }
    atom.element.onchange = changeEvent;
    bindPortTable.addAttrRow("board", RESOURCE["board"], atom);

    if (bindPortTable.getAttrValue("board") != "") {
        var tempSlot = bindPortTable.getAttrValue("board").split("-");
        searchForPorts(tempSlot[0], "0", "0");
    }
    atom = new Atom("select");
    var portList = getPortList();
    atom.addOption("/", NOT_SUPPORT);
    
    for (var j = 0, len = portList.length; j < len; j++) {
        var tempAttr = portList[j].split(",");
        atom.addOption(tempAttr[0], tempAttr[1]);
    }
    var tempLength = temp.length - 1;
    if (temp[tempLength] != null) {
        temp[tempLength] = temp[tempLength].substring(0, temp[tempLength].length - 1);
        for (var j = 0, len = portList.length; j < len; j++) {
            var tempAttr = portList[j].split(",");
            if (temp[tempLength] == tempAttr[1]) {
                atom.element.selectedIndex = j + 1;
            }
        }
    }
    else {
        atom.element.disabled = true;
    }
    bindPortTable.addAttrRow("port", RESOURCE["port"], atom);
    atom = new Atom("text");
    atom.element.setAttribute("id", "htmlTextBfdTunnel");
    bindPortTable.addAttrRow("tunnel", "Tunnel", atom);
    
    var btnElem = document.createElement("input");
    btnElem.type = "button";
    btnElem.id = "selectTunnelbtn";
    btnElem.style.width = "30%";
    btnElem.className = "buttonstyle0";
    btnElem.value = "...";
    btnElem.onclick = handleTunnelSelect;
    
    bindPortTable.getAtom("tunnel").element.value = "";
    bindPortTable.getAtom("tunnel").element.style.width = "70%";
    bindPortTable.getAtom("tunnel").element.parentNode.appendChild(btnElem);
    bindPortTable.setAttrValue("tunnel", "/")
    actionTypeChange.apply(bindPortTable.getAtom("bandtype").element);
    
    if(parentWin.openBindType == "tunnel")
    {
    	bindPortTable.element.childNodes[1].childNodes[1].style.display = "none";
    	bindPortTable.element.childNodes[1].childNodes[2].style.display = "none";
    }
    else
    {
    	bindPortTable.element.childNodes[1].childNodes[3].style.display = "none";
    }
    $("componentcontainer").appendChild(bindPortTable.getTable());
    
}

/**
 * disable tunnel select in case of select tunnel type
 */
function actionTypeChange()
{
    var obj = this.value;
    
    if (obj == OBJTYPE_PORT) {
        bindPortTable.getAtom("board").element.disabled = false;
        bindPortTable.getAtom("port").element.disabled = false;
        bindPortTable.getAtom("tunnel").element.disabled = true;
        bindPortTable.getAtom("tunnel").element.parentNode.childNodes[1].disabled = true;
    }
    else {
        bindPortTable.getAtom("board").element.disabled = true;
        bindPortTable.getAtom("port").element.disabled = true;
        bindPortTable.getAtom("tunnel").element.disabled = true;
        bindPortTable.getAtom("tunnel").element.parentNode.childNodes[1].disabled = false;
    }
}

function handleTunnelSelect(){
    $("confirmbtn").disabled = false;
    
    xshowModalDialog("tunnelselect.html?flag=1", RESOURCE["tunnelselect"], 600, 400, "../../../../images/");
}

function changeEvent(){	
    var tempslot = this.value;
    if (tempslot == NOT_SUPPORT) {
        var ele = bindPortTable.getAtom("port");
        ele.clearOptions();
        ele.addOption("/", NOT_SUPPORT);
        ele.element.selectedIndex = 0;
        ele.element.disabled = true;
        return;
    }
    else {
        var ele = bindPortTable.getAtom("port");
        ele.element.disabled = false;
    }
    var slot = tempslot.split("-");
    searchForPorts(slot[0], "0", "0");
    var portList = getPortList();
    var atom = bindPortTable.getAtom("port");
    atom.clearOptions();
    for (var j = 0, len = portList.length; j < len; j++) {
        var tempAttr = portList[j].split(",");
        atom.addOption(tempAttr[0], tempAttr[1]);
    }
}

/**********************************
 *     
 ************************************/
function searchForPorts(slotid, subslotid, querytype){
    var xml = createPortXML(slotid, subslotid, querytype);
    
    var URL = "../../../../neExlorerServlet?sfid=" + TECMDCODE_GET_VLANFIBDB + "" + "&nmUser=" + winurlobj["nmUser"];
    
    loadXMLdoc(URL, "POST", false, getPortsCallBack, null, "inputdata=" + xml);
}

/**********************************
 *        BFD     
 ************************************/
function getEthBoard(){
    var xml = createXML();
    
    var URL = "../../../../neExlorerServlet?sfid=" + TE_CMD_PTN_RMON_GET_HISTORY_CTRL + "" + "&nmUser=" + winurlobj["nmUser"];
    
    loadXMLdoc(URL, "POST", false, getBoardsCallBack, null, "inputdata=" + xml);
}

/**********************************
 *          
 ************************************/
function getBoardsCallBack(doc){
    var data = EncapsulateData(doc);
    for (var i = 0, len = data.getDataRowLength(); i < len; i++) {
        boardList[i] = data.getDataRowParam(i, "sourceboard");
    }   
   
}

/**********************************
 *          
 ************************************/
function getPortsCallBack(doc){
    var data = EncapsulateData(doc);
    portList = new Array();
    for (var i = 0, len = data.getDataRowLength(); i < len; i++) {
        portList[i] = data.getDataRowParam(i, "portList");
    }
}

/**********************************
 *   XML,       
 ************************************/
function createXML(){
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var row = new tagElement("row-params");
    var param = new tagElement("param");
    
    var neid = winurlobj["neid"];
    param.setAttribute("name", "neid");
    param.setAttribute("value", winurlobj["neid"]);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "queryType");
    param.setAttribute("value", "0");
    row.appendChild(param);
    
    bussiness.appendChild(row);
    di.getRoot().appendChild(bussiness);
    return di.toString();
}



/**********************************
 *   XML,       
 ************************************/
/**********************************
 *   XML,       
 ************************************/
function createPortXML(slotid, subslotid, querytype){
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var row = new tagElement("row-params");
    var param = new tagElement("param");
    
    var neid = winurlobj["neid"];
    param.setAttribute("name", "neid");
    param.setAttribute("value", winurlobj["neid"]);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "slotid");
    param.setAttribute("value", slotid);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "subslotid");
    param.setAttribute("value", subslotid);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "querytype");
    param.setAttribute("value", querytype);
    row.appendChild(param);
    
    bussiness.appendChild(row);
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

/**********************************
 *                
 ************************************/
function initBtn(){
    $("confirmbtn").value = RESOURCE["confirmbtn"];
    $("cancelbtn").value = RESOURCE["cancelbtn"];
}

function confirm(){
    var childst = parentWin.st;
    var cell = childst.getCell(parentWin.rowSelected, parentWin.openBindType);
    if (bindPortTable.getAttrValue("bandtype") != 3) {
        parentWin.bindType = 1;
        cell.element.style.backgroundColor = "#d0f946";
        childst.setCellValue(cell, "tunnel", tunnelIndex);
        if (bindPortTable.getAttrValue("tunnel") == "" || bindPortTable.getAttrValue("tunnel") == "/") 
        {
            childst.setAtomValue(cell.element.showElement, "/");
        }
        else
        {
        	var tunnelType = "GRE Tunnel";
        	if(bindPortTable.getAttrValue("bandtype") == 2)
        	{
        		tunnelType = "IP Tunnel";
        	}
            childst.setAtomValue(cell.element.showElement, tunnelType + ":" + bindPortTable.getAttrValue("tunnel"));
        }
    }
    else {
        parentWin.bindType = 3;
        var sendValue = bindPortTable.getAttrValue("board") + "-" + bindPortTable.getAtom("port").element.options[bindPortTable.getAtom("port").element.selectedIndex].text;
        var sendStoreValue = bindPortTable.getAttrValue("board").split("-")[0] + "," + bindPortTable.getAttrValue("port");
        
        cell.element.style.backgroundColor = "#d0f946";
        if (bindPortTable.getAttrValue("board") == NOT_SUPPORT) {
            childst.setCellValue(cell, "port", "65535,65535");
            childst.setAtomValue(cell.element.showElement, "/");
        }
        else {
            childst.setCellValue(cell, "port", sendStoreValue);
            childst.setAtomValue(cell.element.showElement, sendValue);
        }
    }
    parentWin.document.getElementById("setStatus").disabled = false;
    xcloseDialog();
}
