var winurlobj = getNeProperty(self);
var rowSelected;
var neid = winurlobj["neid"];
var btnRightArr = new Object();

var st = null;
var bindType = null;
var openBindType = null;

function init()
{
    st = new SortTable();
    st.head.setAttribute("id", "htmlTablebfdforpwTHead");
    st.body.setAttribute("id", "htmlTablebfdforpwTBody");
    st.setImage("../../../../images/");
    st.setBodyHeight("400px");
    createTableHead(st, window.tableconf[0]);
    st.setOnCellEditHandler(valueChanged);
    document.getElementById("bodytable").appendChild(st.getTable());
    st.setBodyHeight(getTableHeight(document.getElementById("bodytable"), st) + "px");
    st.setOnRowSelectHandler(deleteRow);
    document.getElementById("totalrow").innerText = RESOURCE["total"] + ":"
    document.getElementById("selrow").innerText = RESOURCE["selected"] + ":"
    initButton();
    
    if (btnRightArr.querybtn.right) 
    {
        sendQueryInfo();
    }
}

function deleteRow(indexArr)
{
    if (indexArr.length > 0) 
    {
        document.getElementById("deletebtn").disabled = !btnRightArr.deletebtn.right;
    }
    else 
    {
        document.getElementById("deletebtn").disabled = true;
    }
    document.getElementById("selrownum").innerText = "" + st.getSelectedRows().length;
}

function deleteData()
{
    hideMenu();
    if (st.getSelectedRowCount()) 
    {
        var rowindex = st.getSelectedRows();
        if (confirm(RESOURCE["deleteconfirm"])) 
        {
            var di = new inputxml("datainterface");
            var bp = new tagElement("bussiness-params");
            for (var i = rowindex.length - 1; i >= 0; i--) 
            {
                var row = new tagElement("row-params");
                var param = new tagElement("param");
                param.setAttribute("name", "neid");
                param.setAttribute("value", winurlobj["neid"]);
                row.appendChild(param);
                
                var param = new tagElement("param");
                var sessionIndex = st.getCellStoreValue(rowindex[i], "sessionIndex", "sessionIndex");
                param.setAttribute("name", "sessionIndex");
                param.setAttribute("value", sessionIndex);
                row.appendChild(param);
                
                param = new tagElement("param");
                var sessionid = st.getCellStoreValue(rowindex[i], "sessionid", "sessionid");
                param.setAttribute("name", "sessionid");
                param.setAttribute("value", sessionid);
                row.appendChild(param);
                
                bp.appendChild(row);
            }
            
            di.getRoot().appendChild(bp);
            $("deletebtn").disabled = !btnRightArr.deletebtn.right;
            var URL = "../../../../neExlorerServlet?sfid=" + TECMDCODE_DELETE_BFD + "&flag=1&nmUser=" + winurlobj["nmUser"];
            loadXMLdoc(URL, "POST", true, detelteCallBack, null, "inputdata=" + di.toString());
        }
    }
    else 
    {
        alert(RESOURCE["pleaseSelect"]);
    }
}

function detelteCallBack(doc, rowindex)
{
    var data = EncapsulateData(doc);
    if (data.getSErrorCode() != 0) 
    {
        showErrorDialog(data);
        return;
    }
    
    document.getElementById("deletebtn").disabled = true;
    
    sendQueryInfo();
}

function sendQueryInfo()
{
    var xml = createQueryXML();
    $("deletebtn").disabled = true;
    $("querybtn").disabled = true;
    $("setStatus").disabled = true;
    var URL = "../../../../neExlorerServlet?sfid=" + TECMDCODE_QUERY_BFD_FORPW + "" + "&nmUser=" + winurlobj["nmUser"];
    st.clearTableData();
    loadXMLdoc(URL, "POST", false, doQueryCallBack, null, "inputdata=" + xml);
}

function setStatus()
{
    var xml = createApplyXML();
    
    var URL = "../../../../neExlorerServlet?sfid=" + TECMDCODE_MODIFY_BFD + "" + "&nmUser=" + winurlobj["nmUser"];
    
    loadXMLdoc(URL, "POST", false, doApplyCallBack, null, "inputdata=" + xml);
}

function doQueryCallBack(doc)
{
	$("querybtn").disabled = false;
    var data = EncapsulateData(doc);
    if (data.getSErrorCode() == 2) 
    {
        adjustEmptyBodyPack(st, window.tableconf[0]);
        showErrorDialog(data);
        return;
    }
    
    st.clearTableData();
    
    for (var i = 0, len = data.getDataRowLength(); i < len; i++) 
    {
        var endip = data.getDataRowParam(i, "endport");
        data.rows[i]["endport"].value = convertNumToIpaddr(endip);
        
        var srcip = data.getDataRowParam(i, "srcport");
        data.rows[i]["srcport"].value = convertNumToIpaddr(srcip);
        if (data.getDataRowParam(i, "sessionstatus") != "0") 
        {
            var ptag = new ParamTag();
            ptag.value = data.getDataRowParam(i, "sessionstatus");
            data.rows[i]["adminStatus"] = ptag;
            data.rows[i]["sessionstatus"].value = "1";
        }
        else 
        {
            var ptag = new ParamTag();
            ptag.value = "1";
            data.rows[i]["adminStatus"] = ptag;
            data.rows[i]["sessionstatus"].value = "0";
        }
        
        if (data.getDataRowParam(i, "sourceboard") == "255" || data.getDataRowParam(i, "sourceboard") == "65535") 
        {
            data.rows[i]["sourceboard"].value = "/";
        }
        else 
        {
            data.rows[i]["sourceboard"].value = data.getDataRowParam(i, "sourceboard") + "-" + data.getDataRowParam(i, "bdName");
        }
        
        /**
         * U2000V1R2         tunnel  
         */
        if (data.getDataRowParam(i, "port") == "65535" || data.getDataRowParam(i, "port") == "/") 
        {
            data.rows[i]["port"].value = "/";
        }
        else 
        {
            data.rows[i]["port"].value = data.getDataRowParam(i, "slotid") + "-" + data.getDataRowParam(i, "boardname") + "-" + data.getDataRowParam(i, "portname");
        }
        
        var ptag = new ParamTag();
        data.rows[i]["tunnel"] = ptag;
        var tunnelIndex = parseInt(data.getDataRowParam(i, "tunnelindex"));
        if (tunnelIndex == 4294967295) 
        {
            data.rows[i]["tunnel"].value = "/";
        }
        else 
        {
            var tunnelType = "IP Tunnel";
            if (tunnelIndex >= GRETUNNELSTARTINDEX && tunnelIndex < IPTUNNELSTARTINDEX) 
            {
                tunnelType = "GRE Tunnel";
            }
            data.rows[i]["tunnel"].value = tunnelType + ":" + data.getDataRowParam(i, "tunnelid") + "(" + convertNumToIpaddr(data.getDataRowParam(i, "ip")) + ")";
        }
        
        if (data.getDataRowParam(i, "sessiontype") == "1") 
        {
            data.rows[i]["frontport"].value = "/";
        }
        if (data.getDataRowParam(i, "sessiontype") == "0" && data.getDataRowParam(i, "sourceboard") == "/") 
        {
            var portid = parseInt(data.getDataRowParam(i, "frontport")) - 10240;
            data.rows[i]["frontport"].value = data.getDataRowParam(i, "frontportName");
        }
        else if (data.getDataRowParam(i, "frontportName") != null) 
        {
            data.rows[i]["frontport"].value = data.getDataRowParam(i, "frontportName");
        }
    }
    createTableBody(st, window.tableconf[0], data, RESOURCE);
    addCellEvent();
    $("setStatus").disabled = true;
    if (data.getDataRowLength() != null) 
    {
        document.getElementById("totalrownum").innerText = data.getDataRowLength();
        document.getElementById("selrownum").innerText = "" + st.getSelectedRows().length;
    }
    if (data.getSErrorCode() == 0) 
    {
        return;
    }
    
    showErrorDialog(data);
}

function doApplyCallBack(doc)
{
    var data = EncapsulateData(doc);
    if (data.getSErrorCode() == 2) 
    {
        showErrorDialog(data);
        return;
    }
    
    if (data.getSErrorCode() == 0) 
    {
        sendQueryInfo();
        return;
    }
    
    showErrorDialog(data);
}

function showErrorDialog(data)
{
    var errArr = [];
    errArr[0] = "sessionid";
    
    for (var i = 0, len = data.getBErrLength(); i < len; i++) 
    {
        errorObj = data.getError().rowErrors[i].errorObj;
        for (var rowindex = 0, rowlen = st.getDataRowLength(); rowindex < rowlen; rowindex++) 
        {
            if (errorObj["sessionIndex"] == st.getCellStoreValue(rowindex, "sessionIndex", "sessionIndex")) 
            {
                errorObj["sessionid"] = RESOURCE["sessionID"] + ":" + st.getCellStoreValue(rowindex, "sessionid", "sessionid");
            }
        }
    }
    
    openErrPage("../../../../page/", data.getError(), errArr);
}

function createQueryXML()
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var row = new tagElement("row-params");
    var param = new tagElement("param");
    
    var neid = winurlobj["neid"];
    param.setAttribute("name", "neid");
    param.setAttribute("value", winurlobj["neid"]);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "sessiontype");
    param.setAttribute("value", "1");
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "sessionIndex");
    param.setAttribute("value", "0");
    row.appendChild(param);
    
    bussiness.appendChild(row);
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

function createApplyXML()
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var row = new tagElement("row-params");
    
    for (var rowindex = 0, rowlen = st.getDataRowLength(); rowindex < rowlen; rowindex++) 
    {
        if (!st.getModify(rowindex)) 
        {
            continue;
        }
        
        row = new tagElement("row-params");
        param = new tagElement("param");
        param.setAttribute("name", "idFlag");
        param.setAttribute("value", "0");
        row.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "isauto");
        param.setAttribute("value", "0");
        row.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "sessionIndex");
        param.setAttribute("value", st.getCellStoreValue(rowindex, "sessionIndex", "sessionIndex"));
        row.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "sessionid");
        param.setAttribute("value", st.getCellStoreValue(rowindex, "sessionid", "sessionid"));
        row.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "neid");
        param.setAttribute("value", winurlobj["neid"]);
        row.appendChild(param);
        
        if (st.getCellModify(rowindex, "port")) 
        {
            var oldbindType = st.getCellStoreValue(rowindex, "bindtype", "bindtype");
            var applyobject = st.getCellShow(rowindex, "port", "port").getValue();
            if (applyobject == "/") //    
            {
                param = new tagElement("param");
                param.setAttribute("name", "port");
                param.setAttribute("value", "65535");
                row.appendChild(param);
                
                param = new tagElement("param");
                param.setAttribute("name", "slotid");
                param.setAttribute("value", "65535");
                row.appendChild(param);
                
                param = new tagElement("param");
                param.setAttribute("name", "subslotid");
                param.setAttribute("value", "255");
                row.appendChild(param);
            }
            else 
            {
                var tempAttr = st.getCellStoreValue(rowindex, "port", "port").split(",");
                param = new tagElement("param");
                param.setAttribute("name", "port");
                param.setAttribute("value", tempAttr[1]);
                row.appendChild(param);
                
                param = new tagElement("param");
                param.setAttribute("name", "slotid");
                param.setAttribute("value", tempAttr[0]);
                row.appendChild(param);
                
                param = new tagElement("param");
                param.setAttribute("name", "subslotid");
                param.setAttribute("value", "255");
                row.appendChild(param);
            }
        }
        
        if (st.getCellModify(rowindex, "tunnel")) 
        {
            var applyobject = st.getCellShow(rowindex, "tunnel", "tunnel").getValue();
            if (applyobject == "/") //    
            {
                param = new tagElement("param");
                param.setAttribute("name", "tunnelIndex");
                param.setAttribute("value", 0xffffffff);
                row.appendChild(param);
            }
            else 
            {
                var tempAttr = st.getCellStoreValue(rowindex, "tunnel", "tunnel");
                param = new tagElement("param");
                param.setAttribute("name", "tunnelIndex");
                param.setAttribute("value", tempAttr);
                row.appendChild(param);
            }
        }
        
        if (st.getCellModify(rowindex, "sendinterval")) 
        {
            param = new tagElement("param");
            param.setAttribute("name", "sendinterval");
            param.setAttribute("value", st.getCellStoreValue(rowindex, "sendinterval", "sendinterval"));
            row.appendChild(param);
        }
        
        if (st.getCellModify(rowindex, "sessionstatus")) 
        {
            param = new tagElement("param");
            param.setAttribute("name", "sessionstatus");
            param.setAttribute("value", st.getCellStoreValue(rowindex, "sessionstatus", "sessionstatus"));
            row.appendChild(param);
        }
        
        if (st.getCellModify(rowindex, "receiveinterval")) 
        {
            param = new tagElement("param");
            param.setAttribute("name", "receiveinterval");
            param.setAttribute("value", st.getCellStoreValue(rowindex, "receiveinterval", "receiveinterval"));
            row.appendChild(param);
        }
        if (st.getCellModify(rowindex, "detectmultiple")) 
        {
            param = new tagElement("param");
            param.setAttribute("name", "localmultplier");
            param.setAttribute("value", st.getCellStoreValue(rowindex, "detectmultiple", "detectmultiple"));
            row.appendChild(param);
        }
        
        bussiness.appendChild(row);
    }
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

function initButton()
{
	$("createbtn").style.display = "none";
    $("querybtn").value = RESOURCE["query"];
    $("createbtn").value = RESOURCE["create"];
    $("deletebtn").value = RESOURCE["delete"];
    $("setStatus").value = RESOURCE["setstatus"];
    
    $("setStatus").disabled = true;
    
    btnRightArr.querybtn = new BtnRightObj("querybtn", TECMDCODE_QUERY_PTMPLPT);
    btnRightArr.createbtn = new BtnRightObj("createbtn", TECMDCODE_SET_PTMPLPT);
    btnRightArr.deletebtn = new BtnRightObj("deletebtn", TECMDCODE_SET_PTMPLPT);
    btnRightArr.setStatus = new BtnRightObj("setStatus", TECMDCODE_SET_PTMPLPT);
    
    getRightInfo(winurlobj, btnRightArr)
    initrightbtn(btnRightArr);
}

function valueChanged()
{
    $("setStatus").disabled = !btnRightArr.setStatus.right;
}

function doCreate()
{
    xshowModalDialog('createbfd_forvrrp.html', RESOURCE["newBFD"], 330, 265, '../../../../images/');
}

function dblclick_port()
{
    if (!btnRightArr.setStatus.right) 
    {
        return;
    }
    rowSelected = this.parentNode.rowIndex;
    maxMemNumStr = st.getCellStoreValue(rowSelected, "port", "port");
    st.element.datarows[rowSelected].element.modify = true;
    this.modify = true;
    var appendUrl = st.getCellStoreValue(rowSelected, "port", "port");
    openBindType = "port";
    if (this.isEdit) 
    {
        xshowModalDialog("bindport.html?" + appendUrl, RESOURCE["bindport"], 420, 240, "../../../../images/");
    }
}

function dblclick_tunnel()
{
    if (!btnRightArr.setStatus.right) 
    {
        return;
    }
    rowSelected = this.parentNode.rowIndex;
    maxMemNumStr = st.getCellStoreValue(rowSelected, "tunnel", "tunnel");
    st.element.datarows[rowSelected].element.modify = true;
    this.modify = true;
    var appendUrl = st.getCellStoreValue(rowSelected, "tunnel", "tunnel");
    openBindType = "tunnel";
    if (this.isEdit) 
    {
        xshowModalDialog("bindport.html?" + appendUrl, RESOURCE["bindtunnel"], 420, 240, "../../../../images/");
    }
}

function addCellEvent()
{
    for (var i = 0, len = st.getDataRowLength(); i < len; i++) 
    {
        var bindport = st.getCellElement(i, "port");
        bindport.ondblclick = dblclick_port;
        var bindport = st.getCellElement(i, "tunnel");
        bindport.ondblclick = dblclick_tunnel;
        
        var cell = st.getCellElement(i, "detectmultiple");
        textCheck(cell.editElement.element, MIN_DETECTMULTIPLE, MAX_DETECTMULTIPLE);
        
        cell = st.getCellElement(i, "sendinterval");
        textCheck(cell.editElement.element, MIN_SENDINTERVAL, MAX_SENDINTERVAL);
        
        cell = st.getCellElement(i, "receiveinterval");
        textCheck(cell.editElement.element, MIN_SENDINTERVAL, MAX_SENDINTERVAL);
    }
}
