
var st;

var rowIndex = null;
var tunnelIndex, tunnelId, sinkPortIP;
var parobj = getParentWindow();
var obj = parobj.winurlobj;
var neid = obj.neid;

window.onload = function()
{
    if (!isIE)
    {
        if (parobj.frames.length >= 5)//???
        {
            parobj = parobj.frames[3];
        }
        else
        {
            var urlAttr = this.location.search;
            if (urlAttr.indexOf("flag") != -1)
            {
                parobj = parobj.frames[0];
            }
        }
    }        
        
    parCell = parobj.editWredCell;
        
    initTable();
    initButtonInfo();
    queryTunnel();
}

function initTable()
{
    st = new SortTable();
    st.head.setAttribute("id", "htmlTableBfdTunnelSelectTHead");
    st.body.setAttribute("id", "htmlTableBfdTunnelSelectTBody");
    st.setImage("../../../../images/");
    createTableHead(st, window.tableconf[0]);
    st.setBodyHeight(getTableHeight($("tunnelselecttable"),st)+"px");
    st.setOnRowSelectHandler(rowSelectHandler);
    st.setSingleChoiceFlg(true);
    $("tunnelselecttable").appendChild(st.getTable());
}

function initButtonInfo()
{
    $("confirmbtn").value = RESOURCE["okbutton"];
    $("cancelbtn").value = RESOURCE["cancelbutton"];
}

function rowSelectHandler()
{
    var rows = st.getSelectedRows();
    if (rows.length <=0)
    {
        rowIndex = null;
        return;
    }
        
        
    rowIndex = rows[0];
    tunnelIndex = st.getCellStoreValue(rowIndex, "tunnelIndex", "tunnelindex");
    tunnelId = st.getCellStoreValue(rowIndex, "tunnelId", "tunnelid");
    sinkPortIP = st.getCellStoreValue(rowIndex, "snkPortIp", "ip");
}

function queryTunnel()
{
    var bandType = parobj.bindPortTable.getAttrValue("bandtype");
    var xmldata = createQueryXml();
    var subFunID;
    if (bandType == 1)
    {         
        subFunID = TECMDCODE_PTN_GRETUNNEL_QUERY;
    }
    else
    {                  
        subFunID = TECMDCODE_PTN_IPTUNNEL_QUERY;      
    }
    var urlstr = "../../../../neExlorerServlet?sfid="+subFunID+"&flag=1&timestamp="+new Date().getTime()+"&nmUser="+obj["nmUser"];
    loadXMLdoc(urlstr, "POST", false, callbackQuery, null, "inputdata="+xmldata);
}

function createQueryXml()
{
    var root = new inputxml("datainterface");
    var business = new tagElement("bussiness-params");
    var row = new tagElement("row-params");
    
    var param = new tagElement("param");    
    param.setAttribute("name", "neid");
    param.setAttribute("value", neid);
    row.appendChild(param);
    
    var param = new tagElement("param");    
    param.setAttribute("name", "isLogFlag");
    param.setAttribute("value", "0");
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "tunnelindex");
    param.setAttribute("value", 0);
    row.appendChild(param);
    
    business.appendChild(row);
    root.getRoot().appendChild(business);
    
    return root.toString();
}

function callbackQuery(doc)
{
    var data = EncapsulateData(doc);
    if (data.getSErrorCode() == 0 || data.getSErrorCode() == 1)
    {
        st.clearTableData();   
        
        for(var i=0,len=data.getDataRowLength();i<len;i++)
        {
            var ip = data.getDataRowParam(i,"ip");    
            data.rows[i]["ip"].value = convertNumToIpaddr(ip);
        }

        createTableBody(st, window.tableconf[0], data, RESOURCE);     
    }

}

function selectTunnel(param)
{
    if (rowIndex == null)
    {
        if (param)
        {
            closeWindow(false);
        }
        else
        {
            alert("please select...");
        }
        
        return;
    }
    else
    {        
        parobj.tunnelIndex = tunnelIndex;
        parobj.bindPortTable.setAttrValue("tunnel", tunnelId + "(" + sinkPortIP + ")");

                
        if (param)
        {
            closeWindow(true);
        }
    }
}

function closeWindow(param)
{
    if (parobj.editWredRow != null)
    {
        var editElement = parCell.element.editElement;
        var showElement = parCell.element.showElement;
                
        editElement.element.style.display = "none"; 
        showElement.element.style.display = "";
        showElement.element.style.backgroundColor = color_edited;
                
    }
    else
    {

    }

    if (parobj.queueDetailsChanged)
    {
        parobj.queueDetailsChanged[parobj.editWredRow] = param;
    }

    xcloseDialog();
}

window.onresize=function()
{
    if (document.body)
    {
        st.setBodyHeight(getTableHeight($("tunnelselecttable"),st)+"px");
    }
}
