/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ptn.util;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.TESubBoard;
import com.huawei.nglct.nelist.model.circuitpack.TEPortProperty;
import com.huawei.nglct.nemgr.ptn.util.TEPortResource;
import com.huawei.nglct.ptn_pub.TEPTNDataMgr;
import com.huawei.nglct.ptn_pub.TEPTNPortNumData;
import com.huawei.nglct.ptn_pub.TEPTNUtil;
import com.huawei.uflight.qxprotocol.TENECommMgr;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import com.huawei.uflight.qxprotocol.definitions.Part;
import gnu.trove.TIntHashSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Vector;

public class TEGetPortRes {
    private static final String FUN_CLOCK_DOMAIN = "TE_CLOCK_DOMAIN_CREATE";
    private static final String FUN_PROCESS_BOARD = "TE_PROCESS_BOARD";
    private static final String FUN_CONTROL_PLANE_ISIS_OSPF = "TE_CONTROL_PLANE_ISIS_OSPF";
    private static final String TE_PPP_PORTS = "TE_PPP_PORTS";
    private static final String FUN_STATIC_ROUTE = "FUN_STATIC_ROUTE";
    private static final String FUN_ETH_PORT = "TE_ETH_PORTS";
    private static final String TE_MSTP_PORTS = "TE_MSTP_PORTS";
    private TEPTNUtil util = TEPTNUtil.instance();
    private TEConfigurationDataMgr cfgDataMgr = TEConfigurationDataMgr.getInstance();
    private static final TEGetPortRes instance = new TEGetPortRes();
    private static final int LAST_E1_PORTID = 32;
    private static final int LAST_FE_PORTID = 12;
    private static final int TIME_OUT = 60;
    private static final HashMap<Integer, Integer> portTypeMap = new HashMap();

    public static final TEGetPortRes getInstance() {
        return instance;
    }

    public ArrayList<TEPortResource> getPorts(int neid, String funid) {
        ArrayList<TEPortResource> allPorts = this.getPortsProxy(neid, funid);
        Collections.sort(allPorts, new Comparator<TEPortResource>(){

            @Override
            public int compare(TEPortResource t1, TEPortResource t2) {
                int boarddiv = t1.getSlotID() - t2.getSlotID();
                int subbddiv = t1.getSubslotID() - t2.getSubslotID();
                if (boarddiv != 0) {
                    return boarddiv;
                }
                if (subbddiv != 0) {
                    return subbddiv;
                }
                return 0;
            }
        });
        return allPorts;
    }

    private ArrayList<TEPortResource> getPortsProxy(int neid, String funid) {
        funid = funid.trim();
        ArrayList<TEPortResource> ports = new ArrayList();
        if (funid.equals(FUN_CLOCK_DOMAIN) || funid.equals(FUN_ETH_PORT) || funid.equals(TE_MSTP_PORTS)) {
            ports = this.getCommonPhyPorts(neid, funid);
        } else if (funid.equals(FUN_CONTROL_PLANE_ISIS_OSPF)) {
            ports = this.getCommonPhyPorts(neid, TE_PPP_PORTS);
            ArrayList<TEPortResource> logicPorts = this.queryMLPPPPorts(neid);
            logicPorts.addAll(this.queryVETHPorts(neid));
            this.processLogicPortWithName(logicPorts, this.queryLogicPortNameMap(neid));
            ports.addAll(logicPorts);
        } else if (funid.equals(FUN_STATIC_ROUTE)) {
            ports = this.getCommonPhyPorts(neid, TE_PPP_PORTS);
            this.joinSerialPorts(ports, this.querySerialPorts(neid));
            ArrayList<TEPortResource> logicPorts = this.queryMLPPPPorts(neid);
            logicPorts.addAll(this.queryVETHPorts(neid));
            this.processLogicPortWithName(logicPorts, this.queryLogicPortNameMap(neid));
            ports.addAll(logicPorts);
        } else if (funid.equals(FUN_PROCESS_BOARD)) {
            ports = this.getProcessBoard(neid);
        }
        return ports;
    }

    private ArrayList<TEPortResource> getCommonPhyPorts(int neid, String funid) {
        TIntHashSet ifboards = this.util.getFilterBoardsSet(neid, "DCN_QUERY_IFDCNIF");
        ArrayList<TEPortResource> allPorts = new ArrayList<TEPortResource>();
        TIntHashSet filterBoards = null;
        if (funid.equals(TE_MSTP_PORTS)) {
            filterBoards = this.util.getFilterBoardsSet(neid, FUN_ETH_PORT);
            filterBoards.addAll(ifboards.toArray());
        } else {
            filterBoards = this.util.getFilterBoardsSet(neid, funid);
        }
        TENE ne = TENEListMgr.getInstance().getNE(neid);
        Vector boardList = ne.getBoardList();
        int neType = ne.getNEType();
        List portNumBoardList = TEPTNDataMgr.getInstance().getPortNumList(neType);
        ArrayList<TEPortProperty> ports = null;
        TEBoard board = null;
        TESubBoard subBoard = null;
        TEPortProperty pProperty = null;
        ArrayList<String> portNameList = null;
        ArrayList<Integer> portIDList = null;
        int size = boardList.size();
        for (int i = 0; i < size; ++i) {
            List subBoardList;
            board = (TEBoard)boardList.get(i);
            int boardType = board.getBoardType();
            int boardSlotID = board.getSlotID();
            if (!filterBoards.contains(boardType)) continue;
            boolean hasInvalidPort = false;
            Set invalid_portlist = new HashSet();
            if (null != portNumBoardList) {
                for (TEPTNPortNumData portNumData : portNumBoardList) {
                    TEBoard processBoard;
                    if (boardSlotID != portNumData.getCur_cpslotID() || !portNumData.getCur_cptype_list().contains(boardType) || null == (processBoard = ne.getBoard(portNumData.getPcp_slotID())) || !portNumData.getPcp_type_list().contains(processBoard.getBoardType())) continue;
                    hasInvalidPort = true;
                    invalid_portlist = portNumData.getInvalid_portlist();
                    break;
                }
            }
            if (!(subBoardList = board.getSubBoardList()).isEmpty()) {
                int sbSize = subBoardList.size();
                for (int j = 0; j < sbSize; ++j) {
                    subBoard = (TESubBoard)subBoardList.get(j);
                    int subBoardType = subBoard.getSubBoardType();
                    if (!filterBoards.contains(subBoardType)) continue;
                    ports = this.getAllPorts(neid, boardSlotID, subBoard.getSubSlotID(), subBoardType);
                    portNameList = new ArrayList();
                    portIDList = new ArrayList();
                    int pSize = ports.size();
                    for (int pi = 0; pi < pSize; ++pi) {
                        pProperty = ports.get(pi);
                        if (pProperty.getPortType() == 64001) continue;
                        portIDList.add(pProperty.getPortNo());
                        portNameList.add(this.cfgDataMgr.getPortName(neid, boardSlotID, boardType, pProperty.getPortNo()));
                    }
                    allPorts.add(new TEPortResource(boardSlotID, board.getBoardName(), subBoard.getSubSlotID(), TEConfigurationDataMgr.getInstance().getBoardTypeName(neid, subBoardType), portIDList, portNameList));
                }
                continue;
            }
            ports = this.getAllPorts(neid, boardSlotID, 255, boardType);
            portNameList = new ArrayList<String>();
            portIDList = new ArrayList<Integer>();
            int pSize = ports.size();
            for (int pi = 0; pi < pSize; ++pi) {
                pProperty = ports.get(pi);
                if (pProperty.getPortType() == 64001 || (funid.equals(FUN_ETH_PORT) || funid.equals(TE_MSTP_PORTS)) && pProperty.getPortType() != 1799 && pProperty.getPortType() != 1025 || hasInvalidPort && invalid_portlist.contains(pProperty.getPortNo())) continue;
                if (portIDList.contains(pProperty.getPortNo())) {
                    TELogFactory.getNormalLogger().error("Board " + board.getBoardName() + "'s model file have some errors,please check it.");
                    continue;
                }
                portIDList.add(pProperty.getPortNo());
                portNameList.add(this.cfgDataMgr.getPortName(neid, boardSlotID, boardType, pProperty.getPortNo()));
            }
            if (portIDList.isEmpty()) continue;
            allPorts.add(new TEPortResource(boardSlotID, board.getBoardName(), 255, "", portIDList, portNameList));
        }
        return allPorts;
    }

    private ArrayList<TEPortResource> getProcessBoard(int neid) {
        ArrayList<TEPortResource> allPorts = new ArrayList<TEPortResource>();
        TENE ne = TENEListMgr.getInstance().getNE(neid);
        TIntHashSet filterBoards = null;
        filterBoards = this.util.getFilterBoardsSet(neid, FUN_PROCESS_BOARD);
        Vector boardList = ne.getBoardList();
        TEBoard board = null;
        TESubBoard subBoard = null;
        ArrayList<String> portNameList = null;
        ArrayList<Integer> portIDList = null;
        int slotid = 0;
        int size = boardList.size();
        for (int i = 0; i < size; ++i) {
            board = (TEBoard)boardList.get(i);
            int boardType = board.getBoardType();
            slotid = board.getSlotID();
            if (!filterBoards.contains(boardType)) continue;
            List subBoardList = board.getSubBoardList();
            if (!subBoardList.isEmpty()) {
                boolean isSlotValid = ne.getNEType() == 59 && (slotid < 5 || slotid > 14) || ne.getNEType() == 78 && (slotid < 7 || slotid > 13) || ne.getNEType() == 58 && (slotid == 1 || slotid == 2);
                int sbSize = subBoardList.size();
                for (int j = 0; j < sbSize; ++j) {
                    subBoard = (TESubBoard)subBoardList.get(j);
                    int subBoardType = subBoard.getSubBoardType();
                    if (!filterBoards.contains(subBoardType) || !isSlotValid) continue;
                    portNameList = new ArrayList();
                    portIDList = new ArrayList();
                    allPorts.add(new TEPortResource(board.getSlotID(), board.getBoardName(), subBoard.getSubSlotID(), TEConfigurationDataMgr.getInstance().getBoardTypeName(neid, subBoardType), portIDList, portNameList));
                }
                continue;
            }
            if (!filterBoards.contains(boardType)) continue;
            portNameList = new ArrayList<String>();
            portIDList = new ArrayList<Integer>();
            allPorts.add(new TEPortResource(board.getSlotID(), board.getBoardName(), 255, "", portIDList, portNameList));
        }
        return allPorts;
    }

    private ArrayList<TEPortResource> queryMLPPPPorts(int neid) {
        ArrayList<Operation> operationList = new ArrayList<Operation>();
        Operation operation = TECreateObjectFactory.getOperation((int)neid, (String)"NSCMD_ETHN_MLPPP_GET_MP_EX");
        if (null == operation) {
            operation = TECreateObjectFactory.getOperation((int)neid, (String)"NSCMD_ETHN_MLPPP_GET_MP");
        }
        Input input = operation.getInput();
        input.setPartValue("mpid", "0");
        operationList.add(operation);
        TENECommMgr.getInstance().sendCommand(neid, operationList, 60);
        Operation tmpOper = (Operation)operationList.get(0);
        operationList.clear();
        Output[] outputArr = tmpOper.getOutput();
        String boardname = "ML-PPP";
        int slotid = 65535;
        int subslotid = 255;
        String subboardname = "";
        ArrayList<Integer> portidList = new ArrayList<Integer>();
        ArrayList<String> portNameList = new ArrayList<String>();
        String mpid = "";
        String returnCode = null;
        for (Output output : outputArr) {
            returnCode = output.getFault()[0].getCode();
            if (returnCode == null || !returnCode.equals("0") || portidList.contains(Integer.valueOf(mpid = output.getPartValue("mpid")))) continue;
            portidList.add(Integer.valueOf(mpid));
        }
        ArrayList<TEPortResource> mpPorts = new ArrayList<TEPortResource>();
        if (0 < portidList.size()) {
            TEPortResource usableRes = new TEPortResource(slotid, boardname, subslotid, subboardname, portidList, portNameList);
            mpPorts.add(usableRes);
        }
        return mpPorts;
    }

    private ArrayList<TEPortResource> queryVETHPorts(int neid) {
        ArrayList<Operation> operationList = new ArrayList<Operation>();
        Operation operation = TECreateObjectFactory.getOperation((int)neid, (String)"NSCMD_ETHN_PORT_GET_VPORT");
        String slotid = this.getInvalidSlotID(neid);
        Input input = operation.getInput();
        input.setPartValue("slotid", slotid);
        input.setPartValue("subslotid", "255");
        input.setPartValue("vport", "0");
        operationList.add(operation);
        TENECommMgr.getInstance().sendCommand(neid, operationList, 60);
        Operation tmpOper = (Operation)operationList.get(0);
        Output[] outputArr = tmpOper.getOutput();
        String boardname = "Virtual Ethernet";
        int subslotid = 255;
        String subboardname = "";
        ArrayList<Integer> portidList = new ArrayList<Integer>();
        ArrayList<String> portNameList = new ArrayList<String>();
        int vport = 0;
        String returnCode = null;
        for (Output output : outputArr) {
            returnCode = output.getFault()[0].getCode();
            if (returnCode == null || !returnCode.equals("0")) continue;
            vport = Integer.parseInt(output.getPartValue("vport"));
            if (TEPTNUtil.instance().isVEPort(vport)) continue;
            portidList.add(vport);
        }
        ArrayList<TEPortResource> vPorts = new ArrayList<TEPortResource>();
        if (0 < portidList.size()) {
            TEPortResource usableRes = new TEPortResource(Integer.parseInt(slotid), boardname, subslotid, subboardname, portidList, portNameList);
            vPorts.add(usableRes);
        }
        return vPorts;
    }

    private HashMap<Integer, String> queryLogicPortNameMap(int neid) {
        ArrayList<Operation> operationList = new ArrayList<Operation>();
        Operation oper = TECreateObjectFactory.getOperation((int)neid, (String)"NSCMD_PTN_PORT_GET_NAME");
        Input input2 = oper.getInput();
        input2.setPartValue("slotid", this.getInvalidSlotID(neid));
        input2.setPartValue("subslotid", "255");
        input2.setPartValue("port", "0");
        operationList.add(oper);
        TENECommMgr.getInstance().sendCommand(neid, operationList, 60);
        HashMap<Integer, String> portNameMap = new HashMap<Integer, String>();
        Output[] outputArr2 = oper.getOutput();
        if (outputArr2 != null) {
            Output output22 = null;
            String returnCode = null;
            for (Output output22 : outputArr2) {
                returnCode = output22.getFault()[0].getCode();
                if (returnCode == null || !returnCode.equals("0")) continue;
                portNameMap.put(new Integer(output22.getPart("port").getValue()), output22.getPart("portName").getValue().trim());
            }
        }
        return portNameMap;
    }

    private String getInvalidSlotID(int neid) {
        TENE ne = TENEListMgr.getInstance().getNE(neid);
        int neType = ne.getNEType();
        String neVersion = ne.getHostVersion();
        if ((neType == 58 || neType == 59) && neVersion.indexOf(".01.") >= 0) {
            return "255";
        }
        return "65535";
    }

    private void processLogicPortWithName(ArrayList<TEPortResource> rawPorts, HashMap<Integer, String> portNameMap) {
        TEPortResource tpr = null;
        ArrayList<Integer> portList = null;
        int size = rawPorts.size();
        for (int i = 0; i < size; ++i) {
            tpr = rawPorts.get(i);
            portList = tpr.getPortidList();
            Integer portid = null;
            int sizep = portList.size();
            for (int pi = 0; pi < sizep; ++pi) {
                portid = portList.get(pi);
                tpr.getPortNameList().add(this.util.getLogicPortName(portid.intValue(), portNameMap.get(portid)));
            }
        }
    }

    private ArrayList<TEPortResource> querySerialPorts(int neid) {
        TIntHashSet serial_boards = this.util.getFilterBoardsSet(neid, "TE_PHY_SERIAL_PORT");
        ArrayList<TEPortResource> tpr = new ArrayList<TEPortResource>();
        HashMap<Integer, TEPortResource> _tempMap = new HashMap<Integer, TEPortResource>();
        ArrayList<Operation> operationList = new ArrayList<Operation>();
        TENE ne = TENEListMgr.getInstance().getNE(neid);
        Vector boardList = ne.getBoardList();
        TESubBoard sb = null;
        boolean isSupportSerial = false;
        int size = boardList.size();
        for (int i = 0; i < size; ++i) {
            TEBoard board = (TEBoard)boardList.get(i);
            if (board.getSubBoardList().size() > 0) {
                int jsize = board.getSubBoardList().size();
                for (int j = 0; j < jsize; ++j) {
                    sb = (TESubBoard)board.getSubBoardList().get(j);
                    if (!serial_boards.contains(sb.getSubBoardType())) continue;
                    isSupportSerial = true;
                    break;
                }
            } else if (serial_boards.contains(board.getBoardType())) {
                isSupportSerial = true;
            }
            if (!isSupportSerial) continue;
            int slotID = board.getSlotID();
            Operation operation = TECreateObjectFactory.getOperation((int)neid, (String)"NSCMD_ETHN_PORT_GET_SERIALPORT");
            Input input = operation.getInput();
            input.setPartValue("slotid", slotID + "");
            input.setPartValue("subslotid", "0");
            input.setPartValue("serialport", "0");
            operationList.add(operation);
            Operation operation1 = TECreateObjectFactory.getOperation((int)neid, (String)"NSCMD_ETHN_PORT_GET_SERIALPORT_VC12");
            Input input1 = operation1.getInput();
            input1.setPartValue("slotid", slotID + "");
            input1.setPartValue("subslotid", "0");
            input1.setPartValue("serialport", "0");
            operationList.add(operation1);
        }
        if (!operationList.isEmpty()) {
            TENECommMgr.getInstance().sendCommand(neid, operationList, 60);
            int slotid = 0;
            String boardname = "";
            int subslotid = 0;
            String subboardname = "";
            int boardtype = 0;
            int subboardtype = 0;
            int serialport = 0;
            String returnCode = null;
            int size2 = operationList.size();
            for (int index = 0; index < size2; ++index) {
                Operation tmpOper = (Operation)operationList.get(index);
                for (Output output : tmpOper.getOutput()) {
                    returnCode = output.getFault()[0].getCode();
                    if (returnCode == null || !returnCode.equals("0")) continue;
                    slotid = Integer.parseInt(output.getPartValue("slotid"));
                    boardtype = this.cfgDataMgr.getBoardType(neid, slotid);
                    boardname = this.cfgDataMgr.getBoardTypeName(neid, boardtype);
                    subslotid = Integer.parseInt(output.getPartValue("subslotid"));
                    subboardname = "";
                    if (255 != subslotid) {
                        subboardtype = this.cfgDataMgr.getSubboardType(neid, slotid, subslotid);
                        subboardname = this.cfgDataMgr.getBoardTypeName(neid, subboardtype);
                    }
                    serialport = Integer.parseInt(output.getPartValue("serialport"));
                    TEPortResource usableRes = (TEPortResource)_tempMap.get(slotid);
                    if (usableRes == null) {
                        ArrayList<Integer> portidList = new ArrayList<Integer>();
                        ArrayList<String> portNameList = new ArrayList<String>();
                        usableRes = new TEPortResource(slotid, boardname, subslotid, subboardname, portidList, portNameList);
                        _tempMap.put(slotid, usableRes);
                        tpr.add(usableRes);
                    }
                    usableRes.getPortidList().add(serialport);
                    usableRes.getPortNameList().add(this.util.getLogicPortName(serialport, ""));
                }
            }
        }
        return tpr;
    }

    private void joinSerialPorts(ArrayList<TEPortResource> phyBoards, ArrayList<TEPortResource> serialBoards) {
        TEPortResource phyPort = null;
        TEPortResource serialPort = null;
        int size = phyBoards.size();
        for (int i = 0; i < size; ++i) {
            phyPort = phyBoards.get(i);
            int lsize = serialBoards.size();
            for (int li = 0; li < lsize; ++li) {
                serialPort = serialBoards.get(li);
                if (phyPort.getSlotID() != serialPort.getSlotID() || phyPort.getSubslotID() != serialPort.getSubslotID()) continue;
                phyPort.getPortidList().addAll(serialPort.getPortidList());
                phyPort.getPortNameList().addAll(serialPort.getPortNameList());
            }
        }
        int lsize = serialBoards.size();
        for (int li = 0; li < lsize; ++li) {
            serialPort = serialBoards.get(li);
            if (phyBoards.contains(serialPort)) continue;
            phyBoards.add(serialPort);
        }
    }

    private ArrayList<Integer> getDynPortList(int neid, int slotid) {
        ArrayList<Operation> operationList = new ArrayList<Operation>();
        Operation oper = TECreateObjectFactory.getOperation((int)neid, (String)"NSCMD_CFG_SUBBD_GET_PORT");
        Input input = oper.getInput();
        Part part = input.getPart("slotid");
        part.setValue(String.valueOf(slotid));
        input.setPartValue("subslotid", "255");
        input.setPartValue("port", "0");
        operationList.add(oper);
        ArrayList<Integer> returnList = new ArrayList<Integer>();
        if (operationList.isEmpty()) {
            return returnList;
        }
        int result = TENECommMgr.getInstance().sendCommand((int)neid, operationList, (int)60).retCode;
        if (result == 0) {
            Operation oOperation = (Operation)operationList.get(0);
            for (Output output : oOperation.getOutput()) {
                if (!String.valueOf(0).equals(output.getFault()[0].getCode())) continue;
                String portId = output.getPartValue("port");
                returnList.add(Integer.valueOf(portId));
            }
        }
        return returnList;
    }

    private ArrayList<TEPortProperty> getDynPortPropertyList(int neid, int subslotid, int slotid, int boardType) {
        ArrayList<Operation> operationList = new ArrayList<Operation>();
        Operation oper = TECreateObjectFactory.getOperation((int)neid, (String)"NSCMD_CFG_SUBBD_GET_PORT_WBID");
        Input input = oper.getInput();
        Part part = input.getPart("slotid");
        part.setValue(String.valueOf(slotid));
        input.setPartValue("subslotid", "" + subslotid);
        input.setPartValue("port", "0");
        operationList.add(oper);
        ArrayList<TEPortProperty> returnList = new ArrayList<TEPortProperty>();
        if (operationList.isEmpty()) {
            return returnList;
        }
        int result = TENECommMgr.getInstance().sendCommand((int)neid, operationList, (int)60).retCode;
        if (result == 0) {
            Operation oOperation = (Operation)operationList.get(0);
            Output[] outputArray = oOperation.getOutput();
            TEPortProperty portProperty = null;
            for (Output output : outputArray) {
                if (!String.valueOf(0).equals(output.getFault()[0].getCode())) continue;
                String portNo = output.getPartValue("port");
                String portType = output.getPartValue("portType");
                String speedLevel = output.getPartValue("speedLevel");
                Integer mapPortType = portTypeMap.get(Integer.valueOf(portType));
                if (mapPortType == null) {
                    mapPortType = Integer.valueOf(portType);
                }
                portProperty = new TEPortProperty(mapPortType.intValue(), Integer.parseInt(speedLevel), Integer.parseInt(portNo), new ArrayList());
                returnList.add(portProperty);
            }
        }
        return returnList;
    }

    public final ArrayList<TEPortProperty> getAllPorts(int neid, int slotid, int subslotid, int boardType) {
        TIntHashSet dynports = this.util.getFilterBoardsSet(neid, "CREATE_BFD_QUERYPORT_DYNPORTS");
        ArrayList<TEPortProperty> allPorts = new ArrayList<TEPortProperty>();
        ArrayList staticPorts = this.cfgDataMgr.getBoardPortPropertyList(neid, boardType);
        allPorts.addAll(staticPorts);
        ArrayList<TEPortProperty> dynPorts = null;
        if (dynports.contains(boardType)) {
            dynPorts = this.getDynPortPropertyList(neid, subslotid, slotid, boardType);
            if (!dynPorts.isEmpty() && !staticPorts.isEmpty() && dynPorts.get(0).getPortNo() < ((TEPortProperty)staticPorts.get(0)).getPortNo()) {
                allPorts.addAll(0, dynPorts);
            } else {
                allPorts.addAll(dynPorts);
            }
        }
        for (int i = allPorts.size() - 1; i >= 0; --i) {
            if (allPorts.get(i).getPortType() != 64001) continue;
            allPorts.remove(i);
        }
        return allPorts;
    }

    public final ArrayList<TEPortProperty> getAllFilterPorts(int neid, int slotid, int subslotid, int boardType, ArrayList<Integer> includedPortTypes) {
        TIntHashSet dynports = this.util.getFilterBoardsSet(neid, "CREATE_BFD_QUERYPORT_DYNPORTS");
        ArrayList<TEPortProperty> allPorts = new ArrayList<TEPortProperty>();
        ArrayList staticPorts = this.cfgDataMgr.getBoardPortPropertyList(neid, boardType);
        ArrayList<TEPortProperty> dynPorts = null;
        if (dynports.contains(boardType)) {
            dynPorts = this.getDynPortPropertyList(neid, subslotid, slotid, boardType);
            allPorts.addAll(dynPorts);
        }
        allPorts.addAll(staticPorts);
        int portType = 0;
        for (int i = allPorts.size() - 1; i >= 0; --i) {
            portType = allPorts.get(i).getPortType();
            if (includedPortTypes.contains(portType)) continue;
            allPorts.remove(i);
        }
        return allPorts;
    }

    static {
        portTypeMap.put(1, 1798);
        portTypeMap.put(5, 1799);
        portTypeMap.put(6, 1025);
    }
}

