/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ptn.snooping_u2kv1r2c00;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.TEDataConverter;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.gencfg.TETimeTocalizationSwitchBean;
import com.huawei.nglct.gencfg.TimeZoneDateBean;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.util.datetime.TEDateUtils;
import com.huawei.nglct.util.io.IOStreamConvertor;
import com.huawei.uflight.qxprotocol.TENECommMgr;
import com.huawei.uflight.qxprotocol.definitions.Definitions;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;

public class TESnoopingQueryRouteBean
extends TENEExplorerBean {
    private Definitions definitions = null;
    private static final String ELAN = "2";
    private HashMap uniPortNameMap = new HashMap();
    private HashMap nniPortNameMap = new HashMap();
    private static final int PW = 1;
    private static final int QINQ = 4;
    private static final int PORT = 3;
    private static final int UNI = 1;
    private boolean queryUNI = false;
    private boolean queryNNI = false;
    private TimeZoneDateBean TimeProccessor = null;

    public TESnoopingQueryRouteBean() {
        this.TIME_OUT = 40;
    }

    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc) {
        int i;
        this.outputData = TEDataConverter.convertToDatainterface((int)neid, (SubFunc)subfunc, (ArrayList)operationList);
        this.TimeProccessor = TETimeTocalizationSwitchBean.getTimeZoneDateInstance((int)neid);
        if (2 == Integer.parseInt(this.outputData.getErrorMessage().getErrorcode())) {
            return;
        }
        BussinessParams bp = this.outputData.getBussinessParams();
        ArrayList<RowParams> tmpRowParamList = new ArrayList<RowParams>();
        RowParams[] rows = bp.getRowParams();
        RowParams row = null;
        RowParams tmpRow = null;
        Param index = null;
        Param vlan = null;
        String portData = null;
        int portNum = -1;
        StringBuffer buf = new StringBuffer();
        for (i = 0; i < rows.length; ++i) {
            row = rows[i];
            index = row.getParam("indexID");
            vlan = row.getParam("vlanID");
            portNum = Integer.parseInt(row.getParam("portNum").getValue());
            portData = row.getParam("portData").getValue();
            byte[] portDataArray = portData.getBytes();
            int arrayIndex = 0;
            for (int j = 0; j < portNum; ++j) {
                buf.delete(0, buf.length());
                tmpRow = new RowParams();
                tmpRow.addParam(index);
                tmpRow.addParam(vlan);
                byte portType = portDataArray[arrayIndex++];
                tmpRow.addParam("portType", String.valueOf(portType));
                int portID = IOStreamConvertor.readUnsignedShort((byte[])portDataArray, (int)arrayIndex);
                if (1 == portType) {
                    if (!this.queryUNI) {
                        this.queryUNI = true;
                        this.getUniPortName(index.getValue());
                    }
                    tmpRow.addParam("portID", (String)this.uniPortNameMap.get(String.valueOf(portID)));
                    tmpRow.addParam("interfaceIndex", portID + "");
                } else {
                    if (!this.queryNNI) {
                        this.queryNNI = true;
                        this.getNniPortName(index.getValue());
                    }
                    tmpRow.addParam("portID", (String)this.nniPortNameMap.get(String.valueOf(portID)));
                    tmpRow.addParam("interfaceIndex", portID + "");
                }
                arrayIndex += 2;
                byte portState = portDataArray[arrayIndex++];
                tmpRow.addParam("portState", String.valueOf(portState));
                int year = portDataArray[arrayIndex++] + 1990;
                byte month = portDataArray[arrayIndex++];
                byte day = portDataArray[arrayIndex++];
                byte hour = portDataArray[arrayIndex++];
                byte minute = portDataArray[arrayIndex++];
                byte second = portDataArray[arrayIndex++];
                byte centiSec = portDataArray[arrayIndex++];
                buf.append(year).append('-').append(month).append('-').append(day).append(" ");
                buf.append(hour).append(':').append(minute).append(':').append(second).append(':').append(centiSec);
                Calendar time = TEDateUtils.strToCalendar((String)buf.toString());
                tmpRow.addParam("createTime", this.TimeProccessor.calendarToTime(time));
                byte rtTime = portDataArray[arrayIndex++];
                tmpRow.addParam("remainRTAgeTime", String.valueOf(rtTime));
                tmpRowParamList.add(tmpRow);
            }
        }
        bp.clearRowParams();
        int size = tmpRowParamList.size();
        for (i = 0; i < size; ++i) {
            bp.addRowParams((RowParams)tmpRowParamList.get(i));
        }
    }

    private void getUniPortName(String serviceIndex) {
        TEConfigurationDataMgr configurationData = TEConfigurationDataMgr.getInstance();
        if (null == this.definitions) {
            try {
                this.definitions = TECreateObjectFactory.parseQxDesFile((int)this.neid);
            }
            catch (Exception e) {
                TELogFactory.getNormalLogger().error("getOperation fail!", (Throwable)e);
                return;
            }
        }
        ArrayList<Object> uniPortList = new ArrayList<Object>();
        Operation oper = this.definitions.getOperation("NSCMD_SERVICE_GET_ETHVUNI");
        if (null == oper) {
            return;
        }
        Input input = oper.getInput();
        input.setPartValue("servType", ELAN);
        input.setPartValue("servIndex", serviceIndex + "");
        input.setPartValue("vuniId", "0");
        uniPortList.add(oper.clone());
        TENECommMgr.getInstance().sendCommand(this.neid, uniPortList, this.TIME_OUT);
        Operation tmpOper = (Operation)uniPortList.get(0);
        uniPortList.clear();
        for (Output output : tmpOper.getOutput()) {
            if (!output.getFault()[0].getCode().equals("0")) continue;
            int slotid = Integer.parseInt(output.getPartValue("slotid"));
            int boardType = configurationData.getBoardType(this.neid, slotid);
            String boardName = configurationData.getBoardTypeName(this.neid, boardType);
            StringBuffer portAllName = new StringBuffer();
            portAllName.append(slotid).append("-").append(boardName).append("-");
            int subslotid = Integer.parseInt(output.getPartValue("subslotid"));
            if (255 != subslotid) {
                int subboardType = configurationData.getSubboardType(this.neid, slotid, subslotid);
                String subboardName = configurationData.getBoardTypeName(this.neid, subboardType);
                portAllName.append(subslotid).append("-").append(subboardName).append("-");
            }
            int port = Integer.parseInt(output.getPartValue("port"));
            String portName = configurationData.getPortName(this.neid, slotid, boardType, port);
            portAllName.append(portName);
            String vuniId = output.getPartValue("vuniId");
            this.uniPortNameMap.put(vuniId, portAllName.toString());
        }
    }

    private void getNniPortName(String serviceIndex) {
        TEConfigurationDataMgr configurationData = TEConfigurationDataMgr.getInstance();
        if (null == this.definitions) {
            try {
                this.definitions = TECreateObjectFactory.parseQxDesFile((int)this.neid);
            }
            catch (Exception e) {
                TELogFactory.getNormalLogger().error("getOperation fail!", (Throwable)e);
                return;
            }
        }
        ArrayList<Object> uniPortList = new ArrayList<Object>();
        Operation oper = this.definitions.getOperation("NSCMD_SERVICE_GET_EVNNI");
        if (null == oper) {
            return;
        }
        Input input = oper.getInput();
        input.setPartValue("servType", ELAN);
        input.setPartValue("servIndex", serviceIndex + "");
        input.setPartValue("vnniId", "0");
        uniPortList.add(oper.clone());
        TENECommMgr.getInstance().sendCommand(this.neid, uniPortList, this.TIME_OUT);
        Operation tmpOper = (Operation)uniPortList.get(0);
        uniPortList.clear();
        for (Output output : tmpOper.getOutput()) {
            if (!output.getFault()[0].getCode().equals("0")) continue;
            StringBuffer portAllName = new StringBuffer();
            String vnniId = output.getPartValue("vnniId");
            int carrierType = Integer.parseInt(output.getPartValue("carrierType"));
            if (1 == carrierType) {
                int pwIndex = Integer.parseInt(output.getPartValue("port"));
                String pwID = this.getPWID(pwIndex);
                portAllName.append("PW-").append(pwID);
            }
            if (4 == carrierType) {
                int QINQIndex = Integer.parseInt(output.getPartValue("port"));
                portAllName.append("QinQ-").append(QINQIndex);
            }
            if (3 == carrierType) {
                int slotid = Integer.parseInt(output.getPartValue("slotid"));
                int boardType = configurationData.getBoardType(this.neid, slotid);
                String boardName = configurationData.getBoardTypeName(this.neid, boardType);
                portAllName.append(slotid).append("-").append(boardName).append("-");
                int subslotid = Integer.parseInt(output.getPartValue("subslotid"));
                if (255 != subslotid) {
                    int subboardType = configurationData.getSubboardType(this.neid, slotid, subslotid);
                    String subboardName = configurationData.getBoardTypeName(this.neid, subboardType);
                    portAllName.append(subslotid).append("-").append(subboardName).append("-");
                }
                int port = Integer.parseInt(output.getPartValue("port"));
                String portName = configurationData.getPortName(this.neid, slotid, boardType, port);
                portAllName.append(portName);
            }
            this.nniPortNameMap.put(vnniId, portAllName.toString());
        }
    }

    private String getPWID(int pwIndex) {
        String pwID = "";
        ArrayList<Object> pwIDList = new ArrayList<Object>();
        Operation oper = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_PTN_MPLS_PW_GET_PW");
        if (null == oper) {
            return pwID;
        }
        Input input = oper.getInput();
        input.setPartValue("pwIndex", pwIndex + "");
        pwIDList.add(oper.clone());
        TENECommMgr.getInstance().sendCommand(this.neid, pwIDList, this.TIME_OUT);
        Operation tmpOper = (Operation)pwIDList.get(0);
        pwIDList.clear();
        for (Output output : tmpOper.getOutput()) {
            if (!output.getFault()[0].getCode().equals("0")) continue;
            pwID = output.getPartValue("pwId");
        }
        return pwID;
    }
}

