/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ptn.snooping;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.TEDataConverter;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.uflight.qxprotocol.TENECommMgr;
import com.huawei.uflight.qxprotocol.definitions.Definitions;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public class TESnoopingQueryMemInfMgrInfoBean
extends TENEExplorerBean {
    private Definitions definitions = null;
    private static final String ELAN = "2";
    private HashMap uniPortNameMap = new HashMap();
    private HashMap nniPortNameMap = new HashMap();
    private static final int PW = 1;
    private static final int PORT = 3;
    private static final int QINQ = 4;
    private static final int UNI = 1;
    private boolean queryUNI = false;
    private boolean queryNNI = false;

    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc) {
        this.outputData = TEDataConverter.convertToDatainterface((int)neid, (SubFunc)subfunc, (ArrayList)operationList);
        int errorCode = Integer.parseInt(this.outputData.getErrorMessage().getErrorcode());
        if (0 != errorCode && 1 != errorCode) {
            return;
        }
        BussinessParams bp = this.outputData.getBussinessParams();
        ArrayList<RowParams> tmpRowParamList = new ArrayList<RowParams>();
        ArrayList rowList = bp.getRowParamList();
        RowParams row = null;
        RowParams tmpRow = null;
        Param index = ((RowParams)rowList.get(0)).getParam("indexID");
        Param vlan = ((RowParams)rowList.get(0)).getParam("vlanID");
        String portData = null;
        int portNum = -1;
        Iterator iter = rowList.iterator();
        while (iter.hasNext()) {
            row = (RowParams)iter.next();
            BigInteger indexIDLong = new BigInteger(index.getValue());
            if (0L > indexIDLong.longValue()) {
                iter.remove();
                continue;
            }
            Param macAddParam = row.getParam("macAdd");
            String macAdd = macAddParam.getValue();
            StringBuffer buf = new StringBuffer();
            if (macAdd.length() == 12) {
                int macL = macAdd.length();
                for (int j = 0; j < macL; j += 2) {
                    buf.append(macAdd.charAt(j)).append(macAdd.charAt(j + 1)).append("-");
                }
                buf.deleteCharAt(buf.length() - 1);
                macAddParam.setValue(buf.toString().trim());
            }
            buf.delete(0, buf.length());
            int offset = 14;
            portData = row.getParam("portData").getValue();
            StringBuffer portDataStrbuf = new StringBuffer(portData);
            portDataStrbuf.delete(0, offset);
            portNum = Integer.parseInt(portDataStrbuf.substring(0, 4), 16);
            offset = 4;
            portDataStrbuf.delete(0, offset);
            offset = 0;
            for (int i = 0; i < portNum; ++i) {
                tmpRow = new RowParams();
                tmpRow.addParam(index);
                tmpRow.addParam(vlan);
                tmpRow.addParam(macAddParam);
                int portType = Integer.parseInt(portDataStrbuf.substring(offset, offset + 2), 16);
                int portID = Integer.parseInt(portDataStrbuf.substring(offset += 2, offset + 4), 16);
                int remainRTAgeTime = Integer.parseInt(portDataStrbuf.substring(offset += 4, offset + 2), 16);
                offset += 2;
                tmpRow.addParam("portType", String.valueOf(portType));
                if (1 == portType) {
                    if (!this.queryUNI) {
                        this.queryUNI = true;
                        this.getUniPortName(index.getValue());
                    }
                    tmpRow.addParam("portID", (String)this.uniPortNameMap.get(String.valueOf(portID)));
                    tmpRow.addParam("interfaceIndex", portID + "");
                } else {
                    if (!this.queryNNI) {
                        this.queryNNI = true;
                        this.getNniPortName(index.getValue());
                    }
                    tmpRow.addParam("portID", (String)this.nniPortNameMap.get(String.valueOf(portID)));
                    tmpRow.addParam("interfaceIndex", portID + "");
                }
                tmpRow.addParam("remainRTAgeTime", String.valueOf(remainRTAgeTime));
                tmpRowParamList.add(tmpRow);
            }
        }
        bp.clearRowParams();
        int size = tmpRowParamList.size();
        for (int i = 0; i < size; ++i) {
            bp.addRowParams((RowParams)tmpRowParamList.get(i));
        }
    }

    private void getUniPortName(String serviceIndex) {
        TEConfigurationDataMgr configurationData = TEConfigurationDataMgr.getInstance();
        if (null == this.definitions) {
            try {
                this.definitions = TECreateObjectFactory.parseQxDesFile((int)this.neid);
            }
            catch (Exception e) {
                TELogFactory.getNormalLogger().error("getOperation fail!", (Throwable)e);
                return;
            }
        }
        ArrayList<Object> uniPortList = new ArrayList<Object>();
        Operation oper = this.definitions.getOperation("NSCMD_SERVICE_GET_ETHVUNI");
        if (null == oper) {
            return;
        }
        Input input = oper.getInput();
        input.setPartValue("servType", ELAN);
        input.setPartValue("servIndex", serviceIndex + "");
        input.setPartValue("vuniId", "0");
        uniPortList.add(oper.clone());
        TENECommMgr.getInstance().sendCommand(this.neid, uniPortList, this.getTimeOut());
        Operation tmpOper = (Operation)uniPortList.get(0);
        uniPortList.clear();
        for (Output output : tmpOper.getOutput()) {
            int slotid = Integer.parseInt(output.getPartValue("slotid"));
            int boardType = configurationData.getBoardType(this.neid, slotid);
            String boardName = configurationData.getBoardTypeName(this.neid, boardType);
            StringBuffer portAllName = new StringBuffer();
            portAllName.append(slotid).append("-").append(boardName).append("-");
            int subslotid = Integer.parseInt(output.getPartValue("subslotid"));
            if (255 != subslotid) {
                int subboardType = configurationData.getSubboardType(this.neid, slotid, subslotid);
                String subboardName = configurationData.getBoardTypeName(this.neid, subboardType);
                portAllName.append(subslotid).append("-").append(subboardName).append("-");
            }
            int port = Integer.parseInt(output.getPartValue("port"));
            String portName = configurationData.getPortName(this.neid, slotid, boardType, port);
            portAllName.append(portName);
            String vuniId = output.getPartValue("vuniId");
            this.uniPortNameMap.put(vuniId, portAllName.toString());
        }
    }

    private void getNniPortName(String serviceIndex) {
        TEConfigurationDataMgr configurationData = TEConfigurationDataMgr.getInstance();
        if (null == this.definitions) {
            try {
                this.definitions = TECreateObjectFactory.parseQxDesFile((int)this.neid);
            }
            catch (Exception e) {
                TELogFactory.getNormalLogger().error("getOperation fail!", (Throwable)e);
                return;
            }
        }
        ArrayList<Object> uniPortList = new ArrayList<Object>();
        Operation oper = this.definitions.getOperation("NSCMD_SERVICE_GET_EVNNI");
        if (null == oper) {
            return;
        }
        Input input = oper.getInput();
        input.setPartValue("servType", ELAN);
        input.setPartValue("servIndex", serviceIndex + "");
        input.setPartValue("vnniId", "0");
        uniPortList.add(oper.clone());
        TENECommMgr.getInstance().sendCommand(this.neid, uniPortList, this.getTimeOut());
        Operation tmpOper = (Operation)uniPortList.get(0);
        uniPortList.clear();
        for (Output output : tmpOper.getOutput()) {
            StringBuffer portAllName = new StringBuffer();
            String vnniId = output.getPartValue("vnniId");
            int carrierType = Integer.parseInt(output.getPartValue("carrierType"));
            if (1 == carrierType) {
                long pwIndex = Long.parseLong(output.getPartValue("port"));
                String pwID = this.getPWID(pwIndex);
                portAllName.append("PW-").append(pwID);
            }
            if (4 == carrierType) {
                long QINQIndex = Long.parseLong(output.getPartValue("port"));
                portAllName.append("QinQ-").append(QINQIndex);
            }
            if (3 == carrierType) {
                int slotid = Integer.parseInt(output.getPartValue("slotid"));
                int boardType = configurationData.getBoardType(this.neid, slotid);
                String boardName = configurationData.getBoardTypeName(this.neid, boardType);
                portAllName.append(slotid).append("-").append(boardName).append("-");
                int subslotid = Integer.parseInt(output.getPartValue("subslotid"));
                if (255 != subslotid) {
                    int subboardType = configurationData.getSubboardType(this.neid, slotid, subslotid);
                    String subboardName = configurationData.getBoardTypeName(this.neid, subboardType);
                    portAllName.append(subslotid).append("-").append(subboardName).append("-");
                }
                int port = Integer.parseInt(output.getPartValue("port"));
                String portName = configurationData.getPortName(this.neid, slotid, boardType, port);
                portAllName.append(portName);
            }
            this.nniPortNameMap.put(vnniId, portAllName.toString());
        }
    }

    private String getPWID(long pwIndex) {
        String pwID = "";
        ArrayList<Object> pwIDList = new ArrayList<Object>();
        Operation oper = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_PTN_MPLS_PW_GET_PW");
        if (null == oper) {
            return pwID;
        }
        Input input = oper.getInput();
        input.setPartValue("pwIndex", pwIndex + "");
        pwIDList.add(oper.clone());
        TENECommMgr.getInstance().sendCommand(this.neid, pwIDList, this.getTimeOut());
        Operation tmpOper = (Operation)pwIDList.get(0);
        pwIDList.clear();
        for (Output output : tmpOper.getOutput()) {
            pwID = output.getPartValue("pwId");
        }
        return pwID;
    }
}

