/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ptn.snooping;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.TEDataConverter;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.uflight.qxprotocol.TENECommMgr;
import com.huawei.uflight.qxprotocol.definitions.Definitions;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;

public class TEQueryQuickLeaveBean
extends TENEExplorerBean {
    private Definitions definitions = null;
    private static final String ELAN = "2";
    private HashMap uniPortNameMap = new HashMap();
    private HashMap nniPortNameMap = new HashMap();
    private static final int PW = 1;
    private static final int QINQ = 4;
    private static final int PORT = 3;
    private static final String UNI = "1";
    private boolean queryUNI = false;
    private boolean queryNNI = false;

    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc) {
        int i;
        this.outputData = TEDataConverter.convertToDatainterface((int)neid, (SubFunc)subfunc, (ArrayList)operationList);
        BussinessParams bp = this.outputData.getBussinessParams();
        ArrayList<RowParams> tmpRowParamList = new ArrayList<RowParams>();
        RowParams[] rows = bp.getRowParams();
        RowParams row = null;
        RowParams tmpRow = null;
        Param index = null;
        Param vlan = null;
        Param portType = null;
        Param portID = null;
        Param quickLeaveEnableState = null;
        for (i = 0; i < rows.length; ++i) {
            row = rows[i];
            index = row.getParam("indexID");
            if (null == index) {
                return;
            }
            vlan = row.getParam("vlanID");
            portType = row.getParam("portType");
            portID = row.getParam("portID");
            quickLeaveEnableState = row.getParam("quickLeaveEnableState");
            tmpRow = new RowParams();
            tmpRow.addParam(index);
            tmpRow.addParam(vlan);
            tmpRow.addParam(portType);
            tmpRow.addParam(quickLeaveEnableState);
            if (UNI.equals(portType.getValue())) {
                if (!this.queryUNI) {
                    this.queryUNI = true;
                    this.getUniPortName(index.getValue());
                }
                tmpRow.addParam("port", portID.getValue());
                tmpRow.addParam("portID", (String)this.uniPortNameMap.get(portID.getValue()));
            } else {
                if (!this.queryNNI) {
                    this.queryNNI = true;
                    this.getNniPortName(index.getValue());
                }
                tmpRow.addParam("port", portID.getValue());
                tmpRow.addParam("portID", (String)this.nniPortNameMap.get(portID.getValue()));
            }
            tmpRowParamList.add(tmpRow);
        }
        bp.clearRowParams();
        int size = tmpRowParamList.size();
        for (i = 0; i < size; ++i) {
            bp.addRowParams((RowParams)tmpRowParamList.get(i));
        }
    }

    private void getUniPortName(String serviceIndex) {
        TEConfigurationDataMgr configurationData = TEConfigurationDataMgr.getInstance();
        if (null == this.definitions) {
            try {
                this.definitions = TECreateObjectFactory.parseQxDesFile((int)this.neid);
            }
            catch (Exception e) {
                TELogFactory.getNormalLogger().error("getOperation fail!", (Throwable)e);
                return;
            }
        }
        ArrayList<Object> uniPortList = new ArrayList<Object>();
        Operation oper = this.definitions.getOperation("NSCMD_SERVICE_GET_ETHVUNI");
        if (null == oper) {
            return;
        }
        Input input = oper.getInput();
        input.setPartValue("servType", ELAN);
        input.setPartValue("servIndex", serviceIndex + "");
        input.setPartValue("vuniId", "0");
        uniPortList.add(oper.clone());
        TENECommMgr.getInstance().sendCommand(this.neid, uniPortList, this.getTimeOut());
        Operation tmpOper = (Operation)uniPortList.get(0);
        uniPortList.clear();
        for (Output output : tmpOper.getOutput()) {
            int slotid = Integer.parseInt(output.getPartValue("slotid"));
            int boardType = configurationData.getBoardType(this.neid, slotid);
            String boardName = configurationData.getBoardTypeName(this.neid, boardType);
            StringBuffer portAllName = new StringBuffer();
            portAllName.append(slotid).append("-").append(boardName).append("-");
            int subslotid = Integer.parseInt(output.getPartValue("subslotid"));
            if (255 != subslotid) {
                int subboardType = configurationData.getSubboardType(this.neid, slotid, subslotid);
                String subboardName = configurationData.getBoardTypeName(this.neid, subboardType);
                portAllName.append(subslotid).append("-").append(subboardName).append("-");
            }
            int port = Integer.parseInt(output.getPartValue("port"));
            String portName = configurationData.getPortName(this.neid, slotid, boardType, port);
            portAllName.append(portName);
            int tagNum = Integer.parseInt(output.getPartValue("tagNum"));
            if (0 != tagNum) {
                String tagIds = output.getPartValue("tagIds");
                int tagidLen = 8;
                StringBuffer buf = new StringBuffer();
                int vlanLen = tagIds.length();
                for (int z = 0; z < vlanLen; z += tagidLen) {
                    int tagID = Integer.parseInt(tagIds.substring(z, z + tagidLen), 16);
                    buf.append(tagID).append(',');
                }
                String tagidStr = buf.delete(buf.length() - 1, buf.length()).toString();
                tagidStr = "[" + this.parseEncapsValueList(tagidStr) + "]";
                portAllName.append(tagidStr);
            }
            String vuniId = output.getPartValue("vuniId");
            this.uniPortNameMap.put(vuniId, portAllName.toString());
        }
    }

    private void getNniPortName(String serviceIndex) {
        TEConfigurationDataMgr configurationData = TEConfigurationDataMgr.getInstance();
        if (null == this.definitions) {
            try {
                this.definitions = TECreateObjectFactory.parseQxDesFile((int)this.neid);
            }
            catch (Exception e) {
                TELogFactory.getNormalLogger().error("getOperation fail!", (Throwable)e);
                return;
            }
        }
        ArrayList<Object> uniPortList = new ArrayList<Object>();
        Operation oper = this.definitions.getOperation("NSCMD_SERVICE_GET_EVNNI");
        if (null == oper) {
            return;
        }
        Input input = oper.getInput();
        input.setPartValue("servType", ELAN);
        input.setPartValue("servIndex", serviceIndex + "");
        input.setPartValue("vnniId", "0");
        uniPortList.add(oper.clone());
        TENECommMgr.getInstance().sendCommand(this.neid, uniPortList, this.getTimeOut());
        Operation tmpOper = (Operation)uniPortList.get(0);
        uniPortList.clear();
        for (Output output : tmpOper.getOutput()) {
            StringBuffer portAllName = new StringBuffer();
            String vnniId = output.getPartValue("vnniId");
            int carrierType = Integer.parseInt(output.getPartValue("carrierType"));
            if (1 == carrierType) {
                long pwIndex = Long.parseLong(output.getPartValue("port"));
                String pwID = this.getPWID(pwIndex);
                portAllName.append("PW-").append(pwID);
            }
            if (4 == carrierType) {
                long QINQIndex = Long.parseLong(output.getPartValue("port"));
                portAllName.append("QinQ-").append(QINQIndex);
            }
            if (3 == carrierType) {
                int slotid = Integer.parseInt(output.getPartValue("slotid"));
                int boardType = configurationData.getBoardType(this.neid, slotid);
                String boardName = configurationData.getBoardTypeName(this.neid, boardType);
                portAllName.append(slotid).append("-").append(boardName).append("-");
                int subslotid = Integer.parseInt(output.getPartValue("subslotid"));
                if (255 != subslotid) {
                    int subboardType = configurationData.getSubboardType(this.neid, slotid, subslotid);
                    String subboardName = configurationData.getBoardTypeName(this.neid, subboardType);
                    portAllName.append(subslotid).append("-").append(subboardName).append("-");
                }
                int port = Integer.parseInt(output.getPartValue("port"));
                String portName = configurationData.getPortName(this.neid, slotid, boardType, port);
                portAllName.append(portName);
            }
            this.nniPortNameMap.put(vnniId, portAllName.toString());
        }
    }

    private String getPWID(long pwIndex) {
        String pwID = "";
        ArrayList<Object> pwIDList = new ArrayList<Object>();
        Operation oper = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_PTN_MPLS_PW_GET_PW");
        if (null == oper) {
            return pwID;
        }
        Input input = oper.getInput();
        input.setPartValue("pwIndex", pwIndex + "");
        pwIDList.add(oper.clone());
        TENECommMgr.getInstance().sendCommand(this.neid, pwIDList, this.getTimeOut());
        Operation tmpOper = (Operation)pwIDList.get(0);
        pwIDList.clear();
        for (Output output : tmpOper.getOutput()) {
            pwID = output.getPartValue("pwId");
        }
        return pwID;
    }

    private String parseEncapsValueList(String str) {
        String[] stringArray = str.split(",");
        int[] intArray = new int[stringArray.length];
        int len = stringArray.length;
        for (int j = 0; j < len; ++j) {
            intArray[j] = Integer.parseInt(stringArray[j]);
        }
        Arrays.sort(intArray);
        ArrayList<String> encapsValue = new ArrayList<String>();
        int len2 = stringArray.length;
        for (int j = 0; j < len2; ++j) {
            encapsValue.add(intArray[j] + "");
        }
        String result = "";
        if (encapsValue.size() >= 2) {
            Iterator it = encapsValue.iterator();
            int curNum = Integer.parseInt((String)it.next());
            int offset = 0;
            StringBuffer temp = new StringBuffer(curNum + "");
            while (it.hasNext()) {
                int nextNum = Integer.parseInt((String)it.next());
                if (nextNum != curNum + offset + 1) {
                    if (offset != 0) {
                        temp.append("-").append(curNum + offset);
                        temp.append(",").append(nextNum);
                    } else {
                        temp.append(",").append(nextNum);
                    }
                    offset = 0;
                    curNum = nextNum;
                    continue;
                }
                ++offset;
            }
            if (offset > 0) {
                temp.append("-").append(curNum + offset);
            }
            result = temp.toString();
        } else if (encapsValue.size() == 1) {
            result = encapsValue.get(0).toString();
        }
        return result;
    }
}

