/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ptn.portpoweroffindication;

import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.ErrorMessage;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.model.TESubBoard;
import com.huawei.nglct.nemgr.ptn.dcnmgr.TEDCNPort;
import com.huawei.nglct.ptn_pub.TEPTNUtil;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import gnu.trove.TIntHashSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class TEQueryPortPoweroffIndication
extends TENEExplorerBean {
    private int accessType;
    private Datainterface newinput = null;
    private TEPTNUtil ptnUtil = TEPTNUtil.instance();
    private static final String FILTERBOARD = "PORT_POWEROFFINDICATION";

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        this.neid = neid;
        this.subfunc = subFunc;
        this.inputData = inputData;
        this.accessType = Integer.valueOf(inputData.getBussinessParams().getRowParams(0).getParam("accesstype").getValue());
        this.newinput = new Datainterface();
        BussinessParams businessParam = new BussinessParams();
        this.newinput.setBussinessParams(businessParam);
        this.outputData = new Datainterface();
        this.handleInputData(this.accessType);
        this.operationList = this.getOperation(neid, subFunc, this.newinput, memeryData);
        if (this.operationList.size() <= 0) {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neid, (int)0));
            return this.outputData;
        }
        int result = this.sendMessage(neid);
        if (result == 0) {
            this.handleMessage(neid, this.operationList, subFunc);
        } else {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)result));
        }
        if (this.isNeedOperationlog()) {
            this.writeLog(neid, subFunc, inputData, user, ipAddress, this.outputData);
        }
        return this.outputData;
    }

    private void handleInputData(int accessType) {
        TIntHashSet filterBdList = this.ptnUtil.getFilterBoardsSet(this.neid, FILTERBOARD);
        TENE ne = TENEListMgr.getInstance().getNE(this.neid);
        Vector boardList = ne.getClonedBoardList();
        if (null == boardList) {
            return;
        }
        TEBoard board = null;
        TESubBoard subBoard = null;
        int subboardid = 255;
        List subBoardList = null;
        RowParams rowParams = null;
        int size = boardList.size();
        for (int i = 0; i < size; ++i) {
            board = (TEBoard)boardList.get(i);
            int boardType = board.getBoardType();
            if (!filterBdList.contains(boardType)) continue;
            int slotid = board.getSlotID();
            subBoardList = board.getSubBoardList();
            if (subBoardList.size() > 0) {
                int n = subBoardList.size();
                for (int j = 0; j < n; ++j) {
                    subBoard = (TESubBoard)subBoardList.get(j);
                    rowParams = new RowParams();
                    rowParams.addParam("slotid", slotid + "");
                    rowParams.addParam("subboardid", subBoard.getSubSlotID() + "");
                    rowParams.addParam("accesstype", accessType + "");
                    rowParams.addParam("portid", "0");
                    this.newinput.getBussinessParams().addRowParams(rowParams);
                }
                continue;
            }
            rowParams = new RowParams();
            rowParams.addParam("slotid", slotid + "");
            rowParams.addParam("subboardid", subboardid + "");
            rowParams.addParam("accesstype", accessType + "");
            rowParams.addParam("portid", "0");
            this.newinput.getBussinessParams().addRowParams(rowParams);
        }
    }

    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc) {
        HashMap<String, TEDCNPort> portMap = new HashMap<String, TEDCNPort>();
        ArrayList<RowErrors> errorData = new ArrayList<RowErrors>();
        this.outputData.setBussinessParams(new BussinessParams());
        this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neid, (int)0));
        ArrayList filterErrLst = this.getFilterErrorCodeList();
        int m = operationList.size();
        for (int i = 0; i < m; ++i) {
            Operation operation = (Operation)operationList.get(i);
            for (Output output : operation.getOutput()) {
                int retCode = Integer.valueOf(output.getFault()[0].getCode());
                if (retCode != 0 && !filterErrLst.contains(retCode)) {
                    this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neid, (int)1));
                    errorData.add(this.constructRowErrors(neid, subfunc, output));
                    continue;
                }
                String slotid = output.getPartValue("slotid");
                String subboardid = output.getPartValue("subboardid");
                String portid = output.getPartValue("portid");
                String hashvalue = slotid + subboardid + portid;
                String enablestatus = output.getPartValue("enablestatus");
                TEDCNPort port = (TEDCNPort)portMap.get(hashvalue);
                if (null != port || null == slotid) continue;
                port = new TEDCNPort();
                port.soltid = Integer.valueOf(slotid);
                port.subboardid = Integer.valueOf(subboardid);
                port.portid = Integer.valueOf(portid);
                port.accesssta = Integer.valueOf(enablestatus);
                portMap.put(hashvalue, port);
            }
        }
        this.addErrorData(errorData);
        this.handleOutData(portMap);
    }

    private void addErrorData(List errorData) {
        if (null != errorData && 0 != errorData.size()) {
            RowParams rowparams = new RowParams();
            RowErrors rErrors = null;
            int size = errorData.size();
            for (int i = 0; i < size; ++i) {
                rErrors = (RowErrors)errorData.get(i);
                rowparams.addRowErrors(rErrors);
            }
            this.outputData.getBussinessParams().addRowParams(rowparams);
        }
    }

    public RowErrors constructRowErrors(int neid, SubFunc subfunc, Output output) {
        String errorCode = "";
        errorCode = output.getFault(0).getCode();
        RowErrors rowError = new RowErrors();
        ErrorMessage errorMessage = new ErrorMessage();
        errorMessage.setErrorcode(errorCode);
        if (!errorCode.equals("")) {
            errorMessage.setErrorinfo(TEErrorResourceUtil.getErrCodeResWithDot((int)Integer.parseInt(errorCode)));
        } else {
            errorMessage.setErrorinfo("");
        }
        rowError.setErrorMessage(errorMessage);
        return rowError;
    }

    private void handleOutData(Map dcnPortMap) {
        ArrayList dcnList = new ArrayList(dcnPortMap.values());
        Collections.sort(dcnList, new MyCompare());
        for (TEDCNPort port : dcnList) {
            RowParams rowParams = new RowParams();
            rowParams.addParam("portid", port.portid + "");
            rowParams.addParam("slotid", port.soltid + "");
            rowParams.addParam("subboardid", port.subboardid + "");
            rowParams.addParam("accesstype", this.accessType + "");
            rowParams.addParam("enablestatus", port.accesssta + "");
            rowParams.addParam("portname", port.getportname(this.neid));
            this.outputData.getBussinessParams().addRowParams(rowParams);
        }
    }

    class MyCompare
    implements Comparator<Object> {
        MyCompare() {
        }

        @Override
        public int compare(Object o0, Object o1) {
            TEDCNPort port0 = (TEDCNPort)o0;
            TEDCNPort port1 = (TEDCNPort)o1;
            if (port0.soltid > port1.soltid) {
                return 1;
            }
            if (port0.soltid < port1.soltid) {
                return -1;
            }
            if (port0.portid > port1.portid) {
                return 1;
            }
            if (port0.portid < port1.portid) {
                return -1;
            }
            return 0;
        }
    }
}

