/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ptn.policy;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.TEDataConverter;
import com.huawei.nglct.common.datainterface.ErrorMessage;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.ptn_pub.TEPTNUtil;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.qxprotocol.definitions.Definitions;
import com.huawei.uflight.qxprotocol.definitions.Fault;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import java.util.ArrayList;

public class TEQueryVportBean
extends TENEExplorerBean {
    public static final int MIN_VPORT = 10240;
    public static final int MAX_VPORT = 12287;
    private String INVALID_SLOTID = "65535";
    private static final String INVALID_SUBSLOTID = "255";
    private static final int VEthnet_PORT = 10240;
    private Definitions definitions = null;
    private static final int ERROR_CODE_PORT_NOT_EXIST = 42165;

    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc) {
        this.outputData = TEDataConverter.convertToDatainterface((int)neid, (SubFunc)subfunc, (ArrayList)operationList, (ArrayList)this.getFilterErrorCodeList());
        if (2 == Integer.parseInt(this.outputData.getErrorMessage().getErrorcode())) {
            return;
        }
        try {
            this.definitions = TECreateObjectFactory.parseQxDesFile((int)neid);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("Parse QxDesFile fail!", (Throwable)e);
        }
        operationList.clear();
        ArrayList rowList = this.outputData.getBussinessParams().getRowParamList();
        Operation oper = this.definitions.getOperation("NSCMD_PTN_PORT_GET_NAME");
        Input input = oper.getInput();
        input.setPartValue("slotid", this.INVALID_SLOTID);
        input.setPartValue("subslotid", INVALID_SUBSLOTID);
        input.setPartValue("port", "0");
        operationList.add(oper);
        int result = this.sendMessage(neid);
        if (result != 0) {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)result));
            return;
        }
        Operation tmpOper = (Operation)operationList.get(0);
        Output[] output = tmpOper.getOutput();
        for (Fault fault : output[0].getFault()) {
            int code = Integer.parseInt(fault.getCode());
            if (code == 0) continue;
            ErrorMessage bigErr = TEErrorResourceUtil.getErrorMessage((int)1);
            this.outputData.setErrorMessage(bigErr);
            return;
        }
        int size = rowList.size();
        block3: for (int i = 0; i < size; ++i) {
            RowParams row = (RowParams)rowList.get(i);
            if (row.getParam("slotid") == null || !row.getParam("slotid").getValue().equals(this.INVALID_SLOTID) || row.getParam("subslotid") == null || !row.getParam("subslotid").getValue().equals(INVALID_SUBSLOTID)) continue;
            int len = output.length;
            for (int j = 0; j < len; ++j) {
                int portId = Integer.parseInt(row.getParam("port").getValue());
                int portId_qryPortName = Integer.parseInt(output[j].getPartValue("port"));
                String portName = output[j].getPartValue("portName");
                if (portName != null) {
                    portName = portName.trim();
                }
                if (portId != portId_qryPortName) continue;
                row.getParam("portname").setValue(TEPTNUtil.instance().getLogicPortName(portId, portName));
                continue block3;
            }
        }
    }

    public ArrayList getFilterErrorCodeList() {
        ArrayList<Integer> errorList = new ArrayList<Integer>();
        errorList.add(38662);
        errorList.add(42165);
        return errorList;
    }
}

