/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ptn.orderwire;

import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.model.configmodel.TESpecialAttrMgr;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import java.util.Vector;

public class TEPublicBoardQueryBean
extends TENEExplorerBean {
    private int neid;
    private Datainterface output;
    private boolean haspublicbd;
    private int DEFAULT_BOARDID = -1;

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        this.neid = neid;
        this.output = new Datainterface();
        TENE neObj = TENEListMgr.getInstance().getNE(neid);
        try {
            if (null != neObj) {
                this.queryPublicBoard();
            } else {
                this.output.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)1090596385));
            }
        }
        catch (Exception e) {
            this.output.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)1090646019));
        }
        return this.output;
    }

    private void queryPublicBoard() {
        RowParams rowparams = null;
        TEBoard board = null;
        int bdType = 0;
        int slotID = 0;
        this.haspublicbd = false;
        this.output.setBussinessParams(new BussinessParams());
        Vector boardList = TENEListMgr.getInstance().getNE(this.neid).getClonedBoardList();
        int size = boardList.size();
        for (int j = 0; j < size; ++j) {
            board = (TEBoard)boardList.get(j);
            slotID = board.getSlotID();
            bdType = board.getBoardType();
            if (bdType != 1410 && bdType != 1411 && bdType != 1607 && bdType != 1608 && bdType != 1609 && bdType != 2443 && bdType != 2465 && bdType != 2444 && bdType != 2476 && !TESpecialAttrMgr.getInstance().isCPSupportByType(bdType, "TE_FUNC_CFG_OHP_INTERFACE", "PTN_ATTR_ORDERWIRE_F1DATA")) continue;
            rowparams = new RowParams();
            rowparams.addParam("publicboardid", String.valueOf(slotID));
            this.output.getBussinessParams().addRowParams(rowparams);
            this.haspublicbd = true;
            break;
        }
        if (!this.haspublicbd) {
            rowparams = new RowParams();
            rowparams.addParam("publicboardid", String.valueOf(this.DEFAULT_BOARDID));
            this.output.getBussinessParams().addRowParams(rowparams);
        }
        this.output.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
    }
}

