/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ptn.orderwire;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TENEMgrInterface;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.TEQueryLogicPort;
import com.huawei.nglct.nelist.model.configmodel.TESpecialAttrMgr;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Vector;
import org.slf4j.Logger;

public class TEAvailabePortQueryBean
implements TENEMgrInterface {
    private int neid;
    private Datainterface output;
    private Logger log = TELogFactory.getNormalLogger();

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        this.neid = neid;
        this.output = new Datainterface();
        TENE neObj = TENEListMgr.getInstance().getNE(neid);
        try {
            if (null != neObj) {
                this.getAvaliableBoard();
            } else {
                this.output.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)1090596385));
            }
        }
        catch (Exception e) {
            this.log.error("Get Avaliable IPA Board Fail!\n", (Throwable)e);
            this.output.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)1090646019));
        }
        return this.output;
    }

    private void getAvaliableBoard() {
        this.output.setBussinessParams(new BussinessParams());
        RowParams rowparams = null;
        TEBoard board = null;
        int bdType = 0;
        int slotID = 0;
        int port = 0;
        String bdName = "";
        Vector boardList = TENEListMgr.getInstance().getNE(this.neid).getClonedBoardList();
        int size = boardList.size();
        for (int j = 0; j < size; ++j) {
            List pathList;
            String availableport;
            int portIndex;
            int portLen;
            ArrayList<Integer> portList;
            board = (TEBoard)boardList.get(j);
            bdType = board.getBoardType();
            slotID = board.getSlotID();
            bdName = TEConfigurationDataMgr.getInstance().getBoardTypeName(this.neid, bdType);
            if (bdType == 1404 || TESpecialAttrMgr.getInstance().isCPSupportByType(bdType, "TE_FUNC_CFG_OHP_INTERFACE", "PTN_ATTR_ORDERWIRE_F1_LOGICPORT")) {
                portList = TEQueryLogicPort.getLogicPortList((int)this.neid, (int)slotID, (int)bdType);
                if (null == portList) continue;
                Collections.sort(portList);
                portLen = portList.size();
                for (portIndex = 0; portIndex < portLen; ++portIndex) {
                    port = (Integer)portList.get(portIndex);
                    rowparams = new RowParams();
                    availableport = slotID + "-" + bdName + "-" + this.getPortName(slotID, port);
                    rowparams.addParam("availableport", availableport);
                    this.output.getBussinessParams().addRowParams(rowparams);
                }
            }
            if (bdType == 2079 || bdType == 2080) {
                portList = new ArrayList<Integer>();
                portList.add(1);
                portLen = portList.size();
                for (portIndex = 0; portIndex < portLen; ++portIndex) {
                    port = (Integer)portList.get(portIndex);
                    rowparams = new RowParams();
                    availableport = slotID + "-" + bdName + "-" + this.getPortName(slotID, port);
                    rowparams.addParam("availableport", availableport);
                    this.output.getBussinessParams().addRowParams(rowparams);
                }
            }
            if ((pathList = TESpecialAttrMgr.getInstance().getCPAttrListValue(this.neid, slotID, "TE_FUNC_CFG_OHP_INTERFACE", "PTN_ATTR_ORDERWIRE_F1_PORTNUM")).isEmpty()) continue;
            portLen = pathList.size();
            for (portIndex = 0; portIndex < portLen; ++portIndex) {
                port = Integer.parseInt((String)pathList.get(portIndex));
                rowparams = new RowParams();
                availableport = slotID + "-" + bdName + "-" + this.getPortName(slotID, port);
                rowparams.addParam("availableport", availableport);
                this.output.getBussinessParams().addRowParams(rowparams);
            }
        }
        this.output.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
    }

    private String getPortName(int slotID, int portID) {
        TEBoard board = TEConfigurationDataMgr.getInstance().getBoard(this.neid, slotID);
        if (board == null) {
            return "";
        }
        int boardType = board.getBoardType();
        String portName = TEConfigurationDataMgr.getInstance().getPortName(this.neid, slotID, boardType, portID);
        return portName;
    }

    public boolean isNeedOperationlog() {
        return false;
    }
}

