/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ptn.lptmanagement;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TENEMgrInterface;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.model.TESubBoard;
import com.huawei.nglct.ptn_pub.TEPTNUtil;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import gnu.trove.TIntHashSet;
import java.util.List;
import java.util.Vector;
import org.slf4j.Logger;

public class TEQueryEthBoards
implements TENEMgrInterface {
    private Datainterface datainterface = null;
    Vector boardList = null;
    int neID = 0;
    int queryType = 0;
    private Logger log = TELogFactory.getNormalLogger();
    private TEPTNUtil util = TEPTNUtil.instance();

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        this.neID = neid;
        Param qtParam = Datainterface.getParam((Param[])inputData.getBussinessParams().getRowParams(0).getParam(), (String)"queryType");
        this.queryType = Integer.parseInt(qtParam.getValue());
        TENE ne = TENEListMgr.getInstance().getNE(this.neID);
        if (ne != null) {
            this.boardList = ne.getBoardList();
        }
        if (null == this.boardList || this.boardList.isEmpty()) {
            this.datainterface = new Datainterface();
            this.datainterface.setBussinessParams(new BussinessParams());
            this.datainterface.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)this.neID, (int)0));
            return this.datainterface;
        }
        this.datainterface = this.constructBoardListData();
        if (null != this.datainterface && null != this.datainterface.getBussinessParams()) {
            this.datainterface.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
        } else {
            this.log.error("Get BoardInfo Fail!\n");
            this.datainterface.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)2));
        }
        return this.datainterface;
    }

    public Datainterface constructBoardListData() {
        TIntHashSet boards;
        Datainterface data = new Datainterface();
        BussinessParams bParams = new BussinessParams();
        TIntHashSet boards1 = boards = this.util.getFilterBoardsSet(this.neID, "CREATE_BFD_01");
        int size = this.boardList.size();
        for (int i = 0; i < size; ++i) {
            String sourceBoard;
            String subBoardName;
            int subBoardSlot;
            TESubBoard subBoards;
            int k;
            int isize;
            List subBoardList;
            String boardName;
            int slotid;
            RowParams rParams = new RowParams();
            Param param = null;
            TEBoard board = (TEBoard)this.boardList.get(i);
            int boardType = board.getBoardType();
            if (this.queryType == 0) {
                if (!boards.contains(boardType)) continue;
                slotid = board.getSlotID();
                boardName = board.getBoardName();
                subBoardList = board.getSubBoardList();
                if (!subBoardList.isEmpty()) {
                    isize = subBoardList.size();
                    for (k = 0; k < isize; ++k) {
                        subBoards = (TESubBoard)subBoardList.get(k);
                        subBoardSlot = subBoards.getSubSlotID();
                        subBoardName = subBoards.getSubBoardName();
                        sourceBoard = slotid + "-" + boardName + "-" + subBoardSlot + "-" + subBoardName;
                        param = new Param("sourceboard", sourceBoard);
                        rParams.addParam(param);
                    }
                } else {
                    param = new Param("sourceboard", slotid + "-" + boardName);
                    rParams.addParam(param);
                }
                bParams.addRowParams(rParams);
                continue;
            }
            if (!boards1.contains(boardType)) continue;
            slotid = board.getSlotID();
            boardName = board.getBoardName();
            subBoardList = board.getSubBoardList();
            if (!subBoardList.isEmpty()) {
                isize = subBoardList.size();
                for (k = 0; k < isize; ++k) {
                    subBoards = (TESubBoard)subBoardList.get(k);
                    subBoardSlot = subBoards.getSubSlotID();
                    subBoardName = subBoards.getSubBoardName();
                    sourceBoard = slotid + "-" + boardName + "-" + subBoardSlot + "-" + subBoardName;
                    param = new Param("sourceboard", sourceBoard);
                    rParams.addParam(param);
                }
            } else {
                param = new Param("sourceboard", slotid + "-" + boardName);
                rParams.addParam(param);
            }
            bParams.addRowParams(rParams);
        }
        data.setBussinessParams(bParams);
        return data;
    }

    public boolean isNeedOperationlog() {
        return false;
    }
}

