/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ptn.logicsys.mooperation;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.ErrorMessage;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.db.TECommonDaoService;
import com.huawei.nglct.db.TEDaoNameValuePair;
import com.huawei.nglct.db.TEDaoOperationResult;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nemgr.ptn.logicsys.datacfg.TELineMspComparator;
import com.huawei.nglct.po.embeddednemgrmo.ptn.linemsp.TELineMspBoardMapMOPO;
import com.huawei.nglct.po.embeddednemgrmo.ptn.linemsp.TELineMspMOPO;
import com.huawei.nglct.ptn_pub.TEPTNUtil;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class TELineMspMoOperationUtil {
    public static final char PROID_E2E = '\u0bda';
    public static final int CREATE_REPORT_CMD = 11536466;
    public static final int DELETE_REPORT_CMD = 11536469;

    public static TELineMspMOPO getLMspMOPO(RowParams rowParams) {
        TELineMspMOPO lineMspMOPO = new TELineMspMOPO();
        long mspID = Long.parseLong(rowParams.getParam("groupID").getValue());
        lineMspMOPO.setLineMspID(mspID);
        short protectType = Short.parseShort(rowParams.getParam("protectionType").getValue());
        lineMspMOPO.setProtectType(protectType);
        short switchMode = Short.parseShort(rowParams.getParam("switchMode").getValue());
        lineMspMOPO.setSwitchMode(switchMode);
        short recoverMode = Short.parseShort(rowParams.getParam("revertiveMode").getValue());
        lineMspMOPO.setRecoverMode(recoverMode);
        int wrtTime = 0;
        if (rowParams.getParam("revertiveTime") != null && rowParams.getParam("revertiveTime").getValue() != null && !rowParams.getParam("revertiveTime").getValue().trim().equals("")) {
            wrtTime = Integer.parseInt(rowParams.getParam("revertiveTime").getValue());
        }
        lineMspMOPO.setWRTTime(wrtTime);
        short sdflag = Short.parseShort(rowParams.getParam("sdEnable").getValue());
        lineMspMOPO.setSdflag(sdflag);
        short protocolType = Short.parseShort(rowParams.getParam("protocolType").getValue());
        lineMspMOPO.setProtocolType(protocolType);
        short sdsfSWFlag = Short.parseShort(rowParams.getParam("switchTag").getValue());
        lineMspMOPO.setSDSFPriSwitchFlag(sdsfSWFlag);
        short switchIndication = Short.parseShort(rowParams.getParam("switchIndication").getValue());
        lineMspMOPO.setSwitchModeIndication(switchIndication);
        short activationStatus = Short.parseShort(rowParams.getParam("activationStatus").getValue());
        lineMspMOPO.setActivationStatus(activationStatus);
        return lineMspMOPO;
    }

    public static TELineMspBoardMapMOPO getLMspBoardMapMOPO(int neID, RowParams rowParams, short protectUnitID, String _slotID, String _subSlotID, String _portID) {
        long slotID = Long.parseLong(rowParams.getParam(_slotID).getValue());
        long subSlotID = Long.parseLong(rowParams.getParam(_subSlotID).getValue());
        long portID = Long.parseLong(rowParams.getParam(_portID).getValue());
        long absolutePortID = TEPTNUtil.getAbsolutePortID((int)16, (int)((int)subSlotID), (int)((int)portID));
        int boardType = TEConfigurationDataMgr.getInstance().getBoardType(neID, (int)slotID);
        TELineMspBoardMapMOPO lMspBoardMapMOPO = new TELineMspBoardMapMOPO(protectUnitID, boardType, slotID, subSlotID, absolutePortID);
        return lMspBoardMapMOPO;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TEDaoOperationResult getLMSPDBData(int neID) {
        TEDaoOperationResult dbResult = null;
        try {
            TENE ne = TENEListMgr.getInstance().getNE(neID);
            dbResult = 255 == ne.getNeImplInterface().getNeDatacfgStatus() ? TECommonDaoService.findAll((int[])new int[]{neID}, TELineMspMOPO.class) : TECommonDaoService.findAll_NonLock((int[])new int[]{neID}, TELineMspMOPO.class);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("The query LMSP from db result exception", (Throwable)e);
        }
        finally {
            if (null == dbResult) {
                TELogFactory.getNormalLogger().error("The query LMSP from db result exception");
            }
        }
        return dbResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TEDaoOperationResult getLMSPDBData_NonLock(int neID) {
        TEDaoOperationResult dbResult = null;
        try {
            dbResult = TECommonDaoService.findAll_NonLock((int[])new int[]{neID}, TELineMspMOPO.class);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("The query LMSP from db result exception", (Throwable)e);
        }
        finally {
            if (null == dbResult) {
                TELogFactory.getNormalLogger().error("The query LMSP from db result exception");
            }
        }
        return dbResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TEDaoOperationResult getLMSPDBData(int neID, Datainterface outputData) {
        TEDaoOperationResult dbResult = null;
        try {
            dbResult = TECommonDaoService.findAll((int[])new int[]{neID}, TELineMspMOPO.class);
        }
        catch (Exception e) {
            try {
                TELogFactory.getNormalLogger().error("The query LMSP from db result exception", (Throwable)e);
            }
            catch (Throwable throwable) {
                TELineMspMoOperationUtil.fillDBErrors(neID, outputData, dbResult);
                throw throwable;
            }
            TELineMspMoOperationUtil.fillDBErrors(neID, outputData, dbResult);
        }
        TELineMspMoOperationUtil.fillDBErrors(neID, outputData, dbResult);
        return dbResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TELineMspMOPO queryTELineMspMOPOFromDB(int neID, Long mspID) {
        TEDaoOperationResult dbResult = null;
        TELineMspMOPO lineMspMOPO = null;
        ArrayList<TEDaoNameValuePair> criteria = new ArrayList<TEDaoNameValuePair>();
        TEDaoNameValuePair aPair = new TEDaoNameValuePair("LineMspID", String.valueOf(mspID));
        criteria.add(aPair);
        try {
            dbResult = TECommonDaoService.findByID((int[])new int[]{neID}, TELineMspMOPO.class, criteria);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("The query LMSP ID from db result exception " + mspID, (Throwable)e);
        }
        finally {
            if (null == dbResult) {
                TELogFactory.getNormalLogger().error("The query LMSP from db result exception");
            }
        }
        if (null != dbResult && 0 == dbResult.getResult() && dbResult.getData().size() > 0) {
            lineMspMOPO = (TELineMspMOPO)dbResult.getData().get(0);
        }
        return lineMspMOPO;
    }

    public static Datainterface fillDBErrors(int neID, Datainterface outputData, TEDaoOperationResult dbResult) {
        if (dbResult != null) {
            if (dbResult.getResult() == 0) {
                return outputData;
            }
            TELogFactory.getNormalLogger().error("Operate DB is fail. The errorCode is " + dbResult.getResult() + " and the errorInfo is " + TEErrorResourceUtil.getErrorMessage((int)dbResult.getResult()) + "!");
        }
        int errorCode = 1090646274;
        RowErrors rowError = new RowErrors();
        Param errorparam = new Param("neid", String.valueOf(neID));
        rowError.addParam(errorparam);
        ErrorMessage errorMessage = new ErrorMessage();
        errorMessage.setErrorcode(String.valueOf(errorCode));
        errorMessage.setErrorinfo(TEErrorResourceUtil.getErrCodeResWithDot((int)errorCode));
        rowError.setErrorMessage(errorMessage);
        outputData.getBussinessParams().getRowParams(0).addRowErrors(rowError);
        errorMessage = outputData.getErrorMessage();
        if (0 == Integer.parseInt(errorMessage.getErrorcode())) {
            errorMessage.setErrorcode(String.valueOf(errorCode));
            errorMessage.setErrorinfo(TEErrorResourceUtil.getErrCodeResWithDot((int)neID, (int)errorCode));
        }
        return outputData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    public static int saveLmspDB(int neID, Datainterface allData, int operateFlag) {
        TELineMspBoardMapMOPO workLMspBoardMapMOPO;
        TELineMspMOPO lineMspMOPO;
        Param param;
        int row;
        HashMap<Long, TELineMspMOPO> mspIDToObjMap = new HashMap<Long, TELineMspMOPO>();
        BussinessParams businessparams = allData.getBussinessParams();
        if (businessparams == null) {
            return 0;
        }
        int rowlen = businessparams.getRowParamsCount();
        for (row = 0; row < rowlen; ++row) {
            RowParams rowparams = businessparams.getRowParams(row);
            param = rowparams.getParam("groupID");
            if (null == param) continue;
            lineMspMOPO = TELineMspMoOperationUtil.getLMspMOPO(rowparams);
            TELineMspBoardMapMOPO protectLMspBoardMapMOPO = TELineMspMoOperationUtil.getLMspBoardMapMOPO(neID, rowparams, (short)0, "Pslotid", "Psubslotid", "Pport");
            lineMspMOPO.getProtectBoardMapList().add(protectLMspBoardMapMOPO);
            workLMspBoardMapMOPO = TELineMspMoOperationUtil.getLMspBoardMapMOPO(neID, rowparams, (short)1, "Wslotid", "Wsubslotid", "Wport");
            lineMspMOPO.getWorkBoardMapList().add(workLMspBoardMapMOPO);
            mspIDToObjMap.put(lineMspMOPO.getLineMspID(), lineMspMOPO);
        }
        rowlen = businessparams.getRowParamsCount();
        for (row = 1; row < rowlen; ++row) {
            RowParams rowParams = businessparams.getRowParams(row);
            param = rowParams.getParam("WgroupID");
            if (null == param || null == (lineMspMOPO = (TELineMspMOPO)mspIDToObjMap.get(Long.parseLong(param.getValue())))) continue;
            short protectUnitID = Short.parseShort(rowParams.getParam("WprotectUnit").getValue());
            workLMspBoardMapMOPO = TELineMspMoOperationUtil.getLMspBoardMapMOPO(neID, rowParams, protectUnitID, "Wslotid", "Wsubslotid", "Wport");
            lineMspMOPO.getWorkBoardMapList().add(workLMspBoardMapMOPO);
        }
        TEDaoOperationResult dbResult = null;
        if (10 != operateFlag) {
            if (mspIDToObjMap.isEmpty()) {
                return 0;
            }
        } else {
            TELineMspComparator compatator = new TELineMspComparator();
            ArrayList<Object> oldLMSList = TELineMspMoOperationUtil.getLMSPDBData_NonLock(neID).getData();
            Collections.sort(oldLMSList, compatator);
            ArrayList<Object> deleteLMSList = new ArrayList<Object>();
            deleteLMSList.addAll(oldLMSList);
            Iterator iter = mspIDToObjMap.values().iterator();
            while (iter.hasNext()) {
                dbResult = TELineMspMoOperationUtil.syncSaveLmspDB(neID, (TELineMspMOPO)iter.next(), (List<Object>)oldLMSList, deleteLMSList);
                oldLMSList = deleteLMSList;
            }
            int i = 0;
            int len = deleteLMSList.size();
            while (true) {
                if (i >= len) {
                    if (null != dbResult) return 0;
                    return -1;
                }
                try {
                    dbResult = TECommonDaoService.delete_NonLock((int[])new int[]{neID}, deleteLMSList.get(i));
                }
                catch (Exception e) {
                    TELogFactory.getNormalLogger().error("Sync LMSP not save data to DB", (Throwable)e);
                }
                ++i;
            }
        }
        Iterator iter = mspIDToObjMap.values().iterator();
        do {
            if (!iter.hasNext()) return 0;
            try {
                dbResult = 3 == operateFlag ? TECommonDaoService.create_NonLock((int[])new int[]{neID}, iter.next()) : TECommonDaoService.create((int[])new int[]{neID}, iter.next());
                if (null != dbResult) continue;
            }
            catch (Exception e) {
                try {
                    if (3 == operateFlag) {
                        TELogFactory.getNormalLogger().error("Upload LMSP not save data to DB", (Throwable)e);
                    } else {
                        TELogFactory.getNormalLogger().error("Query LMSP not save data to DB", (Throwable)e);
                    }
                    if (null != dbResult) continue;
                }
                catch (Throwable throwable) {
                    if (null != dbResult) throw throwable;
                    TELineMspMoOperationUtil.fillDBErrors(neID, allData, dbResult);
                    throw throwable;
                }
                TELineMspMoOperationUtil.fillDBErrors(neID, allData, dbResult);
            }
            TELineMspMoOperationUtil.fillDBErrors(neID, allData, dbResult);
        } while (null != dbResult);
        return -1;
    }

    public static TEDaoOperationResult syncSaveLmspDB(int neID, TELineMspMOPO tmpLineMo, List<Object> oldLMSList, List<Object> deleteLMSList) {
        TEDaoOperationResult dbResult = null;
        TELineMspMOPO oldLineMo = null;
        int len = oldLMSList.size();
        for (int i = 0; i < len; ++i) {
            oldLineMo = (TELineMspMOPO)oldLMSList.get(i);
            if (tmpLineMo.getLineMspID() != oldLineMo.getLineMspID()) continue;
            try {
                dbResult = TECommonDaoService.update_NonLock((int[])new int[]{neID}, (Object)tmpLineMo);
            }
            catch (Exception e) {
                TELogFactory.getNormalLogger().error("Sync LMSP not save data to DB", (Throwable)e);
            }
            deleteLMSList.remove(oldLineMo);
            return dbResult;
        }
        try {
            dbResult = TECommonDaoService.create_NonLock((int[])new int[]{neID}, (Object)tmpLineMo);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("Sync LMSP not save data to DB", (Throwable)e);
        }
        return dbResult;
    }
}

