/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ptn.logicsys;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TENEMgrInterface;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.TEQueryLogicPort;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Vector;
import org.slf4j.Logger;

public class TEMCQueryProtocalChlBean
implements TENEMgrInterface {
    private int neid;
    private Datainterface output;
    private Logger log = TELogFactory.getNormalLogger();
    private static final int BOARD_ASD1 = 1170;

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        this.neid = neid;
        this.output = new Datainterface();
        TENE neObj = TENEListMgr.getInstance().getNE(neid);
        try {
            if (null != neObj) {
                this.getAvaliableBoard();
            } else {
                this.output.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)1090596385));
            }
        }
        catch (Exception e) {
            this.log.error("Get Avaliable IPA Board Fail!\n", (Throwable)e);
            this.output.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)1090646019));
        }
        return this.output;
    }

    private void getAvaliableBoard() {
        this.output.setBussinessParams(new BussinessParams());
        RowParams rowparams = null;
        TEBoard board = null;
        int bdType = 0;
        int slotId = 0;
        int port = 0;
        String bdName = "";
        Vector boardList = TENEListMgr.getInstance().getNE(this.neid).getClonedBoardList();
        int size = boardList.size();
        for (int j = 0; j < size; ++j) {
            board = (TEBoard)boardList.get(j);
            bdType = board.getBoardType();
            slotId = board.getSlotID();
            bdName = board.getBoardName();
            ArrayList portList = TEQueryLogicPort.getLogicPortList((int)this.neid, (int)slotId, (int)bdType);
            if (null == portList) continue;
            Collections.sort(portList);
            int portLen = portList.size();
            for (int portIndex = 0; portIndex < portLen; ++portIndex) {
                port = (Integer)portList.get(portIndex);
                rowparams = new RowParams();
                rowparams.addParam("neid", String.valueOf(this.neid));
                rowparams.addParam("slotid", String.valueOf(slotId));
                rowparams.addParam("boardname", bdName);
                rowparams.addParam("subslotid", "0");
                rowparams.addParam("subboardname", "");
                rowparams.addParam("port", String.valueOf(port));
                rowparams.addParam("portname", TEConfigurationDataMgr.getInstance().getPortName(this.neid, slotId, bdType, port));
                this.output.getBussinessParams().addRowParams(rowparams);
            }
        }
        this.output.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
    }

    public boolean isNeedOperationlog() {
        return false;
    }
}

