/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ptn.logicsys;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TENEMgrInterface;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.TESubBoard;
import com.huawei.nglct.nelist.model.circuitpack.TEPortProperty;
import com.huawei.nglct.nemgr.ptn.util.TEGetPortRes;
import com.huawei.nglct.ptn_pub.TEPTNUtil;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import gnu.trove.TIntHashSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.slf4j.Logger;

public class TEMCAvailabeResQueryBean
implements TENEMgrInterface {
    private int neid;
    private Datainterface output;
    private Logger log = TELogFactory.getNormalLogger();
    private TEGetPortRes resUtil = TEGetPortRes.getInstance();

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        this.neid = neid;
        this.output = new Datainterface();
        TENE neObj = TENEListMgr.getInstance().getNE(neid);
        try {
            if (null != neObj) {
                this.getAvaliableBoard();
            } else {
                this.output.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)1090596385));
            }
        }
        catch (Exception e) {
            this.log.error("Get Avaliable IPA Board Fail!\n", (Throwable)e);
            this.output.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)1090646019));
        }
        return this.output;
    }

    private void getAvaliableBoard() {
        this.output.setBussinessParams(new BussinessParams());
        TEConfigurationDataMgr cfgDataMgr = TEConfigurationDataMgr.getInstance();
        RowParams rowparams = null;
        TEBoard board = null;
        int bdType = 0;
        int slotId = 0;
        int port = 0;
        String bdName = "";
        Vector boardList = TENEListMgr.getInstance().getNE(this.neid).getClonedBoardList();
        int size = boardList.size();
        for (int j = 0; j < size; ++j) {
            board = (TEBoard)boardList.get(j);
            bdType = board.getBoardType();
            slotId = board.getSlotID();
            bdName = board.getBoardName();
            if (this.isPtnSuppBoard(this.neid, slotId, 255, bdType)) {
                ArrayList<TEPortProperty> portList = this.resUtil.getAllPorts(this.neid, slotId, 255, bdType);
                if (null == portList) continue;
                int portLen = portList.size();
                for (int portIndex = 0; portIndex < portLen; ++portIndex) {
                    port = portList.get(portIndex).getPortNo();
                    rowparams = new RowParams();
                    rowparams.addParam("neid", String.valueOf(this.neid));
                    rowparams.addParam("slotid", String.valueOf(slotId));
                    rowparams.addParam("boardname", bdName);
                    rowparams.addParam("subslotid", "0");
                    rowparams.addParam("subboardname", "");
                    rowparams.addParam("port", String.valueOf(port));
                    rowparams.addParam("portname", TEConfigurationDataMgr.getInstance().getPortName(this.neid, slotId, bdType, port));
                    this.output.getBussinessParams().addRowParams(rowparams);
                }
            }
            List subList = board.getSubBoardList();
            int len = subList.size();
            for (int i = 0; i < len; ++i) {
                ArrayList<TEPortProperty> portList;
                TESubBoard subBoard = (TESubBoard)subList.get(i);
                int subSlot = subBoard.getSubSlotID();
                int subType = subBoard.getSubBoardType();
                String subName = cfgDataMgr.getBoardTypeName(this.neid, subType);
                if (!this.isPtnSuppBoard(this.neid, slotId, subSlot, subType) || null == (portList = this.resUtil.getAllPorts(this.neid, slotId, subSlot, subType))) continue;
                int portLen = portList.size();
                for (int portIndex = 0; portIndex < portLen; ++portIndex) {
                    port = portList.get(portIndex).getPortNo();
                    rowparams = new RowParams();
                    rowparams.addParam("neid", String.valueOf(this.neid));
                    rowparams.addParam("slotid", String.valueOf(slotId));
                    rowparams.addParam("boardname", bdName);
                    rowparams.addParam("subslotid", String.valueOf(subSlot));
                    rowparams.addParam("subboardname", subName);
                    rowparams.addParam("port", String.valueOf(port));
                    rowparams.addParam("portname", TEConfigurationDataMgr.getInstance().getPortName(this.neid, subSlot, subType, port));
                    this.output.getBussinessParams().addRowParams(rowparams);
                }
            }
        }
        this.output.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
    }

    public boolean isNeedOperationlog() {
        return false;
    }

    public boolean isPtnSuppBoard(int neid, int slotid, int subslotid, int boardType) {
        TIntHashSet filterBoards = null;
        TEPTNUtil util = TEPTNUtil.instance();
        filterBoards = util.getFilterBoardsSet(neid, "MCLMSP_NOT_SUPPORT");
        if (filterBoards.contains(boardType)) {
            return false;
        }
        ArrayList<TEPortProperty> boardPortList = this.resUtil.getAllPorts(neid, slotid, subslotid, boardType);
        boolean ret = false;
        int size = boardPortList.size();
        for (int i = 0; i < size; ++i) {
            int portType = boardPortList.get(i).getPortType();
            if (portType != 1798 && portType != 256) continue;
            ret = true;
            break;
        }
        return ret;
    }
}

