/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ptn.logicsys;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.TEDataConverter;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.uflight.qxprotocol.OperationResult;
import com.huawei.uflight.qxprotocol.TENECommMgr;
import com.huawei.uflight.qxprotocol.definitions.Definitions;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import com.huawei.uflight.qxprotocol.definitions.Part;
import java.util.ArrayList;
import java.util.List;

public class TELineMspQuery
extends TENEExplorerBean {
    private static final int NSCMD_CFG_GET_LMS_PUMAP_NEW = 31331;
    private static final int NSCMD_CFG_GET_LMS_PUMAP_NEW_EX = 33933;
    private static final int NSCMD_CFG_GET_LMS_SWSTA_02 = 31327;
    private static final int RESULT_NULL_ERROR = 38662;
    private static final int PROTECT_UNIT_INDEX = 1;
    private static final int ACTIVE_FLAG = 3;
    private static final int LOCAL_INDICATION = 1;
    private static final int END_INDICATION = 2;
    private ArrayList queryPG = new ArrayList();
    private ArrayList queryPGAttList = new ArrayList();
    private static final String IDLE = "0";
    private ArrayList workBoardList = new ArrayList();

    public ArrayList getOperation(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData) {
        try {
            Definitions definitions = TECreateObjectFactory.parseQxDesFile((int)neid);
            this.queryPG.add(definitions.getOperation("NSCMD_PTN_LMS_GET_PG"));
            this.queryPGAttList.add(definitions.getOperation("NSCMD_PTN_LMS_GET_WTRTIME"));
            this.queryPGAttList.add(definitions.getOperation("NSCMD_PTN_LMS_GET_SDFLAG"));
            this.queryPGAttList.add(definitions.getOperation("NSCMD_PTN_LMS_GET_SWSTA2"));
            this.queryPGAttList.add(definitions.getOperation("NSCMD_PTN_LMS_GET_PUMAP_NEW"));
            this.queryPGAttList.add(definitions.getOperation("NSCMD_PTN_LMS_GET_PROTOCOL"));
            this.queryPGAttList.add(definitions.getOperation("NSCMD_PTN_LMS_GET_K_LEVEL"));
            this.queryPGAttList.add(definitions.getOperation("NSCMD_PTN_LMS_GET_K2MODE"));
            this.queryPGAttList.add(definitions.getOperation("NSCMD_PTN_LMS_GET_ACTIVE"));
            return this.queryPG;
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("getOperation fail!", (Throwable)e);
            return null;
        }
    }

    public int sendMessage(int neid) {
        int retCode = 0;
        try {
            ArrayList<Object> queryPGAttrQxList = new ArrayList<Object>();
            OperationResult result = TENECommMgr.getInstance().sendCommand(neid, (List)this.queryPG, this.getTimeOut());
            if (null != result) {
                retCode = result.retCode;
            }
            if (retCode != 0) {
                return retCode;
            }
            Operation queryPGOper = (Operation)this.queryPG.get(0);
            Operation tempOper = null;
            for (int i = queryPGOper.getOutputCount() - 1; i >= 0; --i) {
                if (0 != Integer.parseInt(queryPGOper.getOutput(i).getFault(0).getCode())) continue;
                if (3 != Integer.parseInt(queryPGOper.getOutput(i).getPartValue("activeFlag"))) {
                    queryPGOper.removeOutput(i);
                    continue;
                }
                int size = this.queryPGAttList.size();
                for (int j = 0; j < size; ++j) {
                    tempOper = (Operation)this.queryPGAttList.get(j);
                    tempOper.getInput().getPart(0).setValue(queryPGOper.getOutput(i).getPartValue("groupID"));
                    queryPGAttrQxList.add(tempOper.clone());
                }
            }
            if (queryPGAttrQxList.isEmpty()) {
                return retCode;
            }
            result = TENECommMgr.getInstance().sendCommand(neid, queryPGAttrQxList, this.getTimeOut());
            if (null != result) {
                retCode = result.retCode;
            }
            if (retCode != 0) {
                return retCode;
            }
            this.operationList.addAll(queryPGAttrQxList);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("send message fail!", (Throwable)e);
        }
        return retCode;
    }

    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc, ArrayList filterErrorCodeList) {
        Operation tmpOper = null;
        int cmdID = 0;
        for (int i = operationList.size() - 1; i >= 0; --i) {
            tmpOper = (Operation)operationList.get(i);
            cmdID = tmpOper.getCmdid();
            if (cmdID == 31331 || cmdID == 33933) {
                this.handleLMSPuMap(tmpOper, operationList);
                continue;
            }
            if (cmdID != 31327) continue;
            this.handleLMSSWState(tmpOper, operationList);
        }
        this.outputData = TEDataConverter.convertToDatainterface((int)neid, (SubFunc)subfunc, (ArrayList)operationList, (ArrayList)filterErrorCodeList);
        BussinessParams bussinessParams = this.outputData.getBussinessParams();
        int len = this.workBoardList.size();
        for (int i = 0; i < len; ++i) {
            bussinessParams.addRowParams((RowParams)this.workBoardList.get(i));
        }
    }

    private void handleLMSPuMap(Operation puMapOper, ArrayList operationList) {
        Output output = null;
        int slotid = 0;
        int subSlotid = 0;
        int port = 0;
        int boardtype = 0;
        String boardName = null;
        String subBoardName = null;
        String portName = null;
        Part tmpPart = null;
        int len = puMapOper.getOutputCount();
        for (int i = 0; i < len; ++i) {
            String tmpPortName;
            output = puMapOper.getOutput(i);
            if (0 != Integer.parseInt(output.getFault(0).getCode())) continue;
            String str = "W";
            String protectUnit = output.getPart(1).getValue();
            if (IDLE.equals(protectUnit)) {
                str = "P";
            } else if (!"1".equals(protectUnit)) {
                this.handleWorkBoardMap(output);
                continue;
            }
            int size = output.getPartCount();
            for (int j = 2; j < size; ++j) {
                output.getPart(j).setName(str + output.getPart(j).getName());
            }
            slotid = Integer.parseInt(output.getPart(2).getValue());
            if (slotid == 0) continue;
            port = Integer.parseInt(output.getPart(4).getValue());
            boardtype = TEConfigurationDataMgr.getInstance().getBoardType(this.neid, slotid);
            boardName = TEConfigurationDataMgr.getInstance().getBoardTypeName(this.neid, boardtype);
            portName = TEConfigurationDataMgr.getInstance().getPortName(this.neid, slotid, boardtype, port);
            subSlotid = Integer.parseInt(output.getPart(3).getValue());
            int subBType = TEConfigurationDataMgr.getInstance().getSubboardType(this.neid, slotid, subSlotid);
            subBoardName = TEConfigurationDataMgr.getInstance().getBoardTypeName(this.neid, subBType);
            if (subSlotid != 255) {
                portName = TEConfigurationDataMgr.getInstance().getPortName(this.neid, slotid, subBType, port);
            }
            if ((tmpPortName = this.queryPortName(slotid, subSlotid, port)) != null) {
                portName = tmpPortName;
            }
            tmpPart = new Part();
            tmpPart.setName(str + "boardname");
            tmpPart.setValue(boardName);
            output.addPart(tmpPart);
            tmpPart = new Part();
            tmpPart.setName(str + "subboardname");
            tmpPart.setValue(subBoardName);
            output.addPart(tmpPart);
            tmpPart = new Part();
            tmpPart.setName(str + "portname");
            tmpPart.setValue(portName);
            output.addPart(tmpPart);
        }
    }

    private String queryPortName(int slotID, int subSlotID, int portID) {
        String portName = null;
        ArrayList<Operation> tmpoperationList = new ArrayList<Operation>();
        Operation oper = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_PTN_PORT_GET_NAME_EX");
        if (oper == null) {
            oper = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_PTN_PORT_GET_NAME");
        }
        oper.getInput().setPartValue("slotid", String.valueOf(slotID));
        oper.getInput().setPartValue("subslotid", String.valueOf(subSlotID));
        oper.getInput().setPartValue("port", String.valueOf(portID));
        tmpoperationList.add(oper);
        int retCode = 0;
        OperationResult result = TENECommMgr.getInstance().sendCommand(this.neid, tmpoperationList, this.TIME_OUT);
        if (null != result) {
            retCode = result.retCode;
        }
        if (0 != retCode) {
            return portName;
        }
        block0: for (int i = 0; i < tmpoperationList.size(); ++i) {
            Operation tmpOper = (Operation)tmpoperationList.get(i);
            String errorCode = tmpOper.getOutput(0).getFault(0).getCode();
            if (!IDLE.equals(errorCode)) continue;
            Output[] outputArr = tmpOper.getOutput();
            for (int j = 0; j < outputArr.length; ++j) {
                String tmpPortName = outputArr[j].getPartValue("portName").trim();
                if (tmpPortName == null || tmpPortName.equals("")) continue;
                String tmpslotid = outputArr[j].getPartValue("slotid").trim();
                String tmpsubSlotid = outputArr[j].getPartValue("subslotid").trim();
                String tmpport = outputArr[j].getPartValue("port").trim();
                if (!tmpslotid.equals("" + slotID) || !tmpsubSlotid.equals("" + subSlotID) || !tmpport.equals("" + portID)) continue;
                portName = "" + portID + "(" + tmpPortName + ")";
                continue block0;
            }
        }
        return portName;
    }

    private void handleWorkBoardMap(Output output) {
        RowParams rowParams = new RowParams();
        Part part = null;
        Param param = null;
        String name = null;
        String value = null;
        int len = output.getPartCount();
        for (int i = 0; i < len; ++i) {
            part = output.getPart(i);
            name = "W" + part.getName();
            if ("Wau4Used".equals(name)) continue;
            value = part.getValue();
            param = new Param(name, value);
            rowParams.addParam(param);
        }
        int slotid = Integer.valueOf(output.getPartValue("slotid"));
        int port = Integer.parseInt(output.getPart("port").getValue());
        int boardtype = TEConfigurationDataMgr.getInstance().getBoardType(this.neid, slotid);
        String boardName = TEConfigurationDataMgr.getInstance().getBoardTypeName(this.neid, boardtype);
        String portName = TEConfigurationDataMgr.getInstance().getPortName(this.neid, slotid, boardtype, port);
        int subSlotid = Integer.parseInt(output.getPart(3).getValue());
        int subBType = TEConfigurationDataMgr.getInstance().getSubboardType(this.neid, slotid, subSlotid);
        String subBoardName = TEConfigurationDataMgr.getInstance().getBoardTypeName(this.neid, subBType);
        if (subSlotid != 255) {
            portName = TEConfigurationDataMgr.getInstance().getPortName(this.neid, slotid, subBType, port);
        }
        param = new Param("Wboardname", boardName);
        rowParams.addParam(param);
        param = new Param("Wsubboardname", subBoardName);
        rowParams.addParam(param);
        param = new Param("Wportname", portName);
        rowParams.addParam(param);
        this.workBoardList.add(rowParams);
    }

    private void handleLMSSWState(Operation swstaOper, ArrayList operationList) {
        Output output = null;
        int endIndication = 0;
        int len = swstaOper.getOutputCount();
        for (int i = 0; i < len; ++i) {
            output = swstaOper.getOutput(i);
            if (0 != Integer.parseInt(output.getFault(0).getCode())) continue;
            String str = "W";
            String protectUnit = output.getPart(1).getValue();
            if (IDLE.equals(protectUnit)) {
                str = "P";
            } else if (!"1".equals(protectUnit)) {
                this.handleWorkBoardStatus(output);
                continue;
            }
            int size = output.getPartCount();
            for (int j = 2; j < size; ++j) {
                Part part = output.getPart(j);
                String partName = part.getName();
                if (partName.equals("protocolStatus")) continue;
                part.setName(str + partName);
            }
            endIndication = Integer.parseInt(output.getPart(5).getValue());
            if (1 == endIndication || 2 == endIndication) continue;
            output.getPart(5).setValue("");
        }
    }

    private void handleWorkBoardStatus(Output output) {
        RowParams rowParams = null;
        Param param = null;
        String groupID = output.getPartValue("groupID");
        String protectUnit = output.getPartValue("protectUnit");
        int len = this.workBoardList.size();
        for (int i = 0; i < len; ++i) {
            rowParams = (RowParams)this.workBoardList.get(i);
            if (!rowParams.getParam("WgroupID").getValue().equals(groupID) || !rowParams.getParam("WprotectUnit").getValue().equals(protectUnit)) continue;
            param = new Param("WswitchStatue", output.getPartValue("switchStatue"));
            rowParams.addParam(param);
            param = new Param("WendIndication", output.getPartValue("endIndication"));
            rowParams.addParam(param);
            param = new Param("WprotectedUnit", output.getPartValue("protectedUnit"));
            rowParams.addParam(param);
            return;
        }
    }

    public ArrayList getFilterErrorCodeList() {
        ArrayList<Integer> errorList = new ArrayList<Integer>();
        errorList.add(new Integer(38662));
        return errorList;
    }
}

