/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ptn.logicsys;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.TENEMgrInterface;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.TESubBoard;
import com.huawei.nglct.nelist.model.circuitpack.TEPortProperty;
import com.huawei.nglct.nelist.model.configmodel.TESpecialAttrMgr;
import com.huawei.nglct.nemgr.ptn.util.TEGetPortRes;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.qxprotocol.OperationResult;
import com.huawei.uflight.qxprotocol.TENECommMgr;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.slf4j.Logger;

public class TEAvailabeResQueryBean
implements TENEMgrInterface {
    private int neid;
    private Datainterface output;
    private Logger log = TELogFactory.getNormalLogger();
    private static final int BOARD_ASD1 = 1170;
    private static final int BOARD_CD1 = 1624;
    private static final int TIME_OUT = 60;
    private TEGetPortRes resUtil = TEGetPortRes.getInstance();

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        this.neid = neid;
        this.output = new Datainterface();
        TENE neObj = TENEListMgr.getInstance().getNE(neid);
        try {
            if (null != neObj) {
                this.getAvaliableBoard();
            } else {
                this.output.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)1090596385));
            }
        }
        catch (Exception e) {
            this.log.error("Get Avaliable IPA Board Fail!\n", (Throwable)e);
            this.output.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)1090646019));
        }
        return this.output;
    }

    private void getAvaliableBoard() {
        this.output.setBussinessParams(new BussinessParams());
        TEConfigurationDataMgr cfgDataMgr = TEConfigurationDataMgr.getInstance();
        RowParams rowparams = null;
        TEBoard board = null;
        int bdType = 0;
        int slotId = 0;
        int port = 0;
        String bdName = "";
        ArrayList<TEPortStru> portStruList = new ArrayList<TEPortStru>();
        Vector boardList = TENEListMgr.getInstance().getNE(this.neid).getClonedBoardList();
        int size = boardList.size();
        for (int j = 0; j < size; ++j) {
            board = (TEBoard)boardList.get(j);
            bdType = board.getBoardType();
            slotId = board.getSlotID();
            bdName = board.getBoardName();
            ArrayList<TEPortProperty> portList = this.resUtil.getAllPorts(this.neid, slotId, 255, bdType);
            if (null == portList) continue;
            if (this.isPtnSuppBoard(this.neid, slotId, 255, bdType, portList)) {
                int portLen = portList.size();
                for (int portIndex = 0; portIndex < portLen; ++portIndex) {
                    port = portList.get(portIndex).getPortNo();
                    rowparams = new RowParams();
                    rowparams.addParam("neid", String.valueOf(this.neid));
                    rowparams.addParam("slotid", String.valueOf(slotId));
                    rowparams.addParam("boardname", bdName);
                    rowparams.addParam("subslotid", String.valueOf(255));
                    rowparams.addParam("subboardname", "");
                    rowparams.addParam("port", String.valueOf(port));
                    rowparams.addParam("portname", TEConfigurationDataMgr.getInstance().getPortName(this.neid, slotId, bdType, port));
                    this.output.getBussinessParams().addRowParams(rowparams);
                    TEPortStru portStru = new TEPortStru(this.neid, slotId, 255, port);
                    portStruList.add(portStru);
                }
            }
            List subList = board.getSubBoardList();
            int len = subList.size();
            for (int i = 0; i < len; ++i) {
                TESubBoard subBoard = (TESubBoard)subList.get(i);
                int subSlot = subBoard.getSubSlotID();
                int subType = subBoard.getSubBoardType();
                String subName = cfgDataMgr.getBoardTypeName(this.neid, subType);
                portList = this.resUtil.getAllPorts(this.neid, slotId, subSlot, subType);
                if (null == portList || !this.isPtnSuppBoard(this.neid, slotId, subSlot, subType, portList)) continue;
                int portLen = portList.size();
                for (int portIndex = 0; portIndex < portLen; ++portIndex) {
                    port = portList.get(portIndex).getPortNo();
                    rowparams = new RowParams();
                    rowparams.addParam("neid", String.valueOf(this.neid));
                    rowparams.addParam("slotid", String.valueOf(slotId));
                    rowparams.addParam("boardname", bdName);
                    rowparams.addParam("subslotid", String.valueOf(subSlot));
                    rowparams.addParam("subboardname", subName);
                    rowparams.addParam("port", String.valueOf(port));
                    rowparams.addParam("portname", TEConfigurationDataMgr.getInstance().getPortName(this.neid, subSlot, subType, port));
                    this.output.getBussinessParams().addRowParams(rowparams);
                    TEPortStru portStru = new TEPortStru(this.neid, slotId, subSlot, port);
                    portStruList.add(portStru);
                }
            }
        }
        this.queryPortName(portStruList);
        this.output.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
    }

    private void queryPortName(List<TEPortStru> portStruList) {
        ArrayList<Operation> operationList = new ArrayList<Operation>();
        for (TEPortStru portStru : portStruList) {
            Operation oper = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_PTN_PORT_GET_NAME_EX");
            if (oper == null) {
                oper = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_PTN_PORT_GET_NAME");
            }
            oper.getInput().setPartValue("slotid", String.valueOf(portStru.getSlotID()));
            oper.getInput().setPartValue("subslotid", String.valueOf(portStru.getSubSlotID()));
            oper.getInput().setPartValue("port", String.valueOf(portStru.getPortID()));
            operationList.add(oper);
        }
        int retCode = 0;
        OperationResult result = TENECommMgr.getInstance().sendCommand(this.neid, operationList, 60);
        if (null != result) {
            retCode = result.retCode;
        }
        if (0 != retCode) {
            return;
        }
        for (int i = 0; i < operationList.size(); ++i) {
            Operation tmpOper = (Operation)operationList.get(i);
            String errorCode = tmpOper.getOutput(0).getFault(0).getCode();
            if (!"0".equals(errorCode)) continue;
            Output[] outputArr = tmpOper.getOutput();
            block2: for (int j = 0; j < outputArr.length; ++j) {
                String portName = outputArr[j].getPartValue("portName").trim();
                if (portName == null || portName.equals("")) continue;
                String slotid = outputArr[j].getPartValue("slotid").trim();
                String subSlotid = outputArr[j].getPartValue("subslotid").trim();
                String port = outputArr[j].getPartValue("port").trim();
                for (int k = 0; k < this.output.getBussinessParams().getRowParams().length; ++k) {
                    RowParams tmpRowParam = this.output.getBussinessParams().getRowParams()[k];
                    String tmpSlotid = tmpRowParam.getParam("slotid").getValue();
                    String tmpSubSlotId = tmpRowParam.getParam("subslotid").getValue();
                    String tmpPort = tmpRowParam.getParam("port").getValue();
                    if (!slotid.equals(tmpSlotid) || !subSlotid.equals(tmpSubSlotId) || !port.equals(tmpPort)) continue;
                    tmpRowParam.getParam("portname").setValue(tmpPort + "(" + portName + ")");
                    continue block2;
                }
            }
        }
    }

    public boolean isNeedOperationlog() {
        return false;
    }

    private boolean isPtnSuppBoard(int neid, int slotid, int subslotid, int boardType, ArrayList<TEPortProperty> portList) {
        if (boardType == 1170 || TESpecialAttrMgr.getInstance().isCPNotSupportByType(boardType, "TE_FUNC_CFG_LINEMSP", "PTN_ATTR_LIMEMSP_FUNC")) {
            return false;
        }
        boolean ret = false;
        int size = portList.size();
        for (int i = 0; i < size; ++i) {
            int portType = portList.get(i).getPortType();
            if (portType != 1798 && portType != 256) continue;
            ret = true;
            break;
        }
        return ret;
    }

    public int parsePortID(String portString) {
        if (portString != null && portString.contains("-")) {
            try {
                int portid = Integer.valueOf(portString.split("-")[0]);
                return portid;
            }
            catch (Exception e) {
                return -1;
            }
        }
        return -1;
    }

    private class TEPortStru {
        private int neID = -1;
        private int slotID = -1;
        private int subSlotID = -1;
        private int portID = -1;

        public TEPortStru(int neID, int slotID, int subSlotID, int portID) {
            this.neID = neID;
            this.slotID = slotID;
            this.subSlotID = subSlotID;
            this.portID = portID;
        }

        public int getNeID() {
            return this.neID;
        }

        public void setNeID(int neID) {
            this.neID = neID;
        }

        public int getSlotID() {
            return this.slotID;
        }

        public void setSlotID(int slotID) {
            this.slotID = slotID;
        }

        public int getSubSlotID() {
            return this.subSlotID;
        }

        public void setSubSlotID(int subSlotID) {
            this.subSlotID = subSlotID;
        }

        public int getPortID() {
            return this.portID;
        }

        public void setPortID(int portID) {
            this.portID = portID;
        }
    }
}

