/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ptn.ipping;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.gencfg.TEGenCfgDataMgr;
import com.huawei.nglct.nemgr.ptn.ipping.TESlotPort;
import com.huawei.uflight.qxprotocol.OperationResult;
import com.huawei.uflight.qxprotocol.TENECommMgr;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Vector;

public class TEPTNPortUtils {
    private static final String NSCMD_GET_LEVELMODE = "NSCMD_PTNETY_GET_LEVELMODE_EX";
    private static final String SDHPORT_ATTR_MODE = "SDHPORT_ATTR_MODE";
    private static final int LEVEL2 = 2;

    private TEPTNPortUtils() {
    }

    public static List<TESlotPort> parseOperationList(List<Operation> operationList) {
        Operation oper = null;
        Output output = null;
        TESlotPort slotport = null;
        ArrayList<TESlotPort> listResult = new ArrayList<TESlotPort>();
        int len = operationList.size();
        for (int i = 0; i < len; ++i) {
            oper = operationList.get(i);
            if (!oper.getOutput(0).getFault(0).getCode().equals(String.valueOf(0))) continue;
            int lenj = oper.getOutputCount();
            for (int j = 0; j < lenj; ++j) {
                output = oper.getOutput(j);
                int mode = Integer.parseInt(output.getPartValue(SDHPORT_ATTR_MODE));
                if (mode != 2) continue;
                slotport = new TESlotPort(Integer.parseInt(output.getPartValue("slotid")), Integer.parseInt(output.getPartValue("port")));
                listResult.add(slotport);
            }
        }
        return listResult;
    }

    public static List<Operation> getQueryLevelModeOperList(int neid) {
        TENE ne = TEConfigurationDataMgr.getInstance().getNE(neid);
        Vector boardlist = ne.getBoardList();
        Operation operLevelMode = TECreateObjectFactory.getOperation((int)neid, (String)NSCMD_GET_LEVELMODE);
        ArrayList<Operation> operationList = new ArrayList<Operation>();
        Operation oper = null;
        TEBoard board = null;
        Collections.sort(boardlist);
        int len = boardlist.size();
        for (int i = 0; i < len; ++i) {
            board = (TEBoard)boardlist.get(i);
            if (!TEGenCfgDataMgr.isBoardSupportAttr((int)neid, (int)board.getBoardType(), (String)SDHPORT_ATTR_MODE)) continue;
            oper = (Operation)operLevelMode.clone();
            oper.getInput().setPartValue("slotid", String.valueOf(board.getSlotID()));
            oper.getInput().setPartValue("port", "0");
            operationList.add(oper);
        }
        return operationList;
    }

    public static List<TESlotPort> getSupportSlotPortList(int neid) {
        List<Operation> operationList = TEPTNPortUtils.getQueryLevelModeOperList(neid);
        if (!operationList.isEmpty()) {
            OperationResult result = TENECommMgr.getInstance().sendCommand(neid, operationList, 20);
            if (result.retCode != 0) {
                TELogFactory.getNormalLogger().info("getSupportSlotPortList fail!result=" + result.retCode);
                return null;
            }
            return TEPTNPortUtils.parseOperationList(operationList);
        }
        return null;
    }
}

