/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ptn.ipping;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nemgr.ptn.ipping.TEIPPingProcess;
import com.huawei.nglct.nemgr.ptn.ipping.TEIPPingResponse;
import com.huawei.nglct.nemgr.ptn.ipping.TEIPPingStatistic;
import com.huawei.nglct.nemgr.ptn.ipping.TEIPPingTimeOut;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.util.io.TEGetFilePath;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.nglct.util.string.TEResourceUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class TEIPPingTestBean
extends TENEExplorerBean {
    public static final int START_IPPING = 1;
    public static final int STOP_IPPING = 2;
    public static final int REFRESH_IPPING = 3;
    private int configKey;
    private boolean finish = false;
    private String inputAddress = null;
    public static final String LANGUAGE = TESysManagerBean.getInstance().getlanguage();
    private static final String RESFILE = "ptn" + File.separator + "res" + File.separator + "ipping" + File.separator + "ippingres_" + LANGUAGE + ".ini";
    public static TEResourceUtil resourceUtil = null;

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        this.neid = neid;
        RowParams rowParams = inputData.getBussinessParams().getRowParams(0);
        this.inputAddress = rowParams.getParam("curTargetIP").getValue();
        resourceUtil = TEGetFilePath.getResource((int)neid, (String)RESFILE);
        this.configKey = Integer.valueOf(rowParams.getParam("configKey").getValue());
        if (this.configKey == 1) {
            TEIPPingProcess process = TEIPPingProcess.getIPPingProcess(neid);
            if (!process.isRegisterd()) {
                process.registerListener();
            }
            process.clear();
        }
        if (3 == this.configKey) {
            this.handleMessage(neid, this.operationList, this.subfunc);
            return this.outputData;
        }
        return super.performBussinessProcess(neid, subFunc, inputData, memeryData, user, ipAddress);
    }

    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc) {
        switch (this.configKey) {
            case 1: {
                super.handleMessage(neid, operationList, subfunc);
                break;
            }
            case 3: {
                this.outputData = new Datainterface();
                BussinessParams bussiness = new BussinessParams();
                TEIPPingProcess process = TEIPPingProcess.getIPPingProcess(neid);
                this.add(process, bussiness, neid);
                this.outputData.setBussinessParams(bussiness);
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neid, (int)0));
                break;
            }
            default: {
                super.handleMessage(neid, operationList, subfunc);
            }
        }
    }

    private void add(TEIPPingProcess process, BussinessParams bussiness, int neid) {
        int i;
        TELogFactory.getNormalLogger().info("IP Ping Test refresh, NE ID:" + neid + ", targetIP:" + this.inputAddress);
        List resList = process.getResData();
        List outTimeList = process.getOutTimeData();
        List statList = process.getStatData();
        StringBuilder str = new StringBuilder("");
        RowParams rowdata = new RowParams();
        Param param = new Param();
        param.setName("content");
        int len = resList.size();
        for (i = 0; i < len; ++i) {
            TEIPPingResponse response = (TEIPPingResponse)resList.get(i);
            if (response.getNeid() != neid) continue;
            str.append(response.toString());
        }
        len = outTimeList.size();
        for (i = 0; i < len; ++i) {
            TEIPPingTimeOut outTimeData = (TEIPPingTimeOut)outTimeList.get(i);
            if (outTimeData.getNeid() != neid) continue;
            str.append(outTimeData.toString());
        }
        len = statList.size();
        for (i = 0; i < len; ++i) {
            TEIPPingStatistic statictic = (TEIPPingStatistic)statList.get(i);
            if (statictic.getNeid() != neid) continue;
            str.append(statictic.toString());
            this.finish = true;
        }
        param.setValue(str.toString());
        rowdata.addParam(param);
        param = new Param();
        param.setName("endFlg");
        param.setValue("0");
        if (!statList.isEmpty() && this.finish) {
            param.setValue("1");
            process.unregister(neid);
            process.cleardata(neid);
        }
        rowdata.addParam(param);
        bussiness.addRowParams(rowdata);
        TELogFactory.getNormalLogger().info("IP Ping Test refresh successful, NE ID:" + neid + ", targetIP:" + this.inputAddress + ", finish:" + this.finish);
    }
}

