/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ptn.ipping;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.nemgr.ptn.ipping.TEIPPingResponse;
import com.huawei.nglct.nemgr.ptn.ipping.TEIPPingStatistic;
import com.huawei.nglct.nemgr.ptn.ipping.TEIPPingTimeOut;
import com.huawei.uflight.qxprotocol.NoticeHandler;
import com.huawei.uflight.qxprotocol.TENECommMgr;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TEIPPingProcess {
    private List ipPingResList = null;
    private List ipPingOutTimeList = null;
    private List ipPingStatList = null;
    private TEIPPingTestNoticeHandler ipPingTestNotice = null;
    private int neid;
    private Object lock = new Object();
    private boolean isRegister = false;
    private static Map<Integer, TEIPPingProcess> reportMap = new HashMap<Integer, TEIPPingProcess>();
    private String NSEVT_PTN_IPPING_RESPONSE = "NSEVT_PTN_IPPING_RESPONSE";
    private String NSEVT_PTN_IPPING_OVERTIME = "NSEVT_PTN_IPPING_OVERTIME";
    private String NSEVT_PTN_ROUTE_IPPING_STATISTIC = "NSEVT_PTN_ROUTE_IPPING_STATISTIC";

    public void setNeid(int neid) {
        this.neid = neid;
    }

    public List getResData() {
        return this.ipPingResList;
    }

    public List getOutTimeData() {
        return this.ipPingOutTimeList;
    }

    public List getStatData() {
        return this.ipPingStatList;
    }

    public static synchronized TEIPPingProcess getIPPingProcess(int neid) {
        Integer key = neid;
        TEIPPingProcess ptr = null;
        if (reportMap.containsKey(key)) {
            return reportMap.get(key);
        }
        ptr = new TEIPPingProcess(neid);
        reportMap.put(key, ptr);
        return ptr;
    }

    private TEIPPingProcess(int neid) {
        this.neid = neid;
        this.ipPingResList = new ArrayList();
        this.ipPingOutTimeList = new ArrayList();
        this.ipPingStatList = new ArrayList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerListener() {
        if (this.isRegister) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            this.ipPingTestNotice = new TEIPPingTestNoticeHandler();
            try {
                TENECommMgr.getInstance().registerListener(TECreateObjectFactory.getOperation((int)this.neid, (String)this.NSEVT_PTN_IPPING_RESPONSE), (NoticeHandler)this.ipPingTestNotice);
                TENECommMgr.getInstance().registerListener(TECreateObjectFactory.getOperation((int)this.neid, (String)this.NSEVT_PTN_IPPING_OVERTIME), (NoticeHandler)this.ipPingTestNotice);
                TENECommMgr.getInstance().registerListener(TECreateObjectFactory.getOperation((int)this.neid, (String)this.NSEVT_PTN_ROUTE_IPPING_STATISTIC), (NoticeHandler)this.ipPingTestNotice);
                this.isRegister = true;
            }
            catch (Exception e) {
                TELogFactory.getNormalLogger().error("TEIPPingTestProcess registerListener error!", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregister(int neid) {
        Object object = this.lock;
        synchronized (object) {
            TENECommMgr.getInstance().unregisterListener(TECreateObjectFactory.getOperation((int)neid, (String)this.NSEVT_PTN_IPPING_RESPONSE), (NoticeHandler)this.ipPingTestNotice);
            TENECommMgr.getInstance().unregisterListener(TECreateObjectFactory.getOperation((int)neid, (String)this.NSEVT_PTN_IPPING_OVERTIME), (NoticeHandler)this.ipPingTestNotice);
            TENECommMgr.getInstance().unregisterListener(TECreateObjectFactory.getOperation((int)neid, (String)this.NSEVT_PTN_ROUTE_IPPING_STATISTIC), (NoticeHandler)this.ipPingTestNotice);
            this.isRegister = false;
        }
    }

    public boolean isRegisterd() {
        return this.isRegister;
    }

    public void clear() {
        this.ipPingResList.clear();
        this.ipPingOutTimeList.clear();
        this.ipPingStatList.clear();
    }

    public synchronized void cleardata(int neid) {
        if (reportMap.containsKey(neid)) {
            reportMap.get(neid).clear();
            reportMap.remove(neid);
        }
    }

    class TEIPPingTestNoticeHandler
    implements NoticeHandler {
        TEIPPingTestNoticeHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleNotice(int cmdkey, int neID, Operation operation) {
            String operName = operation.getName().trim();
            TELogFactory.getNormalLogger().info("IP Ping Test operName : " + operName + ", NE ID:" + neID);
            Object object = TEIPPingProcess.this.lock;
            synchronized (object) {
                if (TEIPPingProcess.this.NSEVT_PTN_IPPING_RESPONSE.equals(operName)) {
                    this.processIPPingRsp(neID, operation);
                } else if (TEIPPingProcess.this.NSEVT_PTN_IPPING_OVERTIME.equals(operName)) {
                    this.processIPPingOutTime(neID, operation);
                } else if (TEIPPingProcess.this.NSEVT_PTN_ROUTE_IPPING_STATISTIC.equals(operName)) {
                    this.processIPPingStat(neID, operation);
                } else {
                    TELogFactory.getNormalLogger().error("IP Ping Test operName : " + operName + ", NE ID:" + neID);
                }
            }
        }

        private void processIPPingRsp(int neid, Operation oper) {
            Output[] outputArr = oper.getOutput();
            int len = outputArr.length;
            for (int i = 0; i < len; ++i) {
                TEIPPingResponse data = new TEIPPingResponse();
                data.setNeid(neid);
                data.setDestipAddress(outputArr[i].getPart("destipAddress").getValue());
                data.setPackageLen(outputArr[i].getPart("packageLen").getValue());
                data.setPackageSeq(outputArr[i].getPart("packageSeq").getValue());
                data.setDelayTime(outputArr[i].getPart("delayTime").getValue());
                TEIPPingProcess.this.getResData().add(data);
            }
        }

        private void processIPPingOutTime(int neid, Operation oper) {
            Output[] outputArr = oper.getOutput();
            int len = outputArr.length;
            for (int i = 0; i < len; ++i) {
                TEIPPingTimeOut data = new TEIPPingTimeOut();
                data.setNeid(neid);
                data.setDestipAddress(outputArr[i].getPart("destipAddress").getValue());
                data.setPackagelen(outputArr[i].getPart("packageLen").getValue());
                data.setPackageseq(outputArr[i].getPart("packageSeq").getValue());
                TEIPPingProcess.this.getOutTimeData().add(data);
            }
        }

        private void processIPPingStat(int neid, Operation oper) {
            Output[] outputArr = oper.getOutput();
            int len = outputArr.length;
            for (int i = 0; i < len; ++i) {
                TEIPPingStatistic data = new TEIPPingStatistic();
                data.setNeid(neid);
                data.setDestipAddress(outputArr[i].getPart("destipAddress").getValue());
                data.setTxnum(outputArr[i].getPart("txnum").getValue());
                data.setRxnum(outputArr[i].getPart("rxnum").getValue());
                data.setLossrate(outputArr[i].getPart("lossrate").getValue());
                TEIPPingProcess.this.getStatData().add(data);
            }
        }
    }
}

