/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ptn.ethprotocolconfig_r6c02.mstp;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.ErrorMessage;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.util.io.IOStreamConvertor;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.qxprotocol.OperationResult;
import com.huawei.uflight.qxprotocol.TENECommMgr;
import com.huawei.uflight.qxprotocol.definitions.Definitions;
import com.huawei.uflight.qxprotocol.definitions.Fault;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import com.huawei.uflight.qxprotocol.definitions.Part;
import java.util.ArrayList;
import java.util.List;

public class TEQueryPGPortBean
extends TENEExplorerBean {
    private Definitions definitions = null;
    private ArrayList rowErrorList = new ArrayList();
    private static final int INVALIDVALUE = 255;

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        this.neid = neid;
        this.operationList = new ArrayList();
        this.outputData = new Datainterface();
        this.outputData.setBussinessParams(new BussinessParams());
        try {
            this.definitions = TECreateObjectFactory.parseQxDesFile((int)neid);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("getOperation fail!", (Throwable)e);
        }
        BussinessParams businessparams = inputData.getBussinessParams();
        RowParams rowparams = businessparams.getRowParams(0);
        String portGroupID = rowparams.getParam("portGroupID").getValue();
        int resultCode = -1;
        resultCode = this.queryPort(portGroupID);
        if (resultCode == 0) {
            resultCode = this.queryPortProtocol(portGroupID);
        }
        if (resultCode != 0) {
            resultCode = 2;
            int size = this.rowErrorList.size();
            for (int i = 0; i < size; ++i) {
                RowParams rParam = new RowParams();
                RowErrors rError = (RowErrors)this.rowErrorList.get(i);
                rParam.addRowErrors(rError);
                this.outputData.getBussinessParams().addRowParams(rParam);
            }
        }
        ErrorMessage bigErr = TEErrorResourceUtil.getErrorMessage((int)resultCode);
        this.outputData.setErrorMessage(bigErr);
        if (this.isNeedOperationlog()) {
            this.writeLog(neid, this.subfunc, inputData, user, ipAddress, this.outputData);
        }
        return this.outputData;
    }

    private int queryPort(String portGroupID) {
        RowParams rowparam = null;
        Param param = null;
        Part part = null;
        TEConfigurationDataMgr configurDataMgr = TEConfigurationDataMgr.getInstance();
        Operation oper = this.definitions.getOperation("NSCMD_PTN_GET_MSTPPORTGROUP");
        Input input = oper.getInput();
        input.setPartValue("portGroupID", portGroupID);
        this.operationList.add(oper);
        int result = this.sendMessage(this.neid);
        if (result != 0) {
            return result;
        }
        Operation tmpOper = (Operation)this.operationList.get(0);
        this.operationList.clear();
        for (Output output : tmpOper.getOutput()) {
            for (Fault fault : output.getFault()) {
                int code = Integer.parseInt(fault.getCode());
                if (code != 0) {
                    TELogFactory.getNormalLogger().info(TEErrorResourceUtil.getErrCodeResWithDot((int)this.neid, (int)code));
                    RowErrors rowError = new RowErrors();
                    Param errorParam = new Param("portGroupID", portGroupID);
                    rowError.addParam(errorParam);
                    rowError.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)this.neid, (int)code));
                    this.rowErrorList.add(rowError);
                    return code;
                }
                part = Definitions.getParam((Part[])output.getPart(), (String)"portInfo");
                byte[] bValue = part.getValue().getBytes();
                int stepLength = 10;
                int startIndex = 0;
                while (startIndex + stepLength <= bValue.length) {
                    rowparam = new RowParams();
                    param = new Param("portGroupID", portGroupID);
                    rowparam.addParam(param);
                    byte[] bTmp = new byte[4];
                    System.arraycopy(bValue, startIndex + 0, bTmp, 0, 4);
                    int slotid = IOStreamConvertor.readPositiveShort((byte[])bTmp, (int)0);
                    param = new Param("slotid", slotid + "");
                    rowparam.addParam(param);
                    int boardType = configurDataMgr.getBoard(this.neid, slotid).getBoardType();
                    String boardName = configurDataMgr.getBoardTypeName(this.neid, boardType);
                    param = new Param("boardName", boardName);
                    rowparam.addParam(param);
                    bTmp = new byte[2];
                    System.arraycopy(bValue, startIndex + 4, bTmp, 0, 2);
                    int subslotid = IOStreamConvertor.readPositiveShort((byte[])bTmp, (int)0);
                    param = new Param("subslotid", "");
                    rowparam.addParam(param);
                    int subBoardType = 0;
                    if (255 != subslotid) {
                        rowparam.getParam("subslotid").setValue(subslotid + "");
                        subBoardType = configurDataMgr.getSubboardType(this.neid, slotid, subslotid);
                        String subBoardName = configurDataMgr.getBoardTypeName(this.neid, subBoardType);
                        param = new Param("subBoardName", subBoardName);
                        rowparam.addParam(param);
                    }
                    bTmp = new byte[4];
                    System.arraycopy(bValue, startIndex + 6, bTmp, 0, 4);
                    int port = IOStreamConvertor.readPositiveInt((byte[])bTmp, (int)0);
                    param = new Param("port", port + "");
                    rowparam.addParam(param);
                    String portName = "";
                    portName = 0 == subBoardType ? configurDataMgr.getPortName(this.neid, slotid, boardType, port) : configurDataMgr.getPortName(this.neid, slotid, subBoardType, port);
                    param = new Param("portName", portName);
                    rowparam.addParam(param);
                    param = new Param("portProtocolEnable", "");
                    rowparam.addParam(param);
                    this.outputData.getBussinessParams().addRowParams(rowparam);
                    startIndex += stepLength;
                }
            }
        }
        return 0;
    }

    private int queryPortProtocol(String portGroupID) {
        RowParams rowparam = null;
        Param param = null;
        Operation oper = this.definitions.getOperation("NSCMD_PTN_GET_MSTPPORTSTATE");
        Input input = oper.getInput();
        input.setPartValue("portGroupID", portGroupID);
        input.setPartValue("slotid", "0");
        input.setPartValue("subslotid", "0");
        input.setPartValue("port", "0");
        this.operationList.add(oper);
        OperationResult result = TENECommMgr.getInstance().sendCommand(this.neid, (List)this.operationList, this.getTimeOut());
        if (result.retCode != 0) {
            return result.retCode;
        }
        Operation tmpOper = (Operation)this.operationList.get(0);
        this.operationList.clear();
        for (Output output : tmpOper.getOutput()) {
            block1: for (Fault fault : output.getFault()) {
                int code = Integer.parseInt(fault.getCode());
                if (code != 0) {
                    TELogFactory.getNormalLogger().info(TEErrorResourceUtil.getErrCodeResWithDot((int)this.neid, (int)code));
                    RowErrors rowError = new RowErrors();
                    Param errorParam = new Param("errorBbj", this.neid + "Query Port Protocol Status");
                    rowError.addParam(errorParam);
                    rowError.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)this.neid, (int)code));
                    this.rowErrorList.add(rowError);
                    return code;
                }
                String slotid = output.getPartValue("slotid");
                String subslotid = output.getPartValue("subslotid");
                if (255 == Integer.parseInt(subslotid)) {
                    subslotid = "";
                }
                String port = output.getPartValue("port");
                String portProtocolEnable = output.getPartValue("portProtocolEnable");
                BussinessParams businessparams = this.outputData.getBussinessParams();
                int size = businessparams.getRowParamsCount();
                for (int index = 0; index < size; ++index) {
                    rowparam = businessparams.getRowParams(index);
                    param = rowparam.getParam("portProtocolEnable");
                    if (!param.getValue().equals("") || !rowparam.getParam("slotid").getValue().equals(slotid) || !rowparam.getParam("subslotid").getValue().equals(subslotid) || !rowparam.getParam("port").getValue().equals(port)) continue;
                    param.setValue(portProtocolEnable);
                    continue block1;
                }
            }
        }
        return 0;
    }
}

