/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ptn.ethprotocolconfig_r6c02.mstp;

import com.huawei.nglct.cbb.log.TECommonWriteLogBean;
import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.cbb.log.TELogInfo;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.TEDataConverter;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.ErrorMessage;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.qxprotocol.definitions.Definitions;
import com.huawei.uflight.qxprotocol.definitions.Fault;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import java.util.ArrayList;
import java.util.List;

public class TEQueryMstiBean
extends TECommonWriteLogBean {
    private Definitions definitions = null;
    private ArrayList rowErrorList = new ArrayList();
    private StringBuffer portGroupIDArray = new StringBuffer();
    private static final String MSTP = "3";

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        this.neid = neid;
        this.subfunc = subFunc;
        this.inputData = inputData;
        this.operationList = new ArrayList();
        this.outputData = new Datainterface();
        this.outputData.setBussinessParams(new BussinessParams());
        try {
            this.definitions = TECreateObjectFactory.parseQxDesFile((int)neid);
            BussinessParams businessparams = inputData.getBussinessParams();
            RowParams rowparams = businessparams.getRowParams(0);
            String isQeryPortGroup = rowparams.getParam("isQeryPortGroup").getValue();
            if ("false".equals(isQeryPortGroup)) {
                return super.performBussinessProcess(neid, subFunc, inputData, memeryData, user, ipAddress);
            }
            int resultCode = -1;
            resultCode = this.queryPortGroup();
            if (resultCode != 0) {
                resultCode = 2;
                int size = this.rowErrorList.size();
                for (int i = 0; i < size; ++i) {
                    RowParams rParam = new RowParams();
                    RowErrors rError = (RowErrors)this.rowErrorList.get(i);
                    rParam.addRowErrors(rError);
                    this.outputData.getBussinessParams().addRowParams(rParam);
                }
                ErrorMessage bigErr = TEErrorResourceUtil.getErrorMessage((int)resultCode);
                this.outputData.setErrorMessage(bigErr);
                if (this.isNeedOperationlog()) {
                    this.writeLog(neid, this.subfunc, inputData, user, ipAddress, this.outputData, true);
                }
                return this.outputData;
            }
            if (null == this.operationList || this.operationList.size() == 0) {
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
                return this.outputData;
            }
            int result = this.sendMessage(neid, subFunc);
            if (result == 0) {
                this.handleMessage(neid, this.operationList, subFunc);
            } else {
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)result));
            }
            if (this.isNeedOperationlog()) {
                this.writeLog(neid, this.subfunc, inputData, user, ipAddress, this.outputData, true);
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("performBussinessProcess fail!", (Throwable)e);
            return null;
        }
        return this.outputData;
    }

    private int queryPortGroup() {
        boolean flag = false;
        Operation oper = this.definitions.getOperation("NSCMD_PTN_GET_MSTPMODE");
        Input input = oper.getInput();
        input.setPartValue("portGroupID", "0");
        this.operationList.add(oper);
        int result = this.sendMessage(this.neid);
        if (result != 0) {
            return result;
        }
        Operation tmpOper = (Operation)this.operationList.get(0);
        this.operationList.clear();
        for (Output output : tmpOper.getOutput()) {
            for (Fault fault : output.getFault()) {
                int code = Integer.parseInt(fault.getCode());
                if (code == 0) continue;
                TELogFactory.getNormalLogger().info(TEErrorResourceUtil.getErrCodeResWithDot((int)this.neid, (int)code));
                RowErrors rowError = new RowErrors();
                Param errorParam = new Param("portGroupID", "");
                rowError.addParam(errorParam);
                rowError.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)this.neid, (int)code));
                this.rowErrorList.add(rowError);
                return code;
            }
            String portGroupID = output.getPartValue("portGroupID");
            String protocolType = output.getPartValue("protocolType");
            if (!MSTP.equals(protocolType)) continue;
            this.portGroupIDArray.append(portGroupID).append(",");
            if (flag) continue;
            flag = true;
            for (int j = 1; j <= 48; ++j) {
                oper = this.definitions.getOperation("NSCMD_PTN_GET_MSTPMSTIBRIDGE");
                input = oper.getInput();
                input.setPartValue("portGroupID", portGroupID);
                input.setPartValue("mstiID", j + "");
                this.operationList.add(oper);
            }
        }
        return 0;
    }

    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc) {
        this.outputData = TEDataConverter.convertToDatainterface((int)neid, (SubFunc)subfunc, (ArrayList)operationList);
        if (0 < this.portGroupIDArray.length()) {
            RowParams rowparam = new RowParams();
            Param param = new Param("portGroupID", this.portGroupIDArray.toString());
            rowparam.addParam(param);
            this.outputData.getBussinessParams().addRowParams(0, rowparam);
        }
    }

    public List<TELogInfo> getLogInfoList(Datainterface inputData) {
        return this.getSingletonLogInfo(inputData);
    }
}

